/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.transform.TransformException;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.crash.PluginCrashReporter;
import com.android.build.gradle.internal.errors.MessageReceiverImpl;
import com.android.build.gradle.internal.tasks.DexMergingParams;
import com.android.build.gradle.internal.tasks.DexMergingTask;
import com.android.build.gradle.internal.tasks.DexMergingTaskKt;
import com.android.build.gradle.internal.transforms.DexMergerTransformCallable;
import com.android.build.gradle.options.SyncOptions;
import com.android.builder.dexing.DexMergerTool;
import com.android.builder.dexing.DexingType;
import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.MessageReceiver;
import com.android.ide.common.blame.ParsingProcessOutputHandler;
import com.android.ide.common.blame.parser.DexParser;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.ToolOutputParser;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessOutput;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@VisibleForTesting
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/build/gradle/internal/tasks/DexMergingTaskRunnable;", "Ljava/lang/Runnable;", "params", "Lcom/android/build/gradle/internal/tasks/DexMergingParams;", "(Lcom/android/build/gradle/internal/tasks/DexMergingParams;)V", "run", "", "gradle"})
public final class DexMergingTaskRunnable
implements Runnable {
    private final DexMergingParams params;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void run() {
        LoggerWrapper loggerWrapper = LoggerWrapper.getLogger(DexMergingTaskRunnable.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)loggerWrapper, (String)"LoggerWrapper.getLogger(\u2026TaskRunnable::class.java)");
        LoggerWrapper logger = loggerWrapper;
        SyncOptions.ErrorFormatMode errorFormatMode = this.params.getErrorFormatMode();
        org.gradle.api.logging.Logger logger2 = Logging.getLogger(DexMergingTask.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"Logging.getLogger(DexMergingTask::class.java)");
        MessageReceiverImpl messageReceiver = new MessageReceiverImpl(errorFormatMode, (Logger)logger2);
        ForkJoinPool forkJoinPool = new ForkJoinPool();
        ParsingProcessOutputHandler outputHandler = new ParsingProcessOutputHandler(new ToolOutputParser((PatternAwareOutputParser)new DexParser(), Message.Kind.ERROR, (ILogger)logger), new ToolOutputParser((PatternAwareOutputParser)new DexParser(), (ILogger)logger), new MessageReceiver[]{messageReceiver});
        ProcessOutput processOutput = null;
        try {
            processOutput = outputHandler.createOutput();
            FileUtils.cleanOutputDir((File)this.params.getOutputDir());
            if (this.params.getDexFiles().isEmpty()) {
                return;
            }
            if (this.params.getDexFiles().size() >= this.params.getMergingThreshold()) {
                Collection<Path> collection;
                Iterator $receiver$iv$iv;
                void $receiver$iv;
                Iterable iterable = this.params.getDexFiles();
                File file = this.params.getOutputDir();
                ProcessOutput processOutput2 = processOutput;
                DexingType dexingType = this.params.getDexingType();
                MessageReceiver messageReceiver2 = messageReceiver;
                IndexedValue it = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                Iterator iterator = $receiver$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void it2;
                    Object item$iv$iv = iterator.next();
                    File file2 = (File)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    Path path = it2.toPath();
                    collection.add(path);
                }
                collection = (List)destination$iv$iv;
                File file3 = this.params.getMainDexListFile();
                boolean bl = this.params.isDebuggable();
                int n = this.params.getMinSdkVersion();
                DexMergerTool dexMergerTool = this.params.getDexMerger();
                ForkJoinPool forkJoinPool2 = forkJoinPool;
                Path path = file3 != null ? file3.toPath() : null;
                Iterator<Path> iterator2 = collection.iterator();
                File file4 = file;
                ProcessOutput processOutput3 = processOutput2;
                DexingType dexingType2 = dexingType;
                MessageReceiver messageReceiver3 = messageReceiver2;
                new DexMergerTransformCallable(messageReceiver3, dexingType2, processOutput3, file4, iterator2, path, forkJoinPool2, dexMergerTool, n, bl).call();
            } else {
                for (IndexedValue file : CollectionsKt.withIndex((Iterable)DexMergingTaskKt.access$getAllRegularFiles(this.params.getDexFiles()))) {
                    FilesKt.copyTo$default((File)((File)file.getValue()), (File)FilesKt.resolve((File)this.params.getOutputDir(), (String)("classes_" + file.getIndex() + ".dex")), (boolean)false, (int)0, (int)6, null);
                }
            }
        }
        catch (Exception e) {
            PluginCrashReporter.maybeReportException(e);
            logger.error(null, Throwables.getStackTraceAsString((Throwable)e), new Object[0]);
            throw (Throwable)new TransformException((Throwable)e);
        }
        finally {
            ProcessOutput processOutput4 = processOutput;
            if (processOutput4 != null) {
                ProcessOutput processOutput5;
                ProcessOutput it = processOutput5 = processOutput4;
                boolean bl = false;
                try {
                    outputHandler.handleOutput(it);
                    processOutput.close();
                }
                catch (ProcessException processException) {
                }
            }
            forkJoinPool.shutdown();
            forkJoinPool.awaitTermination(100L, TimeUnit.SECONDS);
        }
    }

    @Inject
    public DexMergingTaskRunnable(@NotNull DexMergingParams params) {
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        this.params = params;
    }
}

