/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle;

import android.databinding.tool.DataBindingBuilder;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.DynamicFeaturePlugin;
import com.android.build.gradle.FeaturePlugin;
import com.android.build.gradle.api.AndroidBasePlugin;
import com.android.build.gradle.api.BaseVariantOutput;
import com.android.build.gradle.internal.ApiObjectFactory;
import com.android.build.gradle.internal.BadPluginException;
import com.android.build.gradle.internal.BuildCacheUtils;
import com.android.build.gradle.internal.ClasspathVerifier;
import com.android.build.gradle.internal.DependencyResolutionChecks;
import com.android.build.gradle.internal.ExtraModelInfo;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.NonFinalPluginExpiry;
import com.android.build.gradle.internal.PluginInitializer;
import com.android.build.gradle.internal.SdkComponents;
import com.android.build.gradle.internal.SdkComponentsOptions;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.SdkLibDataFactory;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.VariantManager;
import com.android.build.gradle.internal.api.dsl.extensions.BaseExtension2;
import com.android.build.gradle.internal.crash.CrashReporting;
import com.android.build.gradle.internal.dependency.SourceSetManager;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.BuildTypeFactory;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.dsl.ProductFlavorFactory;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.dsl.SigningConfigFactory;
import com.android.build.gradle.internal.dsl.Splits;
import com.android.build.gradle.internal.errors.DeprecationReporterImpl;
import com.android.build.gradle.internal.ide.ModelBuilder;
import com.android.build.gradle.internal.ide.NativeModelBuilder;
import com.android.build.gradle.internal.packaging.GradleKeystoreHelper;
import com.android.build.gradle.internal.plugin.PluginDelegate;
import com.android.build.gradle.internal.plugin.ProjectWrapper;
import com.android.build.gradle.internal.plugin.TypedPluginDelegate;
import com.android.build.gradle.internal.process.GradleJavaProcessExecutor;
import com.android.build.gradle.internal.process.GradleProcessExecutor;
import com.android.build.gradle.internal.profile.AnalyticsUtil;
import com.android.build.gradle.internal.profile.ProfileAgent;
import com.android.build.gradle.internal.profile.ProfilerInitializer;
import com.android.build.gradle.internal.profile.RecordingBuildListener;
import com.android.build.gradle.internal.scope.DelayedActionsExecutor;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.Workers;
import com.android.build.gradle.internal.utils.GradlePluginUtils;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.build.gradle.internal.variant2.DslScopeImpl;
import com.android.build.gradle.internal.workeractions.WorkerActionServiceRegistry;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.IntegerOption;
import com.android.build.gradle.options.Option;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.build.gradle.options.SyncOptions;
import com.android.build.gradle.tasks.factory.AbstractCompilesUtil;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.errors.EvalIssueReporter;
import com.android.builder.model.Version;
import com.android.builder.profile.ProcessProfileWriter;
import com.android.builder.profile.Recorder;
import com.android.builder.profile.ThreadRecorder;
import com.android.builder.utils.FileCache;
import com.android.dx.command.dexer.Main;
import com.android.ide.common.blame.MessageReceiver;
import com.android.ide.common.process.JavaProcessExecutor;
import com.android.ide.common.process.ProcessExecutor;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.lint.gradle.api.ToolingRegistryProvider;
import com.android.utils.ILogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import com.google.wireless.android.sdk.stats.GradleBuildProject;
import java.io.File;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.initialization.Settings;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.tasks.StopExecutionException;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public abstract class BasePlugin<E extends BaseExtension2>
implements Plugin<Project>,
ToolingRegistryProvider {
    @VisibleForTesting
    public static final GradleVersion GRADLE_MIN_VERSION = GradleVersion.parse((String)"5.3-rc-2");
    private BaseExtension extension;
    private VariantManager variantManager;
    protected TaskManager taskManager;
    protected Project project;
    protected ProjectOptions projectOptions;
    private GlobalScope globalScope;
    private DataBindingBuilder dataBindingBuilder;
    private VariantFactory variantFactory;
    private SourceSetManager sourceSetManager;
    private ToolingModelBuilderRegistry registry;
    private LoggerWrapper loggerWrapper;
    protected ExtraModelInfo extraModelInfo;
    private String creator;
    private Recorder threadRecorder;
    private boolean hasCreatedTasks = false;

    BasePlugin(ToolingModelBuilderRegistry registry) {
        ClasspathVerifier.checkClasspathSanity();
        this.registry = registry;
        this.creator = "Android Gradle " + Version.ANDROID_GRADLE_PLUGIN_VERSION;
        NonFinalPluginExpiry.verifyRetirementAge();
    }

    protected abstract BaseExtension createExtension(Project var1, ProjectOptions var2, GlobalScope var3, NamedDomainObjectContainer<BuildType> var4, NamedDomainObjectContainer<ProductFlavor> var5, NamedDomainObjectContainer<SigningConfig> var6, NamedDomainObjectContainer<BaseVariantOutput> var7, SourceSetManager var8, ExtraModelInfo var9);

    protected abstract GradleBuildProject.PluginType getAnalyticsPluginType();

    protected abstract VariantFactory createVariantFactory(GlobalScope var1, AndroidConfig var2);

    protected abstract TaskManager createTaskManager(GlobalScope var1, Project var2, ProjectOptions var3, DataBindingBuilder var4, AndroidConfig var5, VariantFactory var6, ToolingModelBuilderRegistry var7, Recorder var8);

    protected abstract int getProjectType();

    @VisibleForTesting
    public VariantManager getVariantManager() {
        return this.variantManager;
    }

    public BaseExtension getExtension() {
        return this.extension;
    }

    @VisibleForTesting
    AndroidBuilder getAndroidBuilder() {
        return this.globalScope.getAndroidBuilder();
    }

    private ILogger getLogger() {
        if (this.loggerWrapper == null) {
            this.loggerWrapper = new LoggerWrapper(this.project.getLogger());
        }
        return this.loggerWrapper;
    }

    public final void apply(Project project) {
        CrashReporting.runAction(() -> {
            this.basePluginApply(project);
            this.pluginSpecificApply(project);
        });
    }

    private void basePluginApply(Project project) {
        System.setProperty("java.awt.headless", "true");
        this.project = project;
        this.projectOptions = new ProjectOptions(project);
        BasePlugin.checkGradleVersion(project, this.getLogger(), this.projectOptions);
        DependencyResolutionChecks.registerDependencyCheck(project, this.projectOptions);
        project.getPluginManager().apply(AndroidBasePlugin.class);
        this.checkPathForErrors();
        this.checkModulesForErrors();
        PluginInitializer.initialize(project);
        RecordingBuildListener buildListener = ProfilerInitializer.init(project, this.projectOptions);
        ProfileAgent.INSTANCE.register(project.getName(), buildListener);
        this.threadRecorder = ThreadRecorder.get();
        Workers.INSTANCE.initFromProject(this.projectOptions, ForkJoinPool.commonPool());
        ProcessProfileWriter.getProject((String)project.getPath()).setAndroidPluginVersion(Version.ANDROID_GRADLE_PLUGIN_VERSION).setAndroidPlugin(this.getAnalyticsPluginType()).setPluginGeneration(GradleBuildProject.PluginGeneration.FIRST).setOptions(AnalyticsUtil.toProto(this.projectOptions));
        if (!this.projectOptions.get(BooleanOption.ENABLE_NEW_DSL_AND_API)) {
            this.threadRecorder.record(GradleBuildProfileSpan.ExecutionType.BASE_PLUGIN_PROJECT_CONFIGURE, project.getPath(), null, this::configureProject);
            this.threadRecorder.record(GradleBuildProfileSpan.ExecutionType.BASE_PLUGIN_PROJECT_BASE_EXTENSION_CREATION, project.getPath(), null, this::configureExtension);
            this.threadRecorder.record(GradleBuildProfileSpan.ExecutionType.BASE_PLUGIN_PROJECT_TASKS_CREATION, project.getPath(), null, this::createTasks);
        } else {
            project.getPlugins().apply(JavaBasePlugin.class);
            ProjectWrapper projectWrapper = new ProjectWrapper(project);
            PluginDelegate<E> delegate = new PluginDelegate<E>(project.getPath(), project.getObjects(), project.getExtensions(), project.getConfigurations(), projectWrapper, projectWrapper, project.getLogger(), this.projectOptions, this.getTypedDelegate());
            delegate.prepareForEvaluation();
            project.afterEvaluate(CrashReporting.afterEvaluate(p -> this.threadRecorder.record(GradleBuildProfileSpan.ExecutionType.BASE_PLUGIN_CREATE_ANDROID_TASKS, p.getPath(), null, delegate::afterEvaluate)));
        }
    }

    protected abstract void pluginSpecificApply(Project var1);

    protected abstract TypedPluginDelegate<E> getTypedDelegate();

    private void configureProject() {
        Gradle gradle = this.project.getGradle();
        ObjectFactory objectFactory = this.project.getObjects();
        this.extraModelInfo = new ExtraModelInfo(this.project.getPath(), this.projectOptions, this.project.getLogger());
        final SdkComponents sdkComponents = this.createSdkComponents(gradle);
        AndroidBuilder androidBuilder = new AndroidBuilder(this.creator, (ProcessExecutor)new GradleProcessExecutor(this.project), (JavaProcessExecutor)new GradleJavaProcessExecutor(this.project), (EvalIssueReporter)this.extraModelInfo.getSyncIssueHandler(), (MessageReceiver)this.extraModelInfo.getMessageReceiver(), this.getLogger());
        this.dataBindingBuilder = new DataBindingBuilder();
        this.dataBindingBuilder.setPrintMachineReadableOutput(SyncOptions.getErrorFormatMode(this.projectOptions) == SyncOptions.ErrorFormatMode.MACHINE_PARSABLE);
        if (this.projectOptions.hasRemovedOptions()) {
            androidBuilder.getIssueReporter().reportWarning(EvalIssueReporter.Type.GENERIC, this.projectOptions.getRemovedOptionsErrorMessage());
        }
        if (this.projectOptions.hasDeprecatedOptions()) {
            this.extraModelInfo.getDeprecationReporter().reportDeprecatedOptions((Set<? extends Option<?>>)this.projectOptions.getDeprecatedOptions());
        }
        if (!this.projectOptions.getExperimentalOptions().isEmpty()) {
            this.projectOptions.getExperimentalOptions().forEach(this.extraModelInfo.getDeprecationReporter()::reportExperimentalOption);
        }
        GradlePluginUtils.enforceMinimumVersionsOfPlugins(this.project, androidBuilder.getIssueReporter());
        this.project.getPlugins().apply(JavaBasePlugin.class);
        DslScopeImpl dslScope = new DslScopeImpl(this.extraModelInfo.getSyncIssueHandler(), this.extraModelInfo.getDeprecationReporter(), objectFactory);
        FileCache buildCache = BuildCacheUtils.createBuildCacheIfEnabled(this.project, this.projectOptions);
        this.globalScope = new GlobalScope(this.project, new ProjectWrapper(this.project), this.projectOptions, dslScope, androidBuilder, sdkComponents, this.registry, buildCache);
        this.project.getTasks().named("assemble").configure(task -> task.setDescription("Assembles all variants of all applications and secondary packages."));
        gradle.addBuildListener(new BuildListener(){

            public void buildStarted(Gradle gradle) {
            }

            public void settingsEvaluated(Settings settings) {
            }

            public void projectsLoaded(Gradle gradle) {
            }

            public void projectsEvaluated(Gradle gradle) {
            }

            public void buildFinished(BuildResult buildResult) {
                if (buildResult.getGradle().getParent() != null) {
                    return;
                }
                ModelBuilder.clearCaches();
                Workers.INSTANCE.shutdown();
                sdkComponents.unload();
                BasePlugin.this.threadRecorder.record(GradleBuildProfileSpan.ExecutionType.BASE_PLUGIN_BUILD_FINISHED, BasePlugin.this.project.getPath(), null, () -> {
                    if (!BasePlugin.this.projectOptions.get(BooleanOption.KEEP_SERVICES_BETWEEN_BUILDS)) {
                        WorkerActionServiceRegistry.INSTANCE.shutdownAllRegisteredServices(ForkJoinPool.commonPool());
                    }
                    Main.clearInternTables();
                });
                DeprecationReporterImpl.Companion.clean();
            }
        });
        BasePlugin.createLintClasspathConfiguration(this.project);
    }

    private SdkComponents createSdkComponents(Gradle gradle) {
        SdkHandler sdkHandler = new SdkHandler(this.project, this.getLogger(), this.extraModelInfo.getSyncIssueHandler());
        boolean enableDownload = !gradle.getStartParameter().isOffline() && this.projectOptions.get(BooleanOption.ENABLE_SDK_DOWNLOAD);
        SdkLibDataFactory factory2 = new SdkLibDataFactory(enableDownload, this.projectOptions.get(IntegerOption.ANDROID_SDK_CHANNEL), this.getLogger());
        SdkComponentsOptions options = new SdkComponentsOptions(() -> this.getExtension().getCompileSdkVersion(), () -> this.getExtension().getBuildToolsRevision(), () -> this.getExtension().getNdkVersion(), factory2, this.projectOptions.get(BooleanOption.USE_ANDROID_X), this.projectOptions.get(BooleanOption.ENABLE_SIDE_BY_SIDE_NDK));
        return new SdkComponents(options, sdkHandler, this.extraModelInfo.getSyncIssueHandler(), this.project);
    }

    public static void createLintClasspathConfiguration(Project project) {
        Configuration config2 = (Configuration)project.getConfigurations().create("lintClassPath");
        config2.setVisible(false);
        config2.setTransitive(true);
        config2.setCanBeConsumed(false);
        config2.setDescription("The lint embedded classpath");
        project.getDependencies().add(config2.getName(), (Object)("com.android.tools.lint:lint-gradle:" + Version.ANDROID_TOOLS_BASE_VERSION));
    }

    private void configureExtension() {
        ObjectFactory objectFactory = this.project.getObjects();
        NamedDomainObjectContainer buildTypeContainer = this.project.container(BuildType.class, (NamedDomainObjectFactory)new BuildTypeFactory(objectFactory, this.project, this.extraModelInfo.getSyncIssueHandler(), this.extraModelInfo.getDeprecationReporter()));
        NamedDomainObjectContainer productFlavorContainer = this.project.container(ProductFlavor.class, (NamedDomainObjectFactory)new ProductFlavorFactory(objectFactory, this.project, this.extraModelInfo.getDeprecationReporter(), this.project.getLogger()));
        NamedDomainObjectContainer signingConfigContainer = this.project.container(SigningConfig.class, (NamedDomainObjectFactory)new SigningConfigFactory(objectFactory, GradleKeystoreHelper.getDefaultDebugKeystoreLocation()));
        NamedDomainObjectContainer buildOutputs = this.project.container(BaseVariantOutput.class);
        this.project.getExtensions().add("buildOutputs", (Object)buildOutputs);
        this.sourceSetManager = new SourceSetManager(this.project, this.isPackagePublished(), this.globalScope.getDslScope(), new DelayedActionsExecutor());
        this.extension = this.createExtension(this.project, this.projectOptions, this.globalScope, (NamedDomainObjectContainer<BuildType>)buildTypeContainer, (NamedDomainObjectContainer<ProductFlavor>)productFlavorContainer, (NamedDomainObjectContainer<SigningConfig>)signingConfigContainer, (NamedDomainObjectContainer<BaseVariantOutput>)buildOutputs, this.sourceSetManager, this.extraModelInfo);
        this.globalScope.setExtension(this.extension);
        this.variantFactory = this.createVariantFactory(this.globalScope, this.extension);
        this.taskManager = this.createTaskManager(this.globalScope, this.project, this.projectOptions, this.dataBindingBuilder, this.extension, this.variantFactory, this.registry, this.threadRecorder);
        this.variantManager = new VariantManager(this.globalScope, this.project, this.projectOptions, this.extension, this.variantFactory, this.taskManager, this.sourceSetManager, this.threadRecorder);
        this.registerModels(this.registry, this.globalScope, this.variantManager, this.extension, this.extraModelInfo);
        signingConfigContainer.whenObjectAdded(this.variantManager::addSigningConfig);
        buildTypeContainer.whenObjectAdded(buildType -> {
            if (!this.getClass().isAssignableFrom(DynamicFeaturePlugin.class)) {
                SigningConfig signingConfig = (SigningConfig)signingConfigContainer.findByName("debug");
                buildType.init(signingConfig);
            } else {
                buildType.init();
            }
            this.variantManager.addBuildType((CoreBuildType)buildType);
        });
        productFlavorContainer.whenObjectAdded(this.variantManager::addProductFlavor);
        signingConfigContainer.whenObjectRemoved((Action)new UnsupportedAction("Removing signingConfigs is not supported."));
        buildTypeContainer.whenObjectRemoved((Action)new UnsupportedAction("Removing build types is not supported."));
        productFlavorContainer.whenObjectRemoved((Action)new UnsupportedAction("Removing product flavors is not supported."));
        this.variantFactory.createDefaultComponents((NamedDomainObjectContainer<BuildType>)buildTypeContainer, (NamedDomainObjectContainer<ProductFlavor>)productFlavorContainer, (NamedDomainObjectContainer<SigningConfig>)signingConfigContainer);
    }

    protected void registerModels(ToolingModelBuilderRegistry registry, GlobalScope globalScope, VariantManager variantManager, AndroidConfig config2, ExtraModelInfo extraModelInfo) {
        this.registerModelBuilder(registry, globalScope, variantManager, config2, extraModelInfo);
        NativeModelBuilder nativeModelBuilder = new NativeModelBuilder(globalScope, variantManager);
        registry.register((ToolingModelBuilder)nativeModelBuilder);
    }

    protected void registerModelBuilder(ToolingModelBuilderRegistry registry, GlobalScope globalScope, VariantManager variantManager, AndroidConfig config2, ExtraModelInfo extraModelInfo) {
        registry.register(new ModelBuilder<AndroidConfig>(globalScope, variantManager, this.taskManager, config2, extraModelInfo, this.getProjectType(), 1));
    }

    private void createTasks() {
        this.threadRecorder.record(GradleBuildProfileSpan.ExecutionType.TASK_MANAGER_CREATE_TASKS, this.project.getPath(), null, () -> this.taskManager.createTasksBeforeEvaluate());
        this.project.afterEvaluate(CrashReporting.afterEvaluate(p -> {
            this.sourceSetManager.runBuildableArtifactsActions();
            this.threadRecorder.record(GradleBuildProfileSpan.ExecutionType.BASE_PLUGIN_CREATE_ANDROID_TASKS, this.project.getPath(), null, this::createAndroidTasks);
        }));
    }

    static void checkGradleVersion(Project project, ILogger logger, ProjectOptions projectOptions) {
        String currentVersion = project.getGradle().getGradleVersion();
        if (GRADLE_MIN_VERSION.compareTo(currentVersion) > 0) {
            File file = new File("gradle" + File.separator + "wrapper" + File.separator + "gradle-wrapper.properties");
            String errorMessage = String.format("Minimum supported Gradle version is %s. Current version is %s. If using the gradle wrapper, try editing the distributionUrl in %s to gradle-%s-all.zip", GRADLE_MIN_VERSION, currentVersion, file.getAbsolutePath(), GRADLE_MIN_VERSION);
            if (projectOptions.get(BooleanOption.VERSION_CHECK_OVERRIDE_PROPERTY)) {
                logger.warning(errorMessage, new Object[0]);
                logger.warning("As %s is set, continuing anyway.", new Object[]{BooleanOption.VERSION_CHECK_OVERRIDE_PROPERTY.getPropertyName()});
            } else {
                throw new RuntimeException(errorMessage);
            }
        }
    }

    @VisibleForTesting
    final void createAndroidTasks() {
        Preconditions.checkState((this.extension.getBuildToolsRevision() != null ? 1 : 0) != 0, (Object)"buildToolsVersion is not specified.");
        Preconditions.checkState((this.extension.getCompileSdkVersion() != null ? 1 : 0) != 0, (Object)"compileSdkVersion is not specified.");
        this.extension.getCompileOptions().setDefaultJavaVersion(AbstractCompilesUtil.getDefaultJavaVersion(this.extension.getCompileSdkVersion()));
        if (this.project.getPlugins().hasPlugin(JavaPlugin.class)) {
            throw new BadPluginException("The 'java' plugin has been applied, but it is not compatible with the Android plugins.");
        }
        if (this.project.getPlugins().hasPlugin("me.tatarka.retrolambda")) {
            String warningMsg = "One of the plugins you are using supports Java 8 language features. To try the support built into the Android plugin, remove the following from your build.gradle:\n    apply plugin: 'me.tatarka.retrolambda'\nTo learn more, go to https://d.android.com/r/tools/java-8-support-message.html\n";
            this.extraModelInfo.getSyncIssueHandler().reportWarning(EvalIssueReporter.Type.GENERIC, warningMsg);
        }
        if (this.globalScope.getSdkComponents().getSdkFolder() == null) {
            return;
        }
        if (!(this.project.getState().getExecuted() && this.project.getState().getFailure() == null || SdkHandler.sTestSdkFolder != null)) {
            return;
        }
        if (this.hasCreatedTasks) {
            return;
        }
        this.hasCreatedTasks = true;
        this.extension.disableWrite();
        this.taskManager.configureCustomLintChecks();
        ProcessProfileWriter.getProject((String)this.project.getPath()).setCompileSdk(this.extension.getCompileSdkVersion()).setBuildToolsVersion(this.extension.getBuildToolsRevision().toString()).setSplits(AnalyticsUtil.toProto(this.extension.getSplits()));
        String kotlinPluginVersion = this.getKotlinPluginVersion();
        if (kotlinPluginVersion != null) {
            ProcessProfileWriter.getProject((String)this.project.getPath()).setKotlinPluginVersion(kotlinPluginVersion);
        }
        List<VariantScope> variantScopes = this.variantManager.createAndroidTasks();
        ApiObjectFactory apiObjectFactory = new ApiObjectFactory(this.globalScope.getAndroidBuilder(), this.extension, this.variantFactory, this.project.getObjects());
        for (VariantScope variantScope : variantScopes) {
            BaseVariantData variantData = variantScope.getVariantData();
            apiObjectFactory.create(variantData);
        }
        if (this.projectOptions.get(StringOption.IDE_RESTRICT_VARIANT_NAME) == null) {
            this.sourceSetManager.checkForUnconfiguredSourceSets();
        }
        this.taskManager.addDataBindingDependenciesIfNecessary(this.extension.getDataBinding(), this.variantManager.getVariantScopes());
        this.taskManager.configureGlobalLintTask(this.variantManager.getVariantScopes());
        int flavorDimensionCount = 0;
        if (this.extension.getFlavorDimensionList() != null) {
            flavorDimensionCount = this.extension.getFlavorDimensionList().size();
        }
        this.taskManager.createAnchorAssembleTasks(variantScopes, this.extension.getProductFlavors().size(), flavorDimensionCount, this.variantFactory.getVariantConfigurationTypes().size());
        for (VariantScope variantScope : this.variantManager.getVariantScopes()) {
            this.variantManager.publishBuildArtifacts(variantScope);
        }
        this.checkSplitConfiguration();
        this.variantManager.setHasCreatedTasks(true);
    }

    private void checkSplitConfiguration() {
        boolean splitsEnabled;
        String configApkUrl = "https://d.android.com/topic/instant-apps/guides/config-splits.html";
        boolean isFeatureModule = this.project.getPlugins().hasPlugin(FeaturePlugin.class);
        boolean generatePureSplits = this.extension.getGeneratePureSplits();
        Splits splits = this.extension.getSplits();
        boolean bl = splitsEnabled = splits.getDensity().isEnable() || splits.getAbi().isEnable() || splits.getLanguage().isEnable();
        if (!isFeatureModule && generatePureSplits) {
            this.extraModelInfo.getSyncIssueHandler().reportWarning(EvalIssueReporter.Type.GENERIC, "Configuration APKs are supported by the Google Play Store only when publishing Android Instant Apps. To instead generate stand-alone APKs for different device configurations, set generatePureSplits=false. For more information, go to " + configApkUrl);
        }
        if (!isFeatureModule && !generatePureSplits && splits.getLanguage().isEnable()) {
            this.extraModelInfo.getSyncIssueHandler().reportWarning(EvalIssueReporter.Type.GENERIC, "Per-language APKs are supported only when building Android Instant Apps. For more information, go to " + configApkUrl);
        }
        if (isFeatureModule && !generatePureSplits && splitsEnabled) {
            this.extraModelInfo.getSyncIssueHandler().reportWarning(EvalIssueReporter.Type.GENERIC, "Configuration APKs targeting different device configurations are automatically built when splits are enabled for a feature module.\nTo suppress this warning, remove \"generatePureSplits false\" from your build.gradle file.\nTo learn more, see " + configApkUrl);
        }
    }

    private void checkModulesForErrors() {
        Project rootProject = this.project.getRootProject();
        HashMap<String, Project> subProjectsById = new HashMap<String, Project>();
        for (Project subProject : rootProject.getAllprojects()) {
            String id = subProject.getGroup().toString() + ":" + subProject.getName();
            if (subProjectsById.containsKey(id)) {
                String message = String.format("Your project contains 2 or more modules with the same identification %1$s\nat \"%2$s\" and \"%3$s\".\nYou must use different identification (either name or group) for each modules.", id, ((Project)subProjectsById.get(id)).getPath(), subProject.getPath());
                throw new StopExecutionException(message);
            }
            subProjectsById.put(id, subProject);
        }
    }

    private void checkPathForErrors() {
        if (!System.getProperty("os.name").toLowerCase(Locale.US).contains("windows")) {
            return;
        }
        if (this.projectOptions.get(BooleanOption.OVERRIDE_PATH_CHECK_PROPERTY)) {
            return;
        }
        if (CharMatcher.ascii().matchesAllOf((CharSequence)this.project.getRootDir().getAbsolutePath())) {
            return;
        }
        String message = "Your project path contains non-ASCII characters. This will most likely cause the build to fail on Windows. Please move your project to a different directory. See http://b.android.com/95744 for details. This warning can be disabled by adding the line '" + BooleanOption.OVERRIDE_PATH_CHECK_PROPERTY.getPropertyName() + "=true' to gradle.properties file in the project directory.";
        throw new StopExecutionException(message);
    }

    public ToolingModelBuilderRegistry getModelBuilderRegistry() {
        return this.registry;
    }

    private String getKotlinPluginVersion() {
        Plugin plugin = this.project.getPlugins().findPlugin("kotlin-android");
        if (plugin == null) {
            return null;
        }
        try {
            Method method = plugin.getClass().getMethod("getKotlinPluginVersion", new Class[0]);
            method.setAccessible(true);
            return method.invoke((Object)plugin, new Object[0]).toString();
        }
        catch (Throwable e) {
            return "unknown";
        }
    }

    protected boolean isPackagePublished() {
        return false;
    }

    private static class UnsupportedAction
    implements Action<Object> {
        private final String message;

        UnsupportedAction(String message) {
            this.message = message;
        }

        public void execute(Object o) {
            throw new UnsupportedOperationException(this.message);
        }
    }
}

