/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.configure;

import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.cxx.configure.GradleLocalPropertiesKt;
import com.android.build.gradle.internal.cxx.configure.Location;
import com.android.build.gradle.internal.cxx.configure.LocationType;
import com.android.build.gradle.internal.cxx.configure.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.configure.NdkLocatorKt;
import com.android.build.gradle.internal.cxx.configure.SdkSourceProperties;
import com.android.build.gradle.internal.cxx.logging.BatchLoggingEnvironment;
import com.android.repository.Revision;
import com.android.utils.Pair;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0001\u001ab\u0010\u0005\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\u00032\b\u0010\b\u001a\u0004\u0018\u00010\u00012\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u000b0\n2\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0006\u0012\u0004\u0018\u00010\r0\nH\u0007\u001a\u0012\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u0001H\u0007\u001a\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b2\u0006\u0010\u0011\u001a\u00020\u0001H\u0007\u001a\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a8\u0006\u0017"}, d2={"findNdkPath", "Ljava/io/File;", "ndkVersionFromDsl", "", "projectDir", "findNdkPathImpl", "ndkDirProperty", "androidNdkHomeEnvironmentVariable", "sdkFolder", "getNdkVersionedFolderNames", "Lkotlin/Function1;", "", "getNdkSourceProperties", "Lcom/android/build/gradle/internal/cxx/configure/SdkSourceProperties;", "getNdkVersionInfo", "ndkRoot", "getNdkVersionedFolders", "ndkVersionRoot", "isAcceptableNdkVersion", "", "sourcePropertiesRevision", "Lcom/android/repository/Revision;", "revisionFromDsl", "gradle"})
public final class NdkLocatorKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @VisibleForTesting
    @Nullable
    public static final File findNdkPathImpl(@Nullable String ndkVersionFromDsl, @Nullable String ndkDirProperty, @Nullable String androidNdkHomeEnvironmentVariable, @Nullable File sdkFolder, @NotNull Function1<? super File, ? extends List<String>> getNdkVersionedFolderNames, @NotNull Function1<? super File, SdkSourceProperties> getNdkSourceProperties) {
        Intrinsics.checkParameterIsNotNull(getNdkVersionedFolderNames, (String)"getNdkVersionedFolderNames");
        Intrinsics.checkParameterIsNotNull(getNdkSourceProperties, (String)"getNdkSourceProperties");
        AutoCloseable autoCloseable = new BatchLoggingEnvironment();
        Throwable throwable = null;
        try {
            void ndkVersionFromDslRevision;
            Object maxValue$iv;
            Object maxElem$iv;
            Object object;
            void $receiver$iv$iv;
            void $receiver$iv;
            Iterable $receiver$iv2;
            Iterable iterable;
            Location location;
            Collection collection;
            BatchLoggingEnvironment it = (BatchLoggingEnvironment)autoCloseable;
            boolean bl = false;
            findNdkPathImpl.1.1 considerAndReject$ = findNdkPathImpl.1.1.INSTANCE;
            List foundLocations = new ArrayList();
            if (ndkDirProperty != null) {
                collection = foundLocations;
                location = new Location(LocationType.NDK_DIR_LOCATION, new File(ndkDirProperty));
                collection.add(location);
            }
            if (androidNdkHomeEnvironmentVariable != null) {
                collection = foundLocations;
                location = new Location(LocationType.ANDROID_NDK_HOME_LOCATION, new File(androidNdkHomeEnvironmentVariable));
                collection.add(location);
            }
            if (sdkFolder != null) {
                collection = foundLocations;
                location = new Location(LocationType.NDK_BUNDLE_FOLDER_LOCATION, new File(sdkFolder, "ndk-bundle"));
                collection.add(location);
            }
            collection = new Ref.ObjectRef();
            ((Ref.ObjectRef)collection).element = null;
            if (ndkVersionFromDsl != null) {
                try {
                    ndkVersionFromDslRevision.element = Revision.parseRevision((String)ndkVersionFromDsl);
                }
                catch (NumberFormatException e) {
                    LoggingEnvironmentKt.error("Requested NDK version '" + ndkVersionFromDsl + "' could not be parsed", new Object[0]);
                }
            }
            if (sdkFolder != null) {
                void $receiver$iv$iv2;
                File versionRoot = new File(sdkFolder, "ndk");
                iterable = foundLocations;
                Iterable iterable2 = (Iterable)getNdkVersionedFolderNames.invoke((Object)versionRoot);
                void var16_19 = $receiver$iv2;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv2) {
                    void version;
                    String string = (String)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl2 = false;
                    Location location2 = new Location(LocationType.NDK_VERSIONED_FOLDER_LOCATION, new File(versionRoot, (String)version));
                    collection2.add(location2);
                }
                $receiver$iv2 = (List)destination$iv$iv;
                CollectionsKt.addAll((Collection)iterable, (Iterable)$receiver$iv2);
            }
            iterable = foundLocations;
            $receiver$iv2 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            void $receiver$iv$iv$iv = $receiver$iv$iv;
            Iterator iterator = $receiver$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                kotlin.Pair pair;
                kotlin.Pair pair2;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                Location location3 = (Location)element$iv$iv;
                boolean bl3 = false;
                SdkSourceProperties versionInfo = (SdkSourceProperties)getNdkSourceProperties.invoke((Object)location3.getNdkRoot());
                if (versionInfo == null) {
                    findNdkPathImpl.1.1.INSTANCE.invoke(location3, "that location didn't exist");
                    pair2 = null;
                } else if (versionInfo.getValue(SdkSourceProperties.Companion.SdkSourceProperty.SDK_PKG_REVISION) == null) {
                    findNdkPathImpl.1.1.INSTANCE.invoke(location3, "that location had source.properties " + "with no " + SdkSourceProperties.Companion.SdkSourceProperty.SDK_PKG_REVISION.getKey());
                    pair2 = null;
                } else {
                    kotlin.Pair pair3;
                    String revision2;
                    if (versionInfo.getValue(SdkSourceProperties.Companion.SdkSourceProperty.SDK_PKG_REVISION) == null) {
                        Intrinsics.throwNpe();
                    }
                    try {
                        Revision.parseRevision((String)revision2);
                        pair3 = new kotlin.Pair((Object)location3, (Object)versionInfo);
                    }
                    catch (NumberFormatException e) {
                        findNdkPathImpl.1.1.INSTANCE.invoke(location3, "that location had " + "source.properties with invalid " + SdkSourceProperties.Companion.SdkSourceProperty.SDK_PKG_REVISION.getKey() + '=' + revision2);
                        pair3 = null;
                    }
                    pair2 = pair3;
                }
                if (pair2 == null) continue;
                kotlin.Pair it$iv$iv = pair = pair2;
                destination$iv$iv.add(it$iv$iv);
            }
            List versionedLocations = (List)destination$iv$iv;
            $receiver$iv2 = versionedLocations;
            Iterator iterator$iv = $receiver$iv2.iterator();
            if (!iterator$iv.hasNext()) {
                object = null;
            } else {
                maxElem$iv = iterator$iv.next();
                kotlin.Pair $$_$_sourceProperties = (kotlin.Pair)maxElem$iv;
                boolean bl4 = false;
                SdkSourceProperties sourceProperties = (SdkSourceProperties)$$_$_sourceProperties.component2();
                maxValue$iv = (Comparable)sourceProperties.getRevision();
                while (iterator$iv.hasNext()) {
                    Object e$iv = iterator$iv.next();
                    kotlin.Pair $$_$_sourceProperties2 = (kotlin.Pair)e$iv;
                    $i$a$-maxBy-NdkLocatorKt$findNdkPathImpl$1$highest$1 = false;
                    SdkSourceProperties sourceProperties2 = (SdkSourceProperties)$$_$_sourceProperties2.component2();
                    Comparable v$iv = (Comparable)sourceProperties2.getRevision();
                    if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                }
                object = maxElem$iv;
            }
            kotlin.Pair highest = (kotlin.Pair)object;
            if (highest == null) {
                if ((Revision)ndkVersionFromDslRevision.element == null) {
                    LoggingEnvironmentKt.warn("Compatible side by side NDK version was not found.", new Object[0]);
                } else {
                    LoggingEnvironmentKt.warn("Compatible side by side NDK version was not found for android.ndkVersion " + '\'' + (Revision)ndkVersionFromDslRevision.element + '\'', new Object[0]);
                }
                File file = null;
                return file;
            }
            if ((Revision)ndkVersionFromDslRevision.element != null) {
                void $receiver$iv$iv3;
                Object version;
                if (ndkDirProperty != null) {
                    Object v2;
                    block43: {
                        iterator$iv = versionedLocations;
                        maxElem$iv = iterator$iv;
                        for (Object e : maxElem$iv) {
                            kotlin.Pair $location_$_$ = (kotlin.Pair)e;
                            boolean bl5 = false;
                            Location location4 = (Location)$location_$_$.component1();
                            if (!(location4.getType() == LocationType.NDK_DIR_LOCATION)) continue;
                            v2 = e;
                            break block43;
                        }
                        v2 = null;
                    }
                    kotlin.Pair ndkDirLocation = v2;
                    if (ndkDirLocation == null) {
                        LoggingEnvironmentKt.error("Location specified by ndk.dir (" + ndkDirProperty + ") did not contain a " + "valid NDK and so couldn't satisfy the requested NDK version " + ndkVersionFromDsl, new Object[0]);
                    } else {
                        void location5;
                        maxValue$iv = ndkDirLocation;
                        iterator$iv = (Location)maxValue$iv.component1();
                        version = (SdkSourceProperties)maxValue$iv.component2();
                        if (NdkLocatorKt.isAcceptableNdkVersion(((SdkSourceProperties)version).getRevision(), (Revision)ndkVersionFromDslRevision.element)) {
                            LoggingEnvironmentKt.info("Choosing " + location5.getNdkRoot() + " from ndk.dir which had the requested " + "version " + ndkVersionFromDsl, new Object[0]);
                        } else {
                            LoggingEnvironmentKt.error("Requested NDK version " + ndkVersionFromDsl + " did not match the version " + ((SdkSourceProperties)version).getRevision() + " requested by ndk.dir at " + location5.getNdkRoot(), new Object[0]);
                        }
                        File file = location5.getNdkRoot();
                        return file;
                    }
                }
                Iterable $receiver$iv3 = versionedLocations;
                version = $receiver$iv3;
                Collection destination$iv$iv2 = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv3) {
                    kotlin.Pair $$_$_sourceProperties = (kotlin.Pair)element$iv$iv;
                    boolean bl6 = false;
                    SdkSourceProperties sourceProperties = (SdkSourceProperties)$$_$_sourceProperties.component2();
                    if (!NdkLocatorKt.isAcceptableNdkVersion(sourceProperties.getRevision(), (Revision)ndkVersionFromDslRevision.element)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                List matchingLocations = (List)destination$iv$iv2;
                if (matchingLocations.isEmpty()) {
                    Iterable iterable3;
                    LoggingEnvironmentKt.error("No version of NDK matched the requested version " + ndkVersionFromDsl, new Object[0]);
                    Iterable $receiver$iv4 = iterable3 = ($receiver$iv3 = (Iterable)versionedLocations);
                    for (Object element$iv : $receiver$iv4) {
                        kotlin.Pair $location_version = (kotlin.Pair)element$iv;
                        boolean bl7 = false;
                        Location location6 = (Location)$location_version.component1();
                        SdkSourceProperties version2 = (SdkSourceProperties)$location_version.component2();
                        findNdkPathImpl.1.1.INSTANCE.invoke(location6, "that NDK had version " + version2.getRevision() + " which didn't " + "match the requested version " + ndkVersionFromDsl);
                    }
                    File file = ((Location)highest.getFirst()).getNdkRoot();
                    return file;
                }
                File foundNdkRoot2 = ((Location)((kotlin.Pair)CollectionsKt.last((List)SequencesKt.toList((Sequence)SequencesKt.sortedWith((Sequence)CollectionsKt.asSequence((Iterable)matchingLocations), (Comparator)ComparisonsKt.compareBy((Function1[])new Function1[]{findNdkPathImpl.1.foundNdkRoot.1.INSTANCE, findNdkPathImpl.1.foundNdkRoot.2.INSTANCE}))))).getFirst()).getNdkRoot();
                if (matchingLocations.size() > 1) {
                    LoggingEnvironmentKt.info("Found " + matchingLocations.size() + " NDK folders that matched requested " + "version " + (Revision)ndkVersionFromDslRevision.element + ", choosing " + foundNdkRoot2, new Object[0]);
                } else {
                    LoggingEnvironmentKt.info("Found requested NDK version " + (Revision)ndkVersionFromDslRevision.element + " at " + foundNdkRoot2, new Object[0]);
                }
                File file = foundNdkRoot2;
                return file;
            }
            LoggingEnvironmentKt.info("No user requested version, choosing " + ((Location)highest.getFirst()).getNdkRoot() + " which is " + "version " + ((SdkSourceProperties)highest.getSecond()).getRevision(), new Object[0]);
            File file = ((Location)highest.getFirst()).getNdkRoot();
            return file;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private static final boolean isAcceptableNdkVersion(Revision sourcePropertiesRevision, Revision revisionFromDsl) {
        boolean bl;
        int[] parts = revisionFromDsl.toIntArray(true);
        switch (parts.length) {
            case 3: 
            case 4: {
                bl = Intrinsics.areEqual((Object)sourcePropertiesRevision, (Object)revisionFromDsl);
                break;
            }
            case 2: {
                if (revisionFromDsl.getMajor() == sourcePropertiesRevision.getMajor() && revisionFromDsl.getMinor() == sourcePropertiesRevision.getMinor()) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 1: {
                if (revisionFromDsl.getMajor() == sourcePropertiesRevision.getMajor()) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                throw (Throwable)new RuntimeException("Unexpected");
            }
        }
        return bl;
    }

    @VisibleForTesting
    @Nullable
    public static final SdkSourceProperties getNdkVersionInfo(@NotNull File ndkRoot) {
        SdkSourceProperties sdkSourceProperties;
        Intrinsics.checkParameterIsNotNull((Object)ndkRoot, (String)"ndkRoot");
        try {
            sdkSourceProperties = SdkSourceProperties.Companion.fromInstallFolder(ndkRoot);
        }
        catch (FileNotFoundException e) {
            sdkSourceProperties = null;
        }
        return sdkSourceProperties;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public static final List<String> getNdkVersionedFolders(@NotNull File ndkVersionRoot) {
        void var3_3;
        void $receiver$iv$iv;
        String[] $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)ndkVersionRoot, (String)"ndkVersionRoot");
        if (!ndkVersionRoot.isDirectory()) {
            return CollectionsKt.emptyList();
        }
        String[] stringArray = ndkVersionRoot.list();
        Intrinsics.checkExpressionValueIsNotNull((Object)stringArray, (String)"ndkVersionRoot.list()");
        String[] stringArray2 = $receiver$iv = stringArray;
        Collection destination$iv$iv = new ArrayList();
        void var4_4 = $receiver$iv$iv;
        int n = ((void)var4_4).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = var4_4[i];
            boolean bl = false;
            if (!new File(ndkVersionRoot, (String)it).isDirectory()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)var3_3;
    }

    @Nullable
    public static final File findNdkPath(@Nullable String ndkVersionFromDsl, @NotNull File projectDir) {
        Intrinsics.checkParameterIsNotNull((Object)projectDir, (String)"projectDir");
        Properties properties = GradleLocalPropertiesKt.gradleLocalProperties(projectDir);
        Pair<File, Boolean> pair = SdkHandler.findSdkLocation(properties, projectDir);
        Intrinsics.checkExpressionValueIsNotNull(pair, (String)"SdkHandler.findSdkLocation(properties, projectDir)");
        Pair<File, Boolean> sdkLocation = pair;
        File sdkPath = (File)sdkLocation.getFirst();
        return NdkLocatorKt.findNdkPathImpl(ndkVersionFromDsl, properties.getProperty("ndk.dir"), System.getenv("ANDROID_NDK_HOME"), sdkPath, (Function1<? super File, ? extends List<String>>)((Function1)findNdkPath.1.INSTANCE), (Function1<? super File, SdkSourceProperties>)((Function1)findNdkPath.2.INSTANCE));
    }
}

