/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.OutputFile;
import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.api.artifact.BuildableArtifactUtil;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidBuilderTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.builder.internal.InstallUtils;
import com.android.builder.testing.ConnectedDeviceProvider;
import com.android.builder.testing.api.DeviceConfigProvider;
import com.android.builder.testing.api.DeviceConfigProviderImpl;
import com.android.builder.testing.api.DeviceConnector;
import com.android.builder.testing.api.DeviceException;
import com.android.builder.testing.api.DeviceProvider;
import com.android.ide.common.build.SplitOutputMatcher;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessExecutor;
import com.android.sdklib.AndroidVersion;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;

public class InstallVariantTask
extends AndroidBuilderTask {
    private Provider<File> adbExecutableProvider;
    private Provider<File> splitSelectExeProvider;
    private ProcessExecutor processExecutor;
    private String projectName;
    private int timeOutInMs = 0;
    private Collection<String> installOptions;
    private BuildableArtifact apkDirectory;
    private BaseVariantData variantData;

    public InstallVariantTask() {
        this.getOutputs().upToDateWhen(task -> {
            this.getLogger().debug("Install task is always run.");
            return false;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public void install() throws DeviceException, ProcessException {
        ILogger iLogger = this.getILogger();
        ConnectedDeviceProvider deviceProvider = new ConnectedDeviceProvider((File)this.adbExecutableProvider.get(), this.getTimeOutInMs(), iLogger);
        deviceProvider.init();
        try {
            BaseVariantData variantData = this.getVariantData();
            GradleVariantConfiguration variantConfig = variantData.getVariantConfiguration();
            ImmutableList outputs = ImmutableList.copyOf((Iterable)ExistingBuildElements.from((ArtifactType)InternalArtifactType.APK, BuildableArtifactUtil.singleFile(this.apkDirectory)));
            InstallVariantTask.install(this.getProjectName(), variantConfig.getFullName(), (DeviceProvider)deviceProvider, variantConfig.getMinSdkVersion(), this.getProcessExecutor(), (File)this.getSplitSelectExe().getOrNull(), (List<OutputFile>)outputs, variantConfig.getSupportedAbis(), this.getInstallOptions(), this.getTimeOutInMs(), this.getLogger());
        }
        finally {
            deviceProvider.terminate();
        }
    }

    static void install(String projectName, String variantName2, DeviceProvider deviceProvider, AndroidVersion minSkdVersion, ProcessExecutor processExecutor, File splitSelectExe, List<OutputFile> outputs, Set<String> supportedAbis2, Collection<String> installOptions, int timeOutInMs, Logger logger) throws DeviceException, ProcessException {
        LoggerWrapper iLogger = new LoggerWrapper(logger);
        int successfulInstallCount = 0;
        List devices = deviceProvider.getDevices();
        for (DeviceConnector device : devices) {
            if (!InstallUtils.checkDeviceApiLevel((DeviceConnector)device, (AndroidVersion)minSkdVersion, (ILogger)iLogger, (String)projectName, (String)variantName2)) continue;
            List apkFiles = SplitOutputMatcher.computeBestOutput((ProcessExecutor)processExecutor, (File)splitSelectExe, (DeviceConfigProvider)new DeviceConfigProviderImpl(device), outputs, supportedAbis2);
            if (apkFiles.isEmpty()) {
                logger.lifecycle("Skipping device '{}' for '{}:{}': Could not find build of variant which supports density {} and an ABI in {}", new Object[]{device.getName(), projectName, variantName2, device.getDensity(), Joiner.on((String)", ").join((Iterable)device.getAbis())});
                continue;
            }
            logger.lifecycle("Installing APK '{}' on '{}' for {}:{}", new Object[]{FileUtils.getNamesAsCommaSeparatedList((Iterable)apkFiles), device.getName(), projectName, variantName2});
            Collection extraArgs = (Collection)MoreObjects.firstNonNull(installOptions, (Object)ImmutableList.of());
            if (apkFiles.size() > 1) {
                device.installPackages(apkFiles, extraArgs, timeOutInMs, (ILogger)iLogger);
                ++successfulInstallCount;
                continue;
            }
            device.installPackage((File)apkFiles.get(0), extraArgs, timeOutInMs, (ILogger)iLogger);
            ++successfulInstallCount;
        }
        if (successfulInstallCount == 0) {
            throw new GradleException("Failed to install on any devices.");
        }
        logger.quiet("Installed on {} {}.", new Object[]{successfulInstallCount, successfulInstallCount == 1 ? "device" : "devices"});
    }

    @InputFile
    public Provider<File> getAdbExe() {
        return this.adbExecutableProvider;
    }

    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.NONE)
    public Provider<File> getSplitSelectExe() {
        return this.splitSelectExeProvider;
    }

    public ProcessExecutor getProcessExecutor() {
        return this.processExecutor;
    }

    public void setProcessExecutor(ProcessExecutor processExecutor) {
        this.processExecutor = processExecutor;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @Input
    public int getTimeOutInMs() {
        return this.timeOutInMs;
    }

    public void setTimeOutInMs(int timeOutInMs) {
        this.timeOutInMs = timeOutInMs;
    }

    @Input
    @Optional
    public Collection<String> getInstallOptions() {
        return this.installOptions;
    }

    public void setInstallOptions(Collection<String> installOptions) {
        this.installOptions = installOptions;
    }

    @InputFiles
    public BuildableArtifact getApkDirectory() {
        return this.apkDirectory;
    }

    public void setApkDirectory(BuildableArtifact apkDirectory) {
        this.apkDirectory = apkDirectory;
    }

    public BaseVariantData getVariantData() {
        return this.variantData;
    }

    public void setVariantData(BaseVariantData variantData) {
        this.variantData = variantData;
    }

    public static class CreationAction
    extends VariantTaskCreationAction<InstallVariantTask> {
        public CreationAction(VariantScope scope) {
            super(scope);
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("install");
        }

        @Override
        public Class<InstallVariantTask> getType() {
            return InstallVariantTask.class;
        }

        @Override
        public void configure(InstallVariantTask task) {
            super.configure(task);
            VariantScope scope = this.getVariantScope();
            task.setVariantData(scope.getVariantData());
            task.setDescription("Installs the " + scope.getVariantData().getDescription() + ".");
            task.setGroup("Install");
            task.setProjectName(scope.getGlobalScope().getProject().getName());
            task.setApkDirectory(scope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.APK));
            task.setTimeOutInMs(scope.getGlobalScope().getExtension().getAdbOptions().getTimeOutInMs());
            task.setInstallOptions(scope.getGlobalScope().getExtension().getAdbOptions().getInstallOptions());
            task.setProcessExecutor(scope.getGlobalScope().getAndroidBuilder().getProcessExecutor());
            task.adbExecutableProvider = scope.getGlobalScope().getSdkComponents().getAdbExecutableProvider();
            task.splitSelectExeProvider = scope.getGlobalScope().getSdkComponents().getSplitSelectExecutableProvider();
        }

        @Override
        public void handleProvider(TaskProvider<? extends InstallVariantTask> taskProvider) {
            super.handleProvider(taskProvider);
            this.getVariantScope().getTaskContainer().setInstallTask(taskProvider);
        }
    }
}

