/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ndk;

import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.cxx.configure.NdkAbiFile;
import com.android.build.gradle.internal.cxx.configure.NdkAbiFileKt;
import com.android.build.gradle.internal.cxx.configure.PlatformConfigurator;
import com.android.build.gradle.internal.ndk.AbiInfo;
import com.android.build.gradle.internal.ndk.DefaultNdkInfo;
import com.android.build.gradle.internal.ndk.NdkInfo;
import com.android.repository.Revision;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.utils.FileUtils;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FilenameFilter;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.StringsKt;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0019\u001a\u00020\u0011H\u0016J\u001a\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00112\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u001bH\u0002J\u0010\u0010!\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\tH\u0002J\u0010\u0010\"\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\tH\u0016J\u0010\u0010#\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\tH\u0014J\u0010\u0010$\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\tH\u0002J\u0010\u0010%\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\tH\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\b\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\"\u0010\r\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fRN\u0010\u000f\u001aB\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00110\u0011 \n* \u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00110\u0011\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0014\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\fR\"\u0010\u0016\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\f\u00a8\u0006&"}, d2={"Lcom/android/build/gradle/internal/ndk/DefaultNdkInfo;", "Lcom/android/build/gradle/internal/ndk/NdkInfo;", "rootDirectory", "Ljava/io/File;", "(Ljava/io/File;)V", "abiInfoList", "", "Lcom/android/build/gradle/internal/ndk/AbiInfo;", "default32BitsAbis", "Lcom/android/build/gradle/internal/core/Abi;", "kotlin.jvm.PlatformType", "getDefault32BitsAbis", "()Ljava/util/List;", "defaultAbis", "getDefaultAbis", "defaultToolchainVersions", "Ljava/util/HashMap;", "", "platformConfigurator", "Lcom/android/build/gradle/internal/cxx/configure/PlatformConfigurator;", "supported32BitsAbis", "getSupported32BitsAbis", "supportedAbis", "getSupportedAbis", "findLatestPlatformVersion", "targetPlatformString", "findSuitablePlatformVersion", "", "abi", "androidVersion", "Lcom/android/sdklib/AndroidVersion;", "findTargetPlatformVersionOrLower", "targetVersion", "getDefaultToolchainVersion", "getStripExecutable", "getToolchainAbi", "getToolchainPath", "getToolchainPrefix", "gradle"})
public class DefaultNdkInfo
implements NdkInfo {
    private final PlatformConfigurator platformConfigurator;
    private final List<AbiInfo> abiInfoList;
    private final HashMap<Abi, String> defaultToolchainVersions;
    private final File rootDirectory;

    @Override
    @Nullable
    public String findLatestPlatformVersion(@NotNull String targetPlatformString) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)targetPlatformString, (String)"targetPlatformString");
        AndroidVersion androidVersion = AndroidTargetHash.getVersionFromHash((String)targetPlatformString);
        int targetVersion = 0;
        if (androidVersion == null) {
            Logging.getLogger(this.getClass()).warn("Unable to parse NDK platform version.  Try to find the latest instead.");
            n = Integer.MAX_VALUE;
        } else {
            n = androidVersion.getFeatureLevel();
        }
        targetVersion = n;
        targetVersion = this.findTargetPlatformVersionOrLower(targetVersion);
        return targetVersion == 0 ? null : "android-" + targetVersion;
    }

    @Override
    public int findSuitablePlatformVersion(@NotNull String abi, @Nullable AndroidVersion androidVersion) {
        Intrinsics.checkParameterIsNotNull((Object)abi, (String)"abi");
        return this.platformConfigurator.findSuitablePlatformVersion(abi, androidVersion);
    }

    private final int findTargetPlatformVersionOrLower(int targetVersion) {
        File platformDir = new File(this.rootDirectory, "/platforms");
        if (new File(platformDir, "android-" + targetVersion).exists()) {
            return targetVersion;
        }
        File[] platformSubDirs2 = platformDir.listFiles(findTargetPlatformVersionOrLower.platformSubDirs.1.INSTANCE);
        int highestVersion = 0;
        boolean bl = platformSubDirs2 != null;
        int n = 0;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (platformSubDirs2 == null) {
            Intrinsics.throwNpe();
        }
        File[] fileArray = platformSubDirs2;
        int n2 = fileArray.length;
        for (n = 0; n < n2; ++n) {
            File platform;
            File file = platform = fileArray[n];
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"platform");
            String string = file.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"platform.name");
            if (!StringsKt.startsWith$default((String)string, (String)"android-", (boolean)false, (int)2, null)) continue;
            try {
                String string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)platform.getName(), (String)"platform.name");
                int n3 = "android-".length();
                boolean bl4 = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.substring(n3);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                int version = Integer.parseInt(string4);
                int n4 = version;
                if (highestVersion + 1 > n4 || targetVersion - 1 < n4) continue;
                highestVersion = version;
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return highestVersion;
    }

    private final String getToolchainPrefix(Abi abi) {
        String string = abi.getGccToolchainPrefix();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"abi.gccToolchainPrefix");
        return string;
    }

    private final File getToolchainPath(Abi abi) {
        Abi toolchainAbi = this.getToolchainAbi(abi);
        String version = this.getDefaultToolchainVersion(toolchainAbi);
        CharSequence charSequence = version;
        boolean bl = false;
        version = charSequence.length() == 0 ? "" : '-' + version;
        File prebuiltFolder = new File(this.rootDirectory, "toolchains/" + this.getToolchainPrefix(toolchainAbi) + version + "/prebuilt");
        String string = System.getProperty("os.name");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"System.getProperty(\"os.name\")");
        String string2 = string;
        Locale locale = Locale.ENGLISH;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ENGLISH");
        Locale locale2 = locale;
        boolean bl2 = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase(locale2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase(locale)");
        String osName = string4;
        String hostOs = null;
        hostOs = StringsKt.contains$default((CharSequence)osName, (CharSequence)"windows", (boolean)false, (int)2, null) ? "windows" : (StringsKt.contains$default((CharSequence)osName, (CharSequence)"mac", (boolean)false, (int)2, null) ? "darwin" : "linux");
        File[] fileArray = prebuiltFolder.listFiles(getToolchainPath.toolchainPaths.1.INSTANCE);
        if (fileArray == null) {
            throw (Throwable)new InvalidUserDataException("Unable to find toolchain: " + prebuiltFolder);
        }
        File[] toolchainPaths2 = fileArray;
        if (toolchainPaths2.length == 1) {
            File file = toolchainPaths2[0];
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"toolchainPaths[0]");
            return file;
        }
        File toolchainPath = new File(prebuiltFolder, hostOs + "-x86_64");
        if (toolchainPath.isDirectory()) {
            return toolchainPath;
        }
        String osString = Intrinsics.areEqual((Object)osName, (Object)"windows") ? hostOs : hostOs + "-x86";
        toolchainPath = new File(prebuiltFolder, osString);
        if (!toolchainPath.isDirectory()) {
            throw (Throwable)new InvalidUserDataException("Unable to find toolchain prebuilt folder in: " + prebuiltFolder);
        }
        return toolchainPath;
    }

    @NotNull
    protected Abi getToolchainAbi(@NotNull Abi abi) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)abi), (String)"abi");
        return abi;
    }

    @Override
    @NotNull
    public File getStripExecutable(@NotNull Abi abi) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)abi), (String)"abi");
        Abi toolchainAbi = this.getToolchainAbi(abi);
        File file = FileUtils.join((File)this.getToolchainPath(toolchainAbi), (String[])new String[]{"bin", toolchainAbi.getGccExecutablePrefix() + "-strip"});
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"FileUtils.join(\n        \u2026efix + \"-strip\"\n        )");
        return file;
    }

    private final String getDefaultToolchainVersion(Abi abi) {
        File[] toolchainsForAbi2;
        String toolchainPrefix;
        Abi toolchainAbi;
        block10: {
            block9: {
                toolchainAbi = this.getToolchainAbi(abi);
                String defaultVersion = this.defaultToolchainVersions.get((Object)toolchainAbi);
                if (defaultVersion != null) {
                    return defaultVersion;
                }
                File toolchains = new File(this.rootDirectory, "toolchains");
                toolchainPrefix = this.getToolchainPrefix(toolchainAbi);
                toolchainsForAbi2 = toolchains.listFiles(new FilenameFilter(toolchainPrefix){
                    final /* synthetic */ String $toolchainPrefix;

                    public final boolean accept(File $noName_0, String filename) {
                        String string = filename;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"filename");
                        return StringsKt.startsWith$default((String)string, (String)this.$toolchainPrefix, (boolean)false, (int)2, null);
                    }
                    {
                        this.$toolchainPrefix = string;
                    }
                });
                if (toolchainsForAbi2 == null) break block9;
                File[] fileArray = toolchainsForAbi2;
                boolean bl = false;
                if (!(fileArray.length == 0)) break block10;
            }
            throw (Throwable)new RuntimeException("No toolchains found in the NDK toolchains folder for ABI with prefix: " + toolchainPrefix);
        }
        Revision bestRevision = null;
        String bestVersionString = "";
        File[] fileArray = toolchainsForAbi2;
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            File toolchainFolder;
            File file = toolchainFolder = fileArray[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"toolchainFolder");
            String folderName = file.getName();
            Revision revision = new Revision(0);
            String versionString = "";
            if (folderName.length() > toolchainPrefix.length() + 1) {
                try {
                    String string;
                    Intrinsics.checkExpressionValueIsNotNull((Object)folderName, (String)"folderName");
                    int n2 = toolchainPrefix.length() + 1;
                    boolean bl = false;
                    String string2 = string;
                    if (string2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string3 = string2.substring(n2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                    versionString = string3;
                    Revision revision2 = Revision.parseRevision((String)versionString);
                    Intrinsics.checkExpressionValueIsNotNull((Object)revision2, (String)"Revision.parseRevision(versionString)");
                    revision = revision2;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (bestRevision != null && revision.compareTo(bestRevision) <= 0) continue;
            bestRevision = revision;
            bestVersionString = versionString;
        }
        HashMap<Abi, String> hashMap = this.defaultToolchainVersions;
        Intrinsics.checkExpressionValueIsNotNull(hashMap, (String)"defaultToolchainVersions");
        ((Map)hashMap).put(toolchainAbi, bestVersionString);
        return bestVersionString;
    }

    @NotNull
    public List<Abi> getDefault32BitsAbis() {
        Stream stream = this.abiInfoList.stream().filter(default32BitsAbis.1.INSTANCE).map(default32BitsAbis.2.INSTANCE).filter(default32BitsAbis.3.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull(stream, (String)"abiInfoList\n            \u2026> !abi.supports64Bits() }");
        return StreamsKt.toList(stream);
    }

    @NotNull
    public List<Abi> getDefaultAbis() {
        Stream stream = this.abiInfoList.stream().filter(defaultAbis.1.INSTANCE).map(defaultAbis.2.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull(stream, (String)"abiInfoList\n            \u2026      .map<Abi>{ it.abi }");
        return StreamsKt.toList(stream);
    }

    @NotNull
    public List<Abi> getSupported32BitsAbis() {
        Stream stream = this.abiInfoList.stream().map(supported32BitsAbis.1.INSTANCE).filter(supported32BitsAbis.2.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull(stream, (String)"abiInfoList\n            \u2026> !abi.supports64Bits() }");
        return StreamsKt.toList(stream);
    }

    @NotNull
    public List<Abi> getSupportedAbis() {
        Stream stream = this.abiInfoList.stream().map(supportedAbis.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull(stream, (String)"abiInfoList\n            \u2026           .map{ it.abi }");
        return StreamsKt.toList(stream);
    }

    public DefaultNdkInfo(@NotNull File rootDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)rootDirectory, (String)"rootDirectory");
        this.rootDirectory = rootDirectory;
        this.platformConfigurator = new PlatformConfigurator(this.rootDirectory);
        this.abiInfoList = new NdkAbiFile(NdkAbiFileKt.ndkMetaAbisFile(this.rootDirectory)).getAbiInfoList();
        this.defaultToolchainVersions = Maps.newHashMap();
    }
}

