/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.builder.dexing.DexArchiveMerger;
import com.android.builder.dexing.DexMergerTool;
import com.android.builder.dexing.DexingType;
import com.android.dx.command.dexer.DxContext;
import com.android.ide.common.blame.MessageReceiver;
import com.android.ide.common.process.ProcessOutput;
import java.io.File;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinPool;

public class DexMergerTransformCallable
implements Callable<Void> {
    private final MessageReceiver messageReceiver;
    private final DexingType dexingType;
    private final ProcessOutput processOutput;
    private final File dexOutputDir;
    private final Iterator<Path> dexArchives;
    private final ForkJoinPool forkJoinPool;
    private final Path mainDexList;
    private final DexMergerTool dexMerger;
    private final int minSdkVersion;
    private final boolean isDebuggable;

    public DexMergerTransformCallable(MessageReceiver messageReceiver, DexingType dexingType, ProcessOutput processOutput, File dexOutputDir, Iterator<Path> dexArchives, Path mainDexList, ForkJoinPool forkJoinPool, DexMergerTool dexMerger, int minSdkVersion, boolean isDebuggable2) {
        this.messageReceiver = messageReceiver;
        this.dexingType = dexingType;
        this.processOutput = processOutput;
        this.dexOutputDir = dexOutputDir;
        this.dexArchives = dexArchives;
        this.mainDexList = mainDexList;
        this.forkJoinPool = forkJoinPool;
        this.dexMerger = dexMerger;
        this.minSdkVersion = minSdkVersion;
        this.isDebuggable = isDebuggable2;
    }

    @Override
    public Void call() throws Exception {
        DexArchiveMerger merger;
        switch (this.dexMerger) {
            case DX: {
                DxContext dxContext = new DxContext(this.processOutput.getStandardOutput(), this.processOutput.getErrorOutput());
                merger = DexArchiveMerger.createDxDexMerger((DxContext)dxContext, (ForkJoinPool)this.forkJoinPool, (boolean)this.isDebuggable);
                break;
            }
            case D8: {
                int d8MinSdkVersion = this.minSdkVersion;
                if (d8MinSdkVersion < 21 && this.dexingType == DexingType.NATIVE_MULTIDEX) {
                    d8MinSdkVersion = 21;
                }
                merger = DexArchiveMerger.createD8DexMerger((MessageReceiver)this.messageReceiver, (int)d8MinSdkVersion, (boolean)this.isDebuggable, (ForkJoinPool)this.forkJoinPool);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown dex merger " + this.dexMerger.name()));
            }
        }
        merger.mergeDexArchives(this.dexArchives, this.dexOutputDir.toPath(), this.mainDexList, this.dexingType);
        return null;
    }

    public static interface Factory {
        public DexMergerTransformCallable create(MessageReceiver var1, DexingType var2, ProcessOutput var3, File var4, Iterator<Path> var5, Path var6, ForkJoinPool var7, DexMergerTool var8, int var9, boolean var10);
    }
}

