/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ExternalNativeBuildTaskUtils {
    public static final String CUSTOM_FORK_CMAKE_VERSION = "3.6.0-rc2";

    public static boolean fileIsUpToDate(File source, File derived) throws IOException {
        long derivedTimestamp;
        if (!source.exists()) {
            return false;
        }
        if (!derived.exists()) {
            return false;
        }
        long sourceTimestamp = Files.getLastModifiedTime(source.toPath(), new LinkOption[0]).toMillis();
        return sourceTimestamp <= (derivedTimestamp = Files.getLastModifiedTime(derived.toPath(), new LinkOption[0]).toMillis());
    }

    public static File getJsonMiniConfigFile(File originalJson) {
        return new File(originalJson.getParent(), "android_gradle_build_mini.json");
    }

    public static List<File> getOutputJsons(File jsonFolder2, Collection<String> abis) {
        ArrayList outputs = Lists.newArrayList();
        for (String abi : abis) {
            outputs.add(new File(new File(jsonFolder2, abi), "android_gradle_build.json"));
        }
        return outputs;
    }
}

