/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.SdkConstants;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.cxx.configure.JsonGenerationInvalidationState;
import com.android.build.gradle.internal.cxx.json.AndroidBuildGradleJsons;
import com.android.build.gradle.internal.cxx.json.NativeBuildConfigValueMini;
import com.android.build.gradle.internal.cxx.json.NativeLibraryValueMini;
import com.android.build.gradle.internal.cxx.logging.GradleSyncLoggingEnvironment;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.logging.PassThroughRecordingLoggingEnvironment;
import com.android.build.gradle.internal.cxx.logging.PassThroughRecordingLoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.model.CreateCxxAbiModelKt;
import com.android.build.gradle.internal.cxx.model.CreateCxxVariantModelKt;
import com.android.build.gradle.internal.cxx.model.CxxAbiModel;
import com.android.build.gradle.internal.cxx.model.CxxCmakeModuleModel;
import com.android.build.gradle.internal.cxx.model.CxxModuleModel;
import com.android.build.gradle.internal.cxx.model.CxxVariantModel;
import com.android.build.gradle.internal.profile.AnalyticsUtil;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.tasks.CmakeAndroidNinjaExternalNativeJsonGenerator;
import com.android.build.gradle.tasks.CmakeServerExternalNativeJsonGenerator;
import com.android.build.gradle.tasks.NativeBuildSystem;
import com.android.build.gradle.tasks.NdkBuildExternalNativeJsonGenerator;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.profile.ProcessProfileWriter;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.repository.Revision;
import com.android.utils.FileUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFiles;

public abstract class ExternalNativeJsonGenerator {
    protected final CxxVariantModel variant;
    protected final List<CxxAbiModel> abis;
    protected final Set<String> configurationFailures;
    protected final AndroidBuilder androidBuilder;
    protected final GradleBuildVariant.Builder stats;

    ExternalNativeJsonGenerator(CxxVariantModel variant, List<CxxAbiModel> abis, Set<String> configurationFailures, AndroidBuilder androidBuilder, GradleBuildVariant.Builder stats) {
        this.variant = variant;
        this.abis = abis;
        this.configurationFailures = configurationFailures;
        this.androidBuilder = androidBuilder;
        this.stats = stats;
        if (!this.getNdkFolder().isDirectory()) {
            LoggingEnvironmentKt.errorln("NDK not configured (%s).\nDownload the NDK from http://developer.android.com/tools/sdk/ndk/.Then add ndk.dir=path/to/ndk in local.properties.\n(On Windows, make sure you escape backslashes, e.g. C:\\\\ndk rather than C:\\ndk)", this.getNdkFolder());
        }
    }

    protected static boolean isWindows() {
        return SdkConstants.CURRENT_PLATFORM == 2;
    }

    private List<File> getDependentBuildFiles(File json) throws IOException {
        ArrayList result = Lists.newArrayList();
        if (!json.exists()) {
            return result;
        }
        NativeBuildConfigValueMini config2 = AndroidBuildGradleJsons.getNativeBuildMiniConfig(json, this.stats);
        return config2.buildFiles;
    }

    public void build() throws IOException, ProcessException {
        this.buildAndPropagateException(false);
    }

    public void build(boolean forceJsonGeneration) {
        try {
            LoggingEnvironmentKt.infoln("building json with force flag %s", forceJsonGeneration);
            this.buildAndPropagateException(forceJsonGeneration);
        }
        catch (IOException | GradleException e) {
            LoggingEnvironmentKt.errorln("exception while building Json $%s", e.getMessage());
        }
        catch (ProcessException e) {
            LoggingEnvironmentKt.errorln("executing external native build for %s %s", this.getNativeBuildSystem().getTag(), this.variant.getModule().getMakeFile());
        }
    }

    public List<Callable<Void>> parallelBuild(boolean forceJsonGeneration) {
        ArrayList<Callable<Void>> buildSteps = new ArrayList<Callable<Void>>(this.abis.size());
        for (CxxAbiModel abi : this.abis) {
            buildSteps.add(() -> this.buildForOneConfigurationConvertExceptions(forceJsonGeneration, abi));
        }
        return buildSteps;
    }

    private Void buildForOneConfigurationConvertExceptions(boolean forceJsonGeneration, CxxAbiModel abi) {
        try (GradleSyncLoggingEnvironment ignore = new GradleSyncLoggingEnvironment(this.getVariantName(), abi.getAbi().getTag(), this.configurationFailures, this.androidBuilder.getIssueReporter(), this.androidBuilder.getLogger());){
            try {
                this.buildForOneConfiguration(forceJsonGeneration, abi);
            }
            catch (IOException | GradleException e) {
                LoggingEnvironmentKt.errorln("exception while building Json %s", e.getMessage());
            }
            catch (ProcessException e) {
                LoggingEnvironmentKt.errorln("executing external native build for %s %s", this.getNativeBuildSystem().getTag(), this.variant.getModule().getMakeFile());
            }
            Void void_ = null;
            return void_;
        }
    }

    private static String getPreviousBuildCommand(File commandFile) throws IOException {
        if (!commandFile.exists()) {
            return "";
        }
        return new String(Files.readAllBytes(commandFile.toPath()), Charsets.UTF_8);
    }

    private void buildAndPropagateException(boolean forceJsonGeneration) throws IOException, ProcessException {
        Throwable firstException = null;
        for (CxxAbiModel abi : this.abis) {
            try {
                this.buildForOneConfiguration(forceJsonGeneration, abi);
            }
            catch (ProcessException | IOException | GradleException e) {
                if (firstException != null) continue;
                firstException = e;
            }
        }
        if (firstException != null) {
            if (firstException instanceof GradleException) {
                throw (GradleException)firstException;
            }
            if (firstException instanceof IOException) {
                throw (IOException)firstException;
            }
            throw (ProcessException)firstException;
        }
    }

    public void buildForOneAbiName(boolean forceJsonGeneration, String abiName) {
        int built = 0;
        for (CxxAbiModel abi : this.abis) {
            if (!abi.getAbi().getTag().equals(abiName)) continue;
            ++built;
            this.buildForOneConfigurationConvertExceptions(forceJsonGeneration, abi);
        }
        assert (built == 1);
    }

    private void checkForConfigurationErrors() {
        if (!this.configurationFailures.isEmpty()) {
            throw new GradleException(Joiner.on((String)"\r\n").join(this.configurationFailures));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildForOneConfiguration(boolean forceJsonGeneration, CxxAbiModel abi) throws GradleException, IOException, ProcessException {
        try (PassThroughRecordingLoggingEnvironment recorder = new PassThroughRecordingLoggingEnvironment();){
            this.checkForConfigurationErrors();
            GradleBuildVariant.NativeBuildConfigInfo.Builder variantStats = GradleBuildVariant.NativeBuildConfigInfo.newBuilder();
            variantStats.setAbi(AnalyticsUtil.getAbi(abi.getAbi().getTag()));
            variantStats.setDebuggable(this.variant.isDebuggableEnabled());
            long startTime = System.currentTimeMillis();
            variantStats.setGenerationStartMs(startTime);
            try {
                LoggingEnvironmentKt.infoln("Start JSON generation. Platform version: %s min SDK version: %s", abi.getAbiPlatformVersion(), abi.getAbi().getTag(), abi.getAbiPlatformVersion());
                ProcessInfoBuilder processBuilder = this.getProcessBuilder(abi);
                String currentBuildCommand = processBuilder.toString();
                JsonGenerationInvalidationState invalidationState = new JsonGenerationInvalidationState(forceJsonGeneration, abi.getJsonFile(), abi.getBuildCommandFile(), currentBuildCommand, ExternalNativeJsonGenerator.getPreviousBuildCommand(abi.getBuildCommandFile()), this.getDependentBuildFiles(abi.getJsonFile()));
                if (invalidationState.getRebuild()) {
                    LoggingEnvironmentKt.infoln("rebuilding JSON %s due to:", abi.getJsonFile());
                    for (String reason : invalidationState.getRebuildReasons()) {
                        LoggingEnvironmentKt.infoln(reason, new Object[0]);
                    }
                    if (this.variant.getJsonFolder().exists()) {
                        if (invalidationState.getSoftRegeneration()) {
                            LoggingEnvironmentKt.infoln("keeping json folder '%s' but regenerating project", abi.getCxxBuildFolder());
                        } else {
                            LoggingEnvironmentKt.infoln("removing stale contents from '%s'", abi.getCxxBuildFolder());
                            FileUtils.deletePath((File)abi.getCxxBuildFolder());
                        }
                    }
                    if (abi.getCxxBuildFolder().mkdirs()) {
                        LoggingEnvironmentKt.infoln("created folder '%s'", abi.getCxxBuildFolder());
                    }
                    LoggingEnvironmentKt.infoln("executing %s %s", this.getNativeBuildSystem().getTag(), processBuilder);
                    String buildOutput = this.executeProcess(abi);
                    LoggingEnvironmentKt.infoln("done executing %s", this.getNativeBuildSystem().getTag());
                    LoggingEnvironmentKt.infoln("write build output %s", abi.getBuildOutputFile().getAbsolutePath());
                    Files.write(abi.getBuildOutputFile().toPath(), buildOutput.getBytes(Charsets.UTF_8), new OpenOption[0]);
                    this.processBuildOutput(buildOutput, abi);
                    if (!abi.getJsonFile().exists()) {
                        throw new GradleException(String.format("Expected json generation to create '%s' but it didn't", abi.getJsonFile()));
                    }
                    GradleBuildVariant.Builder builder = this.stats;
                    synchronized (builder) {
                        ExternalNativeJsonGenerator.removeUnexpectedSoFiles(abi.getObjFolder(), AndroidBuildGradleJsons.getNativeBuildMiniConfig(abi.getJsonFile(), this.stats));
                    }
                    LoggingEnvironmentKt.infoln("write command file %s", abi.getBuildCommandFile().getAbsolutePath());
                    Files.write(abi.getBuildCommandFile().toPath(), currentBuildCommand.getBytes(Charsets.UTF_8), new OpenOption[0]);
                    variantStats.setOutcome(GradleBuildVariant.NativeBuildConfigInfo.GenerationOutcome.SUCCESS_BUILT);
                } else {
                    LoggingEnvironmentKt.infoln("JSON '%s' was up-to-date", abi.getJsonFile());
                    variantStats.setOutcome(GradleBuildVariant.NativeBuildConfigInfo.GenerationOutcome.SUCCESS_UP_TO_DATE);
                }
                LoggingEnvironmentKt.infoln("JSON generation completed without problems", new Object[0]);
            }
            catch (ProcessException | IOException | GradleException e) {
                variantStats.setOutcome(GradleBuildVariant.NativeBuildConfigInfo.GenerationOutcome.FAILED);
                LoggingEnvironmentKt.infoln("JSON generation completed with problem. Exception: " + e.toString(), new Object[0]);
                throw e;
            }
            finally {
                variantStats.setGenerationDurationMs(System.currentTimeMillis() - startTime);
                GradleBuildVariant.Builder builder = this.stats;
                synchronized (builder) {
                    this.stats.addNativeBuildConfig(variantStats);
                }
                abi.getJsonGenerationLoggingRecordFile().getParentFile().mkdirs();
                Files.write(abi.getJsonGenerationLoggingRecordFile().toPath(), PassThroughRecordingLoggingEnvironmentKt.toJsonString(recorder.getRecord()).getBytes(Charsets.UTF_8), new OpenOption[0]);
            }
        }
    }

    private static void removeUnexpectedSoFiles(File expectedOutputFolder, NativeBuildConfigValueMini config2) throws IOException {
        if (!expectedOutputFolder.isDirectory()) {
            return;
        }
        ArrayList expectedSoFiles = Lists.newArrayList();
        for (NativeLibraryValueMini library : config2.libraries.values()) {
            assert (library.output != null);
            expectedSoFiles.add(library.output.toPath());
        }
        try (Stream<Path> paths = Files.walk(expectedOutputFolder.toPath(), new FileVisitOption[0]);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".so")).filter(path -> !expectedSoFiles.contains(path)).forEach(path -> {
                if (path.toFile().delete()) {
                    LoggingEnvironmentKt.infoln("deleted unexpected build output %s in incremental regenerate", path);
                }
            });
        }
    }

    abstract void processBuildOutput(String var1, CxxAbiModel var2) throws IOException;

    abstract ProcessInfoBuilder getProcessBuilder(CxxAbiModel var1);

    abstract String executeProcess(CxxAbiModel var1) throws ProcessException, IOException;

    public abstract NativeBuildSystem getNativeBuildSystem();

    abstract Map<Abi, File> getStlSharedObjectFiles();

    public String getVariantName() {
        return this.variant.getVariantName();
    }

    public static ExternalNativeJsonGenerator create(CxxModuleModel module, AndroidBuilder androidBuilder, VariantScope scope) {
        HashSet<String> configurationFailures = new HashSet<String>();
        try (GradleSyncLoggingEnvironment ignore = new GradleSyncLoggingEnvironment(scope.getFullVariantName(), "native", configurationFailures, androidBuilder.getIssueReporter(), androidBuilder.getLogger());){
            ExternalNativeJsonGenerator externalNativeJsonGenerator = ExternalNativeJsonGenerator.createImpl(configurationFailures, module, androidBuilder, scope);
            return externalNativeJsonGenerator;
        }
    }

    public static ExternalNativeJsonGenerator createImpl(Set<String> configurationFailures, CxxModuleModel module, AndroidBuilder androidBuilder, VariantScope scope) {
        CxxVariantModel variant = CreateCxxVariantModelKt.createCxxVariantModel(module, scope.getVariantData());
        ArrayList abis = Lists.newArrayList();
        for (Abi abi : variant.getValidAbiList()) {
            abis.add(CreateCxxAbiModelKt.createCxxAbiModel(variant, abi, scope.getGlobalScope(), scope.getVariantData()));
        }
        GradleBuildVariant.Builder stats = ProcessProfileWriter.getOrCreateVariant((String)module.getGradleModulePathName(), (String)scope.getFullVariantName());
        switch (module.getBuildSystem()) {
            case NDK_BUILD: {
                return new NdkBuildExternalNativeJsonGenerator(variant, abis, configurationFailures, androidBuilder, stats);
            }
            case CMAKE: {
                CxxCmakeModuleModel cmake2 = Objects.requireNonNull(variant.getModule().getCmake());
                Revision cmakeRevision = cmake2.getFoundCmakeVersion();
                stats.setNativeCmakeVersion(cmakeRevision.toShortString());
                if (cmakeRevision.equals((Object)Revision.parseRevision((String)"3.6.0-rc2", (Revision.Precision)Revision.Precision.MICRO))) {
                    return new CmakeAndroidNinjaExternalNativeJsonGenerator(variant, abis, configurationFailures, androidBuilder, stats);
                }
                if (cmakeRevision.getMajor() < 3 || cmakeRevision.getMajor() == 3 && cmakeRevision.getMinor() <= 6) {
                    throw new RuntimeException("Unexpected/unsupported CMake version " + cmakeRevision.toString() + ". Try 3.7.0 or later.");
                }
                return new CmakeServerExternalNativeJsonGenerator(variant, abis, configurationFailures, androidBuilder, stats);
            }
        }
        throw new IllegalArgumentException("Unknown ExternalNativeJsonGenerator type");
    }

    public void forEachNativeBuildConfiguration(Consumer<JsonReader> callback) throws IOException {
        try (GradleSyncLoggingEnvironment ignore = new GradleSyncLoggingEnvironment(this.getVariantName(), "native", this.configurationFailures, this.androidBuilder.getIssueReporter(), this.androidBuilder.getLogger());){
            List<File> files2 = this.getNativeBuildConfigurationsJsons();
            LoggingEnvironmentKt.infoln("streaming %s JSON files", files2.size());
            for (File file : this.getNativeBuildConfigurationsJsons()) {
                if (file.exists()) {
                    LoggingEnvironmentKt.infoln("string JSON file %s", file.getAbsolutePath());
                    try {
                        JsonReader reader = new JsonReader((Reader)new FileReader(file));
                        Throwable throwable = null;
                        try {
                            callback.accept(reader);
                            continue;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (reader == null) continue;
                            if (throwable != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            reader.close();
                            continue;
                        }
                    }
                    catch (Throwable e) {
                        LoggingEnvironmentKt.infoln("Error parsing: %s", String.join((CharSequence)"\r\n", Files.readAllLines(file.toPath())));
                        throw e;
                    }
                }
                LoggingEnvironmentKt.infoln("streaming fallback JSON for %s", file.getAbsolutePath());
                NativeBuildConfigValueMini fallback = new NativeBuildConfigValueMini();
                fallback.buildFiles = Lists.newArrayList((Object[])new File[]{this.variant.getModule().getMakeFile()});
                JsonReader reader = new JsonReader((Reader)new StringReader(new Gson().toJson((Object)fallback)));
                Throwable throwable = null;
                try {
                    callback.accept(reader);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
        }
    }

    public CxxVariantModel getVariant() {
        return this.variant;
    }

    @InputFile
    public File getMakefile() {
        return this.variant.getModule().getMakeFile();
    }

    @Input
    public File getObjFolder() {
        return this.variant.getObjFolder();
    }

    public File getJsonFolder() {
        return this.variant.getJsonFolder();
    }

    @Input
    public File getNdkFolder() {
        return this.variant.getModule().getNdkFolder();
    }

    @Input
    public boolean isDebuggable() {
        return this.variant.isDebuggableEnabled();
    }

    @Optional
    @Input
    public List<String> getBuildArguments() {
        return this.variant.getBuildSystemArgumentList();
    }

    @Optional
    @Input
    public List<String> getcFlags() {
        return this.variant.getCFlagList();
    }

    @Optional
    @Input
    public List<String> getCppFlags() {
        return this.variant.getCppFlagsList();
    }

    @OutputFiles
    public List<File> getNativeBuildConfigurationsJsons() {
        ArrayList<File> generatedJsonFiles = new ArrayList<File>();
        for (CxxAbiModel abi : this.abis) {
            generatedJsonFiles.add(abi.getJsonFile());
        }
        return generatedJsonFiles;
    }

    @Input
    public File getSoFolder() {
        return this.variant.getSoFolder();
    }

    @Input
    public File getSdkFolder() {
        return this.variant.getModule().getSdkFolder();
    }

    @Input
    public Collection<Abi> getAbis() {
        ArrayList result = Lists.newArrayList();
        for (CxxAbiModel abi : this.abis) {
            result.add(abi.getAbi());
        }
        return result;
    }
}

