/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.VariantOutput;
import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.packaging.IncrementalPackagerBuilder;
import com.android.build.gradle.internal.scope.ApkData;
import com.android.build.gradle.internal.scope.BuildElementsTransformParams;
import com.android.build.gradle.internal.scope.BuildElementsTransformRunnable;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.MutableTaskContainer;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidBuilderTask;
import com.android.build.gradle.internal.tasks.PerModuleBundleTaskKt;
import com.android.build.gradle.internal.tasks.SigningConfigMetadata;
import com.android.build.gradle.internal.tasks.Workers;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.options.BooleanOption;
import com.android.builder.files.IncrementalRelativeFileSets;
import com.android.builder.internal.packaging.IncrementalPackager;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.sdklib.AndroidVersion;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.inject.Inject;
import kotlin.jvm.functions.Function2;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.tooling.BuildException;
import org.gradle.workers.WorkerExecutor;

public class PackageSplitAbi
extends AndroidBuilderTask {
    private BuildableArtifact processedAbiResources;
    private File outputDirectory;
    private boolean jniDebuggable;
    private FileCollection signingConfig;
    private FileCollection jniFolders;
    private AndroidVersion minSdkVersion;
    private File incrementalDir;
    private Collection<String> aaptOptionsNoCompress;
    private Set<String> splits;
    private boolean keepTimestampsInApk;
    private final WorkerExecutorFacade workers;

    @Inject
    public PackageSplitAbi(WorkerExecutor workerExecutor) {
        this.workers = Workers.INSTANCE.preferWorkers(this.getProject().getName(), this.getPath(), workerExecutor);
    }

    @InputFiles
    public BuildableArtifact getProcessedAbiResources() {
        return this.processedAbiResources;
    }

    @OutputDirectory
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Input
    public Set<String> getSplits() {
        return this.splits;
    }

    @Input
    public boolean isJniDebuggable() {
        return this.jniDebuggable;
    }

    @InputFiles
    public FileCollection getSigningConfig() {
        return this.signingConfig;
    }

    @InputFiles
    public FileCollection getJniFolders() {
        return this.jniFolders;
    }

    @Input
    public int getMinSdkVersion() {
        return this.minSdkVersion.getFeatureLevel();
    }

    @Input
    public Collection<String> getNoCompressExtensions() {
        return this.aaptOptionsNoCompress != null ? this.aaptOptionsNoCompress : Collections.emptyList();
    }

    @Input
    public boolean getKeepTimestampsInApk() {
        return this.keepTimestampsInApk;
    }

    @TaskAction
    protected void doFullTaskAction() throws IOException {
        FileUtils.cleanOutputDir((File)this.incrementalDir);
        ExistingBuildElements.from((ArtifactType)InternalArtifactType.ABI_PROCESSED_SPLIT_RES, this.processedAbiResources).transform(this.workers, PackageSplitAbiTransformRunnable.class, (Function2<? super ApkData, ? super File, ? extends BuildElementsTransformParams>)((Function2)(apkInfo, input) -> new PackageSplitAbiTransformParams((ApkData)apkInfo, (File)input, this))).into(InternalArtifactType.ABI_PACKAGED_SPLIT, this.outputDirectory);
    }

    private static String getApkName(ApkData apkData, String archivesBaseName, boolean isSigned) {
        String apkName = archivesBaseName + "-" + apkData.getBaseName();
        return apkName + (isSigned ? "" : "-unsigned") + ".apk";
    }

    public static class CreationAction
    extends VariantTaskCreationAction<PackageSplitAbi> {
        private File outputDirectory;
        private final boolean packageCustomClassDependencies;

        public CreationAction(VariantScope scope, boolean packageCustomClassDependencies) {
            super(scope);
            this.packageCustomClassDependencies = packageCustomClassDependencies;
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("package", "SplitAbi");
        }

        @Override
        public Class<PackageSplitAbi> getType() {
            return PackageSplitAbi.class;
        }

        @Override
        public void preConfigure(String taskName) {
            super.preConfigure(taskName);
            this.outputDirectory = this.getVariantScope().getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.ABI_PACKAGED_SPLIT, taskName, "out");
        }

        @Override
        public void handleProvider(TaskProvider<? extends PackageSplitAbi> taskProvider) {
            super.handleProvider(taskProvider);
            this.getVariantScope().getTaskContainer().setPackageSplitAbiTask(taskProvider);
        }

        @Override
        public void configure(PackageSplitAbi task) {
            super.configure(task);
            VariantScope scope = this.getVariantScope();
            GradleVariantConfiguration config2 = scope.getVariantConfiguration();
            task.processedAbiResources = scope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.ABI_PROCESSED_SPLIT_RES);
            task.signingConfig = scope.getSigningConfigFileCollection();
            task.outputDirectory = this.outputDirectory;
            task.minSdkVersion = config2.getMinSdkVersion();
            task.incrementalDir = scope.getIncrementalDir(task.getName());
            task.aaptOptionsNoCompress = scope.getGlobalScope().getExtension().getAaptOptions().getNoCompress();
            task.jniDebuggable = config2.getBuildType().isJniDebuggable();
            task.jniFolders = PerModuleBundleTaskKt.getNativeLibsFiles(scope, this.packageCustomClassDependencies);
            task.jniDebuggable = config2.getBuildType().isJniDebuggable();
            task.splits = scope.getVariantData().getFilters(VariantOutput.FilterType.ABI);
            task.keepTimestampsInApk = scope.getGlobalScope().getProjectOptions().get(BooleanOption.KEEP_TIMESTAMPS_IN_APK);
            MutableTaskContainer taskContainer = scope.getTaskContainer();
            if (taskContainer.getExternalNativeBuildTask() != null) {
                task.dependsOn(new Object[]{taskContainer.getExternalNativeBuildTask()});
            }
        }
    }

    private static class PackageSplitAbiTransformParams
    extends BuildElementsTransformParams {
        private final File input;
        private final ApkData apkInfo;
        private final File output;
        private final File incrementalDir;
        private final File signingConfigFile;
        private final String createdBy;
        private final Collection<String> aaptOptionsNoCompress;
        private final Set<File> jniFolders;
        private final boolean keepTimestampsInApk;
        private final boolean isJniDebuggable;
        private final int minSdkVersion;

        PackageSplitAbiTransformParams(ApkData apkInfo, File input, PackageSplitAbi task) {
            this.apkInfo = apkInfo;
            this.input = input;
            this.output = new File(task.outputDirectory, PackageSplitAbi.getApkName(apkInfo, (String)task.getProject().getProperties().get("archivesBaseName"), task.signingConfig != null));
            this.incrementalDir = task.incrementalDir;
            this.signingConfigFile = SigningConfigMetadata.Companion.getOutputFile(task.signingConfig);
            this.createdBy = task.getBuilder().getCreatedBy();
            this.aaptOptionsNoCompress = task.aaptOptionsNoCompress;
            this.jniFolders = task.getJniFolders().getFiles();
            this.keepTimestampsInApk = task.getKeepTimestampsInApk();
            this.isJniDebuggable = task.jniDebuggable;
            this.minSdkVersion = task.getMinSdkVersion();
        }

        @Override
        public File getOutput() {
            return this.output;
        }
    }

    private static class PackageSplitAbiTransformRunnable
    extends BuildElementsTransformRunnable {
        @Inject
        public PackageSplitAbiTransformRunnable(PackageSplitAbiTransformParams params) {
            super(params);
        }

        @Override
        public void run() {
            PackageSplitAbiTransformParams params = (PackageSplitAbiTransformParams)this.getParams();
            try (IncrementalPackager pkg = new IncrementalPackagerBuilder(IncrementalPackagerBuilder.ApkFormat.FILE).withOutputFile(params.getOutput()).withSigning(SigningConfigMetadata.Companion.load(params.signingConfigFile), params.minSdkVersion).withCreatedBy(params.createdBy).withAaptOptionsNoCompress(params.aaptOptionsNoCompress).withIntermediateDir(params.incrementalDir).withKeepTimestampsInApk(params.keepTimestampsInApk).withDebuggableBuild(params.isJniDebuggable).withJniDebuggableBuild(params.isJniDebuggable).withAcceptedAbis((Set<String>)ImmutableSet.of((Object)params.apkInfo.getFilterName())).build();){
                ImmutableMap nativeLibs = IncrementalRelativeFileSets.fromZipsAndDirectories((Iterable)params.jniFolders);
                pkg.updateNativeLibraries(nativeLibs);
                ImmutableMap androidResources = IncrementalRelativeFileSets.fromZip((File)params.input);
                pkg.updateAndroidResources(androidResources);
            }
            catch (IOException e) {
                throw new BuildException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

