/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import android.databinding.tool.DataBindingBuilder;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.BaseAppModuleExtension;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.feature.BundleAllClasses;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.AnchorOutputType;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AppClasspathCheckTask;
import com.android.build.gradle.internal.tasks.AppPreBuildTask;
import com.android.build.gradle.internal.tasks.ApplicationIdWriterTask;
import com.android.build.gradle.internal.tasks.BundleReportDependenciesTask;
import com.android.build.gradle.internal.tasks.BundleToApkTask;
import com.android.build.gradle.internal.tasks.BundleToStandaloneApkTask;
import com.android.build.gradle.internal.tasks.CheckMultiApkLibrariesTask;
import com.android.build.gradle.internal.tasks.ExtractApksTask;
import com.android.build.gradle.internal.tasks.FinalizeBundleTask;
import com.android.build.gradle.internal.tasks.InstallVariantViaBundleTask;
import com.android.build.gradle.internal.tasks.MergeConsumerProguardFilesTask;
import com.android.build.gradle.internal.tasks.ModuleMetadataWriterTask;
import com.android.build.gradle.internal.tasks.PackageBundleTask;
import com.android.build.gradle.internal.tasks.PerModuleBundleTask;
import com.android.build.gradle.internal.tasks.PerModuleReportDependenciesTask;
import com.android.build.gradle.internal.tasks.SigningConfigWriterTask;
import com.android.build.gradle.internal.tasks.TestPreBuildTask;
import com.android.build.gradle.internal.tasks.databinding.DataBindingExportFeatureApplicationIdsTask;
import com.android.build.gradle.internal.tasks.databinding.DataBindingExportFeatureInfoTask;
import com.android.build.gradle.internal.tasks.factory.TaskFactoryUtils;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSetMetadataWriterTask;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSplitDeclarationWriterTask;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSplitTransitiveDepsWriterTask;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.MultiOutputPolicy;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.tasks.MainApkListPersistence;
import com.android.build.gradle.tasks.MergeResources;
import com.android.builder.core.VariantType;
import com.android.builder.profile.Recorder;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.resources.TextResourceFactory;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public class ApplicationTaskManager
extends TaskManager {
    public ApplicationTaskManager(GlobalScope globalScope, Project project, ProjectOptions projectOptions, DataBindingBuilder dataBindingBuilder, AndroidConfig extension, VariantFactory variantFactory, ToolingModelBuilderRegistry toolingRegistry, Recorder recorder) {
        super(globalScope, project, projectOptions, dataBindingBuilder, extension, variantFactory, toolingRegistry, recorder);
    }

    @Override
    public void createTasksForVariantScope(VariantScope variantScope) {
        this.createAnchorTasks(variantScope);
        this.createCheckManifestTask(variantScope);
        this.handleMicroApp(variantScope);
        this.createDependencyStreams(variantScope);
        this.createApplicationIdWriterTask(variantScope);
        this.taskFactory.register(new MainApkListPersistence.CreationAction(variantScope));
        this.createBuildArtifactReportTask(variantScope);
        this.createMergeApkManifestsTask(variantScope);
        this.createGenerateResValuesTask(variantScope);
        this.createRenderscriptTask(variantScope);
        this.createMergeResourcesTask(variantScope, true, (ImmutableSet<MergeResources.Flag>)Sets.immutableEnumSet((Enum)MergeResources.Flag.PROCESS_VECTOR_DRAWABLES, (Enum[])new MergeResources.Flag[0]));
        this.createShaderTask(variantScope);
        this.createMergeAssetsTask(variantScope);
        this.createBuildConfigTask(variantScope);
        this.createApkProcessResTask(variantScope);
        this.createProcessJavaResTask(variantScope);
        this.createAidlTask(variantScope);
        this.createExternalNativeBuildJsonGenerators(variantScope);
        this.createExternalNativeBuildTasks(variantScope);
        this.createMergeJniLibFoldersTasks(variantScope);
        if (variantScope.getType().isBaseModule()) {
            this.taskFactory.register(new FeatureSetMetadataWriterTask.CreationAction(variantScope));
            this.createValidateSigningTask(variantScope);
            this.taskFactory.register(new SigningConfigWriterTask.CreationAction(variantScope));
            if (this.extension.getDataBinding().isEnabled()) {
                this.taskFactory.register(new DataBindingExportFeatureApplicationIdsTask.CreationAction(variantScope));
            }
        } else {
            this.taskFactory.register(new FeatureSplitDeclarationWriterTask.CreationAction(variantScope));
            if (this.extension.getDataBinding().isEnabled()) {
                this.taskFactory.register(new DataBindingExportFeatureInfoTask.CreationAction(variantScope));
            }
            this.taskFactory.register(new MergeConsumerProguardFilesTask.CreationAction(variantScope));
        }
        this.createDataBindingTasksIfNecessary(variantScope, TaskManager.MergeType.MERGE);
        this.createCompileTask(variantScope);
        this.createStripNativeLibraryTask(this.taskFactory, variantScope);
        if (variantScope.getVariantData().getMultiOutputPolicy().equals((Object)MultiOutputPolicy.SPLITS)) {
            if (this.extension.getBuildToolsRevision().getMajor() < 21) {
                throw new RuntimeException("Pure splits can only be used with buildtools 21 and later");
            }
            this.createSplitTasks(variantScope);
        }
        this.createPackagingTask(variantScope);
        this.createLintTasks(variantScope);
        this.taskFactory.register(new FeatureSplitTransitiveDepsWriterTask.CreationAction(variantScope));
        this.createDynamicBundleTask(variantScope);
    }

    @Override
    protected void createInstallTask(VariantScope variantScope) {
        GradleVariantConfiguration variantConfiguration = variantScope.getVariantConfiguration();
        VariantType variantType = variantConfiguration.getType();
        if (variantType.isFeatureSplit() || variantType.isHybrid()) {
            return;
        }
        if (variantType.isForTesting() || !(this.extension instanceof BaseAppModuleExtension) || ((BaseAppModuleExtension)this.extension).getDynamicFeatures().isEmpty()) {
            super.createInstallTask(variantScope);
        } else {
            this.taskFactory.register(new InstallVariantViaBundleTask.CreationAction(variantScope));
        }
    }

    @Override
    protected void postJavacCreation(VariantScope scope) {
        Provider javacOutput = scope.getArtifacts().getFinalProduct(InternalArtifactType.JAVAC);
        FileCollection preJavacGeneratedBytecode = scope.getVariantData().getAllPreJavacGeneratedBytecode();
        FileCollection postJavacGeneratedBytecode = scope.getVariantData().getAllPostJavacGeneratedBytecode();
        this.taskFactory.register(new BundleAllClasses.CreationAction(scope));
        ConfigurableFileCollection files2 = scope.getGlobalScope().getProject().files(new Object[]{javacOutput, preJavacGeneratedBytecode, postJavacGeneratedBytecode});
        scope.getArtifacts().appendArtifact(AnchorOutputType.ALL_CLASSES, (FileCollection)files2);
    }

    @Override
    protected void createVariantPreBuildTask(VariantScope scope) {
        VariantType variantType = scope.getVariantConfiguration().getType();
        if (variantType.isApk()) {
            Object task;
            boolean useDependencyConstraints = scope.getGlobalScope().getProjectOptions().get(BooleanOption.USE_DEPENDENCY_CONSTRAINTS);
            if (variantType.isTestComponent()) {
                task = this.taskFactory.register(new TestPreBuildTask.CreationAction(scope));
                if (useDependencyConstraints) {
                    task.configure(t -> t.setEnabled(false));
                }
            } else {
                task = this.taskFactory.register(AppPreBuildTask.getCreationAction(scope));
            }
            if (!useDependencyConstraints) {
                TaskProvider<AppClasspathCheckTask> classpathCheck = this.taskFactory.register(new AppClasspathCheckTask.CreationAction(scope));
                TaskFactoryUtils.dependsOn(task, classpathCheck);
            }
            if (variantType.isBaseModule() && this.globalScope.hasDynamicFeatures()) {
                TaskProvider<CheckMultiApkLibrariesTask> checkMultiApkLibrariesTask = this.taskFactory.register(new CheckMultiApkLibrariesTask.CreationAction(scope));
                TaskFactoryUtils.dependsOn(task, checkMultiApkLibrariesTask);
            }
            return;
        }
        super.createVariantPreBuildTask(scope);
    }

    @Override
    protected Set<QualifiedContent.ScopeType> getJavaResMergingScopes(VariantScope variantScope, QualifiedContent.ContentType contentType) {
        if (variantScope.consumesFeatureJars() && contentType == QualifiedContent.DefaultContentType.RESOURCES) {
            return TransformManager.SCOPE_FULL_WITH_FEATURES;
        }
        return TransformManager.SCOPE_FULL_PROJECT;
    }

    private void handleMicroApp(VariantScope scope) {
        BaseVariantData variantData = scope.getVariantData();
        GradleVariantConfiguration variantConfiguration = variantData.getVariantConfiguration();
        VariantType variantType = variantConfiguration.getType();
        if (!variantType.isHybrid() && variantType.isBaseModule()) {
            Boolean unbundledWearApp = variantConfiguration.getMergedFlavor().getWearAppUnbundled();
            if (!Boolean.TRUE.equals(unbundledWearApp) && ((CoreBuildType)variantConfiguration.getBuildType()).isEmbedMicroApp()) {
                Configuration wearApp = variantData.getVariantDependency().getWearAppConfiguration();
                assert (wearApp != null) : "Wear app with no wearApp configuration";
                if (!wearApp.getAllDependencies().isEmpty()) {
                    Action setApkArtifact = container -> container.attribute(AndroidArtifacts.ARTIFACT_TYPE, (Object)AndroidArtifacts.ArtifactType.APK.getType());
                    FileCollection files2 = wearApp.getIncoming().artifactView(config2 -> {
                        ArtifactView.ViewConfiguration cfr_ignored_0 = (ArtifactView.ViewConfiguration)config2.attributes(setApkArtifact);
                    }).getFiles();
                    this.createGenerateMicroApkDataTask(scope, files2);
                }
            } else if (Boolean.TRUE.equals(unbundledWearApp)) {
                this.createGenerateMicroApkDataTask(scope, null);
            }
        }
    }

    private void createApplicationIdWriterTask(VariantScope variantScope) {
        if (variantScope.getType().isBaseModule()) {
            this.taskFactory.register(new ModuleMetadataWriterTask.CreationAction(variantScope));
        }
        TaskProvider<ApplicationIdWriterTask> applicationIdWriterTask = this.taskFactory.register(new ApplicationIdWriterTask.CreationAction(variantScope));
        TextResourceFactory resources = this.project.getResources().getText();
        variantScope.getVariantData().applicationIdTextResource = resources.fromFile(applicationIdWriterTask);
    }

    private static File getIncrementalFolder(VariantScope variantScope, String taskName) {
        return new File(variantScope.getIncrementalDir(taskName), variantScope.getDirName());
    }

    private void createDynamicBundleTask(VariantScope scope) {
        if (scope.getGlobalScope().getExtension().getAaptOptions().getNamespaced()) {
            return;
        }
        this.taskFactory.register(new PerModuleBundleTask.CreationAction(scope, ApplicationTaskManager.packagesCustomClassDependencies(scope, this.projectOptions)));
        this.taskFactory.register(new PerModuleReportDependenciesTask.CreationAction(scope));
        if (scope.getType().isBaseModule()) {
            this.taskFactory.register(new PackageBundleTask.CreationAction(scope));
            this.taskFactory.register(new FinalizeBundleTask.CreationAction(scope));
            this.taskFactory.register(new BundleReportDependenciesTask.CreationAction(scope));
            this.taskFactory.register(new BundleToApkTask.CreationAction(scope));
            this.taskFactory.register(new BundleToStandaloneApkTask.CreationAction(scope));
            this.taskFactory.register(new ExtractApksTask.CreationAction(scope));
        }
    }
}

