/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.logging;

import com.android.build.gradle.internal.cxx.logging.LoggingEnvironment;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.logging.ThreadLoggingEnvironment;
import com.android.utils.ILogger;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/android/build/gradle/internal/cxx/logging/ThreadLoggingEnvironment;", "Lcom/android/build/gradle/internal/cxx/logging/LoggingEnvironment;", "()V", "close", "", "Companion", "gradle"})
public abstract class ThreadLoggingEnvironment
implements LoggingEnvironment {
    private static final ThreadLocal<List<LoggingEnvironment>> loggerStack;
    private static final Companion.BottomLoggingEnvironment BOTTOM_LOGGING_ENVIRONMENT;
    public static final Companion Companion;

    @Override
    public void close() {
        ThreadLoggingEnvironment.Companion.pop();
    }

    public ThreadLoggingEnvironment() {
        ThreadLoggingEnvironment.Companion.push(this);
    }

    static {
        Companion = new Companion(null);
        loggerStack = ThreadLocal.withInitial(Companion.loggerStack.1.INSTANCE);
        BOTTOM_LOGGING_ENVIRONMENT = new Companion.BottomLoggingEnvironment();
    }

    public static final /* synthetic */ Companion.BottomLoggingEnvironment access$getBOTTOM_LOGGING_ENVIRONMENT$cp() {
        return BOTTOM_LOGGING_ENVIRONMENT;
    }

    @JvmStatic
    @NotNull
    protected static final LoggingEnvironment parentLogger() {
        return Companion.parentLogger();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0019B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\u0006H\u0005J\b\u0010\u0010\u001a\u00020\u0006H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u0013H\u0002J\u000e\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bRJ\u0010\t\u001a>\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0006 \f*\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u000b0\u000b \f*\u001e\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0006 \f*\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u000b0\u000b\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/build/gradle/internal/cxx/logging/ThreadLoggingEnvironment$Companion;", "", "()V", "BOTTOM_LOGGING_ENVIRONMENT", "Lcom/android/build/gradle/internal/cxx/logging/ThreadLoggingEnvironment$Companion$BottomLoggingEnvironment;", "logger", "Lcom/android/build/gradle/internal/cxx/logging/LoggingEnvironment;", "getLogger", "()Lcom/android/build/gradle/internal/cxx/logging/LoggingEnvironment;", "loggerStack", "Ljava/lang/ThreadLocal;", "", "kotlin.jvm.PlatformType", "getILogger", "Lcom/android/utils/ILogger;", "parentLogger", "pop", "push", "", "Lcom/android/build/gradle/internal/cxx/logging/ThreadLoggingEnvironment;", "reportFormattedErrorToCurrentLogger", "message", "", "reportFormattedInfoToCurrentLogger", "reportFormattedWarningToCurrentLogger", "BottomLoggingEnvironment", "gradle"})
    public static final class Companion {
        private final LoggingEnvironment getLogger() {
            Object t = loggerStack.get();
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"loggerStack.get()");
            return (LoggingEnvironment)CollectionsKt.first((List)((List)t));
        }

        private final void push(ThreadLoggingEnvironment logger) {
            ((List)loggerStack.get()).add(0, logger);
        }

        private final LoggingEnvironment pop() {
            return (LoggingEnvironment)((List)loggerStack.get()).remove(0);
        }

        @JvmStatic
        @NotNull
        protected final LoggingEnvironment parentLogger() {
            return (LoggingEnvironment)((List)loggerStack.get()).get(1);
        }

        public final void reportFormattedErrorToCurrentLogger(@NotNull String message) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            this.getLogger().error(message);
        }

        public final void reportFormattedWarningToCurrentLogger(@NotNull String message) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            this.getLogger().warn(message);
        }

        public final void reportFormattedInfoToCurrentLogger(@NotNull String message) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            this.getLogger().info(message);
        }

        @NotNull
        public final ILogger getILogger() {
            return new ILogger(){

                public void error(@Nullable Throwable t, @Nullable String format, Object ... args2) {
                    Intrinsics.checkParameterIsNotNull((Object)args2, (String)"args");
                    if (t != null) {
                        throw t;
                    }
                    LoggingEnvironment loggingEnvironment = com.android.build.gradle.internal.cxx.logging.ThreadLoggingEnvironment$Companion.access$getLogger$p(ThreadLoggingEnvironment.Companion);
                    String string = format;
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    loggingEnvironment.error(LoggingEnvironmentKt.access$checkedFormat(string, args2));
                }

                public void warning(@NotNull String format, Object ... args2) {
                    Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
                    Intrinsics.checkParameterIsNotNull((Object)args2, (String)"args");
                    com.android.build.gradle.internal.cxx.logging.ThreadLoggingEnvironment$Companion.access$getLogger$p(ThreadLoggingEnvironment.Companion).warn(LoggingEnvironmentKt.access$checkedFormat(format, args2));
                }

                public void info(@NotNull String format, Object ... args2) {
                    Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
                    Intrinsics.checkParameterIsNotNull((Object)args2, (String)"args");
                    com.android.build.gradle.internal.cxx.logging.ThreadLoggingEnvironment$Companion.access$getLogger$p(ThreadLoggingEnvironment.Companion).info(LoggingEnvironmentKt.access$checkedFormat(format, args2));
                }

                public void verbose(@NotNull String format, Object ... args2) {
                    Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
                    Intrinsics.checkParameterIsNotNull((Object)args2, (String)"args");
                    com.android.build.gradle.internal.cxx.logging.ThreadLoggingEnvironment$Companion.access$getLogger$p(ThreadLoggingEnvironment.Companion).info(LoggingEnvironmentKt.access$checkedFormat(format, args2));
                }
            };
        }

        private Companion() {
        }

        public static final /* synthetic */ LoggingEnvironment access$getLogger$p(Companion $this) {
            return $this.getLogger();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/build/gradle/internal/cxx/logging/ThreadLoggingEnvironment$Companion$BottomLoggingEnvironment;", "Lcom/android/build/gradle/internal/cxx/logging/LoggingEnvironment;", "()V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "close", "", "error", "message", "", "info", "warn", "gradle"})
        private static final class BottomLoggingEnvironment
        implements LoggingEnvironment {
            private final Logger logger = Logging.getLogger(BottomLoggingEnvironment.class);

            @Override
            public void error(@NotNull String message) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                this.logger.error(message);
            }

            @Override
            public void warn(@NotNull String message) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                this.logger.warn(message);
            }

            @Override
            public void info(@NotNull String message) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                this.logger.info(message);
            }

            @Override
            public void close() {
            }
        }
    }
}

