/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import java.io.File;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class CheckTestedAppObfuscation
extends AndroidVariantTask {
    FileCollection mappingFile;

    @InputFiles
    public FileCollection getMappingFile() {
        return this.mappingFile;
    }

    @OutputFile
    @Optional
    public File getDummyOutput() {
        return null;
    }

    @TaskAction
    void checkIfAppIsObfuscated() {
        if (!this.mappingFile.isEmpty()) {
            throw new RuntimeException("Mapping file found in tested application. Code shrinker must also be enabled in test plugin with:\nandroid {\n    buildTypes {\n        " + this.getVariantName() + " {\n            minifyEnabled true\n        }\n    }\n}\n");
        }
    }

    public static class CreationAction
    extends VariantTaskCreationAction<CheckTestedAppObfuscation> {
        public CreationAction(VariantScope scope) {
            super(scope);
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("checkTestedAppObfuscation");
        }

        @Override
        public Class<CheckTestedAppObfuscation> getType() {
            return CheckTestedAppObfuscation.class;
        }

        @Override
        public void configure(CheckTestedAppObfuscation task) {
            super.configure(task);
            task.mappingFile = this.getVariantScope().getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.APK_MAPPING);
        }
    }
}

