/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.gradle.internal.PostprocessingFeatures;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.transforms.ProguardConfigurable;
import com.google.common.base.Charsets;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import proguard.ClassPath;
import proguard.ClassPathEntry;
import proguard.ClassSpecification;
import proguard.Configuration;
import proguard.ConfigurationParser;
import proguard.KeepClassSpecification;
import proguard.ParseException;
import proguard.ProGuard;
import proguard.classfile.util.ClassUtil;
import proguard.util.ListUtil;

public abstract class BaseProguardAction
extends ProguardConfigurable {
    protected static final List<String> JAR_FILTER = ImmutableList.of((Object)"!META-INF/MANIFEST.MF");
    protected final Configuration configuration = new Configuration();
    ListMultimap<File, List<String>> fileToFilter = ArrayListMultimap.create();

    public BaseProguardAction(VariantScope scope) {
        super(scope.getGlobalScope().getProject().files(new Object[0]), scope.getVariantData().getType(), scope.consumesFeatureJars());
        this.configuration.useMixedCaseClassNames = false;
        this.configuration.programJars = new ClassPath();
        this.configuration.libraryJars = new ClassPath();
    }

    public void runProguard() throws IOException {
        new ProGuard(this.configuration).execute();
        this.fileToFilter.clear();
    }

    @Override
    public void keep(String keep) {
        ClassSpecification classSpecification;
        if (this.configuration.keep == null) {
            this.configuration.keep = Lists.newArrayList();
        }
        try {
            ConfigurationParser parser = new ConfigurationParser(new String[]{keep}, null);
            classSpecification = parser.parseClassSpecificationArguments();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        this.configuration.keep.add(new KeepClassSpecification(true, false, false, false, false, false, false, null, classSpecification));
    }

    public void dontpreverify() {
        this.configuration.preverify = false;
    }

    @Override
    public void keepattributes() {
        this.configuration.keepAttributes = Lists.newArrayListWithExpectedSize((int)0);
    }

    @Override
    public void dontwarn(String dontwarn) {
        if (this.configuration.warn == null) {
            this.configuration.warn = Lists.newArrayList();
        }
        dontwarn = ClassUtil.internalClassName((String)dontwarn);
        this.configuration.warn.addAll(ListUtil.commaSeparatedList((String)dontwarn));
    }

    @Override
    public void setActions(PostprocessingFeatures actions) {
        this.configuration.obfuscate = actions.isObfuscate();
        this.configuration.optimize = actions.isOptimize();
        this.configuration.shrink = actions.isRemoveUnusedCode();
    }

    public void dontwarn() {
        this.configuration.warn = Lists.newArrayList((Object[])new String[]{"**"});
    }

    public void dontnote() {
        this.configuration.note = Lists.newArrayList((Object[])new String[]{"**"});
    }

    public void forceprocessing() {
        this.configuration.lastModified = Long.MAX_VALUE;
    }

    public void applyConfigurationFile(File file) throws IOException, ParseException {
        if (!file.isFile()) {
            return;
        }
        this.applyConfigurationText(Files.asCharSource((File)file, (Charset)Charsets.UTF_8).read(), BaseProguardAction.fileDescription(file.getPath()), file.getParentFile());
    }

    public void printconfiguration(File file) {
        this.configuration.printConfiguration = file;
    }

    protected void applyMapping(File testedMappingFile) {
        this.configuration.applyMapping = testedMappingFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyConfigurationText(String lines, String description, File baseDir) throws IOException, ParseException {
        try (ConfigurationParser parser = new ConfigurationParser(lines, description, baseDir, System.getProperties());){
            parser.parse(this.configuration);
        }
    }

    protected void applyConfigurationText(String lines, String fileName) throws IOException, ParseException {
        this.applyConfigurationText(lines, BaseProguardAction.fileDescription(fileName), null);
    }

    protected void inJar(File jarFile, List<String> filter) {
        this.inputJar(this.configuration.programJars, jarFile, filter);
    }

    protected void outJar(File file) {
        ClassPathEntry classPathEntry = new ClassPathEntry(file, true);
        this.configuration.programJars.add(classPathEntry);
    }

    protected void libraryJar(File jarFile) {
        this.inputJar(this.configuration.libraryJars, jarFile, null);
    }

    protected void inputJar(ClassPath classPath, File file, List<String> filter) {
        if (!file.exists() || this.fileToFilter.containsEntry((Object)file, filter)) {
            return;
        }
        this.fileToFilter.put((Object)file, filter);
        ClassPathEntry classPathEntry = new ClassPathEntry(file, false);
        if (filter != null) {
            classPathEntry.setFilter(filter);
        }
        classPath.add(classPathEntry);
    }

    private static String fileDescription(String fileName) {
        return "file '" + fileName + "'";
    }
}

