/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.apksig.ApkSigner;
import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.api.artifact.BuildableArtifactUtil;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.SigningConfigMetadata;
import com.android.build.gradle.internal.tasks.Workers;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.options.StringOption;
import com.android.ide.common.signing.CertificateInfo;
import com.android.ide.common.signing.KeystoreHelper;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.utils.FileUtils;
import java.io.Closeable;
import java.io.File;
import java.io.Serializable;
import java.security.PrivateKey;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001:\u0003\u001d\u001e\u001fB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001b\u001a\u00020\u001cH\u0014R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t8G\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8G\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR \u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00118G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R$\u0010\u0016\u001a\u0004\u0018\u00010\u00152\b\u0010\u0010\u001a\u0004\u0018\u00010\u00158G@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/android/build/gradle/internal/tasks/FinalizeBundleTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "(Lorg/gradle/workers/WorkerExecutor;)V", "finalBundleFile", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/RegularFile;", "finalBundleFileName", "", "getFinalBundleFileName", "()Ljava/lang/String;", "finalBundleLocation", "Ljava/io/File;", "getFinalBundleLocation", "()Ljava/io/File;", "<set-?>", "Lcom/android/build/api/artifact/BuildableArtifact;", "intermediaryBundleFile", "getIntermediaryBundleFile", "()Lcom/android/build/api/artifact/BuildableArtifact;", "Lorg/gradle/api/file/FileCollection;", "signingConfig", "getSigningConfig", "()Lorg/gradle/api/file/FileCollection;", "workers", "Lcom/android/ide/common/workers/WorkerExecutorFacade;", "doTaskAction", "", "BundleToolRunnable", "CreationAction", "Params", "gradle"})
public class FinalizeBundleTask
extends NonIncrementalTask {
    private final WorkerExecutorFacade workers;
    @NotNull
    private BuildableArtifact intermediaryBundleFile;
    @Nullable
    private FileCollection signingConfig;
    private Provider<RegularFile> finalBundleFile;

    @InputFiles
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @NotNull
    public final BuildableArtifact getIntermediaryBundleFile() {
        BuildableArtifact buildableArtifact = this.intermediaryBundleFile;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"intermediaryBundleFile");
        }
        return buildableArtifact;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @Optional
    @Nullable
    public final FileCollection getSigningConfig() {
        return this.signingConfig;
    }

    @OutputDirectory
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public final File getFinalBundleLocation() {
        Provider<RegularFile> provider = this.finalBundleFile;
        if (provider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"finalBundleFile");
        }
        Object object = provider.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"finalBundleFile.get()");
        File file = ((RegularFile)object).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"finalBundleFile.get().asFile");
        File file2 = file.getParentFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"finalBundleFile.get().asFile.parentFile");
        return file2;
    }

    @Input
    @NotNull
    public final String getFinalBundleFileName() {
        Provider<RegularFile> provider = this.finalBundleFile;
        if (provider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"finalBundleFile");
        }
        Object object = provider.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"finalBundleFile.get()");
        File file = ((RegularFile)object).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"finalBundleFile.get().asFile");
        String string = file.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"finalBundleFile.get().asFile.name");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doTaskAction() {
        Closeable closeable = (Closeable)this.workers;
        boolean bl = false;
        Throwable throwable = null;
        try {
            WorkerExecutorFacade it = (WorkerExecutorFacade)closeable;
            boolean bl2 = false;
            BuildableArtifact buildableArtifact = this.intermediaryBundleFile;
            if (buildableArtifact == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"intermediaryBundleFile");
            }
            File file = BuildableArtifactUtil.singleFile(buildableArtifact);
            Provider<RegularFile> provider = this.finalBundleFile;
            if (provider == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"finalBundleFile");
            }
            Object object = provider.get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"finalBundleFile.get()");
            File file2 = ((RegularFile)object).getAsFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"finalBundleFile.get().asFile");
            it.submit(BundleToolRunnable.class, (Serializable)new Params(file, file2, SigningConfigMetadata.Companion.getOutputFile(this.signingConfig)));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Inject
    public FinalizeBundleTask(@NotNull WorkerExecutor workerExecutor) {
        Intrinsics.checkParameterIsNotNull((Object)workerExecutor, (String)"workerExecutor");
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        String string = project.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.name");
        String string2 = this.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"path");
        this.workers = Workers.preferWorkers$default(Workers.INSTANCE, string, string2, workerExecutor, null, 8, null);
    }

    public static final /* synthetic */ BuildableArtifact access$getIntermediaryBundleFile$p(FinalizeBundleTask $this) {
        BuildableArtifact buildableArtifact = $this.intermediaryBundleFile;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"intermediaryBundleFile");
        }
        return buildableArtifact;
    }

    public static final /* synthetic */ Provider access$getFinalBundleFile$p(FinalizeBundleTask $this) {
        Provider<RegularFile> provider = $this.finalBundleFile;
        if (provider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"finalBundleFile");
        }
        return provider;
    }

    public static final /* synthetic */ FileCollection access$getSigningConfig$p(FinalizeBundleTask $this) {
        return $this.signingConfig;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J)\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0017"}, d2={"Lcom/android/build/gradle/internal/tasks/FinalizeBundleTask$Params;", "Ljava/io/Serializable;", "intermediaryBundleFile", "Ljava/io/File;", "finalBundleFile", "signingConfig", "(Ljava/io/File;Ljava/io/File;Ljava/io/File;)V", "getFinalBundleFile", "()Ljava/io/File;", "getIntermediaryBundleFile", "getSigningConfig", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "gradle"})
    private static final class Params
    implements Serializable {
        @NotNull
        private final File intermediaryBundleFile;
        @NotNull
        private final File finalBundleFile;
        @Nullable
        private final File signingConfig;

        @NotNull
        public final File getIntermediaryBundleFile() {
            return this.intermediaryBundleFile;
        }

        @NotNull
        public final File getFinalBundleFile() {
            return this.finalBundleFile;
        }

        @Nullable
        public final File getSigningConfig() {
            return this.signingConfig;
        }

        public Params(@NotNull File intermediaryBundleFile, @NotNull File finalBundleFile, @Nullable File signingConfig) {
            Intrinsics.checkParameterIsNotNull((Object)intermediaryBundleFile, (String)"intermediaryBundleFile");
            Intrinsics.checkParameterIsNotNull((Object)finalBundleFile, (String)"finalBundleFile");
            this.intermediaryBundleFile = intermediaryBundleFile;
            this.finalBundleFile = finalBundleFile;
            this.signingConfig = signingConfig;
        }

        @NotNull
        public final File component1() {
            return this.intermediaryBundleFile;
        }

        @NotNull
        public final File component2() {
            return this.finalBundleFile;
        }

        @Nullable
        public final File component3() {
            return this.signingConfig;
        }

        @NotNull
        public final Params copy(@NotNull File intermediaryBundleFile, @NotNull File finalBundleFile, @Nullable File signingConfig) {
            Intrinsics.checkParameterIsNotNull((Object)intermediaryBundleFile, (String)"intermediaryBundleFile");
            Intrinsics.checkParameterIsNotNull((Object)finalBundleFile, (String)"finalBundleFile");
            return new Params(intermediaryBundleFile, finalBundleFile, signingConfig);
        }

        @NotNull
        public static /* synthetic */ Params copy$default(Params params, File file, File file2, File file3, int n, Object object) {
            if ((n & 1) != 0) {
                file = params.intermediaryBundleFile;
            }
            if ((n & 2) != 0) {
                file2 = params.finalBundleFile;
            }
            if ((n & 4) != 0) {
                file3 = params.signingConfig;
            }
            return params.copy(file, file2, file3);
        }

        @NotNull
        public String toString() {
            return "Params(intermediaryBundleFile=" + this.intermediaryBundleFile + ", finalBundleFile=" + this.finalBundleFile + ", signingConfig=" + this.signingConfig + ")";
        }

        public int hashCode() {
            File file = this.intermediaryBundleFile;
            File file2 = this.finalBundleFile;
            File file3 = this.signingConfig;
            return ((file != null ? ((Object)file).hashCode() : 0) * 31 + (file2 != null ? ((Object)file2).hashCode() : 0)) * 31 + (file3 != null ? ((Object)file3).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Params)) break block3;
                    Params params = (Params)object;
                    if (!Intrinsics.areEqual((Object)this.intermediaryBundleFile, (Object)params.intermediaryBundleFile) || !Intrinsics.areEqual((Object)this.finalBundleFile, (Object)params.finalBundleFile) || !Intrinsics.areEqual((Object)this.signingConfig, (Object)params.signingConfig)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/build/gradle/internal/tasks/FinalizeBundleTask$BundleToolRunnable;", "Ljava/lang/Runnable;", "params", "Lcom/android/build/gradle/internal/tasks/FinalizeBundleTask$Params;", "(Lcom/android/build/gradle/internal/tasks/FinalizeBundleTask$Params;)V", "run", "", "gradle"})
    private static final class BundleToolRunnable
    implements Runnable {
        private final Params params;

        @Override
        public void run() {
            FileUtils.cleanOutputDir((File)this.params.getFinalBundleFile().getParentFile());
            SigningConfig signingConfig = SigningConfigMetadata.Companion.load(this.params.getSigningConfig());
            if (signingConfig != null) {
                SigningConfig signingConfig2 = signingConfig;
                boolean bl = false;
                boolean bl2 = false;
                SigningConfig it = signingConfig2;
                boolean bl3 = false;
                String string = it.getStoreType();
                File file = it.getStoreFile();
                if (file == null) {
                    Intrinsics.throwNpe();
                }
                String string2 = it.getStorePassword();
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                String string3 = it.getKeyPassword();
                if (string3 == null) {
                    Intrinsics.throwNpe();
                }
                String string4 = it.getKeyAlias();
                if (string4 == null) {
                    Intrinsics.throwNpe();
                }
                CertificateInfo certificateInfo = KeystoreHelper.getCertificateInfo((String)string, (File)file, (String)string2, (String)string3, (String)string4);
                String string5 = it.getKeyAlias();
                if (string5 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"it.keyAlias!!");
                String string6 = string5;
                boolean bl4 = false;
                String string7 = string6;
                if (string7 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string8 = string7.toUpperCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.String).toUpperCase()");
                String string9 = string8;
                CertificateInfo certificateInfo2 = certificateInfo;
                Intrinsics.checkExpressionValueIsNotNull((Object)certificateInfo2, (String)"certificateInfo");
                List list = CollectionsKt.listOf((Object)certificateInfo.getCertificate());
                PrivateKey privateKey = certificateInfo2.getKey();
                String string10 = string9;
                ApkSigner.SignerConfig signingConfig3 = new ApkSigner.SignerConfig.Builder(string10, privateKey, list).build();
                new ApkSigner.Builder(CollectionsKt.listOf((Object)signingConfig3)).setOutputApk(this.params.getFinalBundleFile()).setInputApk(this.params.getIntermediaryBundleFile()).setV2SigningEnabled(false).setV3SigningEnabled(false).setMinSdkVersion(18).build().sign();
            } else {
                BundleToolRunnable bundleToolRunnable = this;
                boolean bl = false;
                boolean bl5 = false;
                BundleToolRunnable $this$run = bundleToolRunnable;
                boolean bl6 = false;
                FileUtils.copyFile((File)$this$run.params.getIntermediaryBundleFile(), (File)$this$run.params.getFinalBundleFile());
            }
        }

        @Inject
        public BundleToolRunnable(@NotNull Params params) {
            Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
            this.params = params;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\nH\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lcom/android/build/gradle/internal/tasks/FinalizeBundleTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/FinalizeBundleTask;", "variantScope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "(Lcom/android/build/gradle/internal/scope/VariantScope;)V", "finalBundleFile", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/RegularFile;", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "preConfigure", "taskName", "gradle"})
    public static final class CreationAction
    extends VariantTaskCreationAction<FinalizeBundleTask> {
        private Provider<RegularFile> finalBundleFile;

        @Override
        @NotNull
        public String getName() {
            String string = this.getVariantScope().getTaskName("sign", "Bundle");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variantScope.getTaskName(\"sign\", \"Bundle\")");
            return string;
        }

        @Override
        @NotNull
        public Class<FinalizeBundleTask> getType() {
            return FinalizeBundleTask.class;
        }

        @Override
        public void preConfigure(@NotNull String taskName) {
            Provider<RegularFile> provider;
            Intrinsics.checkParameterIsNotNull((Object)taskName, (String)"taskName");
            super.preConfigure(taskName);
            StringBuilder stringBuilder = new StringBuilder();
            GlobalScope globalScope = this.getVariantScope().getGlobalScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)globalScope, (String)"variantScope.globalScope");
            StringBuilder stringBuilder2 = stringBuilder.append(globalScope.getProjectBaseName()).append('-');
            GradleVariantConfiguration gradleVariantConfiguration = this.getVariantScope().getVariantConfiguration();
            Intrinsics.checkExpressionValueIsNotNull((Object)gradleVariantConfiguration, (String)"variantScope.variantConfiguration");
            String bundleName = stringBuilder2.append(gradleVariantConfiguration.getBaseName()).append(".aab").toString();
            GlobalScope globalScope2 = this.getVariantScope().getGlobalScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)globalScope2, (String)"variantScope.globalScope");
            String apkLocationOverride = globalScope2.getProjectOptions().get(StringOption.IDE_APK_LOCATION);
            if (apkLocationOverride == null) {
                provider = this.getVariantScope().getArtifacts().createArtifactFile((ArtifactType)InternalArtifactType.BUNDLE, BuildArtifactsHolder.OperationType.INITIAL, taskName, bundleName);
            } else {
                BuildArtifactsHolder buildArtifactsHolder = this.getVariantScope().getArtifacts();
                ArtifactType artifactType = InternalArtifactType.BUNDLE;
                GlobalScope globalScope3 = this.getVariantScope().getGlobalScope();
                Intrinsics.checkExpressionValueIsNotNull((Object)globalScope3, (String)"variantScope.globalScope");
                File file = globalScope3.getProject().file((Object)apkLocationOverride);
                String[] stringArray = new String[2];
                GradleVariantConfiguration gradleVariantConfiguration2 = this.getVariantScope().getVariantConfiguration();
                Intrinsics.checkExpressionValueIsNotNull((Object)gradleVariantConfiguration2, (String)"variantScope.variantConfiguration");
                stringArray[0] = gradleVariantConfiguration2.getDirName();
                stringArray[1] = bundleName;
                File file2 = FileUtils.join((File)file, (String[])stringArray);
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"FileUtils.join(\n        \u2026              bundleName)");
                provider = buildArtifactsHolder.createArtifactFile(artifactType, BuildArtifactsHolder.OperationType.INITIAL, taskName, file2);
            }
            this.finalBundleFile = provider;
        }

        @Override
        public void configure(@NotNull FinalizeBundleTask task) {
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super.configure((Task)task);
            task.intermediaryBundleFile = this.getVariantScope().getArtifacts().getFinalArtifactFiles(InternalArtifactType.INTERMEDIARY_BUNDLE);
            Provider<RegularFile> provider = this.finalBundleFile;
            if (provider == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"finalBundleFile");
            }
            task.finalBundleFile = provider;
            GradleVariantConfiguration gradleVariantConfiguration = this.getVariantScope().getVariantConfiguration();
            Intrinsics.checkExpressionValueIsNotNull((Object)gradleVariantConfiguration, (String)"variantScope.variantConfiguration");
            CoreBuildType coreBuildType = (CoreBuildType)gradleVariantConfiguration.getBuildType();
            Intrinsics.checkExpressionValueIsNotNull((Object)coreBuildType, (String)"variantScope.variantConfiguration.buildType");
            if (!coreBuildType.isDebuggable()) {
                task.signingConfig = this.getVariantScope().getSigningConfigFileCollection();
            }
        }

        public CreationAction(@NotNull VariantScope variantScope) {
            Intrinsics.checkParameterIsNotNull((Object)variantScope, (String)"variantScope");
            super(variantScope);
        }
    }
}

