/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.scope;

import com.android.build.FilterData;
import com.android.build.OutputFile;
import com.android.build.VariantOutput;
import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.internal.scope.ApkData;
import com.android.build.gradle.internal.scope.BuildElements;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class BuildOutput
implements OutputFile,
Serializable {
    private final ArtifactType outputType;
    private final ApkData apkData;
    private final String path;
    private final Map<String, String> properties;

    public BuildOutput(ArtifactType outputType, ApkData apkData, File outputFile) {
        this(outputType, apkData, outputFile, (Map<String, String>)ImmutableMap.of());
    }

    public BuildOutput(ArtifactType outputType, ApkData apkData, File outputFile, Map<String, String> properties) {
        this(outputType, apkData, outputFile.toPath(), properties);
    }

    public BuildOutput(ArtifactType outputType, ApkData apkData, Path outputPath2, Map<String, String> properties) {
        this.outputType = outputType;
        this.apkData = apkData;
        this.path = outputPath2.toString();
        this.properties = properties;
    }

    public void save(File folder) throws IOException {
        new BuildElements((Collection<BuildOutput>)ImmutableList.of((Object)this)).save(folder);
    }

    public ApkData getApkData() {
        return this.apkData;
    }

    public File getOutputFile() {
        return Paths.get(this.path, new String[0]).toFile();
    }

    public ArtifactType getType() {
        return this.outputType;
    }

    public String getOutputType() {
        return this.apkData.getType().toString();
    }

    public Collection<String> getFilterTypes() {
        return this.apkData.getFilters().stream().map(FilterData::getFilterType).collect(Collectors.toList());
    }

    public Collection<FilterData> getFilters() {
        return this.apkData.getFilters();
    }

    public String getFilter(String filterType) {
        return ApkData.getFilter(this.apkData.getFilters(), VariantOutput.FilterType.valueOf((String)filterType));
    }

    @Deprecated
    public OutputFile getMainOutputFile() {
        return this;
    }

    @Deprecated
    public Collection<? extends OutputFile> getOutputs() {
        return ImmutableList.of((Object)this);
    }

    public int getVersionCode() {
        return this.apkData.getVersionCode();
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("apkData", (Object)this.apkData).add("path", (Object)this.path).add("properties", (Object)Joiner.on((String)",").join(this.properties.entrySet())).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildOutput that = (BuildOutput)o;
        return this.outputType == that.outputType && Objects.equals(this.properties, that.properties) && Objects.equals(this.apkData, that.apkData) && Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hash(this.outputType, this.apkData, this.path, this.properties);
    }

    public Path getOutputPath() {
        return Paths.get(this.path, new String[0]);
    }
}

