/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.packaging;

import com.android.build.gradle.internal.incremental.CapturingChangesApkCreator;
import com.android.build.gradle.internal.incremental.FolderBasedApkCreator;
import com.android.build.gradle.internal.packaging.ApkCreatorFactories;
import com.android.builder.core.DefaultManifestParser;
import com.android.builder.core.ManifestAttributeSupplier;
import com.android.builder.internal.packaging.IncrementalPackager;
import com.android.builder.model.SigningConfig;
import com.android.builder.packaging.PackagerException;
import com.android.builder.packaging.PackagingUtils;
import com.android.ide.common.signing.CertificateInfo;
import com.android.ide.common.signing.KeystoreHelper;
import com.android.ide.common.signing.KeytoolException;
import com.android.tools.build.apkzlib.sign.SigningOptions;
import com.android.tools.build.apkzlib.zfile.ApkCreatorFactory;
import com.android.tools.build.apkzlib.zfile.NativeLibrariesPackagingMode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;

public class IncrementalPackagerBuilder {
    private static int NO_V1_SDK = 24;
    private ApkCreatorFactory.CreationData.Builder creationDataBuilder = ApkCreatorFactory.CreationData.builder();
    private ApkFormat apkFormat;
    private NativeLibrariesPackagingMode nativeLibrariesPackagingMode;
    private Predicate<String> noCompressPredicate;
    private Boolean keepTimestampsInApk;
    private File intermediateDir;
    private boolean debuggableBuild;
    private boolean jniDebuggableBuild;
    private Set<String> abiFilters = new HashSet<String>();
    private File manifestFile;
    private Collection<String> aaptOptionsNoCompress;
    private BuildType buildType;

    public IncrementalPackagerBuilder(ApkFormat apkFormat, BuildType buildType) {
        this.apkFormat = apkFormat;
        this.buildType = buildType;
        this.creationDataBuilder.setIncremental(buildType == BuildType.INCREMENTAL);
    }

    public IncrementalPackagerBuilder(ApkFormat apkFormat) {
        this(apkFormat, BuildType.UNKNOWN);
    }

    public IncrementalPackagerBuilder withSigning(SigningConfig signingConfig) {
        return this.withSigning(signingConfig, 1);
    }

    public IncrementalPackagerBuilder withSigning(SigningConfig signingConfig, int minSdk) {
        return this.withSigning(signingConfig, minSdk, null);
    }

    public IncrementalPackagerBuilder withSigning(SigningConfig signingConfig, int minSdk, Integer targetApi) {
        if (signingConfig == null) {
            return this;
        }
        try {
            String error2 = "SigningConfig \"" + signingConfig.getName() + "\" is missing required property \"%s\".";
            CertificateInfo certificateInfo = KeystoreHelper.getCertificateInfo((String)signingConfig.getStoreType(), (File)((File)Preconditions.checkNotNull((Object)signingConfig.getStoreFile(), (String)error2, (Object)"storeFile")), (String)((String)Preconditions.checkNotNull((Object)signingConfig.getStorePassword(), (String)error2, (Object)"storePassword")), (String)((String)Preconditions.checkNotNull((Object)signingConfig.getKeyPassword(), (String)error2, (Object)"keyPassword")), (String)((String)Preconditions.checkNotNull((Object)signingConfig.getKeyAlias(), (String)error2, (Object)"keyAlias")));
            boolean enableV1Signing = (targetApi == null || targetApi < NO_V1_SDK) && minSdk < NO_V1_SDK && signingConfig.isV1SigningEnabled();
            boolean enableV2Signing = (targetApi == null || targetApi >= NO_V1_SDK) && signingConfig.isV2SigningEnabled();
            this.creationDataBuilder.setSigningOptions(SigningOptions.builder().setKey(certificateInfo.getKey()).setCertificates(new X509Certificate[]{certificateInfo.getCertificate()}).setV1SigningEnabled(enableV1Signing).setV2SigningEnabled(enableV2Signing).setMinSdkVersion(minSdk).setValidation(this.computeValidation()).build());
        }
        catch (KeytoolException | FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    private SigningOptions.Validation computeValidation() {
        switch (this.buildType) {
            case INCREMENTAL: {
                return SigningOptions.Validation.ASSUME_VALID;
            }
            case CLEAN: {
                return SigningOptions.Validation.ASSUME_INVALID;
            }
            case UNKNOWN: {
                return SigningOptions.Validation.ALWAYS_VALIDATE;
            }
        }
        throw new RuntimeException("Unknown IncrementalPackagerBuilder build type " + (Object)((Object)this.buildType));
    }

    public IncrementalPackagerBuilder withOutputFile(File f) {
        this.creationDataBuilder.setApkPath(f);
        return this;
    }

    public IncrementalPackagerBuilder withNativeLibraryPackagingMode(NativeLibrariesPackagingMode packagingMode) {
        this.nativeLibrariesPackagingMode = packagingMode;
        return this;
    }

    public IncrementalPackagerBuilder withManifest(File manifest) {
        this.manifestFile = manifest;
        return this;
    }

    public IncrementalPackagerBuilder withNoCompressPredicate(Predicate<String> noCompressPredicate) {
        this.noCompressPredicate = noCompressPredicate;
        return this;
    }

    public IncrementalPackagerBuilder withAaptOptionsNoCompress(Collection<String> aaptOptionsNoCompress) {
        this.aaptOptionsNoCompress = aaptOptionsNoCompress;
        return this;
    }

    public IncrementalPackagerBuilder withKeepTimestampsInApk(boolean keepTimestampsInApk) {
        this.keepTimestampsInApk = keepTimestampsInApk;
        return this;
    }

    public IncrementalPackagerBuilder withIntermediateDir(File intermediateDir) {
        this.intermediateDir = intermediateDir;
        return this;
    }

    public IncrementalPackagerBuilder withCreatedBy(String createdBy) {
        this.creationDataBuilder.setCreatedBy(createdBy);
        return this;
    }

    public IncrementalPackagerBuilder withDebuggableBuild(boolean debuggableBuild) {
        this.debuggableBuild = debuggableBuild;
        return this;
    }

    public IncrementalPackagerBuilder withJniDebuggableBuild(boolean jniDebuggableBuild) {
        this.jniDebuggableBuild = jniDebuggableBuild;
        return this;
    }

    public IncrementalPackagerBuilder withAcceptedAbis(Set<String> acceptedAbis) {
        this.abiFilters = ImmutableSet.copyOf(acceptedAbis);
        return this;
    }

    public IncrementalPackager build() {
        DefaultManifestParser manifest;
        Preconditions.checkState((this.keepTimestampsInApk != null ? 1 : 0) != 0, (Object)"keepTimestampsInApk == null");
        Preconditions.checkState((this.intermediateDir != null ? 1 : 0) != 0, (Object)"intermediateDir == null");
        DefaultManifestParser defaultManifestParser = manifest = this.manifestFile != null ? new DefaultManifestParser(this.manifestFile, () -> true, null) : null;
        if (this.noCompressPredicate == null) {
            this.noCompressPredicate = manifest != null ? PackagingUtils.getNoCompressPredicate(this.aaptOptionsNoCompress, (ManifestAttributeSupplier)manifest) : path -> false;
        }
        if (this.nativeLibrariesPackagingMode == null) {
            this.nativeLibrariesPackagingMode = manifest != null ? PackagingUtils.getNativeLibrariesLibrariesPackagingMode((ManifestAttributeSupplier)manifest) : NativeLibrariesPackagingMode.COMPRESSED;
        }
        this.creationDataBuilder.setNativeLibrariesPackagingMode(this.nativeLibrariesPackagingMode).setNoCompressPredicate(this.noCompressPredicate::test);
        try {
            return new IncrementalPackager(this.creationDataBuilder.build(), this.intermediateDir, this.apkFormat.factory(this.keepTimestampsInApk, this.debuggableBuild), this.abiFilters, this.jniDebuggableBuild);
        }
        catch (PackagerException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static enum BuildType {
        UNKNOWN,
        CLEAN,
        INCREMENTAL;

    }

    public static enum ApkFormat {
        FILE{

            @Override
            ApkCreatorFactory factory(boolean keepTimestampsInApk, boolean debuggableBuild) {
                return ApkCreatorFactories.fromProjectProperties(keepTimestampsInApk, debuggableBuild);
            }
        }
        ,
        FILE_WITH_LIST_OF_CHANGES{

            @Override
            ApkCreatorFactory factory(boolean keepTimestampsInApk, boolean debuggableBuild) {
                ApkCreatorFactory apk = ApkCreatorFactories.fromProjectProperties(keepTimestampsInApk, debuggableBuild);
                return creationData -> new CapturingChangesApkCreator(creationData, apk.make(creationData));
            }
        }
        ,
        DIRECTORY{

            @Override
            ApkCreatorFactory factory(boolean keepTimestampsInApk, boolean debuggableBuild) {
                return creationData -> new CapturingChangesApkCreator(creationData, new FolderBasedApkCreator(creationData));
            }
        };


        abstract ApkCreatorFactory factory(boolean var1, boolean var2);
    }
}

