/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dsl;

import com.android.build.gradle.internal.dsl.CoreNdkOptions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;

public class NdkOptions
implements CoreNdkOptions,
Serializable {
    private static final long serialVersionUID = 1L;
    private String moduleName;
    private String cFlags;
    private List<String> ldLibs;
    private Set<String> abiFilters;
    private String stl;
    private Integer jobs;

    public void _initWith(CoreNdkOptions ndkConfig) {
        this.moduleName = ndkConfig.getModuleName();
        this.cFlags = ndkConfig.getcFlags();
        this.setLdLibs(ndkConfig.getLdLibs());
        this.setAbiFilters(ndkConfig.getAbiFilters());
    }

    @Override
    @Input
    @Optional
    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    @Override
    @Input
    @Optional
    public String getcFlags() {
        return this.cFlags;
    }

    public void setcFlags(String cFlags) {
        this.cFlags = cFlags;
    }

    @Override
    @Input
    @Optional
    public List<String> getLdLibs() {
        return this.ldLibs;
    }

    public NdkOptions ldLibs(String lib) {
        if (this.ldLibs == null) {
            this.ldLibs = Lists.newArrayList();
        }
        this.ldLibs.add(lib);
        return this;
    }

    public NdkOptions ldLibs(String ... libs) {
        if (this.ldLibs == null) {
            this.ldLibs = Lists.newArrayListWithCapacity((int)libs.length);
        }
        Collections.addAll(this.ldLibs, libs);
        return this;
    }

    public NdkOptions setLdLibs(Collection<String> libs) {
        if (libs != null) {
            if (this.ldLibs == null) {
                this.ldLibs = Lists.newArrayListWithCapacity((int)libs.size());
            } else {
                this.ldLibs.clear();
            }
            this.ldLibs.addAll(libs);
        } else {
            this.ldLibs = null;
        }
        return this;
    }

    @Override
    @Input
    @Optional
    public Set<String> getAbiFilters() {
        return this.abiFilters;
    }

    public NdkOptions abiFilter(String filter) {
        if (this.abiFilters == null) {
            this.abiFilters = Sets.newHashSetWithExpectedSize((int)2);
        }
        this.abiFilters.add(filter);
        return this;
    }

    public NdkOptions abiFilters(String ... filters) {
        if (this.abiFilters == null) {
            this.abiFilters = Sets.newHashSetWithExpectedSize((int)2);
        }
        Collections.addAll(this.abiFilters, filters);
        return this;
    }

    public NdkOptions setAbiFilters(Collection<String> filters) {
        if (filters != null) {
            if (this.abiFilters == null) {
                this.abiFilters = Sets.newHashSetWithExpectedSize((int)filters.size());
            } else {
                this.abiFilters.clear();
            }
            this.abiFilters.addAll(filters);
        } else {
            this.abiFilters = null;
        }
        return this;
    }

    @Override
    public String getStl() {
        return this.stl;
    }

    public void setStl(String stl) {
        this.stl = stl;
    }

    @Override
    public Integer getJobs() {
        return this.jobs;
    }

    public void setJobs(Integer jobs) {
        this.jobs = jobs;
    }
}

