/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.api.artifact.BuildableArtifactUtil;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.Workers;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.ide.common.symbols.SymbolUtils;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.ide.common.xml.ManifestData;
import com.google.common.collect.Iterables;
import java.io.Closeable;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CacheableTask
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001:\u0003\u0017\u0018\u0019B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0015\u001a\u00020\u0016H\u0014R \u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR,\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR \u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u000f8G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/build/gradle/internal/tasks/GenerateLibraryProguardRulesTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "(Lorg/gradle/workers/WorkerExecutor;)V", "<set-?>", "Lcom/android/build/api/artifact/BuildableArtifact;", "inputResourcesDir", "getInputResourcesDir", "()Lcom/android/build/api/artifact/BuildableArtifact;", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "manifestFiles", "getManifestFiles", "()Lorg/gradle/api/provider/Provider;", "Ljava/io/File;", "proguardOutputFile", "getProguardOutputFile", "()Ljava/io/File;", "workers", "Lcom/android/ide/common/workers/WorkerExecutorFacade;", "doTaskAction", "", "CreationAction", "GenerateProguardRulesParams", "GenerateProguardRulesRunnable", "gradle"})
public class GenerateLibraryProguardRulesTask
extends NonIncrementalTask {
    private final WorkerExecutorFacade workers;
    @NotNull
    private File proguardOutputFile;
    @NotNull
    private Provider<Directory> manifestFiles;
    @NotNull
    private BuildableArtifact inputResourcesDir;

    @OutputFile
    @NotNull
    public final File getProguardOutputFile() {
        File file = this.proguardOutputFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"proguardOutputFile");
        }
        return file;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final Provider<Directory> getManifestFiles() {
        Provider<Directory> provider = this.manifestFiles;
        if (provider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"manifestFiles");
        }
        return provider;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final BuildableArtifact getInputResourcesDir() {
        BuildableArtifact buildableArtifact = this.inputResourcesDir;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inputResourcesDir");
        }
        return buildableArtifact;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doTaskAction() {
        ArtifactType artifactType = InternalArtifactType.MERGED_MANIFESTS;
        Provider<Directory> provider = this.manifestFiles;
        if (provider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"manifestFiles");
        }
        Object object = Iterables.getOnlyElement((Iterable)ExistingBuildElements.Companion.from(artifactType, provider));
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"Iterables.getOnlyElement\u2026ANIFESTS, manifestFiles))");
        File file = ((BuildOutput)object).getOutputFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"Iterables.getOnlyElement\u2026)\n            .outputFile");
        File manifest = file;
        Closeable closeable = (Closeable)this.workers;
        boolean bl = false;
        Throwable throwable = null;
        try {
            WorkerExecutorFacade it = (WorkerExecutorFacade)closeable;
            boolean bl2 = false;
            File file2 = this.proguardOutputFile;
            if (file2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"proguardOutputFile");
            }
            BuildableArtifact buildableArtifact = this.inputResourcesDir;
            if (buildableArtifact == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"inputResourcesDir");
            }
            it.submit(GenerateProguardRulesRunnable.class, (Serializable)new GenerateProguardRulesParams(manifest, file2, BuildableArtifactUtil.singleFile(buildableArtifact)));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Inject
    public GenerateLibraryProguardRulesTask(@NotNull WorkerExecutor workerExecutor) {
        Intrinsics.checkParameterIsNotNull((Object)workerExecutor, (String)"workerExecutor");
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        String string = project.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.name");
        String string2 = this.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"path");
        this.workers = Workers.preferWorkers$default(Workers.INSTANCE, string, string2, workerExecutor, null, 8, null);
    }

    public static final /* synthetic */ File access$getProguardOutputFile$p(GenerateLibraryProguardRulesTask $this) {
        File file = $this.proguardOutputFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"proguardOutputFile");
        }
        return file;
    }

    public static final /* synthetic */ BuildableArtifact access$getInputResourcesDir$p(GenerateLibraryProguardRulesTask $this) {
        BuildableArtifact buildableArtifact = $this.inputResourcesDir;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inputResourcesDir");
        }
        return buildableArtifact;
    }

    public static final /* synthetic */ Provider access$getManifestFiles$p(GenerateLibraryProguardRulesTask $this) {
        Provider<Directory> provider = $this.manifestFiles;
        if (provider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"manifestFiles");
        }
        return provider;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0017"}, d2={"Lcom/android/build/gradle/internal/tasks/GenerateLibraryProguardRulesTask$GenerateProguardRulesParams;", "Ljava/io/Serializable;", "manifestFile", "Ljava/io/File;", "proguardOutputFile", "inputResourcesDir", "(Ljava/io/File;Ljava/io/File;Ljava/io/File;)V", "getInputResourcesDir", "()Ljava/io/File;", "getManifestFile", "getProguardOutputFile", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "gradle"})
    public static final class GenerateProguardRulesParams
    implements Serializable {
        @NotNull
        private final File manifestFile;
        @NotNull
        private final File proguardOutputFile;
        @NotNull
        private final File inputResourcesDir;

        @NotNull
        public final File getManifestFile() {
            return this.manifestFile;
        }

        @NotNull
        public final File getProguardOutputFile() {
            return this.proguardOutputFile;
        }

        @NotNull
        public final File getInputResourcesDir() {
            return this.inputResourcesDir;
        }

        public GenerateProguardRulesParams(@NotNull File manifestFile, @NotNull File proguardOutputFile, @NotNull File inputResourcesDir) {
            Intrinsics.checkParameterIsNotNull((Object)manifestFile, (String)"manifestFile");
            Intrinsics.checkParameterIsNotNull((Object)proguardOutputFile, (String)"proguardOutputFile");
            Intrinsics.checkParameterIsNotNull((Object)inputResourcesDir, (String)"inputResourcesDir");
            this.manifestFile = manifestFile;
            this.proguardOutputFile = proguardOutputFile;
            this.inputResourcesDir = inputResourcesDir;
        }

        @NotNull
        public final File component1() {
            return this.manifestFile;
        }

        @NotNull
        public final File component2() {
            return this.proguardOutputFile;
        }

        @NotNull
        public final File component3() {
            return this.inputResourcesDir;
        }

        @NotNull
        public final GenerateProguardRulesParams copy(@NotNull File manifestFile, @NotNull File proguardOutputFile, @NotNull File inputResourcesDir) {
            Intrinsics.checkParameterIsNotNull((Object)manifestFile, (String)"manifestFile");
            Intrinsics.checkParameterIsNotNull((Object)proguardOutputFile, (String)"proguardOutputFile");
            Intrinsics.checkParameterIsNotNull((Object)inputResourcesDir, (String)"inputResourcesDir");
            return new GenerateProguardRulesParams(manifestFile, proguardOutputFile, inputResourcesDir);
        }

        public static /* synthetic */ GenerateProguardRulesParams copy$default(GenerateProguardRulesParams generateProguardRulesParams, File file, File file2, File file3, int n, Object object) {
            if ((n & 1) != 0) {
                file = generateProguardRulesParams.manifestFile;
            }
            if ((n & 2) != 0) {
                file2 = generateProguardRulesParams.proguardOutputFile;
            }
            if ((n & 4) != 0) {
                file3 = generateProguardRulesParams.inputResourcesDir;
            }
            return generateProguardRulesParams.copy(file, file2, file3);
        }

        @NotNull
        public String toString() {
            return "GenerateProguardRulesParams(manifestFile=" + this.manifestFile + ", proguardOutputFile=" + this.proguardOutputFile + ", inputResourcesDir=" + this.inputResourcesDir + ")";
        }

        public int hashCode() {
            File file = this.manifestFile;
            File file2 = this.proguardOutputFile;
            File file3 = this.inputResourcesDir;
            return ((file != null ? ((Object)file).hashCode() : 0) * 31 + (file2 != null ? ((Object)file2).hashCode() : 0)) * 31 + (file3 != null ? ((Object)file3).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof GenerateProguardRulesParams)) break block3;
                    GenerateProguardRulesParams generateProguardRulesParams = (GenerateProguardRulesParams)object;
                    if (!Intrinsics.areEqual((Object)this.manifestFile, (Object)generateProguardRulesParams.manifestFile) || !Intrinsics.areEqual((Object)this.proguardOutputFile, (Object)generateProguardRulesParams.proguardOutputFile) || !Intrinsics.areEqual((Object)this.inputResourcesDir, (Object)generateProguardRulesParams.inputResourcesDir)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/build/gradle/internal/tasks/GenerateLibraryProguardRulesTask$GenerateProguardRulesRunnable;", "Ljava/lang/Runnable;", "params", "Lcom/android/build/gradle/internal/tasks/GenerateLibraryProguardRulesTask$GenerateProguardRulesParams;", "(Lcom/android/build/gradle/internal/tasks/GenerateLibraryProguardRulesTask$GenerateProguardRulesParams;)V", "run", "", "gradle"})
    public static final class GenerateProguardRulesRunnable
    implements Runnable {
        private final GenerateProguardRulesParams params;

        @Override
        public void run() {
            Files.write(this.params.getProguardOutputFile().toPath(), (Iterable<? extends CharSequence>)SymbolUtils.generateMinifyKeepRules((ManifestData)SymbolUtils.parseManifest((File)this.params.getManifestFile()), (File)this.params.getInputResourcesDir()), new OpenOption[0]);
        }

        @Inject
        public GenerateProguardRulesRunnable(@NotNull GenerateProguardRulesParams params) {
            Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
            this.params = params;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0007H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lcom/android/build/gradle/internal/tasks/GenerateLibraryProguardRulesTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/GenerateLibraryProguardRulesTask;", "variantScope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "(Lcom/android/build/gradle/internal/scope/VariantScope;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "preConfigure", "taskName", "gradle"})
    public static final class CreationAction
    extends VariantTaskCreationAction<GenerateLibraryProguardRulesTask> {
        @Override
        @NotNull
        public String getName() {
            String string = this.getVariantScope().getTaskName("generate", "LibraryProguardRules");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variantScope.getTaskName\u2026, \"LibraryProguardRules\")");
            return string;
        }

        @Override
        @NotNull
        public Class<GenerateLibraryProguardRulesTask> getType() {
            return GenerateLibraryProguardRulesTask.class;
        }

        @Override
        public void preConfigure(@NotNull String taskName) {
            Intrinsics.checkParameterIsNotNull((Object)taskName, (String)"taskName");
            super.preConfigure(taskName);
            this.getVariantScope().getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.AAPT_PROGUARD_FILE, CollectionsKt.listOf((Object)this.getVariantScope().getProcessAndroidResourcesProguardOutputFile()), taskName);
        }

        @Override
        public void configure(@NotNull GenerateLibraryProguardRulesTask task) {
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super.configure((Task)task);
            File file = this.getVariantScope().getProcessAndroidResourcesProguardOutputFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"variantScope.processAndr\u2026sourcesProguardOutputFile");
            task.proguardOutputFile = file;
            task.inputResourcesDir = this.getVariantScope().getArtifacts().getFinalArtifactFiles(InternalArtifactType.PACKAGED_RES);
            task.manifestFiles = this.getVariantScope().getArtifacts().getFinalProduct(InternalArtifactType.MERGED_MANIFESTS);
        }

        public CreationAction(@NotNull VariantScope variantScope) {
            Intrinsics.checkParameterIsNotNull((Object)variantScope, (String)"variantScope");
            super(variantScope);
        }
    }
}

