/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.cxx.stripping.SymbolStripExecutableFinder;
import com.android.build.gradle.internal.dsl.PackagingOptions;
import com.android.build.gradle.internal.process.GradleProcessExecutor;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.IncrementalTask;
import com.android.build.gradle.internal.tasks.StripDebugSymbolsDelegate;
import com.android.build.gradle.internal.tasks.StripDebugSymbolsTask;
import com.android.build.gradle.internal.tasks.Workers;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.ide.common.resources.FileStatus;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.utils.FileUtils;
import com.google.common.collect.FluentIterable;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CacheableTask
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001:\u0001#B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0014J\u001c\u0010\u001c\u001a\u00020\u001b2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u001eH\u0014J\u0016\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001eH\u0007R,\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR,\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/android/build/gradle/internal/tasks/StripDebugSymbolsTask;", "Lcom/android/build/gradle/internal/tasks/IncrementalTask;", "()V", "<set-?>", "", "", "excludePatterns", "getExcludePatterns", "()Ljava/util/List;", "incremental", "", "getIncremental", "()Z", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "inputDir", "getInputDir", "()Lorg/gradle/api/provider/Provider;", "outputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "stripToolFinderProvider", "Lcom/android/build/gradle/internal/cxx/stripping/SymbolStripExecutableFinder;", "workers", "Lcom/android/build/gradle/internal/tasks/Workers$ProfileAwareExecutorServiceAdapter;", "doFullTaskAction", "", "doIncrementalTaskAction", "changedInputs", "", "Ljava/io/File;", "Lcom/android/ide/common/resources/FileStatus;", "getStripExecutablesMap", "Lcom/android/build/gradle/internal/core/Abi;", "CreationAction", "gradle"})
public abstract class StripDebugSymbolsTask
extends IncrementalTask {
    @NotNull
    private Provider<Directory> inputDir;
    @NotNull
    private List<String> excludePatterns;
    private Provider<SymbolStripExecutableFinder> stripToolFinderProvider;
    private final Workers.ProfileAwareExecutorServiceAdapter workers;

    @Classpath
    @NotNull
    public final Provider<Directory> getInputDir() {
        Provider<Directory> provider = this.inputDir;
        if (provider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inputDir");
        }
        return provider;
    }

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputDir();

    @Input
    @NotNull
    public final List<String> getExcludePatterns() {
        List<String> list = this.excludePatterns;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"excludePatterns");
        }
        return list;
    }

    @Input
    @Optional
    @Nullable
    public final Map<Abi, File> getStripExecutablesMap() {
        Map map;
        Provider<Directory> provider = this.inputDir;
        if (provider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inputDir");
        }
        Object object = provider.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"inputDir.get()");
        FluentIterable fluentIterable = FileUtils.getAllFiles((File)((Directory)object).getAsFile());
        Intrinsics.checkExpressionValueIsNotNull((Object)fluentIterable, (String)"FileUtils.getAllFiles(inputDir.get().asFile)");
        if (fluentIterable.isEmpty()) {
            map = null;
        } else {
            Provider<SymbolStripExecutableFinder> provider2 = this.stripToolFinderProvider;
            if (provider2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"stripToolFinderProvider");
            }
            map = MapsKt.toSortedMap(((SymbolStripExecutableFinder)provider2.get()).getStripExecutables());
        }
        return map;
    }

    @Override
    protected boolean getIncremental() {
        return true;
    }

    @Override
    protected void doFullTaskAction() {
        WorkerExecutorFacade workerExecutorFacade = (WorkerExecutorFacade)this.workers;
        Provider<Directory> provider = this.inputDir;
        if (provider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inputDir");
        }
        Object object = provider.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"inputDir.get()");
        File file = ((Directory)object).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"inputDir.get().asFile");
        Object object2 = this.getOutputDir().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"outputDir.get()");
        File file2 = ((Directory)object2).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"outputDir.get().asFile");
        List<String> list = this.excludePatterns;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"excludePatterns");
        }
        Provider<SymbolStripExecutableFinder> provider2 = this.stripToolFinderProvider;
        if (provider2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"stripToolFinderProvider");
        }
        new StripDebugSymbolsDelegate(workerExecutorFacade, file, file2, list, provider2, new GradleProcessExecutor(this.getProject()), null).run();
    }

    @Override
    protected void doIncrementalTaskAction(@NotNull Map<File, ? extends FileStatus> changedInputs) {
        Intrinsics.checkParameterIsNotNull(changedInputs, (String)"changedInputs");
        WorkerExecutorFacade workerExecutorFacade = (WorkerExecutorFacade)this.workers;
        Provider<Directory> provider = this.inputDir;
        if (provider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inputDir");
        }
        Object object = provider.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"inputDir.get()");
        File file = ((Directory)object).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"inputDir.get().asFile");
        Object object2 = this.getOutputDir().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"outputDir.get()");
        File file2 = ((Directory)object2).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"outputDir.get().asFile");
        List<String> list = this.excludePatterns;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"excludePatterns");
        }
        Provider<SymbolStripExecutableFinder> provider2 = this.stripToolFinderProvider;
        if (provider2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"stripToolFinderProvider");
        }
        new StripDebugSymbolsDelegate(workerExecutorFacade, file, file2, list, provider2, new GradleProcessExecutor(this.getProject()), changedInputs).run();
    }

    public StripDebugSymbolsTask() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        String string = project.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.name");
        String string2 = this.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"path");
        this.workers = Workers.INSTANCE.withThreads(string, string2);
    }

    public static final /* synthetic */ Provider access$getInputDir$p(StripDebugSymbolsTask $this) {
        Provider<Directory> provider = $this.inputDir;
        if (provider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inputDir");
        }
        return provider;
    }

    public static final /* synthetic */ List access$getExcludePatterns$p(StripDebugSymbolsTask $this) {
        List<String> list = $this.excludePatterns;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"excludePatterns");
        }
        return list;
    }

    public static final /* synthetic */ Provider access$getStripToolFinderProvider$p(StripDebugSymbolsTask $this) {
        Provider<SymbolStripExecutableFinder> provider = $this.stripToolFinderProvider;
        if (provider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"stripToolFinderProvider");
        }
        return provider;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0018\u0010\u0011\u001a\u00020\u000f2\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/tasks/StripDebugSymbolsTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/StripDebugSymbolsTask;", "variantScope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "(Lcom/android/build/gradle/internal/scope/VariantScope;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle"})
    public static final class CreationAction
    extends VariantTaskCreationAction<StripDebugSymbolsTask> {
        @Override
        @NotNull
        public String getName() {
            String string = this.getVariantScope().getTaskName("strip", "DebugSymbols");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variantScope.getTaskName(\"strip\", \"DebugSymbols\")");
            return string;
        }

        @Override
        @NotNull
        public Class<StripDebugSymbolsTask> getType() {
            return StripDebugSymbolsTask.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<? extends StripDebugSymbolsTask> taskProvider) {
            Intrinsics.checkParameterIsNotNull(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            BuildArtifactsHolder buildArtifactsHolder = this.getVariantScope().getArtifacts();
            ArtifactType artifactType = InternalArtifactType.STRIPPED_NATIVE_LIBS;
            Provider provider = taskProvider.map((Transformer)handleProvider.1.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull((Object)provider, (String)"taskProvider.map { it.outputDir }");
            buildArtifactsHolder.producesDir(artifactType, BuildArtifactsHolder.OperationType.APPEND, taskProvider, (Provider<Property<Directory>>)provider, "out");
        }

        @Override
        public void configure(@NotNull StripDebugSymbolsTask task) {
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super.configure((Task)task);
            task.inputDir = this.getVariantScope().getArtifacts().getFinalProduct(InternalArtifactType.MERGED_NATIVE_LIBS);
            GlobalScope globalScope = this.getVariantScope().getGlobalScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)globalScope, (String)"variantScope.globalScope");
            AndroidConfig androidConfig = globalScope.getExtension();
            Intrinsics.checkExpressionValueIsNotNull((Object)androidConfig, (String)"variantScope.globalScope.extension");
            PackagingOptions packagingOptions = androidConfig.getPackagingOptions();
            Intrinsics.checkExpressionValueIsNotNull((Object)packagingOptions, (String)"variantScope.globalScope\u2026xtension.packagingOptions");
            Set<String> set = packagingOptions.getDoNotStrip();
            Intrinsics.checkExpressionValueIsNotNull(set, (String)"variantScope.globalScope\u2026ckagingOptions.doNotStrip");
            task.excludePatterns = CollectionsKt.sorted((Iterable)set);
            GlobalScope globalScope2 = this.getVariantScope().getGlobalScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)globalScope2, (String)"variantScope.globalScope");
            task.stripToolFinderProvider = globalScope2.getSdkComponents().getStripExecutableFinderProvider();
        }

        public CreationAction(@NotNull VariantScope variantScope) {
            Intrinsics.checkParameterIsNotNull((Object)variantScope, (String)"variantScope");
            super(variantScope);
        }
    }
}

