/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.utils.FileUtils;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;

public abstract class MergeFileTask
extends NonIncrementalTask {
    private FileCollection mInputFiles;

    @Override
    protected void doTaskAction() throws IOException {
        Set inputFiles2 = this.getInputFiles().getFiles();
        File output2 = ((RegularFile)this.getOutputFile().get()).getAsFile();
        List existingFiles = inputFiles2.stream().filter(File::isFile).collect(Collectors.toList());
        if (existingFiles.size() == 1) {
            Files.copy((File)((File)existingFiles.iterator().next()), (File)output2);
            return;
        }
        FileUtils.deleteIfExists((File)output2);
        if (existingFiles.isEmpty()) {
            return;
        }
        for (File file : existingFiles) {
            String content2 = Files.toString((File)file, (Charset)Charsets.UTF_8);
            Files.append((CharSequence)content2, (File)output2, (Charset)Charsets.UTF_8);
            Files.append((CharSequence)"\n", (File)output2, (Charset)Charsets.UTF_8);
        }
    }

    @InputFiles
    public FileCollection getInputFiles() {
        return this.mInputFiles;
    }

    public void setInputFiles(FileCollection inputFiles2) {
        this.mInputFiles = inputFiles2;
    }

    @OutputFile
    public abstract RegularFileProperty getOutputFile();
}

