/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.Context;
import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.internal.InternalScope;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.crash.PluginCrashReporter;
import com.android.build.gradle.internal.errors.MessageReceiverImpl;
import com.android.build.gradle.internal.pipeline.ExtendedContentType;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.transforms.DesugarIncrementalTransformHelper;
import com.android.build.gradle.internal.transforms.DexArchiveBuilderCacheHandler;
import com.android.build.gradle.internal.transforms.DexArchiveBuilderTransformKt;
import com.android.build.gradle.internal.transforms.TransformInputUtil;
import com.android.build.gradle.internal.workeractions.WorkerActionServiceRegistry;
import com.android.build.gradle.options.SyncOptions;
import com.android.builder.core.DexOptions;
import com.android.builder.dexing.ClassFileEntry;
import com.android.builder.dexing.DexerTool;
import com.android.builder.dexing.r8.ClassFileProviderFactory;
import com.android.builder.utils.FileCache;
import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.MessageReceiver;
import com.android.ide.common.blame.ParsingProcessOutputHandler;
import com.android.ide.common.blame.parser.DexParser;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.ToolOutputParser;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessOutput;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.Closeable;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logging;
import org.gradle.tooling.BuildException;
import org.gradle.workers.IsolationMode;
import org.gradle.workers.WorkerConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u00da\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0007[\\]^_`aB\u008f\u0001\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\r\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\r\u0012\u0006\u0010\u0014\u001a\u00020\u0011\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\b\u0010\u0019\u001a\u0004\u0018\u00010\r\u0012\u0006\u0010\u001a\u001a\u00020\u0011\u0012\u0006\u0010\u001b\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u001cJ>\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+2\u0006\u0010-\u001a\u00020.H\u0002JL\u0010/\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020%2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020)2\u0006\u00103\u001a\u00020\u00112\u0006\u00104\u001a\u00020+2\u0006\u0010,\u001a\u00020+2\f\u00105\u001a\b\u0012\u0004\u0012\u00020#06H\u0002J\u001e\u00107\u001a\b\u0012\u0004\u0012\u00020\u00180\"2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001e\u00108\u001a\b\u0012\u0004\u0012\u00020\u00180\"2\u0006\u00109\u001a\u00020:2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J6\u0010;\u001a\u00020.2\b\u0010<\u001a\u0004\u0018\u00010=2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020>0\"2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020>0\"2\u0006\u0010?\u001a\u00020'H\u0002J\u000e\u0010@\u001a\b\u0012\u0004\u0012\u00020A06H\u0016J\b\u0010B\u001a\u00020\u0018H\u0016J\u0018\u0010C\u001a\u00020#2\u0006\u0010D\u001a\u00020)2\u0006\u0010E\u001a\u00020FH\u0002J'\u0010G\u001a\u00020#2\u0006\u0010D\u001a\u00020)2\u0006\u0010H\u001a\u00020'2\b\u0010I\u001a\u0004\u0018\u00010\rH\u0002\u00a2\u0006\u0002\u0010JJ\u000e\u0010K\u001a\b\u0012\u0004\u0012\u00020A06H\u0016J\u0014\u0010L\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020N0MH\u0016J\u0010\u0010O\u001a\n\u0012\u0006\b\u0000\u0012\u00020Q0PH\u0016J\u0010\u0010R\u001a\n\u0012\u0006\b\u0000\u0012\u00020Q0PH\u0016J\u0010\u0010S\u001a\u00020\u00112\u0006\u0010T\u001a\u000201H\u0002J\b\u00103\u001a\u00020\u0011H\u0016JT\u0010U\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020%2\u0006\u00103\u001a\u00020\u00112\u0006\u0010?\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+2\f\u00105\u001a\b\u0012\u0004\u0012\u00020#062\u0006\u0010-\u001a\u00020.H\u0002J\u0018\u0010V\u001a\u00020W2\u0006\u00102\u001a\u00020)2\u0006\u0010X\u001a\u00020YH\u0002J\u0010\u0010Z\u001a\u00020W2\u0006\u00109\u001a\u00020:H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006b"}, d2={"Lcom/android/build/gradle/internal/transforms/DexArchiveBuilderTransform;", "Lcom/android/build/api/transform/Transform;", "androidJarClasspath", "Lorg/gradle/api/file/FileCollection;", "dexOptions", "Lcom/android/builder/core/DexOptions;", "messageReceiver", "Lcom/android/ide/common/blame/MessageReceiver;", "errorFormatMode", "Lcom/android/build/gradle/options/SyncOptions$ErrorFormatMode;", "userLevelCache", "Lcom/android/builder/utils/FileCache;", "minSdkVersion", "", "dexer", "Lcom/android/builder/dexing/DexerTool;", "useGradleWorkers", "", "inBufferSize", "outBufferSize", "isDebuggable", "java8LangSupportType", "Lcom/android/build/gradle/internal/scope/VariantScope$Java8LangSupport;", "projectVariant", "", "numberOfBuckets", "includeFeaturesInScopes", "enableDexingArtifactTransform", "(Lorg/gradle/api/file/FileCollection;Lcom/android/builder/core/DexOptions;Lcom/android/ide/common/blame/MessageReceiver;Lcom/android/build/gradle/options/SyncOptions$ErrorFormatMode;Lcom/android/builder/utils/FileCache;ILcom/android/builder/dexing/DexerTool;ZLjava/lang/Integer;Ljava/lang/Integer;ZLcom/android/build/gradle/internal/scope/VariantScope$Java8LangSupport;Ljava/lang/String;Ljava/lang/Integer;ZZ)V", "cacheHandler", "Lcom/android/build/gradle/internal/transforms/DexArchiveBuilderCacheHandler;", "executor", "Lcom/android/ide/common/internal/WaitableExecutor;", "convertJarToDexArchive", "", "Ljava/io/File;", "context", "Lcom/android/build/api/transform/Context;", "toConvert", "Lcom/android/build/api/transform/JarInput;", "transformOutputProvider", "Lcom/android/build/api/transform/TransformOutputProvider;", "bootclasspath", "Lcom/android/build/gradle/internal/transforms/DexArchiveBuilderTransform$ClasspathServiceKey;", "classpath", "cacheInfo", "Lcom/android/build/gradle/internal/transforms/DexArchiveBuilderTransform$D8DesugaringCacheInfo;", "convertToDexArchive", "input", "Lcom/android/build/api/transform/QualifiedContent;", "outputProvider", "isIncremental", "bootClasspath", "additionalPaths", "", "getBootClasspath", "getClasspath", "transformInvocation", "Lcom/android/build/api/transform/TransformInvocation;", "getD8DesugaringCacheInfo", "desugarIncrementalTransformHelper", "Lcom/android/build/gradle/internal/transforms/DesugarIncrementalTransformHelper;", "Ljava/nio/file/Path;", "jarInput", "getInputTypes", "Lcom/android/build/api/transform/QualifiedContent$ContentType;", "getName", "getOutputForDir", "output", "directoryInput", "Lcom/android/build/api/transform/DirectoryInput;", "getOutputForJar", "qualifiedContent", "bucketId", "(Lcom/android/build/api/transform/TransformOutputProvider;Lcom/android/build/api/transform/JarInput;Ljava/lang/Integer;)Ljava/io/File;", "getOutputTypes", "getParameterInputs", "", "", "getReferencedScopes", "Lcom/google/common/collect/ImmutableSet;", "Lcom/android/build/api/transform/QualifiedContent$Scope;", "getScopes", "isExternalLib", "content", "processJarInput", "removeDeletedEntries", "", "transformInput", "Lcom/android/build/api/transform/TransformInput;", "transform", "ClasspathService", "ClasspathServiceKey", "D8DesugaringCacheInfo", "DesugaringDontCache", "DesugaringNoInfoCache", "DexConversionParameters", "DexConversionWorkAction", "gradle"})
public final class DexArchiveBuilderTransform
extends Transform {
    private final WaitableExecutor executor;
    private final DexArchiveBuilderCacheHandler cacheHandler;
    private final int inBufferSize;
    private final int outBufferSize;
    private final int numberOfBuckets;
    private final FileCollection androidJarClasspath;
    private final DexOptions dexOptions;
    private final MessageReceiver messageReceiver;
    private final SyncOptions.ErrorFormatMode errorFormatMode;
    private final int minSdkVersion;
    private final DexerTool dexer;
    private final boolean useGradleWorkers;
    private final boolean isDebuggable;
    private final VariantScope.Java8LangSupport java8LangSupportType;
    private final String projectVariant;
    private final boolean includeFeaturesInScopes;
    private final boolean enableDexingArtifactTransform;

    @NotNull
    public String getName() {
        return "dexBuilder";
    }

    @NotNull
    public Set<QualifiedContent.ContentType> getInputTypes() {
        Set<QualifiedContent.ContentType> set = TransformManager.CONTENT_CLASS;
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"TransformManager.CONTENT_CLASS");
        return set;
    }

    @NotNull
    public Set<QualifiedContent.ContentType> getOutputTypes() {
        ImmutableSet immutableSet = ImmutableSet.of((Object)((Object)ExtendedContentType.DEX_ARCHIVE));
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableSet, (String)"ImmutableSet.of<ContentT\u2026dContentType.DEX_ARCHIVE)");
        return (Set)immutableSet;
    }

    @NotNull
    public ImmutableSet<? super QualifiedContent.Scope> getScopes() {
        ImmutableSet immutableSet;
        if (this.enableDexingArtifactTransform) {
            ImmutableSet immutableSet2 = ImmutableSet.of((Object)QualifiedContent.Scope.PROJECT);
            immutableSet = immutableSet2;
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableSet2, (String)"ImmutableSet.of(Scope.PROJECT)");
        } else if (this.includeFeaturesInScopes) {
            ImmutableSet immutableSet3 = ImmutableSet.copyOf((Collection)TransformManager.SCOPE_FULL_WITH_IR_AND_FEATURES);
            immutableSet = immutableSet3;
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableSet3, (String)"ImmutableSet.copyOf(Tran\u2026ULL_WITH_IR_AND_FEATURES)");
        } else {
            ImmutableSet immutableSet4 = ImmutableSet.copyOf((Collection)TransformManager.SCOPE_FULL_WITH_IR_FOR_DEXING);
            immutableSet = immutableSet4;
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableSet4, (String)"ImmutableSet.copyOf(Tran\u2026_FULL_WITH_IR_FOR_DEXING)");
        }
        return immutableSet;
    }

    @NotNull
    public ImmutableSet<? super QualifiedContent.Scope> getReferencedScopes() {
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        boolean bl = false;
        boolean bl2 = false;
        ImmutableSet.Builder it = builder;
        boolean bl3 = false;
        it.add((Object[])new QualifiedContent.ScopeType[]{(QualifiedContent.ScopeType)QualifiedContent.Scope.TESTED_CODE, (QualifiedContent.ScopeType)QualifiedContent.Scope.PROVIDED_ONLY});
        if (this.enableDexingArtifactTransform) {
            it.add((Object)QualifiedContent.Scope.SUB_PROJECTS);
            it.add((Object)QualifiedContent.Scope.EXTERNAL_LIBRARIES);
            if (this.includeFeaturesInScopes) {
                it.add((Object)InternalScope.FEATURES);
            }
        }
        ImmutableSet immutableSet = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableSet, (String)"ImmutableSet.Builder<Qua\u2026      }\n        }.build()");
        return immutableSet;
    }

    @NotNull
    public Map<String, Object> getParameterInputs() {
        return MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"optimize", (Object)(!this.dexOptions.getAdditionalParameters().contains("--no-optimize") ? 1 : 0)), TuplesKt.to((Object)"jumbo", (Object)this.dexOptions.getJumboMode()), TuplesKt.to((Object)"min-sdk-version", (Object)this.minSdkVersion), TuplesKt.to((Object)"dex-builder-tool", (Object)this.dexer.name()), TuplesKt.to((Object)"enable-dexing-artifact-transform", (Object)this.enableDexingArtifactTransform)});
    }

    public boolean isIncremental() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void transform(@NotNull TransformInvocation transformInvocation) {
        WorkerActionServiceRegistry.RegisteredService registeredService;
        Object it;
        void classpathServiceKey;
        void bootclasspathServiceKey;
        boolean bl;
        Object $this$mapTo$iv$iv;
        ClasspathServiceKey it2;
        void $this$mapTo$iv$iv2;
        Comparable<File> comparable;
        Collection collection;
        boolean $i$f$map;
        Object object;
        DesugarIncrementalTransformHelper desugarIncrementalTransformHelper2;
        TransformOutputProvider outputProvider;
        block46: {
            block45: {
                void $this$mapTo$iv$iv3;
                Intrinsics.checkParameterIsNotNull((Object)transformInvocation, (String)"transformInvocation");
                TransformOutputProvider transformOutputProvider = transformInvocation.getOutputProvider();
                boolean bl2 = false;
                boolean bl3 = false;
                if (transformOutputProvider == null) {
                    boolean bl4 = false;
                    String string = "Missing output provider.";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                outputProvider = transformOutputProvider;
                if (this.dexOptions.getAdditionalParameters().contains("--no-optimize")) {
                    DexArchiveBuilderTransformKt.access$getLogger$p().warning("Disabling dex optimization produces wrong local debug info, b.android.com/82031.", new Object[0]);
                }
                DexArchiveBuilderTransformKt.access$getLogger$p().verbose("Task is incremental : %b ", transformInvocation.isIncremental());
                if (!transformInvocation.isIncremental()) {
                    outputProvider.deleteAll();
                }
                Iterable<TransformInput> iterable = TransformInputUtil.getInputAndReferenced(transformInvocation);
                Intrinsics.checkExpressionValueIsNotNull(iterable, (String)"TransformInputUtil.getIn\u2026nced(transformInvocation)");
                Iterable<TransformInput> transformInputs = iterable;
                Collection<File> allInputs = TransformInputUtil.getAllFiles(transformInputs);
                DesugarIncrementalTransformHelper bl4 = new DesugarIncrementalTransformHelper(this.projectVariant, transformInvocation.isIncremental(), (Iterable<File>)allInputs, new Supplier<Set<Path>>(transformInputs){
                    final /* synthetic */ Iterable $transformInputs;

                    @NotNull
                    public final Set<Path> get() {
                        return TransformInputUtil.findChangedPaths(this.$transformInputs);
                    }
                    {
                        this.$transformInputs = iterable;
                    }
                }, this.executor);
                boolean bl5 = false;
                boolean bl6 = false;
                Object it3 = bl4;
                boolean bl7 = false;
                desugarIncrementalTransformHelper2 = this.java8LangSupportType == VariantScope.Java8LangSupport.D8 ? bl4 : null;
                object = desugarIncrementalTransformHelper2;
                if (object == null || (object = ((DesugarIncrementalTransformHelper)object).getAdditionalPaths()) == null) break block45;
                Iterable $this$map$iv = (Iterable)object;
                $i$f$map = false;
                it3 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                    Iterator it4;
                    Path path = (Path)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl8 = false;
                    comparable = it4.toFile();
                    collection.add(comparable);
                }
                object = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                if (object != null) break block46;
            }
            object = SetsKt.emptySet();
        }
        Object additionalPaths = object;
        $i$f$map = false;
        List cacheableItems = new ArrayList();
        Iterable $this$map$iv = this.getClasspath(transformInvocation, this.java8LangSupportType);
        boolean $i$f$map2 = false;
        Iterable $i$f$mapTo = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl9 = false;
            comparable = Paths.get((String)((Object)it2), new String[0]);
            collection.add(comparable);
        }
        List classpath = (List)destination$iv$iv;
        Iterable $this$map$iv2 = this.getBootClasspath(this.androidJarClasspath, this.java8LangSupportType);
        boolean $i$f$map222 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo3 = false;
        Iterator item$iv$iv = $this$mapTo$iv$iv.iterator();
        while (item$iv$iv.hasNext()) {
            void it5;
            Object item$iv$iv2 = item$iv$iv.next();
            String bl9 = (String)item$iv$iv2;
            collection = destination$iv$iv2;
            boolean bl10 = false;
            comparable = Paths.get((String)it5, new String[0]);
            collection.add(comparable);
        }
        List bootclasspath = (List)destination$iv$iv2;
        $this$map$iv2 = new Ref.ObjectRef();
        ((Ref.ObjectRef)$this$map$iv2).element = null;
        Ref.ObjectRef $i$f$map222 = new Ref.ObjectRef();
        $i$f$map222.element = null;
        try {
            $this$mapTo$iv$iv = (Closeable)new ClassFileProviderFactory((Collection)bootclasspath);
            bl = false;
            Throwable throwable = null;
            try {
                ClassFileProviderFactory bootClasspathProvider = (ClassFileProviderFactory)$this$mapTo$iv$iv;
                boolean bl11 = false;
                Closeable it5 = (Closeable)new ClassFileProviderFactory((Collection)classpath);
                boolean bl12 = false;
                Throwable throwable2 = null;
                try {
                    ClassFileProviderFactory libraryClasspathProvider = (ClassFileProviderFactory)it5;
                    boolean bl13 = false;
                    bootclasspathServiceKey.element = new ClasspathServiceKey(bootClasspathProvider.getId());
                    classpathServiceKey.element = new ClasspathServiceKey(libraryClasspathProvider.getId());
                    ClasspathServiceKey classpathServiceKey2 = (ClasspathServiceKey)bootclasspathServiceKey.element;
                    if (classpathServiceKey2 == null) {
                        Intrinsics.throwNpe();
                    }
                    WorkerActionServiceRegistry.INSTANCE.registerService(classpathServiceKey2, (Function0)new Function0<ClasspathService>(bootClasspathProvider, this, classpath, (Ref.ObjectRef)bootclasspathServiceKey, (Ref.ObjectRef)classpathServiceKey, transformInvocation, outputProvider, (Set)additionalPaths, desugarIncrementalTransformHelper2, bootclasspath, cacheableItems){
                        final /* synthetic */ ClassFileProviderFactory $bootClasspathProvider$inlined;
                        final /* synthetic */ DexArchiveBuilderTransform this$0;
                        final /* synthetic */ List $classpath$inlined;
                        final /* synthetic */ Ref.ObjectRef $bootclasspathServiceKey$inlined;
                        final /* synthetic */ Ref.ObjectRef $classpathServiceKey$inlined;
                        final /* synthetic */ TransformInvocation $transformInvocation$inlined;
                        final /* synthetic */ TransformOutputProvider $outputProvider$inlined;
                        final /* synthetic */ Set $additionalPaths$inlined;
                        final /* synthetic */ DesugarIncrementalTransformHelper $desugarIncrementalTransformHelper$inlined;
                        final /* synthetic */ List $bootclasspath$inlined;
                        final /* synthetic */ List $cacheableItems$inlined;
                        {
                            this.$bootClasspathProvider$inlined = classFileProviderFactory;
                            this.this$0 = dexArchiveBuilderTransform;
                            this.$classpath$inlined = list;
                            this.$bootclasspathServiceKey$inlined = objectRef;
                            this.$classpathServiceKey$inlined = objectRef2;
                            this.$transformInvocation$inlined = transformInvocation;
                            this.$outputProvider$inlined = transformOutputProvider;
                            this.$additionalPaths$inlined = set;
                            this.$desugarIncrementalTransformHelper$inlined = desugarIncrementalTransformHelper2;
                            this.$bootclasspath$inlined = list2;
                            this.$cacheableItems$inlined = list3;
                            super(0);
                        }

                        @NotNull
                        public final ClasspathService invoke() {
                            return new ClasspathService(this.$bootClasspathProvider$inlined);
                        }
                    });
                    ClasspathServiceKey classpathServiceKey3 = (ClasspathServiceKey)classpathServiceKey.element;
                    if (classpathServiceKey3 == null) {
                        Intrinsics.throwNpe();
                    }
                    WorkerActionServiceRegistry.INSTANCE.registerService(classpathServiceKey3, (Function0)new Function0<ClasspathService>(libraryClasspathProvider){
                        final /* synthetic */ ClassFileProviderFactory $libraryClasspathProvider;

                        @NotNull
                        public final ClasspathService invoke() {
                            return new ClasspathService(this.$libraryClasspathProvider);
                        }
                        {
                            this.$libraryClasspathProvider = classFileProviderFactory;
                            super(0);
                        }
                    });
                    Iterator iterator = transformInvocation.getInputs().iterator();
                    while (iterator.hasNext()) {
                        TransformInput input;
                        TransformInput transformInput = input = (TransformInput)iterator.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)transformInput, (String)"input");
                        for (DirectoryInput dirInput : transformInput.getDirectoryInputs()) {
                            LoggerWrapper loggerWrapper = DexArchiveBuilderTransformKt.access$getLogger$p();
                            Object[] objectArray = new Object[1];
                            DirectoryInput directoryInput = dirInput;
                            Intrinsics.checkExpressionValueIsNotNull((Object)directoryInput, (String)"dirInput");
                            objectArray[0] = directoryInput.getFile().toString();
                            loggerWrapper.verbose("Dir input %s", objectArray);
                            Context context = transformInvocation.getContext();
                            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"transformInvocation.context");
                            QualifiedContent qualifiedContent = (QualifiedContent)dirInput;
                            boolean bl14 = transformInvocation.isIncremental();
                            ClasspathServiceKey classpathServiceKey4 = (ClasspathServiceKey)bootclasspathServiceKey.element;
                            if (classpathServiceKey4 == null) {
                                Intrinsics.throwNpe();
                            }
                            ClasspathServiceKey classpathServiceKey5 = (ClasspathServiceKey)classpathServiceKey.element;
                            if (classpathServiceKey5 == null) {
                                Intrinsics.throwNpe();
                            }
                            this.convertToDexArchive(context, qualifiedContent, outputProvider, bl14, classpathServiceKey4, classpathServiceKey5, (Set<? extends File>)additionalPaths);
                        }
                        for (JarInput jarInput : input.getJarInputs()) {
                            LoggerWrapper loggerWrapper = DexArchiveBuilderTransformKt.access$getLogger$p();
                            Object[] objectArray = new Object[1];
                            JarInput jarInput2 = jarInput;
                            Intrinsics.checkExpressionValueIsNotNull((Object)jarInput2, (String)"jarInput");
                            objectArray[0] = jarInput2.getFile().toString();
                            loggerWrapper.verbose("Jar input %s", objectArray);
                            D8DesugaringCacheInfo cacheInfo = this.getD8DesugaringCacheInfo(desugarIncrementalTransformHelper2, bootclasspath, classpath, jarInput);
                            Context context = transformInvocation.getContext();
                            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"transformInvocation.context");
                            boolean bl15 = transformInvocation.isIncremental();
                            ClasspathServiceKey classpathServiceKey6 = (ClasspathServiceKey)bootclasspathServiceKey.element;
                            if (classpathServiceKey6 == null) {
                                Intrinsics.throwNpe();
                            }
                            ClasspathServiceKey classpathServiceKey7 = (ClasspathServiceKey)classpathServiceKey.element;
                            if (classpathServiceKey7 == null) {
                                Intrinsics.throwNpe();
                            }
                            List<File> dexArchives = this.processJarInput(context, bl15, jarInput, outputProvider, classpathServiceKey6, classpathServiceKey7, (Set<? extends File>)additionalPaths, cacheInfo);
                            if (!(Intrinsics.areEqual((Object)cacheInfo, (Object)DesugaringDontCache.INSTANCE) ^ true)) continue;
                            Collection collection2 = dexArchives;
                            boolean bl16 = false;
                            if (!(!collection2.isEmpty()) || !this.isExternalLib((QualifiedContent)jarInput)) continue;
                            cacheableItems.add(new DexArchiveBuilderCacheHandler.CacheableItem(jarInput.getFile(), (Collection<File>)dexArchives, cacheInfo.getOrderedD8DesugaringDependencies()));
                        }
                    }
                    if (this.useGradleWorkers) {
                        Context context = transformInvocation.getContext();
                        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"transformInvocation.context");
                        context.getWorkerExecutor().await();
                    } else {
                        this.executor.waitForTasksWithQuickFail(true);
                    }
                    if (transformInvocation.isIncremental()) {
                        iterator = transformInvocation.getInputs().iterator();
                        while (iterator.hasNext()) {
                            TransformInput transformInput;
                            TransformInput transformInput2 = transformInput = (TransformInput)iterator.next();
                            Intrinsics.checkExpressionValueIsNotNull((Object)transformInput2, (String)"transformInput");
                            this.removeDeletedEntries(outputProvider, transformInput2);
                        }
                    }
                    Collection collection3 = cacheableItems;
                    boolean bl17 = false;
                    if (!collection3.isEmpty()) {
                        this.cacheHandler.populateCache(cacheableItems);
                    }
                    DexArchiveBuilderTransformKt.access$getLogger$p().verbose("Done with all dex archive conversions", new Object[0]);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)it5, (Throwable)throwable2);
                }
                bootClasspathProvider = Unit.INSTANCE;
            }
            catch (Throwable bootClasspathProvider) {
                throwable = bootClasspathProvider;
                throw bootClasspathProvider;
            }
            finally {
                CloseableKt.closeFinally((Closeable)$this$mapTo$iv$iv, (Throwable)throwable);
            }
        }
        catch (InterruptedException e) {
            try {
                Thread.currentThread().interrupt();
                throw (Throwable)new TransformException((Throwable)e);
                catch (Exception e2) {
                    PluginCrashReporter.maybeReportException(e2);
                    DexArchiveBuilderTransformKt.access$getLogger$p().error(null, Throwables.getStackTraceAsString((Throwable)e2), new Object[0]);
                    throw (Throwable)new TransformException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                WorkerActionServiceRegistry.RegisteredService registeredService2;
                WorkerActionServiceRegistry.RegisteredService registeredService3;
                boolean bl18;
                ClasspathServiceKey classpathServiceKey8;
                ClasspathServiceKey classpathServiceKey9 = (ClasspathServiceKey)classpathServiceKey.element;
                if (classpathServiceKey9 != null) {
                    classpathServiceKey8 = classpathServiceKey9;
                    bl18 = false;
                    boolean bl19 = false;
                    it2 = classpathServiceKey8;
                    boolean bl20 = false;
                    registeredService3 = WorkerActionServiceRegistry.INSTANCE.removeService(it2);
                } else {
                    registeredService3 = null;
                }
                ClasspathServiceKey classpathServiceKey10 = (ClasspathServiceKey)bootclasspathServiceKey.element;
                if (classpathServiceKey10 != null) {
                    classpathServiceKey8 = classpathServiceKey10;
                    bl18 = false;
                    boolean bl21 = false;
                    it2 = classpathServiceKey8;
                    boolean bl22 = false;
                    registeredService2 = WorkerActionServiceRegistry.INSTANCE.removeService(it2);
                    throw throwable;
                }
                registeredService2 = null;
                throw throwable;
            }
        }
        ClasspathServiceKey classpathServiceKey11 = (ClasspathServiceKey)classpathServiceKey.element;
        if (classpathServiceKey11 != null) {
            $this$mapTo$iv$iv = classpathServiceKey11;
            bl = false;
            boolean bl23 = false;
            it = $this$mapTo$iv$iv;
            boolean bl24 = false;
            registeredService = WorkerActionServiceRegistry.INSTANCE.removeService((WorkerActionServiceRegistry.ServiceKey)it);
        } else {
            registeredService = null;
        }
        ClasspathServiceKey classpathServiceKey12 = (ClasspathServiceKey)bootclasspathServiceKey.element;
        if (classpathServiceKey12 == null) return;
        $this$mapTo$iv$iv = classpathServiceKey12;
        bl = false;
        boolean bl25 = false;
        it = $this$mapTo$iv$iv;
        boolean bl26 = false;
        WorkerActionServiceRegistry.RegisteredService registeredService4 = WorkerActionServiceRegistry.INSTANCE.removeService((WorkerActionServiceRegistry.ServiceKey)it);
    }

    /*
     * WARNING - void declaration
     */
    private final D8DesugaringCacheInfo getD8DesugaringCacheInfo(DesugarIncrementalTransformHelper desugarIncrementalTransformHelper2, List<? extends Path> bootclasspath, List<? extends Path> classpath, JarInput jarInput) {
        void $this$filterTo$iv$iv;
        Iterable<Path> path;
        boolean bl;
        Set<Path> unorderedD8DesugaringDependencies;
        block7: {
            if (this.java8LangSupportType != VariantScope.Java8LangSupport.D8) {
                return DesugaringNoInfoCache.INSTANCE;
            }
            if (desugarIncrementalTransformHelper2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.android.build.gradle.internal.transforms.DesugarIncrementalTransformHelper");
            }
            Set<Path> set = unorderedD8DesugaringDependencies = desugarIncrementalTransformHelper2.getDependenciesPaths(jarInput.getFile().toPath());
            Intrinsics.checkExpressionValueIsNotNull(set, (String)"unorderedD8DesugaringDependencies");
            Iterable $this$any$iv = set;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    path = (Path)element$iv;
                    boolean bl2 = false;
                    if (!(!StringsKt.endsWith$default((String)((Object)path).toString(), (String)".jar", (boolean)false, (int)2, null))) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (bl) {
            return DesugaringDontCache.INSTANCE;
        }
        List bootclasspathPaths = CollectionsKt.distinct((Iterable)bootclasspath);
        Iterable $this$filter$iv = CollectionsKt.distinct((Iterable)classpath);
        boolean $i$f$filter = false;
        path = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Path it = (Path)element$iv$iv;
            boolean bl3 = false;
            if (!unorderedD8DesugaringDependencies.contains(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List classpathJars = (List)destination$iv$iv;
        ArrayList allDependencies = new ArrayList(bootclasspathPaths.size() + classpathJars.size());
        allDependencies.addAll(bootclasspathPaths);
        allDependencies.addAll(classpathJars);
        return new D8DesugaringCacheInfo(allDependencies);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isExternalLib(QualifiedContent content2) {
        File file = content2.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"content.file");
        if (!file.isFile()) return false;
        if (!Intrinsics.areEqual((Object)content2.getScopes(), (Object)SetsKt.setOf((Object)QualifiedContent.Scope.EXTERNAL_LIBRARIES))) return false;
        if (!Intrinsics.areEqual((Object)content2.getContentTypes(), (Object)SetsKt.setOf((Object)QualifiedContent.DefaultContentType.CLASSES))) return false;
        String string = content2.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"content.name");
        if (StringsKt.startsWith$default((String)string, (String)"android.local.jars:", (boolean)false, (int)2, null)) return false;
        return true;
    }

    private final void removeDeletedEntries(TransformOutputProvider outputProvider, TransformInput transformInput) {
        Iterator iterator = transformInput.getDirectoryInputs().iterator();
        while (iterator.hasNext()) {
            Map map;
            DirectoryInput input;
            DirectoryInput directoryInput = input = (DirectoryInput)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)directoryInput, (String)"input");
            Intrinsics.checkExpressionValueIsNotNull((Object)directoryInput.getChangedFiles(), (String)"input.changedFiles");
            boolean bl = false;
            Iterator iterator2 = map.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator2.next();
                boolean bl2 = false;
                File file = (File)entry2.getKey();
                entry2 = entry;
                bl2 = false;
                Status value = (Status)entry2.getValue();
                if (value != Status.REMOVED) continue;
                Path relativePath = input.getFile().toPath().relativize(file.toPath());
                File file2 = file;
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
                String string = file2.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.name");
                String fileToDelete = StringsKt.endsWith$default((String)string, (String)".class", (boolean)false, (int)2, null) ? ClassFileEntry.withDexExtension((String)((Object)relativePath).toString()) : ((Object)relativePath).toString();
                File outputFile = this.getOutputForDir(outputProvider, input);
                FileUtils.deleteRecursivelyIfExists((File)outputFile.toPath().resolve(fileToDelete).toFile());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<File> processJarInput(Context context, boolean isIncremental, JarInput jarInput, TransformOutputProvider transformOutputProvider, ClasspathServiceKey bootclasspath, ClasspathServiceKey classpath, Set<? extends File> additionalPaths, D8DesugaringCacheInfo cacheInfo) {
        if (!isIncremental) {
            Preconditions.checkState((boolean)jarInput.getFile().exists(), (String)"File %s does not exist, yet it is reported as input. Try \ncleaning the build directory.", (Object)jarInput.getFile().toString());
            return this.convertJarToDexArchive(context, jarInput, transformOutputProvider, bootclasspath, classpath, cacheInfo);
        }
        if (jarInput.getStatus() != Status.NOTCHANGED || additionalPaths.contains(jarInput.getFile())) {
            int n = 0;
            int n2 = this.numberOfBuckets;
            while (n < n2) {
                void bucketId;
                File shardedOutput = this.getOutputForJar(transformOutputProvider, jarInput, (int)bucketId);
                FileUtils.deleteIfExists((File)shardedOutput);
                if (jarInput.getStatus() != Status.REMOVED) {
                    FileUtils.mkdirs((File)shardedOutput.getParentFile());
                }
                ++bucketId;
            }
            File nonShardedOutput = this.getOutputForJar(transformOutputProvider, jarInput, null);
            FileUtils.deleteIfExists((File)nonShardedOutput);
            if (jarInput.getStatus() != Status.REMOVED) {
                FileUtils.mkdirs((File)nonShardedOutput.getParentFile());
            }
            if (jarInput.getStatus() == Status.ADDED || jarInput.getStatus() == Status.CHANGED || additionalPaths.contains(jarInput.getFile())) {
                return this.convertJarToDexArchive(context, jarInput, transformOutputProvider, bootclasspath, classpath, cacheInfo);
            }
        }
        boolean bl = false;
        return CollectionsKt.emptyList();
    }

    private final List<File> convertJarToDexArchive(Context context, JarInput toConvert, TransformOutputProvider transformOutputProvider, ClasspathServiceKey bootclasspath, ClasspathServiceKey classpath, D8DesugaringCacheInfo cacheInfo) {
        File cachedVersion;
        if (cacheInfo != DesugaringDontCache.INSTANCE && (cachedVersion = this.cacheHandler.getCachedVersionIfPresent(toConvert.getFile(), cacheInfo.getOrderedD8DesugaringDependencies())) != null) {
            File outputFile = this.getOutputForJar(transformOutputProvider, toConvert, null);
            Files.copy(cachedVersion.toPath(), outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
        QualifiedContent qualifiedContent = (QualifiedContent)toConvert;
        ImmutableSet immutableSet = ImmutableSet.of();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableSet, (String)"ImmutableSet.of()");
        return this.convertToDexArchive(context, qualifiedContent, transformOutputProvider, false, bootclasspath, classpath, (Set)immutableSet);
    }

    /*
     * WARNING - void declaration
     */
    private final List<File> convertToDexArchive(Context context, QualifiedContent input, TransformOutputProvider outputProvider, boolean isIncremental, ClasspathServiceKey bootClasspath, ClasspathServiceKey classpath, Set<? extends File> additionalPaths) {
        LoggerWrapper loggerWrapper = DexArchiveBuilderTransformKt.access$getLogger$p();
        Object[] objectArray = new Object[1];
        File file = input.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"input.file");
        objectArray[0] = file.getAbsolutePath();
        loggerWrapper.verbose("Dexing %s", objectArray);
        int n = 0;
        List dexArchives = new ArrayList();
        n = 0;
        int n2 = this.numberOfBuckets;
        while (n < n2) {
            void bucketId;
            File file2;
            if (input instanceof DirectoryInput) {
                File file3 = this.getOutputForDir(outputProvider, (DirectoryInput)input);
                boolean bl = false;
                boolean bl2 = false;
                File it = file3;
                boolean bl3 = false;
                it.mkdirs();
                file2 = file3;
            } else {
                QualifiedContent qualifiedContent = input;
                if (qualifiedContent == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.android.build.api.transform.JarInput");
                }
                file2 = this.getOutputForJar(outputProvider, (JarInput)qualifiedContent, (int)bucketId);
            }
            File preDexOutputFile = file2;
            dexArchives.add(preDexOutputFile);
            List list = this.dexOptions.getAdditionalParameters();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"dexOptions.additionalParameters");
            DexConversionParameters parameters = new DexConversionParameters(input, bootClasspath, classpath, preDexOutputFile, this.numberOfBuckets, (int)bucketId, this.minSdkVersion, list, this.inBufferSize, this.outBufferSize, this.dexer, this.isDebuggable, isIncremental, this.java8LangSupportType, additionalPaths, this.errorFormatMode);
            if (this.useGradleWorkers) {
                context.getWorkerExecutor().submit(DexConversionWorkAction.class, (Action)new Action<WorkerConfiguration>(parameters){
                    final /* synthetic */ DexConversionParameters $parameters;

                    public final void execute(WorkerConfiguration configuration) {
                        WorkerConfiguration workerConfiguration = configuration;
                        Intrinsics.checkExpressionValueIsNotNull((Object)workerConfiguration, (String)"configuration");
                        workerConfiguration.setIsolationMode(IsolationMode.NONE);
                        configuration.setParams(new Object[]{this.$parameters});
                    }
                    {
                        this.$parameters = dexConversionParameters;
                    }
                });
            } else {
                this.executor.execute((Callable)new Callable<Object>(this, parameters){
                    final /* synthetic */ DexArchiveBuilderTransform this$0;
                    final /* synthetic */ DexConversionParameters $parameters;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Nullable
                    public final Void call() {
                        Object it2;
                        boolean bl;
                        Closeable closeable;
                        ParsingProcessOutputHandler outputHandler = new ParsingProcessOutputHandler(new ToolOutputParser((PatternAwareOutputParser)new DexParser(), Message.Kind.ERROR, (ILogger)DexArchiveBuilderTransformKt.access$getLogger$p()), new ToolOutputParser((PatternAwareOutputParser)new DexParser(), (ILogger)DexArchiveBuilderTransformKt.access$getLogger$p()), new MessageReceiver[]{DexArchiveBuilderTransform.access$getMessageReceiver$p(this.this$0)});
                        ProcessOutput output2 = null;
                        try {
                            closeable = (Closeable)outputHandler.createOutput();
                            bl = false;
                            Throwable throwable = null;
                            try {
                                it2 = (ProcessOutput)closeable;
                                boolean bl2 = false;
                                ProcessOutput processOutput = output2 = it2;
                                if (processOutput == null) {
                                    Intrinsics.throwNpe();
                                }
                                OutputStream outputStream = processOutput.getStandardOutput();
                                Intrinsics.checkExpressionValueIsNotNull((Object)outputStream, (String)"output!!.standardOutput");
                                ProcessOutput processOutput2 = output2;
                                if (processOutput2 == null) {
                                    Intrinsics.throwNpe();
                                }
                                OutputStream outputStream2 = processOutput2.getErrorOutput();
                                Intrinsics.checkExpressionValueIsNotNull((Object)outputStream2, (String)"output!!.errorOutput");
                                DexArchiveBuilderTransformKt.access$launchProcessing(this.$parameters, outputStream, outputStream2, DexArchiveBuilderTransform.access$getMessageReceiver$p(this.this$0));
                                it2 = Unit.INSTANCE;
                            }
                            catch (Throwable it2) {
                                throwable = it2;
                                throw it2;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                            }
                        }
                        finally {
                            ProcessOutput processOutput = output2;
                            if (processOutput != null) {
                                closeable = processOutput;
                                bl = false;
                                boolean bl3 = false;
                                it2 = closeable;
                                boolean bl4 = false;
                                try {
                                    outputHandler.handleOutput(it2);
                                }
                                catch (ProcessException processException) {
                                }
                            }
                        }
                        return null;
                    }
                    {
                        this.this$0 = dexArchiveBuilderTransform;
                        this.$parameters = dexConversionParameters;
                    }
                });
            }
            ++bucketId;
        }
        return dexArchives;
    }

    private final File getOutputForDir(TransformOutputProvider output2, DirectoryInput directoryInput) {
        File file = output2.getContentLocation(directoryInput.getFile().toString(), SetsKt.setOf((Object)((Object)ExtendedContentType.DEX_ARCHIVE)), directoryInput.getScopes(), Format.DIRECTORY);
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"output.getContentLocatio\u2026ormat.DIRECTORY\n        )");
        return file;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getClasspath(TransformInvocation transformInvocation, VariantScope.Java8LangSupport java8LangSupportType) {
        JarInput jarInput;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        String string;
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        if (java8LangSupportType != VariantScope.Java8LangSupport.D8) {
            return CollectionsKt.emptyList();
        }
        boolean bl = false;
        List classpathEntries = new ArrayList();
        Iterable dependencies = Iterables.concat((Iterable)transformInvocation.getInputs(), (Iterable)transformInvocation.getReferencedInputs());
        Collection<File> collection2 = TransformInputUtil.getDirectories(dependencies);
        Intrinsics.checkExpressionValueIsNotNull(collection2, (String)"TransformInputUtil.getDirectories(dependencies)");
        Iterable iterable = CollectionsKt.distinct((Iterable)collection2);
        List list = classpathEntries;
        boolean $i$f$map = false;
        void var7_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            string = v1.getPath();
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        list.addAll((Collection)collection);
        Iterable iterable2 = dependencies;
        Intrinsics.checkExpressionValueIsNotNull((Object)iterable2, (String)"dependencies");
        $this$map$iv = iterable2;
        list = classpathEntries;
        boolean $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            TransformInput transformInput = (TransformInput)element$iv$iv;
            boolean bl3 = false;
            TransformInput transformInput2 = transformInput;
            Intrinsics.checkExpressionValueIsNotNull((Object)transformInput2, (String)"transformInput");
            Iterable list$iv$iv = transformInput2.getJarInputs();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        collection = (List)destination$iv$iv;
        $this$flatMap$iv = collection;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            jarInput = (JarInput)element$iv$iv;
            boolean bl4 = false;
            JarInput jarInput2 = jarInput;
            Intrinsics.checkExpressionValueIsNotNull((Object)jarInput2, (String)"jarInput");
            if (!(jarInput2.getStatus() != Status.REMOVED)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        collection = (List)destination$iv$iv;
        $this$filter$iv = collection;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            jarInput = (JarInput)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl5 = false;
            JarInput jarInput3 = jarInput;
            Intrinsics.checkExpressionValueIsNotNull((Object)jarInput3, (String)"jarInput");
            File file = jarInput3.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"jarInput.file");
            string = file.getPath();
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        list.addAll(CollectionsKt.distinct((Iterable)collection));
        return classpathEntries;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getBootClasspath(FileCollection androidJarClasspath, VariantScope.Java8LangSupport java8LangSupportType) {
        void $this$mapTo$iv$iv;
        if (java8LangSupportType != VariantScope.Java8LangSupport.D8) {
            return CollectionsKt.emptyList();
        }
        Set set = androidJarClasspath.getFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"androidJarClasspath.files");
        Iterable $this$map$iv = set;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            String string = v1.getPath();
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    private final File getOutputForJar(TransformOutputProvider output2, JarInput qualifiedContent, Integer bucketId) {
        String string = "" + '-' + bucketId;
        StringBuilder stringBuilder = new StringBuilder().append(qualifiedContent.getFile().toString());
        TransformOutputProvider transformOutputProvider = output2;
        boolean bl = false;
        boolean bl2 = false;
        String it = string;
        boolean bl3 = false;
        String string2 = bucketId != null ? string : null;
        String string3 = string2;
        if (string3 == null) {
            string3 = "";
        }
        File file = transformOutputProvider.getContentLocation(stringBuilder.append((Object)string3).toString(), SetsKt.setOf((Object)((Object)ExtendedContentType.DEX_ARCHIVE)), qualifiedContent.getScopes(), Format.JAR);
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"output.getContentLocatio\u2026     Format.JAR\n        )");
        return file;
    }

    public DexArchiveBuilderTransform(@NotNull FileCollection androidJarClasspath, @NotNull DexOptions dexOptions, @NotNull MessageReceiver messageReceiver, @NotNull SyncOptions.ErrorFormatMode errorFormatMode, @Nullable FileCache userLevelCache, int minSdkVersion, @NotNull DexerTool dexer, boolean useGradleWorkers, @Nullable Integer inBufferSize, @Nullable Integer outBufferSize, boolean isDebuggable, @NotNull VariantScope.Java8LangSupport java8LangSupportType, @NotNull String projectVariant, @Nullable Integer numberOfBuckets, boolean includeFeaturesInScopes, boolean enableDexingArtifactTransform) {
        Intrinsics.checkParameterIsNotNull((Object)androidJarClasspath, (String)"androidJarClasspath");
        Intrinsics.checkParameterIsNotNull((Object)dexOptions, (String)"dexOptions");
        Intrinsics.checkParameterIsNotNull((Object)messageReceiver, (String)"messageReceiver");
        Intrinsics.checkParameterIsNotNull((Object)((Object)errorFormatMode), (String)"errorFormatMode");
        Intrinsics.checkParameterIsNotNull((Object)dexer, (String)"dexer");
        Intrinsics.checkParameterIsNotNull((Object)((Object)java8LangSupportType), (String)"java8LangSupportType");
        Intrinsics.checkParameterIsNotNull((Object)projectVariant, (String)"projectVariant");
        this.androidJarClasspath = androidJarClasspath;
        this.dexOptions = dexOptions;
        this.messageReceiver = messageReceiver;
        this.errorFormatMode = errorFormatMode;
        this.minSdkVersion = minSdkVersion;
        this.dexer = dexer;
        this.useGradleWorkers = useGradleWorkers;
        this.isDebuggable = isDebuggable;
        this.java8LangSupportType = java8LangSupportType;
        this.projectVariant = projectVariant;
        this.includeFeaturesInScopes = includeFeaturesInScopes;
        this.enableDexingArtifactTransform = enableDexingArtifactTransform;
        WaitableExecutor waitableExecutor = WaitableExecutor.useGlobalSharedThreadPool();
        Intrinsics.checkExpressionValueIsNotNull((Object)waitableExecutor, (String)"WaitableExecutor.useGlobalSharedThreadPool()");
        this.executor = waitableExecutor;
        this.cacheHandler = new DexArchiveBuilderCacheHandler(userLevelCache, this.dexOptions, this.minSdkVersion, this.isDebuggable, this.dexer);
        Integer n = inBufferSize;
        this.inBufferSize = (n != null ? n : 100) * 1024;
        Integer n2 = outBufferSize;
        this.outBufferSize = (n2 != null ? n2 : 100) * 1024;
        Integer n3 = numberOfBuckets;
        this.numberOfBuckets = n3 != null ? n3 : DexArchiveBuilderTransformKt.access$getDEFAULT_NUM_BUCKETS$p();
    }

    public static final /* synthetic */ MessageReceiver access$getMessageReceiver$p(DexArchiveBuilderTransform $this) {
        return $this.messageReceiver;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\t\u0010\n\u001a\u00020\u0004H\u00c2\u0003J\u0013\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/transforms/DexArchiveBuilderTransform$ClasspathServiceKey;", "Lcom/android/build/gradle/internal/workeractions/WorkerActionServiceRegistry$ServiceKey;", "Lcom/android/builder/dexing/r8/ClassFileProviderFactory;", "id", "", "(J)V", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "gradle"})
    public static final class ClasspathServiceKey
    implements WorkerActionServiceRegistry.ServiceKey<ClassFileProviderFactory> {
        @NotNull
        private final Class<ClassFileProviderFactory> type;
        private final long id;

        @Override
        @NotNull
        public Class<ClassFileProviderFactory> getType() {
            return this.type;
        }

        public ClasspathServiceKey(long id) {
            this.id = id;
            this.type = ClassFileProviderFactory.class;
        }

        private final long component1() {
            return this.id;
        }

        @NotNull
        public final ClasspathServiceKey copy(long id) {
            return new ClasspathServiceKey(id);
        }

        @NotNull
        public static /* synthetic */ ClasspathServiceKey copy$default(ClasspathServiceKey classpathServiceKey, long l, int n, Object object) {
            if ((n & 1) != 0) {
                l = classpathServiceKey.id;
            }
            return classpathServiceKey.copy(l);
        }

        @NotNull
        public String toString() {
            return "ClasspathServiceKey(id=" + this.id + ")";
        }

        public int hashCode() {
            return Long.hashCode(this.id);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ClasspathServiceKey)) break block3;
                    ClasspathServiceKey classpathServiceKey = (ClasspathServiceKey)object;
                    if (!(this.id == classpathServiceKey.id)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/android/build/gradle/internal/transforms/DexArchiveBuilderTransform$ClasspathService;", "Lcom/android/build/gradle/internal/workeractions/WorkerActionServiceRegistry$RegisteredService;", "Lcom/android/builder/dexing/r8/ClassFileProviderFactory;", "service", "(Lcom/android/builder/dexing/r8/ClassFileProviderFactory;)V", "getService", "()Lcom/android/builder/dexing/r8/ClassFileProviderFactory;", "shutdown", "", "gradle"})
    public static final class ClasspathService
    implements WorkerActionServiceRegistry.RegisteredService<ClassFileProviderFactory> {
        @NotNull
        private final ClassFileProviderFactory service;

        @Override
        public void shutdown() {
        }

        @Override
        @NotNull
        public ClassFileProviderFactory getService() {
            return this.service;
        }

        public ClasspathService(@NotNull ClassFileProviderFactory service) {
            Intrinsics.checkParameterIsNotNull((Object)service, (String)"service");
            this.service = service;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001d\u0018\u00002\u00020\u0001B\u0091\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\u0006\u0010\u0010\u001a\u00020\n\u0012\u0006\u0010\u0011\u001a\u00020\n\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0015\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u001a\u0012\u0006\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\u0002\u0010\u001dJ\u000e\u00107\u001a\u00020\u00152\u0006\u00108\u001a\u00020\u000fR\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u001aX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010!R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010\u0012\u001a\u00020\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0014\u0010\u001b\u001a\u00020\u001cX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0014\u0010\u0010\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0014\u0010\u0014\u001a\u00020\u0015X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0011\u0010/\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010.R\u0014\u0010\u0016\u001a\u00020\u0015X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010.R\u0014\u0010\u0017\u001a\u00020\u0018X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0014\u0010\f\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010*R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010*R\u0014\u0010\u0007\u001a\u00020\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106\u00a8\u00069"}, d2={"Lcom/android/build/gradle/internal/transforms/DexArchiveBuilderTransform$DexConversionParameters;", "Ljava/io/Serializable;", "input", "Lcom/android/build/api/transform/QualifiedContent;", "bootClasspath", "Lcom/android/build/gradle/internal/transforms/DexArchiveBuilderTransform$ClasspathServiceKey;", "classpath", "output", "Ljava/io/File;", "numberOfBuckets", "", "buckedId", "minSdkVersion", "dexAdditionalParameters", "", "", "inBufferSize", "outBufferSize", "dexer", "Lcom/android/builder/dexing/DexerTool;", "isDebuggable", "", "isIncremental", "java8LangSupportType", "Lcom/android/build/gradle/internal/scope/VariantScope$Java8LangSupport;", "additionalPaths", "", "errorFormatMode", "Lcom/android/build/gradle/options/SyncOptions$ErrorFormatMode;", "(Lcom/android/build/api/transform/QualifiedContent;Lcom/android/build/gradle/internal/transforms/DexArchiveBuilderTransform$ClasspathServiceKey;Lcom/android/build/gradle/internal/transforms/DexArchiveBuilderTransform$ClasspathServiceKey;Ljava/io/File;IIILjava/util/List;IILcom/android/builder/dexing/DexerTool;ZZLcom/android/build/gradle/internal/scope/VariantScope$Java8LangSupport;Ljava/util/Set;Lcom/android/build/gradle/options/SyncOptions$ErrorFormatMode;)V", "getAdditionalPaths$gradle", "()Ljava/util/Set;", "getBootClasspath$gradle", "()Lcom/android/build/gradle/internal/transforms/DexArchiveBuilderTransform$ClasspathServiceKey;", "getClasspath$gradle", "getDexAdditionalParameters$gradle", "()Ljava/util/List;", "getDexer$gradle", "()Lcom/android/builder/dexing/DexerTool;", "getErrorFormatMode$gradle", "()Lcom/android/build/gradle/options/SyncOptions$ErrorFormatMode;", "getInBufferSize$gradle", "()I", "getInput$gradle", "()Lcom/android/build/api/transform/QualifiedContent;", "isDebuggable$gradle", "()Z", "isDirectoryBased", "isIncremental$gradle", "getJava8LangSupportType$gradle", "()Lcom/android/build/gradle/internal/scope/VariantScope$Java8LangSupport;", "getMinSdkVersion$gradle", "getOutBufferSize$gradle", "getOutput$gradle", "()Ljava/lang/String;", "belongsToThisBucket", "path", "gradle"})
    public static final class DexConversionParameters
    implements Serializable {
        @NotNull
        private final String output;
        private final boolean isDirectoryBased;
        @NotNull
        private final QualifiedContent input;
        @NotNull
        private final ClasspathServiceKey bootClasspath;
        @NotNull
        private final ClasspathServiceKey classpath;
        private final int numberOfBuckets;
        private final int buckedId;
        private final int minSdkVersion;
        @NotNull
        private final List<String> dexAdditionalParameters;
        private final int inBufferSize;
        private final int outBufferSize;
        @NotNull
        private final DexerTool dexer;
        private final boolean isDebuggable;
        private final boolean isIncremental;
        @NotNull
        private final VariantScope.Java8LangSupport java8LangSupportType;
        @NotNull
        private final Set<File> additionalPaths;
        @NotNull
        private final SyncOptions.ErrorFormatMode errorFormatMode;

        @NotNull
        public final String getOutput$gradle() {
            return this.output;
        }

        public final boolean isDirectoryBased() {
            return this.isDirectoryBased;
        }

        public final boolean belongsToThisBucket(@NotNull String path) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            return DexArchiveBuilderTransformKt.access$getBucketForFile(this.input, path, this.numberOfBuckets) == this.buckedId;
        }

        @NotNull
        public final QualifiedContent getInput$gradle() {
            return this.input;
        }

        @NotNull
        public final ClasspathServiceKey getBootClasspath$gradle() {
            return this.bootClasspath;
        }

        @NotNull
        public final ClasspathServiceKey getClasspath$gradle() {
            return this.classpath;
        }

        public final int getMinSdkVersion$gradle() {
            return this.minSdkVersion;
        }

        @NotNull
        public final List<String> getDexAdditionalParameters$gradle() {
            return this.dexAdditionalParameters;
        }

        public final int getInBufferSize$gradle() {
            return this.inBufferSize;
        }

        public final int getOutBufferSize$gradle() {
            return this.outBufferSize;
        }

        @NotNull
        public final DexerTool getDexer$gradle() {
            return this.dexer;
        }

        public final boolean isDebuggable$gradle() {
            return this.isDebuggable;
        }

        public final boolean isIncremental$gradle() {
            return this.isIncremental;
        }

        @NotNull
        public final VariantScope.Java8LangSupport getJava8LangSupportType$gradle() {
            return this.java8LangSupportType;
        }

        @NotNull
        public final Set<File> getAdditionalPaths$gradle() {
            return this.additionalPaths;
        }

        @NotNull
        public final SyncOptions.ErrorFormatMode getErrorFormatMode$gradle() {
            return this.errorFormatMode;
        }

        public DexConversionParameters(@NotNull QualifiedContent input, @NotNull ClasspathServiceKey bootClasspath, @NotNull ClasspathServiceKey classpath, @NotNull File output2, int numberOfBuckets, int buckedId, int minSdkVersion, @NotNull List<String> dexAdditionalParameters, int inBufferSize, int outBufferSize, @NotNull DexerTool dexer, boolean isDebuggable, boolean isIncremental, @NotNull VariantScope.Java8LangSupport java8LangSupportType, @NotNull Set<? extends File> additionalPaths, @NotNull SyncOptions.ErrorFormatMode errorFormatMode) {
            Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
            Intrinsics.checkParameterIsNotNull((Object)bootClasspath, (String)"bootClasspath");
            Intrinsics.checkParameterIsNotNull((Object)classpath, (String)"classpath");
            Intrinsics.checkParameterIsNotNull((Object)output2, (String)"output");
            Intrinsics.checkParameterIsNotNull(dexAdditionalParameters, (String)"dexAdditionalParameters");
            Intrinsics.checkParameterIsNotNull((Object)dexer, (String)"dexer");
            Intrinsics.checkParameterIsNotNull((Object)((Object)java8LangSupportType), (String)"java8LangSupportType");
            Intrinsics.checkParameterIsNotNull(additionalPaths, (String)"additionalPaths");
            Intrinsics.checkParameterIsNotNull((Object)((Object)errorFormatMode), (String)"errorFormatMode");
            this.input = input;
            this.bootClasspath = bootClasspath;
            this.classpath = classpath;
            this.numberOfBuckets = numberOfBuckets;
            this.buckedId = buckedId;
            this.minSdkVersion = minSdkVersion;
            this.dexAdditionalParameters = dexAdditionalParameters;
            this.inBufferSize = inBufferSize;
            this.outBufferSize = outBufferSize;
            this.dexer = dexer;
            this.isDebuggable = isDebuggable;
            this.isIncremental = isIncremental;
            this.java8LangSupportType = java8LangSupportType;
            this.additionalPaths = additionalPaths;
            this.errorFormatMode = errorFormatMode;
            String string = output2.toURI().toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"output.toURI().toString()");
            this.output = string;
            this.isDirectoryBased = this.input instanceof DirectoryInput;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/build/gradle/internal/transforms/DexArchiveBuilderTransform$DexConversionWorkAction;", "Ljava/lang/Runnable;", "dexConversionParameters", "Lcom/android/build/gradle/internal/transforms/DexArchiveBuilderTransform$DexConversionParameters;", "(Lcom/android/build/gradle/internal/transforms/DexArchiveBuilderTransform$DexConversionParameters;)V", "run", "", "gradle"})
    public static final class DexConversionWorkAction
    implements Runnable {
        private final DexConversionParameters dexConversionParameters;

        @Override
        public void run() {
            try {
                PrintStream printStream = System.out;
                Intrinsics.checkExpressionValueIsNotNull((Object)printStream, (String)"System.out");
                OutputStream outputStream = printStream;
                PrintStream printStream2 = System.err;
                Intrinsics.checkExpressionValueIsNotNull((Object)printStream2, (String)"System.err");
                OutputStream outputStream2 = printStream2;
                SyncOptions.ErrorFormatMode errorFormatMode = this.dexConversionParameters.getErrorFormatMode$gradle();
                org.gradle.api.logging.Logger logger = Logging.getLogger(DexArchiveBuilderTransform.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logging.getLogger(DexArc\u2026derTransform::class.java)");
                DexArchiveBuilderTransformKt.access$launchProcessing(this.dexConversionParameters, outputStream, outputStream2, new MessageReceiverImpl(errorFormatMode, (Logger)logger));
            }
            catch (Exception e) {
                throw (Throwable)new BuildException(e.getMessage(), (Throwable)e);
            }
        }

        @Inject
        public DexConversionWorkAction(@NotNull DexConversionParameters dexConversionParameters) {
            Intrinsics.checkParameterIsNotNull((Object)dexConversionParameters, (String)"dexConversionParameters");
            this.dexConversionParameters = dexConversionParameters;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0012\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/android/build/gradle/internal/transforms/DexArchiveBuilderTransform$D8DesugaringCacheInfo;", "", "orderedD8DesugaringDependencies", "", "Ljava/nio/file/Path;", "(Ljava/util/List;)V", "getOrderedD8DesugaringDependencies", "()Ljava/util/List;", "gradle"})
    private static class D8DesugaringCacheInfo {
        @NotNull
        private final List<Path> orderedD8DesugaringDependencies;

        @NotNull
        public final List<Path> getOrderedD8DesugaringDependencies() {
            return this.orderedD8DesugaringDependencies;
        }

        public D8DesugaringCacheInfo(@NotNull List<? extends Path> orderedD8DesugaringDependencies) {
            Intrinsics.checkParameterIsNotNull(orderedD8DesugaringDependencies, (String)"orderedD8DesugaringDependencies");
            this.orderedD8DesugaringDependencies = orderedD8DesugaringDependencies;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/android/build/gradle/internal/transforms/DexArchiveBuilderTransform$DesugaringNoInfoCache;", "Lcom/android/build/gradle/internal/transforms/DexArchiveBuilderTransform$D8DesugaringCacheInfo;", "()V", "gradle"})
    private static final class DesugaringNoInfoCache
    extends D8DesugaringCacheInfo {
        public static final DesugaringNoInfoCache INSTANCE;

        private DesugaringNoInfoCache() {
            super(CollectionsKt.emptyList());
        }

        static {
            DesugaringNoInfoCache desugaringNoInfoCache;
            INSTANCE = desugaringNoInfoCache = new DesugaringNoInfoCache();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/android/build/gradle/internal/transforms/DexArchiveBuilderTransform$DesugaringDontCache;", "Lcom/android/build/gradle/internal/transforms/DexArchiveBuilderTransform$D8DesugaringCacheInfo;", "()V", "gradle"})
    private static final class DesugaringDontCache
    extends D8DesugaringCacheInfo {
        public static final DesugaringDontCache INSTANCE;

        private DesugaringDontCache() {
            super(CollectionsKt.emptyList());
        }

        static {
            DesugaringDontCache desugaringDontCache;
            INSTANCE = desugaringDontCache = new DesugaringDontCache();
        }
    }
}

