/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.CoreSigningConfig;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.SigningConfigMetadata;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CacheableTask
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016R6\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u000e\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00048G@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR*\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0003\u001a\u0004\u0018\u00010\u000b8G@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0018"}, d2={"Lcom/android/build/gradle/internal/tasks/SigningConfigWriterTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "<set-?>", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "outputDirectory", "getOutputDirectory", "()Lorg/gradle/api/provider/Provider;", "setOutputDirectory$gradle", "(Lorg/gradle/api/provider/Provider;)V", "Lcom/android/build/gradle/internal/dsl/SigningConfig;", "signingConfig", "getSigningConfig", "()Lcom/android/build/gradle/internal/dsl/SigningConfig;", "setSigningConfig$gradle", "(Lcom/android/build/gradle/internal/dsl/SigningConfig;)V", "validatedSigningOutput", "Lorg/gradle/api/file/DirectoryProperty;", "getValidatedSigningOutput", "()Lorg/gradle/api/file/DirectoryProperty;", "doTaskAction", "", "CreationAction", "gradle"})
public abstract class SigningConfigWriterTask
extends NonIncrementalTask {
    @Nullable
    private Provider<Directory> outputDirectory;
    @Nullable
    private SigningConfig signingConfig;

    @OutputDirectory
    @Nullable
    public final Provider<Directory> getOutputDirectory() {
        return this.outputDirectory;
    }

    public final void setOutputDirectory$gradle(@Nullable Provider<Directory> provider) {
        this.outputDirectory = provider;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract DirectoryProperty getValidatedSigningOutput();

    @Nested
    @Optional
    @Nullable
    public final SigningConfig getSigningConfig() {
        return this.signingConfig;
    }

    public final void setSigningConfig$gradle(@Nullable SigningConfig signingConfig) {
        this.signingConfig = signingConfig;
    }

    @Override
    public void doTaskAction() {
        Provider<Directory> provider = this.outputDirectory;
        if (provider == null) {
            throw (Throwable)new RuntimeException("OutputDirectory not set.");
        }
        Provider<Directory> out = provider;
        Object object = out.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"out.get()");
        File file = ((Directory)object).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"out.get().asFile");
        SigningConfigMetadata.Companion.save(file, this.signingConfig);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0007H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lcom/android/build/gradle/internal/tasks/SigningConfigWriterTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/SigningConfigWriterTask;", "variantScope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "(Lcom/android/build/gradle/internal/scope/VariantScope;)V", "name", "", "getName", "()Ljava/lang/String;", "outputDirectory", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "preConfigure", "taskName", "gradle"})
    public static final class CreationAction
    extends VariantTaskCreationAction<SigningConfigWriterTask> {
        private Provider<Directory> outputDirectory;

        @Override
        @NotNull
        public String getName() {
            String string = this.getVariantScope().getTaskName("signingConfigWriter");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variantScope.getTaskName(\"signingConfigWriter\")");
            return string;
        }

        @Override
        @NotNull
        public Class<SigningConfigWriterTask> getType() {
            return SigningConfigWriterTask.class;
        }

        @Override
        public void preConfigure(@NotNull String taskName) {
            Intrinsics.checkParameterIsNotNull((Object)taskName, (String)"taskName");
            super.preConfigure(taskName);
            this.outputDirectory = BuildArtifactsHolder.createDirectory$default(this.getVariantScope().getArtifacts(), InternalArtifactType.SIGNING_CONFIG, taskName, null, 4, null);
        }

        @Override
        public void configure(@NotNull SigningConfigWriterTask task) {
            SigningConfig signingConfig;
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super.configure((Task)task);
            task.setOutputDirectory$gradle(this.outputDirectory);
            this.getVariantScope().getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.VALIDATE_SIGNING_CONFIG, (Property)task.getValidatedSigningOutput());
            SigningConfigWriterTask signingConfigWriterTask = task;
            GradleVariantConfiguration gradleVariantConfiguration = this.getVariantScope().getVariantConfiguration();
            Intrinsics.checkExpressionValueIsNotNull((Object)gradleVariantConfiguration, (String)"variantScope.variantConfiguration");
            CoreSigningConfig coreSigningConfig = gradleVariantConfiguration.getSigningConfig();
            if (coreSigningConfig != null) {
                CoreSigningConfig coreSigningConfig2 = coreSigningConfig;
                SigningConfigWriterTask signingConfigWriterTask2 = signingConfigWriterTask;
                boolean bl = false;
                boolean bl2 = false;
                CoreSigningConfig it = coreSigningConfig2;
                boolean bl3 = false;
                CoreSigningConfig coreSigningConfig3 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)coreSigningConfig3, (String)"it");
                SigningConfig signingConfig2 = new SigningConfig(coreSigningConfig3.getName()).initWith(it);
                signingConfigWriterTask = signingConfigWriterTask2;
                signingConfig = signingConfig2;
            } else {
                signingConfig = null;
            }
            signingConfigWriterTask.setSigningConfig$gradle(signingConfig);
        }

        public CreationAction(@NotNull VariantScope variantScope) {
            Intrinsics.checkParameterIsNotNull((Object)variantScope, (String)"variantScope");
            super(variantScope);
        }
    }
}

