/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.transforms.DexArchiveBuilderCacheHandler;
import com.android.build.gradle.internal.transforms.DexArchiveBuilderTransform;
import com.android.build.gradle.internal.transforms.DexArchiveBuilderTransformKt;
import com.android.build.gradle.internal.transforms.DexArchiveBuilderTransformKt$WhenMappings;
import com.android.build.gradle.internal.transforms.DexArchiveBuilderTransformKt$sam$i$java_util_function_Predicate$0;
import com.android.build.gradle.internal.workeractions.WorkerActionServiceRegistry;
import com.android.builder.dexing.ClassFileInput;
import com.android.builder.dexing.ClassFileInputs;
import com.android.builder.dexing.DexArchiveBuilder;
import com.android.builder.dexing.DexArchiveBuilderConfig;
import com.android.builder.dexing.DexArchiveBuilderException;
import com.android.builder.dexing.DexerTool;
import com.android.builder.dexing.r8.ClassFileProviderFactory;
import com.android.dx.command.dexer.DxContext;
import com.android.ide.common.blame.MessageReceiver;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0001H\u0002\u001an\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000f2\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u001a(\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u001eH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"DEFAULT_BUFFER_SIZE_IN_KB", "", "DEFAULT_NUM_BUCKETS", "logger", "Lcom/android/build/gradle/internal/LoggerWrapper;", "getBucketForFile", "content", "Lcom/android/build/api/transform/QualifiedContent;", "path", "", "numberOfBuckets", "getDexArchiveBuilder", "Lcom/android/builder/dexing/DexArchiveBuilder;", "minSdkVersion", "dexAdditionalParameters", "", "inBufferSize", "outBufferSize", "bootClasspath", "Lcom/android/build/gradle/internal/transforms/DexArchiveBuilderTransform$ClasspathServiceKey;", "classpath", "dexer", "Lcom/android/builder/dexing/DexerTool;", "isDebuggable", "", "d8DesugaringEnabled", "outStream", "Ljava/io/OutputStream;", "errStream", "messageReceiver", "Lcom/android/ide/common/blame/MessageReceiver;", "launchProcessing", "", "dexConversionParameters", "Lcom/android/build/gradle/internal/transforms/DexArchiveBuilderTransform$DexConversionParameters;", "receiver", "gradle"})
public final class DexArchiveBuilderTransformKt {
    private static final int DEFAULT_BUFFER_SIZE_IN_KB = 100;
    private static final int DEFAULT_NUM_BUCKETS = Math.max(Runtime.getRuntime().availableProcessors() / 2, 1);
    private static final LoggerWrapper logger;

    private static final int getBucketForFile(QualifiedContent content2, String path, int numberOfBuckets) {
        Path filePath;
        if (!(content2 instanceof DirectoryInput)) {
            return Math.abs(path.hashCode()) % numberOfBuckets;
        }
        Path path2 = filePath = Paths.get(path, new String[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"filePath");
        Preconditions.checkArgument((boolean)path2.isAbsolute(), (String)("Path should be absolute: " + path), (Object[])new Object[0]);
        Path path3 = filePath.getParent();
        if (path3 == null) {
            return 0;
        }
        Path packagePath = path3;
        return Math.abs(((Object)packagePath).toString().hashCode()) % numberOfBuckets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void launchProcessing(DexArchiveBuilderTransform.DexConversionParameters dexConversionParameters, OutputStream outStream, OutputStream errStream, MessageReceiver receiver) throws IOException, URISyntaxException {
        DexArchiveBuilder dexArchiveBuilder = DexArchiveBuilderTransformKt.getDexArchiveBuilder(dexConversionParameters.getMinSdkVersion$gradle(), dexConversionParameters.getDexAdditionalParameters$gradle(), dexConversionParameters.getInBufferSize$gradle(), dexConversionParameters.getOutBufferSize$gradle(), dexConversionParameters.getBootClasspath$gradle(), dexConversionParameters.getClasspath$gradle(), dexConversionParameters.getDexer$gradle(), dexConversionParameters.isDebuggable$gradle(), VariantScope.Java8LangSupport.D8 == dexConversionParameters.getJava8LangSupportType$gradle(), outStream, errStream, receiver);
        Path inputPath = dexConversionParameters.getInput$gradle().getFile().toPath();
        boolean hasIncrementalInfo = dexConversionParameters.isDirectoryBased() && dexConversionParameters.isIncremental$gradle();
        Function1<String, Boolean> $fun$toProcess$1 = new Function1<String, Boolean>(dexConversionParameters, hasIncrementalInfo, inputPath){
            final /* synthetic */ DexArchiveBuilderTransform.DexConversionParameters $dexConversionParameters;
            final /* synthetic */ boolean $hasIncrementalInfo;
            final /* synthetic */ Path $inputPath;

            public final boolean invoke(@NotNull String path) {
                Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
                if (!this.$dexConversionParameters.belongsToThisBucket(path)) {
                    return false;
                }
                if (!this.$hasIncrementalInfo) {
                    return true;
                }
                File resolved = this.$inputPath.resolve(path).toFile();
                if (this.$dexConversionParameters.getAdditionalPaths$gradle().contains(resolved)) {
                    return true;
                }
                QualifiedContent qualifiedContent = this.$dexConversionParameters.getInput$gradle();
                if (qualifiedContent == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.android.build.api.transform.DirectoryInput");
                }
                Map changedFiles = ((DirectoryInput)qualifiedContent).getChangedFiles();
                Status status = (Status)changedFiles.get(resolved);
                return status == Status.ADDED || status == Status.CHANGED;
            }
            {
                this.$dexConversionParameters = dexConversionParameters;
                this.$hasIncrementalInfo = bl;
                this.$inputPath = path;
                super(1);
            }
        };
        Function1 bucketFilter2 = (Function1)new Function1<String, Boolean>($fun$toProcess$1){
            final /* synthetic */ launchProcessing.1 $toProcess$1;

            public final boolean invoke(@NotNull String name) {
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                return this.$toProcess$1.invoke(name);
            }
            {
                this.$toProcess$1 = var1_1;
                super(1);
            }
        };
        logger.verbose("Dexing '" + inputPath + "' to '" + dexConversionParameters.getOutput$gradle() + "'", new Object[0]);
        try {
            Closeable closeable = (Closeable)ClassFileInputs.fromPath((Path)inputPath);
            boolean bl = false;
            Throwable throwable = null;
            try {
                ClassFileInput input = (ClassFileInput)closeable;
                boolean bl2 = false;
                Object object = bucketFilter2;
                object = input.entries((Predicate)new DexArchiveBuilderTransformKt$sam$i$java_util_function_Predicate$0((Function1)object));
                boolean bl3 = false;
                Throwable throwable2 = null;
                try {
                    Stream entries = (Stream)object;
                    boolean bl4 = false;
                    dexArchiveBuilder.convert(entries, Paths.get(new URI(dexConversionParameters.getOutput$gradle())), dexConversionParameters.isDirectoryBased());
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (DexArchiveBuilderException ex) {
            throw (Throwable)new DexArchiveBuilderException("Failed to process " + inputPath, (Throwable)ex);
        }
    }

    private static final DexArchiveBuilder getDexArchiveBuilder(int minSdkVersion, List<String> dexAdditionalParameters, int inBufferSize, int outBufferSize, DexArchiveBuilderTransform.ClasspathServiceKey bootClasspath, DexArchiveBuilderTransform.ClasspathServiceKey classpath, DexerTool dexer, boolean isDebuggable, boolean d8DesugaringEnabled, OutputStream outStream, OutputStream errStream, MessageReceiver messageReceiver) {
        DexArchiveBuilder dexArchiveBuilder = null;
        switch (DexArchiveBuilderTransformKt$WhenMappings.$EnumSwitchMapping$0[dexer.ordinal()]) {
            case 1: {
                boolean optimizedDex = !dexAdditionalParameters.contains("--no-optimize");
                DxContext dxContext = new DxContext(outStream, errStream);
                DexArchiveBuilderConfig config2 = new DexArchiveBuilderConfig(dxContext, optimizedDex, inBufferSize, minSdkVersion, DexerTool.DX, outBufferSize, DexArchiveBuilderCacheHandler.isJumboModeEnabledForDx());
                DexArchiveBuilder dexArchiveBuilder2 = DexArchiveBuilder.createDxDexBuilder((DexArchiveBuilderConfig)config2);
                Intrinsics.checkExpressionValueIsNotNull((Object)dexArchiveBuilder2, (String)"DexArchiveBuilder.createDxDexBuilder(config)");
                dexArchiveBuilder = dexArchiveBuilder2;
                break;
            }
            case 2: {
                DexArchiveBuilder dexArchiveBuilder3 = DexArchiveBuilder.createD8DexBuilder((int)minSdkVersion, (boolean)isDebuggable, (ClassFileProviderFactory)((ClassFileProviderFactory)WorkerActionServiceRegistry.INSTANCE.getService(bootClasspath).getService()), (ClassFileProviderFactory)((ClassFileProviderFactory)WorkerActionServiceRegistry.INSTANCE.getService(classpath).getService()), (boolean)d8DesugaringEnabled, (MessageReceiver)messageReceiver);
                Intrinsics.checkExpressionValueIsNotNull((Object)dexArchiveBuilder3, (String)"DexArchiveBuilder.create\u2026messageReceiver\n        )");
                dexArchiveBuilder = dexArchiveBuilder3;
                break;
            }
            default: {
                throw (Throwable)((Object)new AssertionError((Object)("Unknown dexer type: " + dexer.name())));
            }
        }
        return dexArchiveBuilder;
    }

    static {
        LoggerWrapper loggerWrapper = LoggerWrapper.getLogger(DexArchiveBuilderTransform.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)loggerWrapper, (String)"LoggerWrapper.getLogger(\u2026derTransform::class.java)");
        logger = loggerWrapper;
    }

    public static final /* synthetic */ int access$getBucketForFile(QualifiedContent content2, String path, int numberOfBuckets) {
        return DexArchiveBuilderTransformKt.getBucketForFile(content2, path, numberOfBuckets);
    }

    public static final /* synthetic */ void access$launchProcessing(DexArchiveBuilderTransform.DexConversionParameters dexConversionParameters, OutputStream outStream, OutputStream errStream, MessageReceiver receiver) {
        DexArchiveBuilderTransformKt.launchProcessing(dexConversionParameters, outStream, errStream, receiver);
    }

    public static final /* synthetic */ LoggerWrapper access$getLogger$p() {
        return logger;
    }

    public static final /* synthetic */ int access$getDEFAULT_NUM_BUCKETS$p() {
        return DEFAULT_NUM_BUCKETS;
    }
}

