/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.attribution;

import com.android.build.gradle.internal.cxx.attribution.AttributionKey;
import com.android.build.gradle.internal.cxx.attribution.AttributionTask;
import com.android.build.gradle.internal.cxx.attribution.ChromeTraceJson;
import com.android.build.gradle.internal.cxx.attribution.OperationType;
import com.android.build.gradle.internal.cxx.attribution.TraceEventJson;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.google.common.base.Throwables;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.LongSerializationPolicy;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007\u001a\"\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\"\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002\u001a\"\u0010\u0010\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u000bH\u0002\u001a*\u0010\u0015\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\rH\u0002\u001a\"\u0010\u0018\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"MICROSECOND_IN_MILLISECOND", "", "gson", "Lcom/google/gson/Gson;", "generateChromeTrace", "", "file", "Ljava/io/File;", "outputFile", "readZipContent", "", "Lcom/android/build/gradle/internal/cxx/attribution/AttributionKey;", "", "Lcom/android/build/gradle/internal/cxx/attribution/AttributionTask;", "squashTasks", "tasks", "addProcessNameMetaEvent", "", "Lcom/android/build/gradle/internal/cxx/attribution/TraceEventJson;", "pid", "key", "addTaskEvent", "tid", "task", "addThreadNameMetaEvent", "gradle"})
public final class GenerateChromeTraceKt {
    private static final int MICROSECOND_IN_MILLISECOND = 1000;
    private static final Gson gson;

    /*
     * WARNING - void declaration
     */
    public static final void generateChromeTrace(@NotNull File file, @NotNull File outputFile) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
        try {
            Map<AttributionKey, List<AttributionTask>> allAttributions = GenerateChromeTraceKt.readZipContent(file);
            boolean bl = false;
            List allEvents = new ArrayList();
            Iterable $this$sortedBy$iv = allAttributions.entrySet();
            boolean $i$f$sortedBy = false;
            Iterable iterable = $this$sortedBy$iv;
            boolean bl2 = false;
            Comparator comparator = new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    Map.Entry $dstr$_u24__u24$tasks = (Map.Entry)a;
                    boolean bl2 = false;
                    Map.Entry entry = $dstr$_u24__u24$tasks;
                    boolean bl3 = false;
                    List tasks = (List)entry.getValue();
                    AttributionTask attributionTask = (AttributionTask)CollectionsKt.firstOrNull((List)tasks);
                    $dstr$_u24__u24$tasks = (Map.Entry)b;
                    Comparable comparable = Long.valueOf(attributionTask != null ? attributionTask.getStartTimeMs() : 0L);
                    bl2 = false;
                    entry = $dstr$_u24__u24$tasks;
                    bl3 = false;
                    tasks = (List)entry.getValue();
                    AttributionTask attributionTask2 = (AttributionTask)CollectionsKt.firstOrNull((List)tasks);
                    Long l = attributionTask2 != null ? attributionTask2.getStartTimeMs() : 0L;
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)l);
                }
            };
            Iterable $this$forEachIndexed$iv = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void $dstr$key$tasksForAnAbi;
                int n = index$iv++;
                boolean bl3 = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n2 = n;
                Map.Entry entry = (Map.Entry)item$iv;
                int pid = n2;
                boolean bl4 = false;
                void var15_19 = $dstr$key$tasksForAnAbi;
                boolean bl5 = false;
                AttributionKey key = (AttributionKey)var15_19.getKey();
                var15_19 = $dstr$key$tasksForAnAbi;
                bl5 = false;
                List tasksForAnAbi = (List)var15_19.getValue();
                GenerateChromeTraceKt.addProcessNameMetaEvent(allEvents, pid, key);
                Iterable $this$forEachIndexed$iv2 = GenerateChromeTraceKt.squashTasks(tasksForAnAbi);
                boolean $i$f$forEachIndexed2 = false;
                int index$iv2 = 0;
                for (Object item$iv2 : $this$forEachIndexed$iv2) {
                    void tasks;
                    int n3 = index$iv2++;
                    boolean bl6 = false;
                    if (n3 < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    int n4 = n3;
                    List list = (List)item$iv2;
                    int tid = n4;
                    boolean bl7 = false;
                    GenerateChromeTraceKt.addThreadNameMetaEvent(allEvents, pid, tid);
                    Iterable $this$forEach$iv = (Iterable)tasks;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        AttributionTask task = (AttributionTask)element$iv;
                        boolean bl8 = false;
                        GenerateChromeTraceKt.addTaskEvent(allEvents, pid, tid, task);
                    }
                }
            }
            new ChromeTraceJson(allEvents).storeToFile(outputFile);
        }
        catch (Throwable e) {
            LoggingEnvironmentKt.warnln("Cannot output native build attribution in Chrome trace format. " + "Exception: " + Throwables.getStackTraceAsString((Throwable)e), new Object[0]);
        }
    }

    public static /* synthetic */ void generateChromeTrace$default(File file, File file2, int n, Object object) {
        if ((n & 2) != 0) {
            file2 = new File(file.getParentFile(), FilesKt.getNameWithoutExtension((File)file) + ".json.gz");
        }
        GenerateChromeTraceKt.generateChromeTrace(file, file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Map<AttributionKey, List<AttributionTask>> readZipContent(File file) {
        boolean bl = false;
        Map allAttributions = new LinkedHashMap();
        ZipFile zipFile = new ZipFile(file);
        Closeable closeable = new ZipInputStream(new FileInputStream(file));
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            ZipInputStream it = (ZipInputStream)closeable;
            boolean bl3 = false;
            while (it.getNextEntry() != null) {
                List list;
                void variant2;
                void module2;
                ZipEntry entry;
                if (entry.isDirectory()) continue;
                String string = entry.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"entry.name");
                Object object = new char[]{'/'};
                boolean bl4 = false;
                int n = 3;
                List list2 = StringsKt.split$default((CharSequence)string, (char[])object, (boolean)bl4, (int)n, (int)2, null);
                object = list2;
                bl4 = false;
                String string2 = (String)object.get(0);
                object = list2;
                bl4 = false;
                String string3 = (String)object.get(1);
                object = list2;
                bl4 = false;
                String abi = (String)object.get(2);
                AttributionKey attributionKey = new AttributionKey((String)module2, (String)variant2, abi);
                Map map = allAttributions;
                boolean bl5 = false;
                list2 = list = (List)new ArrayList();
                boolean bl6 = false;
                bl4 = false;
                List $this$apply = list2;
                boolean bl7 = false;
                Closeable closeable2 = new InputStreamReader(zipFile.getInputStream(entry), StandardCharsets.UTF_8);
                boolean bl8 = false;
                Throwable throwable2 = null;
                try {
                    InputStreamReader it2 = (InputStreamReader)closeable2;
                    boolean bl9 = false;
                    long startingTimestamp = 0L;
                    for (String line : TextStreamsKt.readLines((Reader)it2)) {
                        void end;
                        void start;
                        OperationType operationType;
                        int n2;
                        String $this$takeWhile$iv;
                        if (StringsKt.startsWith$default((CharSequence)line, (char)'#', (boolean)false, (int)2, null)) {
                            String string4;
                            boolean $i$f$takeWhile;
                            block22: {
                                String string5;
                                int index$iv;
                                int n3;
                                block21: {
                                    String $this$dropWhile$iv = line;
                                    boolean $i$f$dropWhile = false;
                                    int n4 = 0;
                                    n3 = ((CharSequence)$this$dropWhile$iv).length();
                                    while (n4 < n3) {
                                        char c2 = $this$dropWhile$iv.charAt(index$iv);
                                        boolean bl10 = false;
                                        if (!(!Character.isDigit(c2))) {
                                            String c2 = $this$dropWhile$iv;
                                            bl10 = false;
                                            String string6 = c2.substring(index$iv);
                                            string5 = string6;
                                            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
                                            break block21;
                                        }
                                        ++index$iv;
                                    }
                                    string5 = "";
                                }
                                $this$takeWhile$iv = string5;
                                $i$f$takeWhile = false;
                                n3 = $this$takeWhile$iv.length();
                                for (index$iv = 0; index$iv < n3; ++index$iv) {
                                    char c = $this$takeWhile$iv.charAt(index$iv);
                                    boolean bl11 = false;
                                    if (Character.isDigit(c)) continue;
                                    String string7 = $this$takeWhile$iv;
                                    n2 = 0;
                                    boolean bl12 = false;
                                    String string8 = string7.substring(n2, index$iv);
                                    string4 = string8;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                                    break block22;
                                }
                                string4 = $this$takeWhile$iv;
                            }
                            $this$takeWhile$iv = string4;
                            $i$f$takeWhile = false;
                            startingTimestamp = Long.parseLong($this$takeWhile$iv);
                            continue;
                        }
                        List list3 = StringsKt.split$default((CharSequence)line, (char[])new char[]{'\t'}, (boolean)false, (int)0, (int)6, null);
                        Object object2 = list3;
                        n2 = 0;
                        $this$takeWhile$iv = (String)object2.get(0);
                        object2 = list3;
                        n2 = 0;
                        String $i$f$takeWhile = (String)object2.get(1);
                        object2 = list3;
                        n2 = 0;
                        String output2 = (String)object2.get(3);
                        File outputFile = new File(output2);
                        String string9 = outputFile.getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"outputFile.name");
                        object2 = FilesKt.getExtension((File)outputFile);
                        switch (((String)object2).hashCode()) {
                            case 111: {
                                if (((String)object2).equals("o")) {
                                    operationType = OperationType.COMPILE;
                                    break;
                                }
                            }
                            default: {
                                operationType = OperationType.LINK;
                            }
                        }
                        object2 = start;
                        OperationType operationType2 = operationType;
                        String string10 = string9;
                        List list4 = $this$apply;
                        n2 = 0;
                        long l = Long.parseLong((String)object2);
                        object2 = end;
                        n2 = 0;
                        long l2 = Long.parseLong((String)object2);
                        String string11 = output2;
                        long l3 = l2 + startingTimestamp;
                        long l4 = l += startingTimestamp;
                        OperationType operationType3 = operationType2;
                        String string12 = string10;
                        list4.add(new AttributionTask(string12, operationType3, l4, l3, string11));
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                list = list2;
                map.put(attributionKey, list);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return allAttributions;
    }

    private static final void addProcessNameMetaEvent(@NotNull List<TraceEventJson> $this$addProcessNameMetaEvent, int pid, AttributionKey key) {
        $this$addProcessNameMetaEvent.add(new TraceEventJson(pid, 0, 0L, "M", null, "process_name", null, MapsKt.mapOf((Pair)TuplesKt.to((Object)"name", (Object)key.toString())), 80, null));
    }

    private static final void addThreadNameMetaEvent(@NotNull List<TraceEventJson> $this$addThreadNameMetaEvent, int pid, int tid) {
        $this$addThreadNameMetaEvent.add(new TraceEventJson(pid, tid, 0L, "M", null, "thread_name", null, MapsKt.mapOf((Pair)TuplesKt.to((Object)"name", (Object)("ninja->clang " + tid))), 80, null));
    }

    private static final void addTaskEvent(@NotNull List<TraceEventJson> $this$addTaskEvent, int pid, int tid, AttributionTask task) {
        $this$addTaskEvent.add(new TraceEventJson(pid, tid, task.getStartTimeMs() * (long)1000, "B", task.getType().toString(), task.getName(), task.getType().getColorName(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"output", (Object)task.getOutput()))));
        $this$addTaskEvent.add(new TraceEventJson(pid, tid, task.getEndTimeMs() * (long)1000, "E", null, null, null, null, 240, null));
    }

    /*
     * WARNING - void declaration
     */
    private static final List<List<AttributionTask>> squashTasks(List<AttributionTask> tasks) {
        boolean bl = false;
        List result = new ArrayList();
        Iterable $this$sortedBy$iv = tasks;
        boolean $i$f$sortedBy = false;
        Iterable iterable = $this$sortedBy$iv;
        boolean bl2 = false;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                AttributionTask it = (AttributionTask)a;
                boolean bl2 = false;
                Comparable comparable = Long.valueOf(it.getStartTimeMs());
                it = (AttributionTask)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Long l = it.getStartTimeMs();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
            }
        };
        for (AttributionTask task : CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator)) {
            Object v1;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = result;
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                List it = (List)element$iv$iv;
                boolean bl3 = false;
                AttributionTask attributionTask = (AttributionTask)CollectionsKt.lastOrNull((List)it);
                if (!((attributionTask != null ? attributionTask.getEndTimeMs() : 0L) <= task.getStartTimeMs())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$maxBy$iv = (List)destination$iv$iv;
            boolean $i$f$maxBy = false;
            Iterator iterator$iv = $this$maxBy$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v1 = null;
            } else {
                long maxValue$iv;
                Object maxElem$iv = iterator$iv.next();
                List it = (List)maxElem$iv;
                boolean bl4 = false;
                AttributionTask attributionTask = (AttributionTask)CollectionsKt.lastOrNull((List)it);
                long l = maxValue$iv = attributionTask != null ? attributionTask.getEndTimeMs() : 0L;
                while (iterator$iv.hasNext()) {
                    Object e$iv = iterator$iv.next();
                    List it2 = (List)e$iv;
                    $i$a$-maxBy-GenerateChromeTraceKt$squashTasks$chosenTrack$2 = false;
                    AttributionTask attributionTask2 = (AttributionTask)CollectionsKt.lastOrNull((List)it2);
                    long v$iv = attributionTask2 != null ? attributionTask2.getEndTimeMs() : 0L;
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                }
                v1 = maxElem$iv;
            }
            List chosenTrack = v1;
            if (chosenTrack == null) {
                result.add(CollectionsKt.mutableListOf((Object[])new AttributionTask[]{task}));
                continue;
            }
            chosenTrack.add(task);
        }
        return result;
    }

    static {
        Gson gson = new GsonBuilder().setLongSerializationPolicy(LongSerializationPolicy.STRING).create();
        Intrinsics.checkExpressionValueIsNotNull((Object)gson, (String)"GsonBuilder().setLongSer\u2026onPolicy.STRING).create()");
        GenerateChromeTraceKt.gson = gson;
    }

    public static final /* synthetic */ Gson access$getGson$p() {
        return gson;
    }
}

