/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.pipeline;

import com.android.build.api.transform.Context;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.SecondaryFile;
import com.android.build.api.transform.SecondaryInput;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.gradle.internal.pipeline.IncrementalTransformInput;
import com.android.build.gradle.internal.pipeline.IntermediateFolderUtils;
import com.android.build.gradle.internal.pipeline.IntermediateStream;
import com.android.build.gradle.internal.pipeline.StreamBasedTask;
import com.android.build.gradle.internal.pipeline.TransformInvocationBuilder;
import com.android.build.gradle.internal.pipeline.TransformStream;
import com.android.build.gradle.internal.profile.AnalyticsUtil;
import com.android.build.gradle.internal.tasks.factory.TaskCreationAction;
import com.android.builder.profile.Recorder;
import com.android.ide.common.util.ReferenceHolder;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import com.google.wireless.android.sdk.stats.GradleTransformExecution;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectories;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.workers.WorkerExecutor;

@CacheableTask
public abstract class TransformTask
extends StreamBasedTask
implements Context {
    private Transform transform;
    private Recorder recorder;
    Collection<SecondaryFile> secondaryFiles = null;
    List<FileCollection> secondaryInputFiles = null;
    private final WorkerExecutor workerExecutor;

    public Transform getTransform() {
        return this.transform;
    }

    @Inject
    public TransformTask(WorkerExecutor workerExecutor) {
        this.workerExecutor = workerExecutor;
    }

    @Input
    public Set<? super QualifiedContent.Scope> getScopes() {
        return this.transform.getScopes();
    }

    @Input
    public Set<? super QualifiedContent.Scope> getReferencedScopes() {
        return this.transform.getReferencedScopes();
    }

    @Input
    public Set<QualifiedContent.ContentType> getInputTypes() {
        return this.transform.getInputTypes();
    }

    @InputFiles
    @Optional
    public Collection<File> getOldSecondaryInputs() {
        return this.transform.getSecondaryFileInputs();
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public List<FileCollection> getSecondaryFileInputs() {
        if (this.secondaryInputFiles == null) {
            this.secondaryInputFiles = this.transform.getSecondaryFiles().stream().map(secondaryFile -> secondaryFile.getFileCollection(this.getProject())).collect(Collectors.toList());
        }
        return this.secondaryInputFiles;
    }

    @OutputFiles
    public Map<String, File> getOtherFileOutputs() {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        int index = 0;
        for (File outputFile : this.transform.getSecondaryFileOutputs()) {
            builder.put((Object)("otherFileOutput" + Integer.toString(++index)), (Object)outputFile);
        }
        return builder.build();
    }

    @OutputDirectory
    @Optional
    public abstract DirectoryProperty getOutputDirectory();

    @OutputFile
    @Optional
    public abstract RegularFileProperty getOutputFile();

    @OutputDirectories
    public Map<String, File> getOtherFolderOutputs() {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        int index = 0;
        for (File outputFolder : this.transform.getSecondaryDirectoryOutputs()) {
            builder.put((Object)("otherFolderOutput" + Integer.toString(++index)), (Object)outputFolder);
        }
        return builder.build();
    }

    @Input
    public Map<String, Object> getOtherInputs() {
        return this.transform.getParameterInputs();
    }

    @TaskAction
    void transform(final IncrementalTaskInputs incrementalTaskInputs) throws IOException, TransformException, InterruptedException {
        final ReferenceHolder consumedInputs = ReferenceHolder.empty();
        final ReferenceHolder referencedInputs = ReferenceHolder.empty();
        final ReferenceHolder isIncremental = ReferenceHolder.empty();
        final ReferenceHolder changedSecondaryInputs = ReferenceHolder.empty();
        isIncremental.setValue((Object)(this.transform.isIncremental() && incrementalTaskInputs.isIncremental() ? 1 : 0));
        GradleTransformExecution preExecutionInfo = GradleTransformExecution.newBuilder().setType(AnalyticsUtil.getTransformType(this.transform.getClass()).getNumber()).setIsIncremental(((Boolean)isIncremental.getValue()).booleanValue()).build();
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.TASK_TRANSFORM_PREPARATION, preExecutionInfo, this.getProject().getPath(), this.getVariantName(), (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() throws Exception {
                List incReferencedInputs;
                List incInputs;
                HashMap changedMap = Maps.newHashMap();
                HashSet removedFiles = Sets.newHashSet();
                if (((Boolean)isIncremental.getValue()).booleanValue()) {
                    TransformTask.gatherChangedFiles(TransformTask.this.getLogger(), incrementalTaskInputs, changedMap, removedFiles);
                    isIncremental.setValue((Object)TransformTask.this.checkSecondaryFiles(changedMap, removedFiles));
                }
                if (((Boolean)isIncremental.getValue()).booleanValue() && ((Boolean)isIncremental.setValue((Object)TransformTask.this.updateIncrementalInputsWithChangedFiles(incInputs = TransformTask.createIncrementalInputs(TransformTask.this.consumedInputStreams), incReferencedInputs = TransformTask.createIncrementalInputs(TransformTask.this.referencedInputStreams), changedMap, removedFiles))).booleanValue()) {
                    consumedInputs.setValue((Object)TransformTask.convertToImmutable(incInputs));
                    referencedInputs.setValue((Object)TransformTask.convertToImmutable(incReferencedInputs));
                }
                if (!((Boolean)isIncremental.getValue()).booleanValue()) {
                    consumedInputs.setValue((Object)TransformTask.computeNonIncTransformInput(TransformTask.this.consumedInputStreams));
                    referencedInputs.setValue((Object)TransformTask.computeNonIncTransformInput(TransformTask.this.referencedInputStreams));
                    changedSecondaryInputs.setValue((Object)ImmutableList.of());
                } else {
                    changedSecondaryInputs.setValue((Object)TransformTask.this.gatherSecondaryInputChanges(changedMap, removedFiles));
                }
                return null;
            }
        });
        GradleTransformExecution executionInfo = preExecutionInfo.toBuilder().setIsIncremental(((Boolean)isIncremental.getValue()).booleanValue()).build();
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.TASK_TRANSFORM, executionInfo, this.getProject().getPath(), this.getVariantName(), (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() throws Exception {
                TransformTask.this.transform.transform(new TransformInvocationBuilder(TransformTask.this).addInputs((Collection)consumedInputs.getValue()).addReferencedInputs((Collection)referencedInputs.getValue()).addSecondaryInputs((Collection)changedSecondaryInputs.getValue()).addOutputProvider(TransformTask.this.outputStream != null ? TransformTask.this.outputStream.asOutput() : null).setIncrementalMode((Boolean)isIncremental.getValue()).build());
                if (TransformTask.this.outputStream != null) {
                    TransformTask.this.outputStream.save();
                }
                return null;
            }
        });
    }

    private Collection<SecondaryInput> gatherSecondaryInputChanges(Map<File, Status> changedMap, Set<File> removedFiles) {
        Project project2 = this.getProject();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (final SecondaryFile secondaryFile : this.getAllSecondaryInputs()) {
            for (File file : secondaryFile.getFileCollection(project2).getFiles()) {
                final Status status = changedMap.containsKey(file) ? changedMap.get(file) : (removedFiles.contains(file) ? Status.REMOVED : Status.NOTCHANGED);
                builder.add((Object)new SecondaryInput(){

                    public SecondaryFile getSecondaryInput() {
                        return secondaryFile;
                    }

                    public Status getStatus() {
                        return status;
                    }
                });
            }
        }
        return builder.build();
    }

    public String getProjectName() {
        return this.getProject().getName();
    }

    private static List<TransformInput> computeNonIncTransformInput(Collection<TransformStream> streams) {
        return streams.stream().map(TransformStream::asNonIncrementalInput).collect(Collectors.toList());
    }

    private static List<IncrementalTransformInput> createIncrementalInputs(Collection<TransformStream> streams) {
        return streams.stream().map(TransformStream::asIncrementalInput).collect(Collectors.toList());
    }

    @Internal
    private synchronized Collection<SecondaryFile> getAllSecondaryInputs() {
        if (this.secondaryFiles == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll((Iterable)this.transform.getSecondaryFiles());
            builder.addAll(this.transform.getSecondaryFileInputs().stream().map(SecondaryFile::nonIncremental).iterator());
            this.secondaryFiles = builder.build();
        }
        return this.secondaryFiles;
    }

    private static void gatherChangedFiles(Logger logger, IncrementalTaskInputs incrementalTaskInputs, Map<File, Status> changedFileMap, Set<File> removedFiles) {
        logger.info("Transform inputs calculations based on following changes");
        incrementalTaskInputs.outOfDate(inputFileDetails -> {
            logger.info(inputFileDetails.getFile().getAbsolutePath() + ":" + IntermediateFolderUtils.inputFileDetailsToStatus(inputFileDetails));
            if (inputFileDetails.isAdded()) {
                changedFileMap.put(inputFileDetails.getFile(), Status.ADDED);
            } else if (inputFileDetails.isModified()) {
                changedFileMap.put(inputFileDetails.getFile(), Status.CHANGED);
            }
        });
        incrementalTaskInputs.removed(inputFileDetails -> {
            logger.info(inputFileDetails.getFile().getAbsolutePath() + ":REMOVED");
            removedFiles.add(inputFileDetails.getFile());
        });
    }

    private boolean checkSecondaryFiles(Map<File, Status> changedMap, Set<File> removedFiles) {
        Project project2 = this.getProject();
        for (SecondaryFile secondaryFile : this.getAllSecondaryInputs()) {
            Set files = secondaryFile.getFileCollection(project2).getFiles();
            if (Sets.intersection((Set)files, changedMap.keySet()).isEmpty() && Sets.intersection((Set)files, removedFiles).isEmpty() || secondaryFile.supportsIncrementalBuild()) continue;
            return false;
        }
        return true;
    }

    private boolean isSecondaryFile(File file) {
        Project project2 = this.getProject();
        for (SecondaryFile secondaryFile : this.getAllSecondaryInputs()) {
            if (!secondaryFile.getFileCollection(project2).contains(file)) continue;
            return true;
        }
        return false;
    }

    private boolean updateIncrementalInputsWithChangedFiles(List<IncrementalTransformInput> consumedInputs, List<IncrementalTransformInput> referencedInputs, Map<File, Status> changedFilesMap, Set<File> removedFiles) {
        ArrayList iterators = Lists.newArrayListWithCapacity((int)2);
        Splitter splitter = Splitter.on((char)File.separatorChar);
        Sets.SetView scopes = Sets.union((Set)this.transform.getScopes(), (Set)this.transform.getReferencedScopes());
        Set inputTypes = this.transform.getInputTypes();
        for (File file : removedFiles) {
            ArrayList removedFileSegments = Lists.newArrayList((Iterable)splitter.split((CharSequence)file.getAbsolutePath()));
            Iterator<IncrementalTransformInput> iterator = TransformTask.getConcatIterator(consumedInputs, referencedInputs, iterators);
            boolean found = false;
            while (iterator.hasNext()) {
                IncrementalTransformInput next = iterator.next();
                if (!next.checkRemovedJarFile((Set<? super QualifiedContent.Scope>)scopes, inputTypes, file, removedFileSegments) && !next.checkRemovedFolderFile((Set<? super QualifiedContent.Scope>)scopes, inputTypes, file, removedFileSegments)) continue;
                found = true;
                break;
            }
            if (found || this.isSecondaryFile(file)) continue;
            return false;
        }
        for (Map.Entry entry : changedFilesMap.entrySet()) {
            File changedFile = (File)entry.getKey();
            Status changedStatus = (Status)entry.getValue();
            Iterator<IncrementalTransformInput> iterator = TransformTask.getConcatIterator(consumedInputs, referencedInputs, iterators);
            boolean found = false;
            while (iterator.hasNext()) {
                if (!iterator.next().checkForJar(changedFile, changedStatus)) continue;
                found = true;
                break;
            }
            if (found) continue;
            iterator = TransformTask.getConcatIterator(consumedInputs, referencedInputs, iterators);
            ArrayList changedSegments = Lists.newArrayList((Iterable)splitter.split((CharSequence)changedFile.getAbsolutePath()));
            while (iterator.hasNext() && !iterator.next().checkForFolder(changedFile, changedSegments, changedStatus)) {
            }
        }
        return true;
    }

    private static Iterator<IncrementalTransformInput> getConcatIterator(List<IncrementalTransformInput> consumedInputs, List<IncrementalTransformInput> referencedInputs, List<Iterator<IncrementalTransformInput>> iterators) {
        iterators.clear();
        iterators.add(consumedInputs.iterator());
        iterators.add(referencedInputs.iterator());
        return Iterators.concat(iterators.iterator());
    }

    private static List<TransformInput> convertToImmutable(List<IncrementalTransformInput> inputs) {
        return inputs.stream().map(IncrementalTransformInput::asImmutable).collect(Collectors.toList());
    }

    public WorkerExecutor getWorkerExecutor() {
        return this.workerExecutor;
    }

    public static class CreationAction<T extends Transform>
    extends TaskCreationAction<TransformTask> {
        private final String variantName;
        private final String taskName;
        private final T transform;
        private Collection<TransformStream> consumedInputStreams;
        private Collection<TransformStream> referencedInputStreams;
        private IntermediateStream outputStream;
        private final Recorder recorder;

        CreationAction(String variantName, String taskName, T transform2, Collection<TransformStream> consumedInputStreams, Collection<TransformStream> referencedInputStreams, IntermediateStream outputStream, Recorder recorder) {
            this.variantName = variantName;
            this.taskName = taskName;
            this.transform = transform2;
            this.consumedInputStreams = consumedInputStreams;
            this.referencedInputStreams = referencedInputStreams;
            this.outputStream = outputStream;
            this.recorder = recorder;
        }

        @Override
        public String getName() {
            return this.taskName;
        }

        @Override
        public Class<TransformTask> getType() {
            return TransformTask.class;
        }

        @Override
        public void configure(TransformTask task) {
            task.transform = this.transform;
            this.transform.setOutputDirectory((Property)task.getOutputDirectory());
            this.transform.setOutputFile((Property)task.getOutputFile());
            task.consumedInputStreams = this.consumedInputStreams;
            task.referencedInputStreams = this.referencedInputStreams;
            task.outputStream = this.outputStream;
            task.setVariantName(this.variantName);
            task.recorder = this.recorder;
            task.getOutputs().cacheIf(t -> this.transform.isCacheable());
            task.registerConsumedAndReferencedStreamInputs();
        }
    }
}

