/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.transform.QualifiedContent;
import com.android.build.gradle.internal.coverage.JacocoConfigurations;
import com.android.build.gradle.internal.pipeline.OriginalStream;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.DesugarTask$CreationAction$handleProvider$1;
import com.android.build.gradle.internal.tasks.DesugarTask$CreationAction$handleProvider$2;
import com.android.build.gradle.internal.tasks.DesugarTask$CreationAction$handleProvider$3;
import com.android.build.gradle.internal.tasks.DesugarTask$CreationAction$handleProvider$4;
import com.android.build.gradle.internal.tasks.DesugarTaskDelegate;
import com.android.build.gradle.internal.tasks.JacocoTask;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.Workers;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.ide.common.repository.GradleVersion;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.sdklib.AndroidVersion;
import java.io.File;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.logging.Logger;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.LocalState;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001:\u0001)B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010'\u001a\u00020(H\u0014R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0019\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00158gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017R\u0019\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000e8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0011R\u0014\u0010\u001d\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\nR\u0014\u0010\u001f\u001a\u00020\u00158gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0017R\u0014\u0010!\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\nR\u0014\u0010#\u001a\u00020\u00158gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0017R\u0014\u0010%\u001a\u00020\u00158gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0017\u00a8\u0006*"}, d2={"Lcom/android/build/gradle/internal/tasks/DesugarTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "(Lorg/gradle/api/model/ObjectFactory;Lorg/gradle/workers/WorkerExecutor;)V", "bootClasspath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getBootClasspath", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "desugaringClasspath", "getDesugaringClasspath", "enableBugFixForJacoco", "Lorg/gradle/api/provider/Property;", "", "getEnableBugFixForJacoco", "()Lorg/gradle/api/provider/Property;", "executorFacade", "Lcom/android/ide/common/workers/WorkerExecutorFacade;", "externaLibsClasses", "Lorg/gradle/api/file/DirectoryProperty;", "getExternaLibsClasses", "()Lorg/gradle/api/file/DirectoryProperty;", "externalLibsOutput", "getExternalLibsOutput", "minSdk", "", "getMinSdk", "projectClasses", "getProjectClasses", "projectOutput", "getProjectOutput", "subProjectClasses", "getSubProjectClasses", "subProjectOutput", "getSubProjectOutput", "tmpDir", "getTmpDir", "doTaskAction", "", "CreationAction", "gradle"})
public abstract class DesugarTask
extends NonIncrementalTask {
    @NotNull
    private final Property<Integer> minSdk;
    @NotNull
    private final Property<Boolean> enableBugFixForJacoco;
    private final WorkerExecutorFacade executorFacade;

    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getProjectClasses();

    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getSubProjectClasses();

    @Classpath
    @NotNull
    public abstract DirectoryProperty getExternaLibsClasses();

    @CompileClasspath
    @NotNull
    public abstract ConfigurableFileCollection getDesugaringClasspath();

    @CompileClasspath
    @NotNull
    public abstract ConfigurableFileCollection getBootClasspath();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getProjectOutput();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getSubProjectOutput();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getExternalLibsOutput();

    @LocalState
    @NotNull
    public abstract DirectoryProperty getTmpDir();

    @Input
    @NotNull
    public final Property<Integer> getMinSdk() {
        return this.minSdk;
    }

    @Input
    @NotNull
    public final Property<Boolean> getEnableBugFixForJacoco() {
        return this.enableBugFixForJacoco;
    }

    @Override
    protected void doTaskAction() {
        Object[] objectArray = ((File)this.getExternaLibsClasses().getAsFile().get()).listFiles();
        if (objectArray == null) {
            Intrinsics.throwNpe();
        }
        Iterable $this$sortedBy$iv = ArraysKt.toList((Object[])objectArray);
        boolean $i$f$sortedBy = false;
        Iterable iterable = $this$sortedBy$iv;
        boolean bl = false;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                File it = (File)a;
                boolean bl2 = false;
                File file = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it");
                it = (File)b;
                Comparable comparable = (Comparable)((Object)file.getName());
                bl2 = false;
                File file2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"it");
                String string = file2.getName();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string)));
            }
        };
        List libs = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
        Set set = this.getProjectClasses().getFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"projectClasses.files");
        Set set2 = this.getSubProjectClasses().getFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"subProjectClasses.files");
        Set set3 = this.getDesugaringClasspath().getFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)set3, (String)"desugaringClasspath.files");
        Object object = this.getProjectOutput().getAsFile().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"projectOutput.asFile.get()");
        File file = (File)object;
        Object object2 = this.getSubProjectOutput().getAsFile().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"subProjectOutput.asFile.get()");
        File file2 = (File)object2;
        Object object3 = this.getExternalLibsOutput().getAsFile().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"externalLibsOutput.asFile.get()");
        File file3 = (File)object3;
        Object object4 = this.getTmpDir().getAsFile().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"tmpDir.asFile.get()");
        File file4 = (File)object4;
        Set set4 = this.getBootClasspath().getFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)set4, (String)"bootClasspath.files");
        Object object5 = this.minSdk.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object5, (String)"minSdk.get()");
        int n = ((Number)object5).intValue();
        Object object6 = this.enableBugFixForJacoco.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object6, (String)"enableBugFixForJacoco.get()");
        boolean bl2 = (Boolean)object6;
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        Logger logger = project2.getLogger();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"project.logger");
        new DesugarTaskDelegate(set, set2, libs, set3, file, file2, file3, file4, set4, n, bl2, logger.isDebugEnabled(), this.executorFacade).doProcess();
    }

    @Inject
    public DesugarTask(@NotNull ObjectFactory objectFactory, @NotNull WorkerExecutor workerExecutor) {
        Intrinsics.checkParameterIsNotNull((Object)objectFactory, (String)"objectFactory");
        Intrinsics.checkParameterIsNotNull((Object)workerExecutor, (String)"workerExecutor");
        Property property = objectFactory.property(Integer.TYPE);
        Intrinsics.checkExpressionValueIsNotNull((Object)property, (String)"objectFactory.property(Int::class.java)");
        this.minSdk = property;
        Property property2 = objectFactory.property(Boolean.TYPE);
        Intrinsics.checkExpressionValueIsNotNull((Object)property2, (String)"objectFactory.property(Boolean::class.java)");
        this.enableBugFixForJacoco = property2;
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        String string = project2.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.name");
        String string2 = this.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"path");
        this.executorFacade = Workers.preferWorkers$default(Workers.INSTANCE, string, string2, workerExecutor, null, 8, null);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\u0018\u0010\u0013\u001a\u00020\u00112\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0015H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lcom/android/build/gradle/internal/tasks/DesugarTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/DesugarTask;", "variantScope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "(Lcom/android/build/gradle/internal/scope/VariantScope;)V", "name", "", "getName", "()Ljava/lang/String;", "projectClasses", "Lorg/gradle/api/file/FileCollection;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle"})
    public static final class CreationAction
    extends VariantTaskCreationAction<DesugarTask> {
        @NotNull
        private final String name;
        @NotNull
        private final Class<DesugarTask> type;
        private final FileCollection projectClasses;

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public Class<DesugarTask> getType() {
            return this.type;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<? extends DesugarTask> taskProvider) {
            Intrinsics.checkParameterIsNotNull(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            BuildArtifactsHolder.producesDir$default(this.getVariantScope().getArtifacts(), InternalArtifactType.DESUGAR_PROJECT_CLASSES, BuildArtifactsHolder.OperationType.INITIAL, taskProvider, (Function1)DesugarTask$CreationAction$handleProvider$1.INSTANCE, null, 16, null);
            BuildArtifactsHolder.producesDir$default(this.getVariantScope().getArtifacts(), InternalArtifactType.DESUGAR_SUB_PROJECT_CLASSES, BuildArtifactsHolder.OperationType.INITIAL, taskProvider, (Function1)DesugarTask$CreationAction$handleProvider$2.INSTANCE, null, 16, null);
            BuildArtifactsHolder.producesDir$default(this.getVariantScope().getArtifacts(), InternalArtifactType.DESUGAR_EXTERNAL_LIBS_CLASSES, BuildArtifactsHolder.OperationType.INITIAL, taskProvider, (Function1)DesugarTask$CreationAction$handleProvider$3.INSTANCE, null, 16, null);
            BuildArtifactsHolder.producesDir$default(this.getVariantScope().getArtifacts(), InternalArtifactType.DESUGAR_LOCAL_STATE_OUTPUT, BuildArtifactsHolder.OperationType.INITIAL, taskProvider, (Function1)DesugarTask$CreationAction$handleProvider$4.INSTANCE, null, 16, null);
        }

        @Override
        public void configure(@NotNull DesugarTask task) {
            block2: {
                boolean bl;
                Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
                super.configure((Task)task);
                Property<Integer> property = task.getMinSdk();
                AndroidVersion androidVersion = this.getVariantScope().getMinSdkVersion();
                Intrinsics.checkExpressionValueIsNotNull((Object)androidVersion, (String)"variantScope.minSdkVersion");
                property.set((Object)androidVersion.getFeatureLevel());
                try {
                    GradleVersion current = GradleVersion.parse((String)JacocoTask.getJacocoVersion(this.getVariantScope()));
                    bl = JacocoConfigurations.MIN_WITHOUT_BROKEN_BYTECODE.compareTo(current) > 0;
                }
                catch (Throwable ignored) {
                    bl = true;
                }
                boolean enableDesugarBugFixForJacoco = bl;
                task.getEnableBugFixForJacoco().set((Object)enableDesugarBugFixForJacoco);
                task.getProjectClasses().from(new Object[]{this.projectClasses});
                task.getSubProjectClasses().from(new Object[]{this.getVariantScope().getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.CLASSES)});
                this.getVariantScope().getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.FIXED_STACK_FRAMES, (Property)task.getExternaLibsClasses());
                task.getDesugaringClasspath().from(new Object[]{this.getVariantScope().getProvidedOnlyClasspath()});
                task.getBootClasspath().from(new Object[]{this.getVariantScope().getBootClasspath()});
                BaseVariantData baseVariantData = this.getVariantScope().getTestedVariantData();
                if (baseVariantData == null) break block2;
                BaseVariantData baseVariantData2 = baseVariantData;
                boolean bl2 = false;
                boolean bl3 = false;
                BaseVariantData it = baseVariantData2;
                boolean bl4 = false;
                BaseVariantData baseVariantData3 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)baseVariantData3, (String)"it");
                VariantScope variantScope = baseVariantData3.getScope();
                Intrinsics.checkExpressionValueIsNotNull((Object)variantScope, (String)"it.scope");
                VariantScope testedVariantScope = variantScope;
                task.getDesugaringClasspath().from(new Object[]{this.getVariantScope().getArtifacts().getFinalProduct(InternalArtifactType.TESTED_CODE_CLASSES)});
                ConfigurableFileCollection configurableFileCollection = task.getDesugaringClasspath();
                Object[] objectArray = new Object[1];
                ArtifactCollection artifactCollection = testedVariantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.CLASSES);
                Intrinsics.checkExpressionValueIsNotNull((Object)artifactCollection, (String)"testedVariantScope.getAr\u2026SES\n                    )");
                objectArray[0] = artifactCollection.getArtifactFiles();
                configurableFileCollection.from(objectArray);
            }
        }

        public CreationAction(@NotNull VariantScope variantScope) {
            Intrinsics.checkParameterIsNotNull((Object)variantScope, (String)"variantScope");
            super(variantScope);
            String string = variantScope.getTaskName("desugar");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variantScope.getTaskName(\"desugar\")");
            this.name = string;
            this.type = DesugarTask.class;
            FileCollection fileCollection2 = variantScope.getTransformManager().getPipelineOutputAsFileCollection(1.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection2, (String)"variantScope.transformMa\u2026ROJECT)\n                }");
            this.projectClasses = fileCollection2;
            variantScope.getTransformManager().consumeStreams(SetsKt.mutableSetOf((Object[])new QualifiedContent.Scope[]{QualifiedContent.Scope.PROJECT, QualifiedContent.Scope.SUB_PROJECTS, QualifiedContent.Scope.EXTERNAL_LIBRARIES}), SetsKt.setOf((Object)QualifiedContent.DefaultContentType.CLASSES));
            Map $this$forEach$iv = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)((Object)InternalArtifactType.DESUGAR_PROJECT_CLASSES), (Object)QualifiedContent.Scope.PROJECT), TuplesKt.to((Object)((Object)InternalArtifactType.DESUGAR_SUB_PROJECT_CLASSES), (Object)QualifiedContent.Scope.SUB_PROJECTS), TuplesKt.to((Object)((Object)InternalArtifactType.DESUGAR_EXTERNAL_LIBS_CLASSES), (Object)QualifiedContent.Scope.EXTERNAL_LIBRARIES)});
            boolean $i$f$forEach = false;
            Map map = $this$forEach$iv;
            boolean bl = false;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry $dstr$output$scope = element$iv = iterator.next();
                boolean bl2 = false;
                Map.Entry entry = $dstr$output$scope;
                boolean bl3 = false;
                InternalArtifactType output2 = (InternalArtifactType)((Object)entry.getKey());
                entry = $dstr$output$scope;
                bl3 = false;
                QualifiedContent.Scope scope = (QualifiedContent.Scope)entry.getValue();
                GlobalScope globalScope = variantScope.getGlobalScope();
                Intrinsics.checkExpressionValueIsNotNull((Object)globalScope, (String)"variantScope.globalScope");
                ConfigurableFileCollection configurableFileCollection = globalScope.getProject().files(new Object[]{variantScope.getArtifacts().getFinalProduct(output2)});
                Intrinsics.checkExpressionValueIsNotNull((Object)configurableFileCollection, (String)"variantScope.globalScope\u2026      )\n                )");
                FileTree processedClasses = configurableFileCollection.getAsFileTree();
                TransformManager transformManager = variantScope.getTransformManager();
                GlobalScope globalScope2 = variantScope.getGlobalScope();
                Intrinsics.checkExpressionValueIsNotNull((Object)globalScope2, (String)"variantScope.globalScope");
                transformManager.addStream(OriginalStream.builder(globalScope2.getProject(), "desugared-classes-" + scope.name()).addContentTypes(TransformManager.CONTENT_CLASS).addScope((QualifiedContent.ScopeType)scope).setFileCollection((FileCollection)processedClasses).build());
            }
        }
    }
}

