/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.attributes.BuildTypeAttr;
import com.android.build.api.attributes.ProductFlavorAttr;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.TestedAndroidConfig;
import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.internal.BuildTypeData;
import com.android.build.gradle.internal.ProductFlavorCombo;
import com.android.build.gradle.internal.ProductFlavorData;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.VariantModel;
import com.android.build.gradle.internal.api.DefaultAndroidSourceSet;
import com.android.build.gradle.internal.api.ReadOnlyObjectProvider;
import com.android.build.gradle.internal.api.VariantFilter;
import com.android.build.gradle.internal.api.artifact.BuildArtifactSpec;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.crash.ExternalApiUsageException;
import com.android.build.gradle.internal.dependency.AarResourcesCompilerTransform;
import com.android.build.gradle.internal.dependency.AarToClassTransform;
import com.android.build.gradle.internal.dependency.AarTransform;
import com.android.build.gradle.internal.dependency.AlternateCompatibilityRule;
import com.android.build.gradle.internal.dependency.AlternateDisambiguationRule;
import com.android.build.gradle.internal.dependency.AndroidTypeAttr;
import com.android.build.gradle.internal.dependency.AndroidTypeAttrCompatRule;
import com.android.build.gradle.internal.dependency.AndroidTypeAttrDisambRule;
import com.android.build.gradle.internal.dependency.AndroidXDepedencySubstitution;
import com.android.build.gradle.internal.dependency.DexingArtifactConfiguration;
import com.android.build.gradle.internal.dependency.DexingTransformKt;
import com.android.build.gradle.internal.dependency.ExtractAarTransform;
import com.android.build.gradle.internal.dependency.ExtractProGuardRulesTransform;
import com.android.build.gradle.internal.dependency.FilterShrinkerRulesTransform;
import com.android.build.gradle.internal.dependency.GenericTransformParameters;
import com.android.build.gradle.internal.dependency.IdentityTransform;
import com.android.build.gradle.internal.dependency.JetifyTransform;
import com.android.build.gradle.internal.dependency.LibraryDefinedSymbolTableTransform;
import com.android.build.gradle.internal.dependency.LibrarySymbolTableTransform;
import com.android.build.gradle.internal.dependency.MockableJarTransform;
import com.android.build.gradle.internal.dependency.PlatformAttrTransform;
import com.android.build.gradle.internal.dependency.SourceSetManager;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.dependency.VersionedCodeShrinker;
import com.android.build.gradle.internal.dsl.BaseAppModuleExtension;
import com.android.build.gradle.internal.dsl.BaseFlavor;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.CoreProductFlavor;
import com.android.build.gradle.internal.dsl.DefaultConfig;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.errors.SyncIssueHandler;
import com.android.build.gradle.internal.profile.AnalyticsUtil;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.publishing.PublishingSpecs;
import com.android.build.gradle.internal.res.Aapt2MavenUtils;
import com.android.build.gradle.internal.scope.AnchorOutputType;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.CodeShrinker;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.TransformVariantScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.internal.variant.TestedVariantData;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.SigningOptions;
import com.android.build.gradle.options.StringOption;
import com.android.build.gradle.options.SyncOptions;
import com.android.builder.core.DefaultManifestParser;
import com.android.builder.core.DefaultProductFlavor;
import com.android.builder.core.ManifestAttributeSupplier;
import com.android.builder.core.VariantType;
import com.android.builder.core.VariantTypeImpl;
import com.android.builder.errors.EvalIssueReporter;
import com.android.builder.model.SourceProvider;
import com.android.builder.profile.ProcessProfileWriter;
import com.android.builder.profile.Recorder;
import com.android.utils.StringHelper;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.wireless.android.sdk.stats.ApiVersion;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kotlin.Pair;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeMatchingStrategy;
import org.gradle.api.attributes.AttributesSchema;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.internal.artifacts.ArtifactAttributes;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;

public class VariantManager
implements VariantModel {
    private static final String TYPE_PROCESSED_AAR = "processed-aar";
    private static final String MULTIDEX_VERSION = "1.0.2";
    protected static final String COM_ANDROID_SUPPORT_MULTIDEX = "com.android.support:multidex:1.0.2";
    protected static final String COM_ANDROID_SUPPORT_MULTIDEX_INSTRUMENTATION = "com.android.support:multidex-instrumentation:1.0.2";
    protected static final String ANDROIDX_MULTIDEX_MULTIDEX = AndroidXDepedencySubstitution.getAndroidXMappings().get("com.android.support:multidex");
    protected static final String ANDROIDX_MULTIDEX_MULTIDEX_INSTRUMENTATION = AndroidXDepedencySubstitution.getAndroidXMappings().get("com.android.support:multidex-instrumentation");
    private final Project project;
    private final ProjectOptions projectOptions;
    private final BaseExtension extension;
    private final VariantFactory variantFactory;
    private final TaskManager taskManager;
    private final SourceSetManager sourceSetManager;
    private final Recorder recorder;
    private final ProductFlavorData<CoreProductFlavor> defaultConfigData;
    private final Map<String, BuildTypeData> buildTypes;
    private final VariantFilter variantFilter;
    private final List<VariantScope> variantScopes;
    private final Map<String, ProductFlavorData<CoreProductFlavor>> productFlavors;
    private final Map<String, com.android.builder.model.SigningConfig> signingConfigs;
    private final Map<File, ManifestAttributeSupplier> manifestParserMap;
    protected final GlobalScope globalScope;
    private final com.android.builder.model.SigningConfig signingOverride;
    private boolean hasCreatedTasks = false;
    public static final Attribute<String> SHRINKER_ATTR = Attribute.of((String)"codeShrinker", String.class);

    public VariantManager(GlobalScope globalScope, Project project2, ProjectOptions projectOptions, BaseExtension extension, VariantFactory variantFactory, TaskManager taskManager, SourceSetManager sourceSetManager, Recorder recorder) {
        this.globalScope = globalScope;
        this.extension = extension;
        this.project = project2;
        this.projectOptions = projectOptions;
        this.variantFactory = variantFactory;
        this.taskManager = taskManager;
        this.sourceSetManager = sourceSetManager;
        this.recorder = recorder;
        this.signingOverride = this.createSigningOverride();
        this.variantFilter = new VariantFilter(new ReadOnlyObjectProvider());
        this.buildTypes = Maps.newHashMap();
        this.variantScopes = Lists.newArrayList();
        this.productFlavors = Maps.newHashMap();
        this.signingConfigs = Maps.newHashMap();
        this.manifestParserMap = Maps.newHashMap();
        DefaultAndroidSourceSet mainSourceSet = (DefaultAndroidSourceSet)extension.getSourceSets().getByName("main");
        DefaultAndroidSourceSet androidTestSourceSet = null;
        DefaultAndroidSourceSet unitTestSourceSet = null;
        if (variantFactory.hasTestScope()) {
            androidTestSourceSet = (DefaultAndroidSourceSet)extension.getSourceSets().getByName("androidTest");
            unitTestSourceSet = (DefaultAndroidSourceSet)extension.getSourceSets().getByName("test");
        }
        this.defaultConfigData = new ProductFlavorData<DefaultConfig>(extension.getDefaultConfig(), mainSourceSet, androidTestSourceSet, unitTestSourceSet);
    }

    public void addVariant(BaseVariantData variantData) {
        this.variantScopes.add(variantData.getScope());
    }

    @Override
    public ProductFlavorData<CoreProductFlavor> getDefaultConfig() {
        return this.defaultConfigData;
    }

    @Override
    public Map<String, BuildTypeData> getBuildTypes() {
        return this.buildTypes;
    }

    @Override
    public Map<String, ProductFlavorData<CoreProductFlavor>> getProductFlavors() {
        return this.productFlavors;
    }

    public Map<String, com.android.builder.model.SigningConfig> getSigningConfigs() {
        return this.signingConfigs;
    }

    public void addSigningConfig(com.android.builder.model.SigningConfig signingConfig) {
        this.signingConfigs.put(signingConfig.getName(), signingConfig);
    }

    public void addBuildType(CoreBuildType buildType) {
        String name = buildType.getName();
        VariantManager.checkName(name, "BuildType");
        if (this.productFlavors.containsKey(name)) {
            throw new RuntimeException("BuildType names cannot collide with ProductFlavor names");
        }
        DefaultAndroidSourceSet mainSourceSet = (DefaultAndroidSourceSet)this.sourceSetManager.setUpSourceSet(name);
        DefaultAndroidSourceSet androidTestSourceSet = null;
        DefaultAndroidSourceSet unitTestSourceSet = null;
        if (this.variantFactory.hasTestScope()) {
            if (buildType.getName().equals(this.extension.getTestBuildType())) {
                androidTestSourceSet = (DefaultAndroidSourceSet)this.sourceSetManager.setUpTestSourceSet(VariantManager.computeSourceSetName(buildType.getName(), (VariantType)VariantTypeImpl.ANDROID_TEST));
            }
            unitTestSourceSet = (DefaultAndroidSourceSet)this.sourceSetManager.setUpTestSourceSet(VariantManager.computeSourceSetName(buildType.getName(), (VariantType)VariantTypeImpl.UNIT_TEST));
        }
        BuildTypeData buildTypeData = new BuildTypeData(buildType, mainSourceSet, androidTestSourceSet, unitTestSourceSet);
        this.buildTypes.put(name, buildTypeData);
    }

    public void addProductFlavor(CoreProductFlavor productFlavor) {
        String name = productFlavor.getName();
        VariantManager.checkName(name, "ProductFlavor");
        if (this.buildTypes.containsKey(name)) {
            throw new RuntimeException("ProductFlavor names cannot collide with BuildType names");
        }
        DefaultAndroidSourceSet mainSourceSet = (DefaultAndroidSourceSet)this.sourceSetManager.setUpSourceSet(productFlavor.getName());
        DefaultAndroidSourceSet androidTestSourceSet = null;
        DefaultAndroidSourceSet unitTestSourceSet = null;
        if (this.variantFactory.hasTestScope()) {
            androidTestSourceSet = (DefaultAndroidSourceSet)this.sourceSetManager.setUpTestSourceSet(VariantManager.computeSourceSetName(productFlavor.getName(), (VariantType)VariantTypeImpl.ANDROID_TEST));
            unitTestSourceSet = (DefaultAndroidSourceSet)this.sourceSetManager.setUpTestSourceSet(VariantManager.computeSourceSetName(productFlavor.getName(), (VariantType)VariantTypeImpl.UNIT_TEST));
        }
        ProductFlavorData<CoreProductFlavor> productFlavorData = new ProductFlavorData<CoreProductFlavor>(productFlavor, mainSourceSet, androidTestSourceSet, unitTestSourceSet);
        this.productFlavors.put(productFlavor.getName(), productFlavorData);
    }

    public List<VariantScope> getVariantScopes() {
        return this.variantScopes;
    }

    @Deprecated
    public List<BaseVariantData> getVariantDataList() {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)this.variantScopes.size());
        for (VariantScope variantScope : this.variantScopes) {
            result.add(variantScope.getVariantData());
        }
        return result;
    }

    public List<VariantScope> createAndroidTasks() {
        this.variantFactory.validateModel(this);
        this.variantFactory.preVariantWork(this.project);
        if (this.variantScopes.isEmpty()) {
            this.populateVariantDataList();
        }
        this.taskManager.createTopLevelTestTasks(!this.productFlavors.isEmpty());
        for (VariantScope variantScope : this.variantScopes) {
            this.createTasksForVariantData(variantScope);
        }
        this.taskManager.createReportTasks(this.variantScopes);
        return this.variantScopes;
    }

    public void createTasksForVariantData(VariantScope variantScope) {
        BaseVariantData variantData = variantScope.getVariantData();
        VariantType variantType = variantData.getType();
        GradleVariantConfiguration variantConfig = variantScope.getVariantConfiguration();
        this.taskManager.createAssembleTask(variantData);
        if (variantType.isBaseModule()) {
            this.taskManager.createBundleTask(variantData);
        }
        if (variantType.isTestComponent()) {
            BuildTypeData buildTypeData;
            DefaultAndroidSourceSet buildTypeConfigurationProvider;
            BaseVariantData testedVariantData = (BaseVariantData)((Object)((TestVariantData)variantData).getTestedVariantData());
            List testProductFlavors = variantConfig.getProductFlavors();
            ArrayList testVariantSourceSets = Lists.newArrayListWithExpectedSize((int)(4 + testProductFlavors.size()));
            if (!testProductFlavors.isEmpty()) {
                testVariantSourceSets.add((DefaultAndroidSourceSet)variantConfig.getVariantSourceProvider());
            }
            if ((buildTypeConfigurationProvider = (buildTypeData = this.buildTypes.get(((CoreBuildType)variantConfig.getBuildType()).getName())).getTestSourceSet(variantType)) != null) {
                testVariantSourceSets.add(buildTypeConfigurationProvider);
            }
            if (testProductFlavors.size() > 1) {
                testVariantSourceSets.add((DefaultAndroidSourceSet)variantConfig.getMultiFlavorSourceProvider());
            }
            for (CoreProductFlavor productFlavor : testProductFlavors) {
                testVariantSourceSets.add(this.productFlavors.get(productFlavor.getName()).getTestSourceSet(variantType));
            }
            testVariantSourceSets.add(this.defaultConfigData.getTestSourceSet(variantType));
            AndroidTypeAttr consumeAndroidTypeAttr = this.instantiateAndroidTypeAttr(testedVariantData.getVariantConfiguration().getType().getConsumeType());
            VariantDependencies.Builder builder = VariantDependencies.builder(this.project, variantScope.getGlobalScope().getErrorHandler(), variantConfig).setConsumeType(consumeAndroidTypeAttr).addSourceSets(testVariantSourceSets).setFlavorSelection(this.getFlavorSelection(variantConfig)).setTestedVariantScope(testedVariantData.getScope());
            VariantDependencies variantDep = builder.build(variantScope);
            variantData.setVariantDependency(variantDep);
            if (testedVariantData.getVariantConfiguration().getRenderscriptSupportModeEnabled()) {
                this.project.getDependencies().add(variantDep.getCompileClasspath().getName(), (Object)this.project.files(new Object[]{this.globalScope.getSdkComponents().getRenderScriptSupportJarProvider()}));
            }
            if (variantType.isApk()) {
                if (variantConfig.isLegacyMultiDexMode()) {
                    String multiDexInstrumentationDep = this.globalScope.getProjectOptions().get(BooleanOption.USE_ANDROID_X) ? ANDROIDX_MULTIDEX_MULTIDEX_INSTRUMENTATION : COM_ANDROID_SUPPORT_MULTIDEX_INSTRUMENTATION;
                    this.project.getDependencies().add(variantDep.getCompileClasspath().getName(), (Object)multiDexInstrumentationDep);
                    this.project.getDependencies().add(variantDep.getRuntimeClasspath().getName(), (Object)multiDexInstrumentationDep);
                }
                this.taskManager.createAndroidTestVariantTasks((TestVariantData)variantData, this.variantScopes.stream().filter(TaskManager::isLintVariant).collect(Collectors.toList()));
            } else {
                this.taskManager.createUnitTestVariantTasks((TestVariantData)variantData);
            }
        } else {
            this.taskManager.createTasksForVariantScope(variantScope, this.variantScopes.stream().filter(TaskManager::isLintVariant).collect(Collectors.toList()));
        }
    }

    public void publishBuildArtifacts(VariantScope variantScope) {
        BuildArtifactsHolder buildArtifactsHolder = variantScope.getArtifacts();
        for (PublishingSpecs.OutputSpec outputSpec : variantScope.getPublishingSpec().getOutputs()) {
            ArtifactType buildArtifactType = outputSpec.getOutputType();
            if (BuildArtifactSpec.Companion.has(buildArtifactType) && BuildArtifactSpec.Companion.get(buildArtifactType).getAppendable()) {
                throw new RuntimeException(String.format("Appendable ArtifactType '%1s' cannot be published.", buildArtifactType.name()));
            }
            if (buildArtifactsHolder.hasFinalProduct(buildArtifactType)) {
                Pair finalProduct = buildArtifactsHolder.getFinalProductWithTaskName(buildArtifactType);
                variantScope.publishIntermediateArtifact((Provider<? extends FileSystemLocation>)((Provider)finalProduct.getSecond()), (Provider<String>)((Provider)finalProduct.getFirst()), outputSpec.getArtifactType(), (Collection<AndroidArtifacts.PublishedConfigType>)outputSpec.getPublishedConfigTypes());
                continue;
            }
            if (buildArtifactType != AnchorOutputType.ALL_CLASSES) continue;
            variantScope.publishIntermediateArtifact(buildArtifactsHolder.getFinalProductAsFileCollection(buildArtifactType), outputSpec.getArtifactType(), (Collection<AndroidArtifacts.PublishedConfigType>)outputSpec.getPublishedConfigTypes());
        }
    }

    private Map<Attribute<ProductFlavorAttr>, ProductFlavorAttr> getFlavorSelection(GradleVariantConfiguration config2) {
        com.android.builder.model.ProductFlavor mergedFlavors = config2.getMergedFlavor();
        if (mergedFlavors instanceof DefaultProductFlavor) {
            ObjectFactory factory2 = this.project.getObjects();
            return ((DefaultProductFlavor)mergedFlavors).getMissingDimensionStrategies().entrySet().stream().collect(Collectors.toMap(entry -> Attribute.of((String)((String)entry.getKey()), ProductFlavorAttr.class), entry -> (ProductFlavorAttr)factory2.named(ProductFlavorAttr.class, ((DefaultProductFlavor.DimensionRequest)entry.getValue()).getRequested())));
        }
        return ImmutableMap.of();
    }

    AndroidTypeAttr instantiateAndroidTypeAttr(String androidTypeAttrString) {
        return (AndroidTypeAttr)this.project.getObjects().named(AndroidTypeAttr.class, androidTypeAttrString);
    }

    public void configureDependencies() {
        DependencyHandler dependencies = this.project.getDependencies();
        if (!this.globalScope.getProjectOptions().get(BooleanOption.USE_ANDROID_X) && this.globalScope.getProjectOptions().get(BooleanOption.ENABLE_JETIFIER)) {
            throw new IllegalStateException("AndroidX must be enabled when Jetifier is enabled. To resolve, set " + BooleanOption.USE_ANDROID_X.getPropertyName() + "=true in your gradle.properties file.");
        }
        if (this.globalScope.getProjectOptions().get(BooleanOption.ENABLE_JETIFIER)) {
            AndroidXDepedencySubstitution.replaceOldSupportLibraries(this.project);
        }
        String jetifierBlackList = Strings.nullToEmpty((String)this.globalScope.getProjectOptions().get(StringOption.JETIFIER_BLACKLIST));
        dependencies.registerTransform(transform2 -> {
            transform2.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.AAR.getType());
            transform2.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)TYPE_PROCESSED_AAR);
            if (this.globalScope.getProjectOptions().get(BooleanOption.ENABLE_JETIFIER)) {
                transform2.artifactTransform(JetifyTransform.class, config2 -> config2.params(new Object[]{jetifierBlackList}));
            } else {
                transform2.artifactTransform(IdentityTransform.class);
            }
        });
        dependencies.registerTransform(transform2 -> {
            transform2.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.JAR.getType());
            transform2.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.PROCESSED_JAR.getType());
            if (this.globalScope.getProjectOptions().get(BooleanOption.ENABLE_JETIFIER)) {
                transform2.artifactTransform(JetifyTransform.class, config2 -> config2.params(new Object[]{jetifierBlackList}));
            } else {
                transform2.artifactTransform(IdentityTransform.class);
            }
        });
        dependencies.registerTransform(ExtractAarTransform.class, spec2 -> {
            ((GenericTransformParameters)spec2.getParameters()).getProjectName().set((Object)this.project.getName());
            spec2.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)TYPE_PROCESSED_AAR);
            spec2.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.EXPLODED_AAR.getType());
        });
        dependencies.registerTransform(reg -> {
            reg.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.JAR.getType());
            reg.getFrom().attribute(AndroidArtifacts.MOCKABLE_JAR_RETURN_DEFAULT_VALUES, (Object)true);
            reg.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"android-mockable-jar");
            reg.getTo().attribute(AndroidArtifacts.MOCKABLE_JAR_RETURN_DEFAULT_VALUES, (Object)true);
            reg.artifactTransform(MockableJarTransform.class, config2 -> config2.params(new Object[]{true}));
        });
        dependencies.registerTransform(reg -> {
            reg.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.JAR.getType());
            reg.getFrom().attribute(AndroidArtifacts.MOCKABLE_JAR_RETURN_DEFAULT_VALUES, (Object)false);
            reg.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"android-mockable-jar");
            reg.getTo().attribute(AndroidArtifacts.MOCKABLE_JAR_RETURN_DEFAULT_VALUES, (Object)false);
            reg.artifactTransform(MockableJarTransform.class, config2 -> config2.params(new Object[]{false}));
        });
        dependencies.registerTransform(PlatformAttrTransform.class, spec2 -> {
            ((GenericTransformParameters)spec2.getParameters()).getProjectName().set((Object)this.project.getName());
            spec2.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.JAR.getType());
            spec2.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"android-platform-attr");
        });
        boolean sharedLibSupport = this.globalScope.getProjectOptions().get(BooleanOption.CONSUME_DEPENDENCIES_AS_SHARED_LIBRARIES);
        boolean autoNamespaceDependencies = this.globalScope.getExtension().getAaptOptions().getNamespaced() && this.globalScope.getProjectOptions().get(BooleanOption.CONVERT_NON_NAMESPACED_DEPENDENCIES);
        for (AndroidArtifacts.ArtifactType transformTarget : AarTransform.getTransformTargets()) {
            dependencies.registerTransform(reg -> {
                reg.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.EXPLODED_AAR.getType());
                reg.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)transformTarget.getType());
                reg.artifactTransform(AarTransform.class, config2 -> config2.params(new Object[]{transformTarget, sharedLibSupport, autoNamespaceDependencies}));
            });
        }
        if (this.globalScope.getProjectOptions().get(BooleanOption.PRECOMPILE_REMOTE_RESOURCES)) {
            dependencies.registerTransform(AarResourcesCompilerTransform.class, reg -> {
                reg.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.EXPLODED_AAR.getType());
                reg.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.COMPILED_REMOTE_RESOURCES.getType());
                reg.parameters(params -> {
                    params.getAapt2FromMaven().from(new Object[]{Aapt2MavenUtils.getAapt2FromMaven(this.globalScope)});
                    params.getErrorFormatMode().set((Object)SyncOptions.getErrorFormatMode(this.globalScope.getProjectOptions()));
                });
            });
        }
        Usage apiUsage = (Usage)this.project.getObjects().named(Usage.class, "java-api");
        dependencies.registerTransform(AarToClassTransform.class, reg -> {
            reg.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)TYPE_PROCESSED_AAR);
            reg.getFrom().attribute(Usage.USAGE_ATTRIBUTE, (Object)apiUsage);
            reg.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.CLASSES.getType());
            reg.getTo().attribute(Usage.USAGE_ATTRIBUTE, (Object)apiUsage);
            reg.parameters(params -> {
                params.getForCompileUse().set((Object)true);
                params.getAutoNamespaceDependencies().set((Object)autoNamespaceDependencies);
                params.getGenerateRClassJar().set((Object)this.projectOptions.get(BooleanOption.COMPILE_CLASSPATH_LIBRARY_R_CLASSES));
            });
        });
        Usage runtimeUsage = (Usage)this.project.getObjects().named(Usage.class, "java-runtime");
        dependencies.registerTransform(AarToClassTransform.class, reg -> {
            reg.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)TYPE_PROCESSED_AAR);
            reg.getFrom().attribute(Usage.USAGE_ATTRIBUTE, (Object)runtimeUsage);
            reg.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.CLASSES.getType());
            reg.getTo().attribute(Usage.USAGE_ATTRIBUTE, (Object)runtimeUsage);
            reg.parameters(params -> {
                params.getForCompileUse().set((Object)false);
                params.getAutoNamespaceDependencies().set((Object)autoNamespaceDependencies);
                params.getGenerateRClassJar().set((Object)false);
            });
        });
        if (this.globalScope.getProjectOptions().get(BooleanOption.ENABLE_PROGUARD_RULES_EXTRACTION)) {
            dependencies.registerTransform(reg -> {
                reg.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.PROCESSED_JAR.getType());
                reg.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.UNFILTERED_PROGUARD_RULES.getType());
                reg.artifactTransform(ExtractProGuardRulesTransform.class);
            });
        }
        dependencies.registerTransform(reg -> {
            reg.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.EXPLODED_AAR.getType());
            reg.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.SYMBOL_LIST_WITH_PACKAGE_NAME.getType());
            reg.artifactTransform(LibrarySymbolTableTransform.class);
        });
        if (autoNamespaceDependencies) {
            dependencies.registerTransform(reg -> {
                reg.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.EXPLODED_AAR.getType());
                reg.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.DEFINED_ONLY_SYMBOL_LIST.getType());
                reg.artifactTransform(LibraryDefinedSymbolTableTransform.class);
            });
        }
        for (String classesOrResources : new String[]{AndroidArtifacts.ArtifactType.CLASSES.getType(), AndroidArtifacts.ArtifactType.JAVA_RES.getType()}) {
            dependencies.registerTransform(reg -> {
                reg.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.PROCESSED_JAR.getType());
                reg.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)classesOrResources);
                reg.artifactTransform(IdentityTransform.class);
            });
        }
        this.project.getConfigurations().all(configuration2 -> {
            if (configuration2.getName().startsWith("kapt")) {
                configuration2.getAttributes().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.PROCESSED_JAR.getType());
            }
        });
        AttributesSchema schema = dependencies.getAttributesSchema();
        AttributeMatchingStrategy androidTypeAttrStrategy = schema.attribute(AndroidTypeAttr.ATTRIBUTE);
        androidTypeAttrStrategy.getCompatibilityRules().add(AndroidTypeAttrCompatRule.class);
        androidTypeAttrStrategy.getDisambiguationRules().add(AndroidTypeAttrDisambRule.class);
        this.setBuildTypeStrategy(schema);
        this.setupFlavorStrategy(schema);
    }

    private void configureVariantArtifactTransforms(Collection<VariantScope> variantScopes) {
        DependencyHandler dependencies = this.project.getDependencies();
        if (this.globalScope.getProjectOptions().get(BooleanOption.ENABLE_DEXING_ARTIFACT_TRANSFORM)) {
            for (DexingArtifactConfiguration artifactConfiguration : DexingTransformKt.getDexingArtifactConfigurations(variantScopes)) {
                artifactConfiguration.registerTransform(this.globalScope.getProject().getName(), dependencies, this.globalScope.getBootClasspath(), SyncOptions.getErrorFormatMode(this.globalScope.getProjectOptions()));
            }
        }
        if (this.globalScope.getProjectOptions().get(BooleanOption.ENABLE_PROGUARD_RULES_EXTRACTION)) {
            Set shrinkers = variantScopes.stream().map(VariantScope::getCodeShrinker).filter(Objects::nonNull).collect(Collectors.toSet());
            for (CodeShrinker shrinker : shrinkers) {
                dependencies.registerTransform(FilterShrinkerRulesTransform.class, reg -> {
                    reg.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.UNFILTERED_PROGUARD_RULES.getType());
                    reg.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.FILTERED_PROGUARD_RULES.getType());
                    reg.getFrom().attribute(SHRINKER_ATTR, (Object)shrinker.toString());
                    reg.getTo().attribute(SHRINKER_ATTR, (Object)shrinker.toString());
                    reg.parameters(params -> {
                        params.getShrinker().set((Object)VersionedCodeShrinker.of(shrinker));
                        params.getProjectName().set((Object)this.project.getName());
                    });
                });
            }
        }
    }

    private static <F, T> List<T> convert(Collection<F> values, Function<F, ?> function, Class<T> convertedType) {
        return values.stream().map(function).filter(convertedType::isInstance).map(convertedType::cast).collect(Collectors.toList());
    }

    private void setBuildTypeStrategy(AttributesSchema schema) {
        List<BuildType> dslBuildTypes = VariantManager.convert(this.buildTypes.values(), BuildTypeData::getBuildType, BuildType.class);
        if (dslBuildTypes.isEmpty()) {
            return;
        }
        HashMap alternateMap = Maps.newHashMap();
        for (BuildType buildType : dslBuildTypes) {
            if (buildType.getMatchingFallbacks().isEmpty()) continue;
            alternateMap.put(buildType.getName(), buildType.getMatchingFallbacks());
        }
        if (!alternateMap.isEmpty()) {
            AttributeMatchingStrategy buildTypeStrategy = schema.attribute(BuildTypeAttr.ATTRIBUTE);
            buildTypeStrategy.getCompatibilityRules().add(AlternateCompatibilityRule.BuildTypeRule.class, config2 -> config2.setParams(new Object[]{alternateMap}));
            buildTypeStrategy.getDisambiguationRules().add(AlternateDisambiguationRule.BuildTypeRule.class, config2 -> config2.setParams(new Object[]{alternateMap}));
        }
    }

    private void setupFlavorStrategy(AttributesSchema schema) {
        List<ProductFlavor> flavors = VariantManager.convert(this.productFlavors.values(), ProductFlavorData::getProductFlavor, ProductFlavor.class);
        HashMap alternateMap = Maps.newHashMap();
        for (ProductFlavor productFlavor : flavors) {
            if (!productFlavor.getMatchingFallbacks().isEmpty()) {
                String name = productFlavor.getName();
                String dimension = productFlavor.getDimension();
                Map dimensionMap = alternateMap.computeIfAbsent(dimension, s -> Maps.newHashMap());
                dimensionMap.put(name, productFlavor.getMatchingFallbacks());
            }
            VariantManager.handleMissingDimensions(alternateMap, productFlavor);
        }
        if (this.defaultConfigData.getProductFlavor() instanceof BaseFlavor) {
            VariantManager.handleMissingDimensions(alternateMap, (BaseFlavor)this.defaultConfigData.getProductFlavor());
        }
        for (Map.Entry entry : alternateMap.entrySet()) {
            VariantManager.addFlavorStrategy(schema, (String)entry.getKey(), (Map)entry.getValue());
        }
    }

    public static void addFlavorStrategy(AttributesSchema schema, String dimension, Map<String, List<String>> alternateMap) {
        Attribute attr = Attribute.of((String)dimension, ProductFlavorAttr.class);
        AttributeMatchingStrategy flavorStrategy = schema.attribute(attr);
        flavorStrategy.getCompatibilityRules().add(AlternateCompatibilityRule.ProductFlavorRule.class, config2 -> config2.setParams(new Object[]{alternateMap}));
        flavorStrategy.getDisambiguationRules().add(AlternateDisambiguationRule.ProductFlavorRule.class, config2 -> config2.setParams(new Object[]{alternateMap}));
    }

    private static void handleMissingDimensions(Map<String, Map<String, List<String>>> alternateMap, BaseFlavor flavor) {
        Map missingStrategies = flavor.getMissingDimensionStrategies();
        if (!missingStrategies.isEmpty()) {
            for (Map.Entry entry : missingStrategies.entrySet()) {
                String dimension = (String)entry.getKey();
                Map dimensionMap = alternateMap.computeIfAbsent(dimension, s -> Maps.newHashMap());
                dimensionMap.put(((DefaultProductFlavor.DimensionRequest)entry.getValue()).getRequested(), ((DefaultProductFlavor.DimensionRequest)entry.getValue()).getFallbacks());
            }
        }
    }

    public static String getModifiedName(String name) {
        return "____" + name;
    }

    public void populateVariantDataList() {
        List<String> flavorDimensionList = this.extension.getFlavorDimensionList();
        if (this.productFlavors.isEmpty()) {
            this.configureDependencies();
            this.createVariantDataForProductFlavors(Collections.emptyList());
        } else {
            if (flavorDimensionList == null || flavorDimensionList.isEmpty()) {
                this.globalScope.getErrorHandler().reportError(EvalIssueReporter.Type.UNNAMED_FLAVOR_DIMENSION, "All flavors must now belong to a named flavor dimension. Learn more at https://d.android.com/r/tools/flavorDimensions-missing-error-message.html");
            } else if (flavorDimensionList.size() == 1) {
                String dimensionName = flavorDimensionList.get(0);
                for (ProductFlavorData<CoreProductFlavor> flavorData : this.productFlavors.values()) {
                    CoreProductFlavor flavor = flavorData.getProductFlavor();
                    if (flavor.getDimension() != null || !(flavor instanceof DefaultProductFlavor)) continue;
                    ((DefaultProductFlavor)flavor).setDimension(dimensionName);
                }
            }
            this.configureDependencies();
            Iterable flavorDsl = Iterables.transform(this.productFlavors.values(), ProductFlavorData::getProductFlavor);
            List flavorComboList = ProductFlavorCombo.createCombinations(flavorDimensionList, flavorDsl);
            for (ProductFlavorCombo flavorCombo : flavorComboList) {
                this.createVariantDataForProductFlavors(flavorCombo.getFlavorList());
            }
        }
        this.configureVariantArtifactTransforms(this.variantScopes);
    }

    private BaseVariantData createVariantDataForVariantType(com.android.builder.model.BuildType buildType, List<? extends com.android.builder.model.ProductFlavor> productFlavorList, VariantType variantType) {
        BuildTypeData buildTypeData = this.buildTypes.get(buildType.getName());
        DefaultAndroidSourceSet sourceSet = this.defaultConfigData.getSourceSet();
        GradleVariantConfiguration variantConfig = GradleVariantConfiguration.getBuilderForExtension(this.extension).create(this.globalScope.getProjectOptions(), this.defaultConfigData.getProductFlavor(), sourceSet, this.getParser(sourceSet.getManifestFile()), buildTypeData.getBuildType(), buildTypeData.getSourceSet(), variantType, this.signingOverride, this.globalScope.getErrorHandler(), this::canParseManifest);
        if (!buildTypeData.getBuildType().isDebuggable() && variantType.isApk() && !variantConfig.getType().isForTesting()) {
            ProcessProfileWriter.get().recordApplicationId(variantConfig::getApplicationId);
        }
        NamedDomainObjectContainer<AndroidSourceSet> sourceSetsContainer = this.extension.getSourceSets();
        for (com.android.builder.model.ProductFlavor productFlavor : productFlavorList) {
            ProductFlavorData<CoreProductFlavor> productFlavorData = this.productFlavors.get(productFlavor.getName());
            String dimensionName = productFlavor.getDimension();
            if (dimensionName == null) {
                dimensionName = "";
            }
            variantConfig.addProductFlavor(productFlavorData.getProductFlavor(), (SourceProvider)productFlavorData.getSourceSet(), dimensionName);
        }
        VariantManager.createCompoundSourceSets(productFlavorList, variantConfig, this.sourceSetManager);
        ArrayList variantSourceSets = Lists.newArrayListWithExpectedSize((int)(productFlavorList.size() + 4));
        if (!productFlavorList.isEmpty()) {
            variantSourceSets.add((DefaultAndroidSourceSet)variantConfig.getVariantSourceProvider());
        }
        variantSourceSets.add(buildTypeData.getSourceSet());
        if (productFlavorList.size() > 1) {
            variantSourceSets.add((DefaultAndroidSourceSet)variantConfig.getMultiFlavorSourceProvider());
        }
        for (com.android.builder.model.ProductFlavor productFlavor : productFlavorList) {
            variantSourceSets.add(this.productFlavors.get(productFlavor.getName()).getSourceSet());
        }
        variantSourceSets.add(this.defaultConfigData.getSourceSet());
        BaseVariantData baseVariantData = this.variantFactory.createVariantData(variantConfig, this.taskManager, this.recorder);
        VariantScope variantScope = baseVariantData.getScope();
        VariantDependencies.Builder builder = VariantDependencies.builder(this.project, variantScope.getGlobalScope().getErrorHandler(), variantConfig).setConsumeType(this.instantiateAndroidTypeAttr(variantType.getConsumeType())).setFlavorSelection(this.getFlavorSelection(variantConfig)).addSourceSets(variantSourceSets);
        String publishType = variantType.getPublishType();
        if (publishType != null) {
            builder.setPublishType(this.instantiateAndroidTypeAttr(publishType));
        }
        if (this.extension instanceof BaseAppModuleExtension) {
            builder.setFeatureList(((BaseAppModuleExtension)this.extension).getDynamicFeatures());
        }
        VariantDependencies variantDep = builder.build(variantScope);
        baseVariantData.setVariantDependency(variantDep);
        if (variantConfig.isLegacyMultiDexMode()) {
            String multiDexDependency = this.globalScope.getProjectOptions().get(BooleanOption.USE_ANDROID_X) ? ANDROIDX_MULTIDEX_MULTIDEX : COM_ANDROID_SUPPORT_MULTIDEX;
            this.project.getDependencies().add(variantDep.getCompileClasspath().getName(), (Object)multiDexDependency);
            this.project.getDependencies().add(variantDep.getRuntimeClasspath().getName(), (Object)multiDexDependency);
        }
        if (variantConfig.getRenderscriptSupportModeEnabled()) {
            ConfigurableFileCollection fileCollection2 = this.project.files(new Object[]{this.globalScope.getSdkComponents().getRenderScriptSupportJarProvider()});
            this.project.getDependencies().add(variantDep.getCompileClasspath().getName(), (Object)fileCollection2);
            if (variantType.isApk() && !variantType.isForTesting()) {
                this.project.getDependencies().add(variantDep.getRuntimeClasspath().getName(), (Object)fileCollection2);
            }
        }
        return baseVariantData;
    }

    private static void createCompoundSourceSets(List<? extends com.android.builder.model.ProductFlavor> productFlavorList, GradleVariantConfiguration variantConfig, SourceSetManager sourceSetManager) {
        if (!productFlavorList.isEmpty()) {
            DefaultAndroidSourceSet variantSourceSet = (DefaultAndroidSourceSet)sourceSetManager.setUpSourceSet(VariantManager.computeSourceSetName(variantConfig.getFullName(), variantConfig.getType()), variantConfig.getType().isTestComponent());
            variantConfig.setVariantSourceProvider(variantSourceSet);
        }
        if (productFlavorList.size() > 1) {
            DefaultAndroidSourceSet multiFlavorSourceSet = (DefaultAndroidSourceSet)sourceSetManager.setUpSourceSet(VariantManager.computeSourceSetName(variantConfig.getFlavorName(), variantConfig.getType()), variantConfig.getType().isTestComponent());
            variantConfig.setMultiFlavorSourceProvider(multiFlavorSourceSet);
        }
    }

    private static String computeSourceSetName(String name, VariantType variantType) {
        if (name.endsWith(variantType.getSuffix())) {
            name = name.substring(0, name.length() - variantType.getSuffix().length());
        }
        if (!variantType.getPrefix().isEmpty()) {
            name = StringHelper.appendCapitalized((String)variantType.getPrefix(), (String)name);
        }
        return name;
    }

    public TestVariantData createTestVariantData(BaseVariantData testedVariantData, VariantType type) {
        DefaultAndroidSourceSet testSourceSet;
        CoreBuildType buildType = (CoreBuildType)testedVariantData.getVariantConfiguration().getBuildType();
        BuildTypeData buildTypeData = this.buildTypes.get(buildType.getName());
        GradleVariantConfiguration testedConfig = testedVariantData.getVariantConfiguration();
        List productFlavorList = testedConfig.getProductFlavors();
        GradleVariantConfiguration testVariantConfig = testedConfig.getMyTestConfig(testSourceSet, (testSourceSet = this.defaultConfigData.getTestSourceSet(type)) != null ? this.getParser(testSourceSet.getManifestFile()) : null, buildTypeData.getTestSourceSet(type), type, this::canParseManifest);
        for (CoreProductFlavor productFlavor : productFlavorList) {
            ProductFlavorData<CoreProductFlavor> data = this.productFlavors.get(productFlavor.getName());
            String dimensionName = productFlavor.getDimension();
            if (dimensionName == null) {
                dimensionName = "";
            }
            testVariantConfig.addProductFlavor(data.getProductFlavor(), (SourceProvider)data.getTestSourceSet(type), dimensionName);
        }
        VariantManager.createCompoundSourceSets(productFlavorList, testVariantConfig, this.sourceSetManager);
        TestVariantData testVariantData = new TestVariantData(this.globalScope, this.taskManager, testVariantConfig, (TestedVariantData)((Object)testedVariantData), this.recorder);
        ((TestedVariantData)((Object)testedVariantData)).setTestVariantData(testVariantData, type);
        return testVariantData;
    }

    private void createVariantDataForProductFlavors(List<com.android.builder.model.ProductFlavor> productFlavorList) {
        for (VariantType variantType : this.variantFactory.getVariantConfigurationTypes()) {
            this.createVariantDataForProductFlavorsAndVariantType(productFlavorList, variantType);
        }
    }

    private void createVariantDataForProductFlavorsAndVariantType(List<com.android.builder.model.ProductFlavor> productFlavorList, VariantType variantType) {
        String restrictedVariantName;
        boolean projectMatch;
        boolean restrictVariants;
        TestedAndroidConfig testedExtension;
        BuildTypeData testBuildTypeData = null;
        if (this.extension instanceof TestedAndroidConfig && (testBuildTypeData = this.buildTypes.get((testedExtension = (TestedAndroidConfig)((Object)this.extension)).getTestBuildType())) == null) {
            throw new RuntimeException(String.format("Test Build Type '%1$s' does not exist.", testedExtension.getTestBuildType()));
        }
        BaseVariantData variantForAndroidTest = null;
        CoreProductFlavor defaultConfig = this.defaultConfigData.getProductFlavor();
        Action<com.android.build.api.variant.VariantFilter> variantFilterAction = this.extension.getVariantFilter();
        String restrictedProject = this.projectOptions.get(StringOption.IDE_RESTRICT_VARIANT_PROJECT);
        boolean bl = restrictVariants = restrictedProject != null;
        if (restrictVariants) {
            projectMatch = variantType.isApk() && this.project.getPath().equals(restrictedProject);
            restrictedVariantName = this.projectOptions.get(StringOption.IDE_RESTRICT_VARIANT_NAME);
        } else {
            projectMatch = false;
            restrictedVariantName = null;
        }
        for (BuildTypeData buildTypeData : this.buildTypes.values()) {
            VariantScope.Java8LangSupport supportType;
            boolean ignore = false;
            if (restrictVariants || variantFilterAction != null) {
                this.variantFilter.reset(defaultConfig, buildTypeData.getBuildType(), variantType, productFlavorList);
                if (restrictVariants) {
                    if (projectMatch) {
                        ignore = !this.variantFilter.getName().equals(restrictedVariantName);
                    }
                } else {
                    try {
                        variantFilterAction.execute((Object)this.variantFilter);
                    }
                    catch (Throwable t) {
                        throw new ExternalApiUsageException(t);
                    }
                    ignore = this.variantFilter.isIgnore();
                }
            }
            if (ignore) continue;
            BaseVariantData variantData = this.createVariantDataForVariantType(buildTypeData.getBuildType(), productFlavorList, variantType);
            this.addVariant(variantData);
            GradleVariantConfiguration variantConfig = variantData.getVariantConfiguration();
            VariantScope variantScope = variantData.getScope();
            int minSdkVersion = variantConfig.getMinSdkVersion().getApiLevel();
            int targetSdkVersion = variantConfig.getTargetSdkVersion().getApiLevel();
            if (minSdkVersion > 0 && targetSdkVersion > 0 && minSdkVersion > targetSdkVersion) {
                this.globalScope.getDslScope().getIssueReporter().reportWarning(EvalIssueReporter.Type.GENERIC, String.format(Locale.US, "minSdkVersion (%d) is greater than targetSdkVersion (%d) for variant \"%s\". Please change the values such that minSdkVersion is less than or equal to targetSdkVersion.", minSdkVersion, targetSdkVersion, variantData.getName()));
            }
            GradleBuildVariant.Builder profileBuilder = ProcessProfileWriter.getOrCreateVariant((String)this.project.getPath(), (String)variantData.getName()).setIsDebug(((CoreBuildType)variantConfig.getBuildType()).isDebuggable()).setMinSdkVersion(AnalyticsUtil.toProto(variantConfig.getMinSdkVersion())).setMinifyEnabled(variantScope.getCodeShrinker() != null).setUseMultidex(variantConfig.isMultiDexEnabled()).setUseLegacyMultidex(variantConfig.isLegacyMultiDexMode()).setVariantType(variantData.getType().getAnalyticsVariantType()).setDexBuilder(AnalyticsUtil.toProto(variantScope.getDexer())).setDexMerger(AnalyticsUtil.toProto(variantScope.getDexMerger())).setTestExecution(AnalyticsUtil.toProto(this.globalScope.getExtension().getTestOptions().getExecutionEnum()));
            if (variantScope.getCodeShrinker() != null) {
                profileBuilder.setCodeShrinker(AnalyticsUtil.toProto(variantScope.getCodeShrinker()));
            }
            if (variantConfig.getTargetSdkVersion().getApiLevel() > 0) {
                profileBuilder.setTargetSdkVersion(AnalyticsUtil.toProto(variantConfig.getTargetSdkVersion()));
            }
            if (variantConfig.getMergedFlavor().getMaxSdkVersion() != null) {
                profileBuilder.setMaxSdkVersion(ApiVersion.newBuilder().setApiLevel((long)variantConfig.getMergedFlavor().getMaxSdkVersion().intValue()));
            }
            if ((supportType = variantData.getScope().getJava8LangSupportType()) != VariantScope.Java8LangSupport.INVALID && supportType != VariantScope.Java8LangSupport.UNUSED) {
                profileBuilder.setJava8LangSupport(AnalyticsUtil.toProto(supportType));
            }
            if (!this.variantFactory.hasTestScope()) continue;
            if (buildTypeData == testBuildTypeData) {
                variantForAndroidTest = variantData;
            }
            if (variantType.isHybrid()) continue;
            TestVariantData unitTestVariantData = this.createTestVariantData(variantData, (VariantType)VariantTypeImpl.UNIT_TEST);
            this.addVariant(unitTestVariantData);
        }
        if (variantForAndroidTest != null && !variantType.isHybrid()) {
            TestVariantData androidTestVariantData = this.createTestVariantData(variantForAndroidTest, (VariantType)VariantTypeImpl.ANDROID_TEST);
            this.addVariant(androidTestVariantData);
        }
    }

    private static void checkName(String name, String displayName) {
        VariantManager.checkPrefix(name, displayName, "androidTest");
        VariantManager.checkPrefix(name, displayName, "test");
        if ("lint".equals(name)) {
            throw new RuntimeException(String.format("%1$s names cannot be %2$s", displayName, "lint"));
        }
    }

    private static void checkPrefix(String name, String displayName, String prefix) {
        if (name.startsWith(prefix)) {
            throw new RuntimeException(String.format("%1$s names cannot start with '%2$s'", displayName, prefix));
        }
    }

    private com.android.builder.model.SigningConfig createSigningOverride() {
        SigningOptions signingOptions = SigningOptions.readSigningOptions(this.projectOptions);
        if (signingOptions != null) {
            SigningConfig signingConfigDsl = new SigningConfig("externalOverride");
            signingConfigDsl.setStoreFile(new File(signingOptions.getStoreFile()));
            signingConfigDsl.setStorePassword(signingOptions.getStorePassword());
            signingConfigDsl.setKeyAlias(signingOptions.getKeyAlias());
            signingConfigDsl.setKeyPassword(signingOptions.getKeyPassword());
            if (signingOptions.getStoreType() != null) {
                signingConfigDsl.setStoreType(signingOptions.getStoreType());
            }
            if (signingOptions.getV1Enabled() != null) {
                signingConfigDsl.setV1SigningEnabled(signingOptions.getV1Enabled());
            }
            if (signingOptions.getV2Enabled() != null) {
                signingConfigDsl.setV2SigningEnabled(signingOptions.getV2Enabled());
            }
            return signingConfigDsl;
        }
        return null;
    }

    private ManifestAttributeSupplier getParser(File file) {
        return this.manifestParserMap.computeIfAbsent(file, f -> new DefaultManifestParser(f, this::canParseManifest, (EvalIssueReporter)this.globalScope.getErrorHandler()));
    }

    private boolean canParseManifest() {
        return this.hasCreatedTasks || !this.projectOptions.get(BooleanOption.DISABLE_EARLY_MANIFEST_PARSING);
    }

    public void setHasCreatedTasks(boolean hasCreatedTasks) {
        this.hasCreatedTasks = hasCreatedTasks;
    }

    public String getDefaultVariant(SyncIssueHandler syncIssueHandler) {
        this.finalizeDefaultVariantDsl();
        if (this.variantScopes.isEmpty()) {
            return null;
        }
        String chosenBuildType = this.getBuildAuthorSpecifiedDefaultBuildType(syncIssueHandler);
        Map<String, String> chosenFlavors = this.getBuildAuthorSpecifiedDefaultFlavors(syncIssueHandler);
        Comparator<VariantScope> preferredDefaultVariantScopeComparator = new BuildAuthorSpecifiedDefaultBuildTypeComparator(chosenBuildType).thenComparing(new BuildAuthorSpecifiedDefaultsFlavorComparator(chosenFlavors)).thenComparing(new DefaultBuildTypeComparator()).thenComparing(new DefaultFlavorComparator());
        Optional<VariantScope> defaultVariantScope = this.variantScopes.stream().filter(it -> !it.getType().isTestComponent()).filter(it -> !it.getType().isHybrid()).min(preferredDefaultVariantScopeComparator);
        return defaultVariantScope.map(TransformVariantScope::getFullVariantName).orElse(null);
    }

    private void finalizeDefaultVariantDsl() {
        for (BuildTypeData buildTypeData : this.buildTypes.values()) {
            buildTypeData.getBuildType().getIsDefault().finalizeValue();
        }
        for (ProductFlavorData productFlavorData : this.productFlavors.values()) {
            ((ProductFlavor)productFlavorData.getProductFlavor()).getIsDefault().finalizeValue();
        }
    }

    private String getBuildAuthorSpecifiedDefaultBuildType(SyncIssueHandler syncIssueHandler) {
        ArrayList<String> buildTypesMarkedAsDefault = new ArrayList<String>(1);
        for (BuildTypeData buildType : this.buildTypes.values()) {
            if (!((Boolean)buildType.getBuildType().getIsDefault().get()).booleanValue()) continue;
            buildTypesMarkedAsDefault.add(buildType.getBuildType().getName());
        }
        Collections.sort(buildTypesMarkedAsDefault);
        if (buildTypesMarkedAsDefault.size() > 1) {
            syncIssueHandler.reportWarning(EvalIssueReporter.Type.AMBIGUOUS_BUILD_TYPE_DEFAULT, "Ambiguous default build type: '" + Joiner.on((String)"', '").join(buildTypesMarkedAsDefault) + "'.\nPlease only set `isDefault = true` for one build type.", Joiner.on((char)',').join(buildTypesMarkedAsDefault));
        }
        if (buildTypesMarkedAsDefault.isEmpty()) {
            return null;
        }
        return (String)buildTypesMarkedAsDefault.get(0);
    }

    private Map<String, String> getBuildAuthorSpecifiedDefaultFlavors(SyncIssueHandler syncIssueHandler) {
        ArrayListMultimap userDefaults = ArrayListMultimap.create();
        for (ProductFlavorData<CoreProductFlavor> flavor : this.productFlavors.values()) {
            ProductFlavor productFlavor = (ProductFlavor)flavor.getProductFlavor();
            String dimension = productFlavor.getDimension();
            if (!((Boolean)productFlavor.getIsDefault().get()).booleanValue()) continue;
            userDefaults.put((Object)dimension, (Object)productFlavor.getName());
        }
        ImmutableMap.Builder defaults = ImmutableMap.builder();
        for (String dimension : userDefaults.keySet()) {
            List userDefault = userDefaults.get((Object)dimension);
            Collections.sort(userDefault);
            if (!userDefault.isEmpty()) {
                defaults.put((Object)dimension, userDefault.get(0));
            }
            if (userDefault.size() <= 1) continue;
            syncIssueHandler.reportWarning(EvalIssueReporter.Type.AMBIGUOUS_PRODUCT_FLAVOR_DEFAULT, "Ambiguous default product flavors for flavor dimension '" + dimension + "': '" + Joiner.on((String)"', '").join((Iterable)userDefault) + "'.\nPlease only set `isDefault = true` for one product flavor in each flavor dimension.", dimension);
        }
        return defaults.build();
    }

    private static class DefaultFlavorComparator
    implements Comparator<VariantScope> {
        private DefaultFlavorComparator() {
        }

        @Override
        public int compare(VariantScope v1, VariantScope v2) {
            for (int i2 = 0; i2 < v1.getVariantConfiguration().getProductFlavors().size(); ++i2) {
                String f2;
                String f1 = ((CoreProductFlavor)v1.getVariantConfiguration().getProductFlavors().get(i2)).getName();
                int diff = f1.compareTo(f2 = ((CoreProductFlavor)v2.getVariantConfiguration().getProductFlavors().get(i2)).getName());
                if (diff == 0) continue;
                return diff;
            }
            return 0;
        }
    }

    private static class DefaultBuildTypeComparator
    implements Comparator<VariantScope> {
        private DefaultBuildTypeComparator() {
        }

        @Override
        public int compare(VariantScope v1, VariantScope v2) {
            String b2;
            String b1 = ((CoreBuildType)v1.getVariantConfiguration().getBuildType()).getName();
            if (b1.equals(b2 = ((CoreBuildType)v2.getVariantConfiguration().getBuildType()).getName())) {
                return 0;
            }
            if (b1.equals("debug")) {
                return -1;
            }
            if (b2.equals("debug")) {
                return 1;
            }
            return b1.compareTo(b2);
        }
    }

    private static class BuildAuthorSpecifiedDefaultsFlavorComparator
    implements Comparator<VariantScope> {
        private final Map<String, String> defaultFlavors;

        BuildAuthorSpecifiedDefaultsFlavorComparator(Map<String, String> defaultFlavors) {
            this.defaultFlavors = defaultFlavors;
        }

        @Override
        public int compare(VariantScope v1, VariantScope v2) {
            int f1Score = 0;
            int f2Score = 0;
            for (CoreProductFlavor flavor : v1.getVariantConfiguration().getProductFlavors()) {
                if (!flavor.getName().equals(this.defaultFlavors.get(flavor.getDimension()))) continue;
                ++f1Score;
            }
            for (CoreProductFlavor flavor : v2.getVariantConfiguration().getProductFlavors()) {
                if (!flavor.getName().equals(this.defaultFlavors.get(flavor.getDimension()))) continue;
                ++f2Score;
            }
            return f2Score - f1Score;
        }
    }

    private static class BuildAuthorSpecifiedDefaultBuildTypeComparator
    implements Comparator<VariantScope> {
        private final String chosen;

        private BuildAuthorSpecifiedDefaultBuildTypeComparator(String chosen) {
            this.chosen = chosen;
        }

        @Override
        public int compare(VariantScope v1, VariantScope v2) {
            if (this.chosen == null) {
                return 0;
            }
            int b1Score = ((CoreBuildType)v1.getVariantConfiguration().getBuildType()).getName().equals(this.chosen) ? 1 : 0;
            int b2Score = ((CoreBuildType)v2.getVariantConfiguration().getBuildType()).getName().equals(this.chosen) ? 1 : 0;
            return b2Score - b1Score;
        }
    }
}

