/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.apksig.ApkSigner;
import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.FinalizeBundleTask$CreationAction$handleProvider$1;
import com.android.build.gradle.internal.tasks.FinalizeBundleTask$CreationAction$handleProvider$2;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.SigningConfigUtils;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.options.StringOption;
import com.android.builder.model.SigningConfig;
import com.android.ide.common.signing.CertificateInfo;
import com.android.ide.common.signing.KeystoreHelper;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.utils.FileUtils;
import java.io.Closeable;
import java.io.File;
import java.io.Serializable;
import java.security.PrivateKey;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001:\u0003\u0014\u0015\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0014R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8G\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R$\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u000e8G@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lcom/android/build/gradle/internal/tasks/FinalizeBundleTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "finalBundleFile", "Lorg/gradle/api/file/RegularFileProperty;", "getFinalBundleFile", "()Lorg/gradle/api/file/RegularFileProperty;", "finalBundleFileName", "", "getFinalBundleFileName", "()Ljava/lang/String;", "intermediaryBundleFile", "getIntermediaryBundleFile", "<set-?>", "Lorg/gradle/api/file/FileCollection;", "signingConfig", "getSigningConfig", "()Lorg/gradle/api/file/FileCollection;", "doTaskAction", "", "BundleToolRunnable", "CreationAction", "Params", "gradle"})
public abstract class FinalizeBundleTask
extends NonIncrementalTask {
    @Nullable
    private FileCollection signingConfig;

    @InputFiles
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @NotNull
    public abstract RegularFileProperty getIntermediaryBundleFile();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Optional
    @Nullable
    public final FileCollection getSigningConfig() {
        return this.signingConfig;
    }

    @Input
    @NotNull
    public final String getFinalBundleFileName() {
        Object object = this.getFinalBundleFile().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"finalBundleFile.get()");
        File file = ((RegularFile)object).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"finalBundleFile.get().asFile");
        String string = file.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"finalBundleFile.get().asFile.name");
        return string;
    }

    @OutputFile
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract RegularFileProperty getFinalBundleFile();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doTaskAction() {
        Closeable closeable = (Closeable)this.getWorkerFacadeWithWorkers();
        boolean bl = false;
        Throwable throwable = null;
        try {
            WorkerExecutorFacade it = (WorkerExecutorFacade)closeable;
            boolean bl2 = false;
            Object object = this.getIntermediaryBundleFile().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"intermediaryBundleFile.get()");
            File file = ((RegularFile)object).getAsFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"intermediaryBundleFile.get().asFile");
            Object object2 = this.getFinalBundleFile().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"finalBundleFile.get()");
            File file2 = ((RegularFile)object2).getAsFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"finalBundleFile.get().asFile");
            it.submit(BundleToolRunnable.class, (Serializable)new Params(file, file2, SigningConfigUtils.Companion.getOutputFile(this.signingConfig)));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static final /* synthetic */ FileCollection access$getSigningConfig$p(FinalizeBundleTask $this) {
        return $this.signingConfig;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J)\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0017"}, d2={"Lcom/android/build/gradle/internal/tasks/FinalizeBundleTask$Params;", "Ljava/io/Serializable;", "intermediaryBundleFile", "Ljava/io/File;", "finalBundleFile", "signingConfig", "(Ljava/io/File;Ljava/io/File;Ljava/io/File;)V", "getFinalBundleFile", "()Ljava/io/File;", "getIntermediaryBundleFile", "getSigningConfig", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "gradle"})
    private static final class Params
    implements Serializable {
        @NotNull
        private final File intermediaryBundleFile;
        @NotNull
        private final File finalBundleFile;
        @Nullable
        private final File signingConfig;

        @NotNull
        public final File getIntermediaryBundleFile() {
            return this.intermediaryBundleFile;
        }

        @NotNull
        public final File getFinalBundleFile() {
            return this.finalBundleFile;
        }

        @Nullable
        public final File getSigningConfig() {
            return this.signingConfig;
        }

        public Params(@NotNull File intermediaryBundleFile, @NotNull File finalBundleFile, @Nullable File signingConfig) {
            Intrinsics.checkParameterIsNotNull((Object)intermediaryBundleFile, (String)"intermediaryBundleFile");
            Intrinsics.checkParameterIsNotNull((Object)finalBundleFile, (String)"finalBundleFile");
            this.intermediaryBundleFile = intermediaryBundleFile;
            this.finalBundleFile = finalBundleFile;
            this.signingConfig = signingConfig;
        }

        @NotNull
        public final File component1() {
            return this.intermediaryBundleFile;
        }

        @NotNull
        public final File component2() {
            return this.finalBundleFile;
        }

        @Nullable
        public final File component3() {
            return this.signingConfig;
        }

        @NotNull
        public final Params copy(@NotNull File intermediaryBundleFile, @NotNull File finalBundleFile, @Nullable File signingConfig) {
            Intrinsics.checkParameterIsNotNull((Object)intermediaryBundleFile, (String)"intermediaryBundleFile");
            Intrinsics.checkParameterIsNotNull((Object)finalBundleFile, (String)"finalBundleFile");
            return new Params(intermediaryBundleFile, finalBundleFile, signingConfig);
        }

        public static /* synthetic */ Params copy$default(Params params, File file, File file2, File file3, int n, Object object) {
            if ((n & 1) != 0) {
                file = params.intermediaryBundleFile;
            }
            if ((n & 2) != 0) {
                file2 = params.finalBundleFile;
            }
            if ((n & 4) != 0) {
                file3 = params.signingConfig;
            }
            return params.copy(file, file2, file3);
        }

        @NotNull
        public String toString() {
            return "Params(intermediaryBundleFile=" + this.intermediaryBundleFile + ", finalBundleFile=" + this.finalBundleFile + ", signingConfig=" + this.signingConfig + ")";
        }

        public int hashCode() {
            File file = this.intermediaryBundleFile;
            File file2 = this.finalBundleFile;
            File file3 = this.signingConfig;
            return ((file != null ? ((Object)file).hashCode() : 0) * 31 + (file2 != null ? ((Object)file2).hashCode() : 0)) * 31 + (file3 != null ? ((Object)file3).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Params)) break block3;
                    Params params = (Params)object;
                    if (!Intrinsics.areEqual((Object)this.intermediaryBundleFile, (Object)params.intermediaryBundleFile) || !Intrinsics.areEqual((Object)this.finalBundleFile, (Object)params.finalBundleFile) || !Intrinsics.areEqual((Object)this.signingConfig, (Object)params.signingConfig)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/build/gradle/internal/tasks/FinalizeBundleTask$BundleToolRunnable;", "Ljava/lang/Runnable;", "params", "Lcom/android/build/gradle/internal/tasks/FinalizeBundleTask$Params;", "(Lcom/android/build/gradle/internal/tasks/FinalizeBundleTask$Params;)V", "run", "", "gradle"})
    private static final class BundleToolRunnable
    implements Runnable {
        private final Params params;

        @Override
        public void run() {
            FileUtils.cleanOutputDir((File)this.params.getFinalBundleFile().getParentFile());
            SigningConfig signingConfig = SigningConfigUtils.Companion.load(this.params.getSigningConfig());
            if (signingConfig != null) {
                SigningConfig signingConfig2 = signingConfig;
                boolean bl = false;
                boolean bl2 = false;
                SigningConfig it = signingConfig2;
                boolean bl3 = false;
                String string = it.getStoreType();
                File file = it.getStoreFile();
                if (file == null) {
                    Intrinsics.throwNpe();
                }
                String string2 = it.getStorePassword();
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                String string3 = it.getKeyPassword();
                if (string3 == null) {
                    Intrinsics.throwNpe();
                }
                String string4 = it.getKeyAlias();
                if (string4 == null) {
                    Intrinsics.throwNpe();
                }
                CertificateInfo certificateInfo = KeystoreHelper.getCertificateInfo((String)string, (File)file, (String)string2, (String)string3, (String)string4);
                String string5 = it.getKeyAlias();
                if (string5 == null) {
                    Intrinsics.throwNpe();
                }
                String string6 = string5;
                boolean bl4 = false;
                String string7 = string6;
                if (string7 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string8 = string7.toUpperCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.String).toUpperCase()");
                String string9 = string8;
                CertificateInfo certificateInfo2 = certificateInfo;
                Intrinsics.checkExpressionValueIsNotNull((Object)certificateInfo2, (String)"certificateInfo");
                List list = CollectionsKt.listOf((Object)certificateInfo.getCertificate());
                PrivateKey privateKey = certificateInfo2.getKey();
                String string10 = string9;
                ApkSigner.SignerConfig signingConfig3 = new ApkSigner.SignerConfig.Builder(string10, privateKey, list).build();
                new ApkSigner.Builder(CollectionsKt.listOf((Object)signingConfig3)).setOutputApk(this.params.getFinalBundleFile()).setInputApk(this.params.getIntermediaryBundleFile()).setV2SigningEnabled(false).setV3SigningEnabled(false).setMinSdkVersion(18).build().sign();
            } else {
                BundleToolRunnable bundleToolRunnable = this;
                boolean bl = false;
                boolean bl5 = false;
                BundleToolRunnable $this$run = bundleToolRunnable;
                boolean bl6 = false;
                FileUtils.copyFile((File)$this$run.params.getIntermediaryBundleFile(), (File)$this$run.params.getFinalBundleFile());
            }
        }

        @Inject
        public BundleToolRunnable(@NotNull Params params) {
            Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
            this.params = params;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0018\u0010\u0011\u001a\u00020\u000f2\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/tasks/FinalizeBundleTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/FinalizeBundleTask;", "variantScope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "(Lcom/android/build/gradle/internal/scope/VariantScope;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle"})
    public static final class CreationAction
    extends VariantTaskCreationAction<FinalizeBundleTask> {
        @Override
        @NotNull
        public String getName() {
            String string = this.getVariantScope().getTaskName("sign", "Bundle");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variantScope.getTaskName(\"sign\", \"Bundle\")");
            return string;
        }

        @Override
        @NotNull
        public Class<FinalizeBundleTask> getType() {
            return FinalizeBundleTask.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<? extends FinalizeBundleTask> taskProvider) {
            Intrinsics.checkParameterIsNotNull(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            StringBuilder stringBuilder = new StringBuilder();
            GlobalScope globalScope = this.getVariantScope().getGlobalScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)globalScope, (String)"variantScope.globalScope");
            StringBuilder stringBuilder2 = stringBuilder.append(globalScope.getProjectBaseName()).append('-');
            GradleVariantConfiguration gradleVariantConfiguration = this.getVariantScope().getVariantConfiguration();
            Intrinsics.checkExpressionValueIsNotNull((Object)gradleVariantConfiguration, (String)"variantScope.variantConfiguration");
            String bundleName = stringBuilder2.append(gradleVariantConfiguration.getBaseName()).append(".aab").toString();
            GlobalScope globalScope2 = this.getVariantScope().getGlobalScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)globalScope2, (String)"variantScope.globalScope");
            String apkLocationOverride = globalScope2.getProjectOptions().get(StringOption.IDE_APK_LOCATION);
            if (apkLocationOverride == null) {
                this.getVariantScope().getArtifacts().producesFile(InternalArtifactType.BUNDLE, BuildArtifactsHolder.OperationType.INITIAL, taskProvider, (Function1)FinalizeBundleTask$CreationAction$handleProvider$1.INSTANCE, bundleName);
            } else {
                BuildArtifactsHolder buildArtifactsHolder = this.getVariantScope().getArtifacts();
                ArtifactType artifactType = InternalArtifactType.BUNDLE;
                Function1 function1 = (Function1)FinalizeBundleTask$CreationAction$handleProvider$2.INSTANCE;
                GlobalScope globalScope3 = this.getVariantScope().getGlobalScope();
                Intrinsics.checkExpressionValueIsNotNull((Object)globalScope3, (String)"variantScope.globalScope");
                File file = globalScope3.getProject().file((Object)apkLocationOverride);
                String[] stringArray = new String[1];
                GradleVariantConfiguration gradleVariantConfiguration2 = this.getVariantScope().getVariantConfiguration();
                Intrinsics.checkExpressionValueIsNotNull((Object)gradleVariantConfiguration2, (String)"variantScope.variantConfiguration");
                stringArray[0] = gradleVariantConfiguration2.getDirName();
                File file2 = FileUtils.join((File)file, (String[])stringArray);
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"FileUtils.join(\n        \u2026antConfiguration.dirName)");
                buildArtifactsHolder.producesFile(artifactType, BuildArtifactsHolder.OperationType.INITIAL, taskProvider, function1, file2.getAbsolutePath(), bundleName);
            }
        }

        @Override
        public void configure(@NotNull FinalizeBundleTask task) {
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super.configure((Task)task);
            this.getVariantScope().getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.INTERMEDIARY_BUNDLE, (Property)task.getIntermediaryBundleFile());
            GradleVariantConfiguration gradleVariantConfiguration = this.getVariantScope().getVariantConfiguration();
            Intrinsics.checkExpressionValueIsNotNull((Object)gradleVariantConfiguration, (String)"variantScope.variantConfiguration");
            CoreBuildType coreBuildType = (CoreBuildType)gradleVariantConfiguration.getBuildType();
            Intrinsics.checkExpressionValueIsNotNull((Object)coreBuildType, (String)"variantScope.variantConfiguration.buildType");
            if (!coreBuildType.isDebuggable()) {
                task.signingConfig = this.getVariantScope().getSigningConfigFileCollection();
            }
        }

        public CreationAction(@NotNull VariantScope variantScope) {
            Intrinsics.checkParameterIsNotNull((Object)variantScope, (String)"variantScope");
            super(variantScope);
        }
    }
}

