/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks.databinding;

import android.databinding.tool.LayoutXmlProcessor;
import android.databinding.tool.processing.Scope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.options.BooleanOption;
import java.io.File;
import java.util.function.Supplier;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskProvider;

public abstract class DataBindingExportBuildInfoTask
extends NonIncrementalTask {
    @Internal
    private Supplier<LayoutXmlProcessor> xmlProcessor;
    private boolean useAndroidX;
    private File emptyClassOutDir;

    @Input
    public boolean isUseAndroidX() {
        return this.useAndroidX;
    }

    @OutputDirectory
    public File getEmptyClassOutDir() {
        return this.emptyClassOutDir;
    }

    @Override
    protected void doTaskAction() {
        this.xmlProcessor.get().writeEmptyInfoClass(this.useAndroidX);
        Scope.assertNoError();
    }

    public static class CreationAction
    extends VariantTaskCreationAction<DataBindingExportBuildInfoTask> {
        public CreationAction(VariantScope variantScope) {
            super(variantScope);
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("dataBindingExportBuildInfo");
        }

        @Override
        public Class<DataBindingExportBuildInfoTask> getType() {
            return DataBindingExportBuildInfoTask.class;
        }

        @Override
        public void handleProvider(TaskProvider<? extends DataBindingExportBuildInfoTask> taskProvider) {
            super.handleProvider(taskProvider);
            this.getVariantScope().getTaskContainer().setDataBindingExportBuildInfoTask(taskProvider);
        }

        @Override
        public void configure(DataBindingExportBuildInfoTask task) {
            super.configure(task);
            VariantScope variantScope = this.getVariantScope();
            task.xmlProcessor = variantScope.getVariantData()::getLayoutXmlProcessor;
            task.useAndroidX = variantScope.getGlobalScope().getProjectOptions().get(BooleanOption.USE_ANDROID_X);
            task.emptyClassOutDir = variantScope.getClassOutputForDataBinding();
            task.dependsOn(new Object[]{variantScope.getTaskContainer().getSourceGenTask()});
        }
    }
}

