/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks.structureplugin;

import com.android.build.gradle.internal.tasks.structureplugin.AndroidCollector;
import com.android.build.gradle.internal.tasks.structureplugin.DependencyCollector;
import com.android.build.gradle.internal.tasks.structureplugin.KotlinUsageCollector;
import com.android.build.gradle.internal.tasks.structureplugin.ModuleInfo;
import com.android.build.gradle.internal.tasks.structureplugin.SourceFilesCollector;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/internal/tasks/structureplugin/GatherModuleInfoTask;", "Lorg/gradle/api/DefaultTask;", "()V", "moduleDataHolder", "Lcom/android/build/gradle/internal/tasks/structureplugin/ModuleInfo;", "<set-?>", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/RegularFile;", "outputProvider", "getOutputProvider", "()Lorg/gradle/api/provider/Provider;", "sourceProjectName", "", "action", "", "ConfigAction", "gradle"})
public class GatherModuleInfoTask
extends DefaultTask {
    private String sourceProjectName;
    @NotNull
    private Provider<RegularFile> outputProvider;
    private ModuleInfo moduleDataHolder = new ModuleInfo(null, null, null, false, null, null, 0, false, null, null, 1023, null);

    @NotNull
    public final Provider<RegularFile> getOutputProvider() {
        Provider<RegularFile> provider = this.outputProvider;
        if (provider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputProvider");
        }
        return provider;
    }

    @TaskAction
    public final void action() {
        new AndroidCollector().collectInto(this.moduleDataHolder, this);
        new DependencyCollector().collectInto(this.moduleDataHolder, this);
        new KotlinUsageCollector().collectInto(this.moduleDataHolder, this);
        new SourceFilesCollector().collectInto(this.moduleDataHolder, this);
        String string = this.sourceProjectName;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sourceProjectName");
        }
        this.moduleDataHolder.setName(StringsKt.replace$default((String)string, (char)':', (char)'_', (boolean)false, (int)4, null));
        Provider<RegularFile> provider = this.outputProvider;
        if (provider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputProvider");
        }
        Object object = provider.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"outputProvider.get()");
        File file = ((RegularFile)object).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"outputProvider.get().asFile");
        this.moduleDataHolder.saveAsJsonTo(file);
    }

    public static final /* synthetic */ String access$getSourceProjectName$p(GatherModuleInfoTask $this) {
        String string = $this.sourceProjectName;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sourceProjectName");
        }
        return string;
    }

    public static final /* synthetic */ Provider access$getOutputProvider$p(GatherModuleInfoTask $this) {
        Provider<RegularFile> provider = $this.outputProvider;
        if (provider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputProvider");
        }
        return provider;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/build/gradle/internal/tasks/structureplugin/GatherModuleInfoTask$ConfigAction;", "Lorg/gradle/api/Action;", "Lcom/android/build/gradle/internal/tasks/structureplugin/GatherModuleInfoTask;", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "execute", "", "task", "gradle"})
    public static final class ConfigAction
    implements Action<GatherModuleInfoTask> {
        private final Project project;

        public void execute(@NotNull GatherModuleInfoTask task) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
            String string = this.project.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.name");
            task.sourceProjectName = string;
            ProjectLayout projectLayout = this.project.getLayout();
            Intrinsics.checkExpressionValueIsNotNull((Object)projectLayout, (String)"project.layout");
            Provider provider = projectLayout.getBuildDirectory().file("local-module-info.json");
            Intrinsics.checkExpressionValueIsNotNull((Object)provider, (String)"project.layout.buildDire\u2026\"local-module-info.json\")");
            task.outputProvider = provider;
        }

        public ConfigAction(@NotNull Project project2) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            this.project = project2;
        }
    }
}

