/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.TaskInputHelper;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.builder.compiling.BuildConfigGenerator;
import com.android.builder.model.ClassField;
import com.android.utils.FileUtils;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Task;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CacheableTask
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001:\u0001:B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u00108\u001a\u000209H\u0014R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u00048G\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u00048G\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u00020\u00048GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0006\"\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00048G\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0006R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u00188G\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00180\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\u001d8G\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001eR\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001d0\bX\u0082.\u00a2\u0006\u0002\n\u0000R \u0010!\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u001d8G@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001eR\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040\u00188G\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u001aR\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u00188G\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u001aR\u001a\u0010'\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0\u00180\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010(\u001a\u00020\u00118gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0013R\u001c\u0010*\u001a\u00020+8GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u0011\u00100\u001a\u0002018G\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u0014\u00104\u001a\b\u0012\u0004\u0012\u0002010\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0013\u00105\u001a\u0004\u0018\u00010\u00048G\u00a2\u0006\u0006\u001a\u0004\b6\u0010\u0006R\u0016\u00107\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/android/build/gradle/tasks/GenerateBuildConfig;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "appPackageName", "", "getAppPackageName", "()Ljava/lang/String;", "appPackageNameSupplier", "Ljava/util/function/Supplier;", "buildConfigPackageName", "getBuildConfigPackageName", "buildConfigPackageNameSupplier", "buildTypeName", "getBuildTypeName", "setBuildTypeName", "(Ljava/lang/String;)V", "checkManifestResult", "Lorg/gradle/api/file/DirectoryProperty;", "getCheckManifestResult", "()Lorg/gradle/api/file/DirectoryProperty;", "flavorName", "getFlavorName", "flavorNameSupplier", "flavorNamesWithDimensionNames", "", "getFlavorNamesWithDimensionNames", "()Ljava/util/List;", "flavorNamesWithDimensionNamesSupplier", "isDebuggable", "", "()Z", "isDebuggableSupplier", "<set-?>", "isLibrary", "itemValues", "getItemValues", "items", "", "getItems", "itemsSupplier", "mergedManifests", "getMergedManifests", "sourceOutputDir", "Ljava/io/File;", "getSourceOutputDir", "()Ljava/io/File;", "setSourceOutputDir", "(Ljava/io/File;)V", "versionCode", "", "getVersionCode", "()I", "versionCodeSupplier", "versionName", "getVersionName", "versionNameSupplier", "doTaskAction", "", "CreationAction", "gradle"})
public abstract class GenerateBuildConfig
extends NonIncrementalTask {
    @NotNull
    public File sourceOutputDir;
    private Supplier<String> buildConfigPackageNameSupplier;
    private Supplier<String> appPackageNameSupplier;
    private Supplier<Boolean> isDebuggableSupplier;
    private Supplier<String> flavorNameSupplier;
    private Supplier<List<String>> flavorNamesWithDimensionNamesSupplier;
    @NotNull
    public String buildTypeName;
    private Supplier<String> versionNameSupplier;
    private Supplier<Integer> versionCodeSupplier;
    private Supplier<List<Object>> itemsSupplier;
    private boolean isLibrary;

    @OutputDirectory
    @NotNull
    public final File getSourceOutputDir() {
        File file = this.sourceOutputDir;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sourceOutputDir");
        }
        return file;
    }

    public final void setSourceOutputDir(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"<set-?>");
        this.sourceOutputDir = file;
    }

    @Input
    @NotNull
    public final String getBuildTypeName() {
        String string = this.buildTypeName;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buildTypeName");
        }
        return string;
    }

    public final void setBuildTypeName(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.buildTypeName = string;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @Optional
    @NotNull
    public abstract DirectoryProperty getCheckManifestResult();

    @Input
    public final boolean isLibrary() {
        return this.isLibrary;
    }

    @Input
    @NotNull
    public final String getBuildConfigPackageName() {
        Supplier<String> supplier = this.buildConfigPackageNameSupplier;
        if (supplier == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buildConfigPackageNameSupplier");
        }
        String string = supplier.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"buildConfigPackageNameSupplier.get()");
        return string;
    }

    @Input
    @Optional
    @Nullable
    public final String getAppPackageName() {
        String string;
        if (this.isLibrary) {
            string = null;
        } else {
            Supplier<String> supplier = this.appPackageNameSupplier;
            if (supplier == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"appPackageNameSupplier");
            }
            string = supplier.get();
        }
        return string;
    }

    @Input
    public final boolean isDebuggable() {
        Supplier<Boolean> supplier = this.isDebuggableSupplier;
        if (supplier == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"isDebuggableSupplier");
        }
        Boolean bl = supplier.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"isDebuggableSupplier.get()");
        return bl;
    }

    @Input
    @NotNull
    public final String getFlavorName() {
        Supplier<String> supplier = this.flavorNameSupplier;
        if (supplier == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"flavorNameSupplier");
        }
        String string = supplier.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"flavorNameSupplier.get()");
        return string;
    }

    @Input
    @NotNull
    public final List<String> getFlavorNamesWithDimensionNames() {
        Supplier<List<String>> supplier = this.flavorNamesWithDimensionNamesSupplier;
        if (supplier == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"flavorNamesWithDimensionNamesSupplier");
        }
        List<String> list = supplier.get();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"flavorNamesWithDimensionNamesSupplier.get()");
        return list;
    }

    @Input
    @Optional
    @Nullable
    public final String getVersionName() {
        Supplier<String> supplier = this.versionNameSupplier;
        if (supplier == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"versionNameSupplier");
        }
        return supplier.get();
    }

    @Input
    public final int getVersionCode() {
        Supplier<Integer> supplier = this.versionCodeSupplier;
        if (supplier == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"versionCodeSupplier");
        }
        Integer n = supplier.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"versionCodeSupplier.get()");
        return ((Number)n).intValue();
    }

    @Input
    @NotNull
    public final List<String> getItemValues() {
        List<Object> resolvedItems = this.getItems();
        ArrayList list = Lists.newArrayListWithCapacity((int)(resolvedItems.size() * 3));
        for (Object item : resolvedItems) {
            if (item instanceof String) {
                list.add(item);
                continue;
            }
            if (!(item instanceof ClassField)) continue;
            list.add(((ClassField)item).getType());
            list.add(((ClassField)item).getName());
            list.add(((ClassField)item).getValue());
        }
        ArrayList arrayList = list;
        Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"list");
        return arrayList;
    }

    @Internal
    @NotNull
    public final List<Object> getItems() {
        Supplier<List<Object>> supplier = this.itemsSupplier;
        if (supplier == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"itemsSupplier");
        }
        List<Object> list = supplier.get();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"itemsSupplier.get()");
        return list;
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract DirectoryProperty getMergedManifests();

    @Override
    protected void doTaskAction() {
        File file = this.sourceOutputDir;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sourceOutputDir");
        }
        File destinationDir = file;
        FileUtils.cleanOutputDir((File)destinationDir);
        File file2 = this.sourceOutputDir;
        if (file2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sourceOutputDir");
        }
        BuildConfigGenerator generator = new BuildConfigGenerator(file2, this.getBuildConfigPackageName());
        generator.addField("boolean", "DEBUG", this.isDebuggable() ? "Boolean.parseBoolean(\"true\")" : "false");
        if (this.isLibrary) {
            generator.addField("String", "LIBRARY_PACKAGE_NAME", "\"" + this.getBuildConfigPackageName() + "\"").addDeprecatedField("String", "APPLICATION_ID", "\"" + this.getBuildConfigPackageName() + "\"", "@deprecated APPLICATION_ID is misleading in libraries. For the library package name use LIBRARY_PACKAGE_NAME");
        } else {
            generator.addField("String", "APPLICATION_ID", "\"" + this.getAppPackageName() + "\"");
        }
        StringBuilder stringBuilder = new StringBuilder().append("\"");
        String string = this.buildTypeName;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buildTypeName");
        }
        generator.addField("String", "BUILD_TYPE", stringBuilder.append(string).append("\"").toString()).addField("String", "FLAVOR", "\"" + this.getFlavorName() + "\"").addField("int", "VERSION_CODE", Integer.toString(this.getVersionCode())).addField("String", "VERSION_NAME", "\"" + Strings.nullToEmpty((String)this.getVersionName()) + "\"").addItems((Collection)this.getItems());
        List<String> flavors = this.getFlavorNamesWithDimensionNames();
        int count = flavors.size();
        if (count > 1) {
            for (int i2 = 0; i2 < count; i2 += 2) {
                generator.addField("String", "FLAVOR_" + flavors.get(i2 + 1), "\"" + flavors.get(i2) + "\"");
            }
        }
        generator.generate();
    }

    public static final /* synthetic */ Supplier access$getBuildConfigPackageNameSupplier$p(GenerateBuildConfig $this) {
        Supplier<String> supplier = $this.buildConfigPackageNameSupplier;
        if (supplier == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buildConfigPackageNameSupplier");
        }
        return supplier;
    }

    public static final /* synthetic */ Supplier access$getAppPackageNameSupplier$p(GenerateBuildConfig $this) {
        Supplier<String> supplier = $this.appPackageNameSupplier;
        if (supplier == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"appPackageNameSupplier");
        }
        return supplier;
    }

    public static final /* synthetic */ Supplier access$getVersionNameSupplier$p(GenerateBuildConfig $this) {
        Supplier<String> supplier = $this.versionNameSupplier;
        if (supplier == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"versionNameSupplier");
        }
        return supplier;
    }

    public static final /* synthetic */ Supplier access$getVersionCodeSupplier$p(GenerateBuildConfig $this) {
        Supplier<Integer> supplier = $this.versionCodeSupplier;
        if (supplier == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"versionCodeSupplier");
        }
        return supplier;
    }

    public static final /* synthetic */ Supplier access$isDebuggableSupplier$p(GenerateBuildConfig $this) {
        Supplier<Boolean> supplier = $this.isDebuggableSupplier;
        if (supplier == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"isDebuggableSupplier");
        }
        return supplier;
    }

    public static final /* synthetic */ Supplier access$getFlavorNameSupplier$p(GenerateBuildConfig $this) {
        Supplier<String> supplier = $this.flavorNameSupplier;
        if (supplier == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"flavorNameSupplier");
        }
        return supplier;
    }

    public static final /* synthetic */ Supplier access$getFlavorNamesWithDimensionNamesSupplier$p(GenerateBuildConfig $this) {
        Supplier<List<String>> supplier = $this.flavorNamesWithDimensionNamesSupplier;
        if (supplier == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"flavorNamesWithDimensionNamesSupplier");
        }
        return supplier;
    }

    public static final /* synthetic */ Supplier access$getItemsSupplier$p(GenerateBuildConfig $this) {
        Supplier<List<Object>> supplier = $this.itemsSupplier;
        if (supplier == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"itemsSupplier");
        }
        return supplier;
    }

    public static final /* synthetic */ boolean access$isLibrary$p(GenerateBuildConfig $this) {
        return $this.isLibrary;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0018\u0010\u0011\u001a\u00020\u000f2\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/tasks/GenerateBuildConfig$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/tasks/GenerateBuildConfig;", "scope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "(Lcom/android/build/gradle/internal/scope/VariantScope;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle"})
    public static final class CreationAction
    extends VariantTaskCreationAction<GenerateBuildConfig> {
        @NotNull
        private final String name;
        @NotNull
        private final Class<GenerateBuildConfig> type;

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public Class<GenerateBuildConfig> getType() {
            return this.type;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<? extends GenerateBuildConfig> taskProvider) {
            Intrinsics.checkParameterIsNotNull(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            this.getVariantScope().getTaskContainer().setGenerateBuildConfigTask(taskProvider);
        }

        @Override
        public void configure(@NotNull GenerateBuildConfig task) {
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super.configure((Task)task);
            BaseVariantData baseVariantData = this.getVariantScope().getVariantData();
            Intrinsics.checkExpressionValueIsNotNull((Object)baseVariantData, (String)"variantScope.variantData");
            BaseVariantData variantData = baseVariantData;
            GradleVariantConfiguration gradleVariantConfiguration = variantData.getVariantConfiguration();
            Intrinsics.checkExpressionValueIsNotNull((Object)gradleVariantConfiguration, (String)"variantData.variantConfiguration");
            GradleVariantConfiguration variantConfiguration = gradleVariantConfiguration;
            Supplier supplier = TaskInputHelper.memoize(new Supplier<T>(variantConfiguration){
                final /* synthetic */ GradleVariantConfiguration $variantConfiguration;

                @NotNull
                public final String get() {
                    return this.$variantConfiguration.getOriginalApplicationId();
                }
                {
                    this.$variantConfiguration = gradleVariantConfiguration;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull(supplier, (String)"TaskInputHelper.memoize \u2026n.originalApplicationId }");
            task.buildConfigPackageNameSupplier = supplier;
            Supplier supplier2 = TaskInputHelper.memoize(new Supplier<T>(variantConfiguration){
                final /* synthetic */ GradleVariantConfiguration $variantConfiguration;

                @NotNull
                public final String get() {
                    return this.$variantConfiguration.getApplicationId();
                }
                {
                    this.$variantConfiguration = gradleVariantConfiguration;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull(supplier2, (String)"TaskInputHelper.memoize \u2026iguration.applicationId }");
            task.appPackageNameSupplier = supplier2;
            Supplier supplier3 = TaskInputHelper.memoize(new Supplier<T>(variantConfiguration){
                final /* synthetic */ GradleVariantConfiguration $variantConfiguration;

                @Nullable
                public final String get() {
                    return this.$variantConfiguration.getVersionName();
                }
                {
                    this.$variantConfiguration = gradleVariantConfiguration;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull(supplier3, (String)"TaskInputHelper.memoize \u2026nfiguration.versionName }");
            task.versionNameSupplier = supplier3;
            Supplier supplier4 = TaskInputHelper.memoize(new Supplier<T>(variantConfiguration){
                final /* synthetic */ GradleVariantConfiguration $variantConfiguration;

                public final int get() {
                    return this.$variantConfiguration.getVersionCode();
                }
                {
                    this.$variantConfiguration = gradleVariantConfiguration;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull(supplier4, (String)"TaskInputHelper.memoize \u2026nfiguration.versionCode }");
            task.versionCodeSupplier = supplier4;
            Supplier supplier5 = TaskInputHelper.memoize(new Supplier<T>(variantConfiguration){
                final /* synthetic */ GradleVariantConfiguration $variantConfiguration;

                public final boolean get() {
                    CoreBuildType coreBuildType = (CoreBuildType)this.$variantConfiguration.getBuildType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)coreBuildType, (String)"variantConfiguration.buildType");
                    return coreBuildType.isDebuggable();
                }
                {
                    this.$variantConfiguration = gradleVariantConfiguration;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull(supplier5, (String)"TaskInputHelper.memoize \u2026.buildType.isDebuggable }");
            task.isDebuggableSupplier = supplier5;
            CoreBuildType coreBuildType = (CoreBuildType)variantConfiguration.getBuildType();
            Intrinsics.checkExpressionValueIsNotNull((Object)coreBuildType, (String)"variantConfiguration.buildType");
            String string = coreBuildType.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variantConfiguration.buildType.name");
            task.setBuildTypeName(string);
            task.flavorNameSupplier = new Supplier<String>(variantConfiguration){
                final /* synthetic */ GradleVariantConfiguration $variantConfiguration;

                @NotNull
                public final String get() {
                    return this.$variantConfiguration.getFlavorName();
                }
                {
                    this.$variantConfiguration = gradleVariantConfiguration;
                }
            };
            Supplier supplier6 = TaskInputHelper.memoize(new Supplier<T>(variantConfiguration){
                final /* synthetic */ GradleVariantConfiguration $variantConfiguration;

                @NotNull
                public final List<String> get() {
                    return this.$variantConfiguration.getFlavorNamesWithDimensionNames();
                }
                {
                    this.$variantConfiguration = gradleVariantConfiguration;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull(supplier6, (String)"TaskInputHelper.memoize \u2026NamesWithDimensionNames }");
            task.flavorNamesWithDimensionNamesSupplier = supplier6;
            Supplier supplier7 = TaskInputHelper.memoize(new Supplier<T>(variantConfiguration){
                final /* synthetic */ GradleVariantConfiguration $variantConfiguration;

                @NotNull
                public final List<Object> get() {
                    return this.$variantConfiguration.getBuildConfigItems();
                }
                {
                    this.$variantConfiguration = gradleVariantConfiguration;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull(supplier7, (String)"TaskInputHelper.memoize \u2026ration.buildConfigItems }");
            task.itemsSupplier = supplier7;
            File file = this.getVariantScope().getBuildConfigSourceOutputDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"variantScope.buildConfigSourceOutputDir");
            task.setSourceOutputDir(file);
            this.getVariantScope().getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.CHECK_MANIFEST_RESULT, (Property)task.getCheckManifestResult());
            GradleVariantConfiguration gradleVariantConfiguration2 = this.getVariantScope().getVariantConfiguration();
            Intrinsics.checkExpressionValueIsNotNull((Object)gradleVariantConfiguration2, (String)"variantScope.variantConfiguration");
            if (gradleVariantConfiguration2.getType().isTestComponent()) {
                this.getVariantScope().getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.MERGED_MANIFESTS, (Property)task.getMergedManifests());
            }
            task.isLibrary = variantConfiguration.getType().isAar();
        }

        public CreationAction(@NotNull VariantScope scope) {
            Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
            super(scope);
            String string = scope.getTaskName("generate", "BuildConfig");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"scope.getTaskName(\"generate\", \"BuildConfig\")");
            this.name = string;
            this.type = GenerateBuildConfig.class;
        }
    }
}

