/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.internal.dependency.AarTransformUtil;
import com.android.build.gradle.internal.dependency.ExtractProGuardRulesTransform;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.utils.FileUtils;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.gradle.api.artifacts.transform.ArtifactTransform;

public class AarTransform
extends ArtifactTransform {
    private final AndroidArtifacts.ArtifactType targetType;
    private final boolean sharedLibSupport;
    private final boolean autoNamespaceDependencies;

    @Inject
    public AarTransform(AndroidArtifacts.ArtifactType targetType, boolean sharedLibSupport, boolean autoNamespaceDependencies) {
        this.targetType = targetType;
        this.sharedLibSupport = sharedLibSupport;
        this.autoNamespaceDependencies = autoNamespaceDependencies;
    }

    public static AndroidArtifacts.ArtifactType[] getTransformTargets() {
        return new AndroidArtifacts.ArtifactType[]{AndroidArtifacts.ArtifactType.NON_NAMESPACED_CLASSES, AndroidArtifacts.ArtifactType.SHARED_CLASSES, AndroidArtifacts.ArtifactType.JAVA_RES, AndroidArtifacts.ArtifactType.SHARED_JAVA_RES, AndroidArtifacts.ArtifactType.PROCESSED_JAR, AndroidArtifacts.ArtifactType.JAR, AndroidArtifacts.ArtifactType.MANIFEST, AndroidArtifacts.ArtifactType.NON_NAMESPACED_MANIFEST, AndroidArtifacts.ArtifactType.ANDROID_RES, AndroidArtifacts.ArtifactType.ASSETS, AndroidArtifacts.ArtifactType.SHARED_ASSETS, AndroidArtifacts.ArtifactType.JNI, AndroidArtifacts.ArtifactType.SHARED_JNI, AndroidArtifacts.ArtifactType.AIDL, AndroidArtifacts.ArtifactType.RENDERSCRIPT, AndroidArtifacts.ArtifactType.UNFILTERED_PROGUARD_RULES, AndroidArtifacts.ArtifactType.LINT, AndroidArtifacts.ArtifactType.ANNOTATIONS, AndroidArtifacts.ArtifactType.PUBLIC_RES, AndroidArtifacts.ArtifactType.COMPILE_SYMBOL_LIST, AndroidArtifacts.ArtifactType.DATA_BINDING_ARTIFACT, AndroidArtifacts.ArtifactType.DATA_BINDING_BASE_CLASS_LOG_ARTIFACT, AndroidArtifacts.ArtifactType.COMPILE_ONLY_NAMESPACED_R_CLASS_JAR, AndroidArtifacts.ArtifactType.RES_STATIC_LIBRARY, AndroidArtifacts.ArtifactType.RES_SHARED_STATIC_LIBRARY};
    }

    public List<File> transform(File input) {
        switch (this.targetType) {
            case CLASSES: {
                return AarTransformUtil.shouldBeAutoNamespaced(input, this.autoNamespaceDependencies) || this.isShared(input) ? Collections.emptyList() : AarTransformUtil.getJars(input);
            }
            case NON_NAMESPACED_CLASSES: {
                return AarTransformUtil.shouldBeAutoNamespaced(input, this.autoNamespaceDependencies) ? AarTransformUtil.getJars(input) : Collections.emptyList();
            }
            case JAVA_RES: 
            case PROCESSED_JAR: 
            case JAR: {
                return this.isShared(input) ? Collections.emptyList() : AarTransformUtil.getJars(input);
            }
            case SHARED_CLASSES: 
            case SHARED_JAVA_RES: {
                return this.isShared(input) ? AarTransformUtil.getJars(input) : Collections.emptyList();
            }
            case LINT: {
                return AarTransform.listIfExists(FileUtils.join((File)input, (String[])new String[]{"jars", "lint.jar"}));
            }
            case MANIFEST: {
                if (AarTransformUtil.shouldBeAutoNamespaced(input, this.autoNamespaceDependencies)) {
                    return Collections.emptyList();
                }
                if (this.isShared(input)) {
                    return AarTransform.listIfExists(Stream.of(new File(input, "AndroidManifest.xml"), new File(input, "SharedLibraryAndroidManifest.xml")));
                }
                return AarTransform.listIfExists(new File(input, "AndroidManifest.xml"));
            }
            case NON_NAMESPACED_MANIFEST: {
                return AarTransformUtil.shouldBeAutoNamespaced(input, this.autoNamespaceDependencies) ? AarTransform.listIfExists(new File(input, "AndroidManifest.xml")) : Collections.emptyList();
            }
            case ANDROID_RES: {
                return AarTransform.listIfExists(new File(input, "res"));
            }
            case ASSETS: {
                return AarTransform.listIfExists(new File(input, "assets"));
            }
            case JNI: {
                return AarTransform.listIfExists(new File(input, "jni"));
            }
            case AIDL: {
                return AarTransform.listIfExists(new File(input, "aidl"));
            }
            case RENDERSCRIPT: {
                return AarTransform.listIfExists(new File(input, "rs"));
            }
            case UNFILTERED_PROGUARD_RULES: {
                List<File> list = ExtractProGuardRulesTransform.performTransform(FileUtils.join((File)input, (String[])new String[]{"jars", "classes.jar"}), this.getOutputDirectory(), false);
                return list.isEmpty() ? AarTransform.listIfExists(new File(input, "proguard.txt")) : list;
            }
            case ANNOTATIONS: {
                return AarTransform.listIfExists(new File(input, "annotations.zip"));
            }
            case PUBLIC_RES: {
                return AarTransform.listIfExists(new File(input, "public.txt"));
            }
            case COMPILE_SYMBOL_LIST: {
                return AarTransform.listIfExists(new File(input, "R.txt"));
            }
            case RES_STATIC_LIBRARY: {
                return this.isShared(input) ? Collections.emptyList() : AarTransform.listIfExists(new File(input, "res.apk"));
            }
            case RES_SHARED_STATIC_LIBRARY: {
                return this.isShared(input) ? AarTransform.listIfExists(new File(input, "shared.apk")) : Collections.emptyList();
            }
            case COMPILE_ONLY_NAMESPACED_R_CLASS_JAR: {
                return AarTransform.listIfExists(new File(input, "R.jar"));
            }
            case DATA_BINDING_ARTIFACT: {
                return AarTransform.listIfExists(new File(input, "data-binding"));
            }
            case DATA_BINDING_BASE_CLASS_LOG_ARTIFACT: {
                return AarTransform.listIfExists(new File(input, "data-binding-base-class-log"));
            }
        }
        throw new RuntimeException("Unsupported type in AarTransform: " + (Object)((Object)this.targetType));
    }

    private boolean isShared(File explodedAar) {
        return this.sharedLibSupport && new File(explodedAar, "SharedLibraryAndroidManifest.xml").exists();
    }

    private static List<File> listIfExists(File file) {
        return file.exists() ? Collections.singletonList(file) : Collections.emptyList();
    }

    private static List<File> listIfExists(Stream<File> files) {
        return files.filter(File::exists).collect(Collectors.toList());
    }
}

