/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.internal.dependency.AndroidXDepedencySubstitution;
import com.android.build.gradle.internal.errors.SyncIssueHandler;
import com.android.build.gradle.options.BooleanOption;
import com.android.builder.errors.EvalIssueReporter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/build/gradle/internal/dependency/AndroidXDependencyCheck;", "Lorg/gradle/api/Action;", "Lorg/gradle/api/artifacts/ResolvableDependencies;", "syncIssueHandler", "Lcom/android/build/gradle/internal/errors/SyncIssueHandler;", "(Lcom/android/build/gradle/internal/errors/SyncIssueHandler;)V", "execute", "", "resolvableDependencies", "gradle"})
public final class AndroidXDependencyCheck
implements Action<ResolvableDependencies> {
    private final SyncIssueHandler syncIssueHandler;

    public void execute(@NotNull ResolvableDependencies resolvableDependencies) {
        Collection artifact;
        Intrinsics.checkParameterIsNotNull((Object)resolvableDependencies, (String)"resolvableDependencies");
        HashSet<String> androidXDependencies = new HashSet<String>();
        ResolutionResult resolutionResult = resolvableDependencies.getResolutionResult();
        Intrinsics.checkExpressionValueIsNotNull((Object)resolutionResult, (String)"resolvableDependencies.resolutionResult");
        Iterator iterator = resolutionResult.getAllComponents().iterator();
        while (iterator.hasNext()) {
            String dependency;
            Collection collection = artifact = (ResolvedComponentResult)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"artifact");
            ComponentIdentifier artifactId = collection.getId();
            if (!(artifactId instanceof ModuleComponentIdentifier) || !AndroidXDepedencySubstitution.isAndroidXDependency(dependency = ((ModuleComponentIdentifier)artifactId).getGroup() + ':' + ((ModuleComponentIdentifier)artifactId).getModule() + ':' + ((ModuleComponentIdentifier)artifactId).getVersion())) continue;
            androidXDependencies.add(dependency);
        }
        artifact = androidXDependencies;
        boolean bl = false;
        if (!artifact.isEmpty()) {
            String androidXDepList = CollectionsKt.joinToString$default((Iterable)androidXDependencies, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            String message = "This project uses AndroidX dependencies, but the" + " '" + BooleanOption.USE_ANDROID_X.getPropertyName() + "' property is not enabled." + " Set this property to true in the gradle.properties file and retry.\n" + "The following AndroidX dependencies are detected: " + androidXDepList;
            if (!this.syncIssueHandler.hasSyncIssue(EvalIssueReporter.Type.ANDROID_X_PROPERTY_NOT_ENABLED)) {
                EvalIssueReporter.reportError$default((EvalIssueReporter)this.syncIssueHandler, (EvalIssueReporter.Type)EvalIssueReporter.Type.ANDROID_X_PROPERTY_NOT_ENABLED, (String)message, (String)androidXDepList, null, (int)8, null);
            }
        }
    }

    public AndroidXDependencyCheck(@NotNull SyncIssueHandler syncIssueHandler) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)syncIssueHandler), (String)"syncIssueHandler");
        this.syncIssueHandler = syncIssueHandler;
    }
}

