/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import android.databinding.tool.DataBindingBuilder;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.internal.FeatureTaskManager;
import com.android.build.gradle.internal.LibraryTaskManager;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.build.gradle.options.ProjectOptions;
import com.android.builder.core.VariantType;
import com.android.builder.core.VariantTypeImpl;
import com.android.builder.profile.Recorder;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public class MultiTypeTaskManager
extends TaskManager {
    Map<VariantType, TaskManager> delegates;

    public MultiTypeTaskManager(GlobalScope globalScope, Project project2, ProjectOptions projectOptions, DataBindingBuilder dataBindingBuilder, BaseExtension extension, VariantFactory variantFactory, ToolingModelBuilderRegistry toolingRegistry, Recorder recorder) {
        super(globalScope, project2, projectOptions, dataBindingBuilder, extension, variantFactory, toolingRegistry, recorder);
        FeatureTaskManager featureTaskManager = new FeatureTaskManager(globalScope, project2, projectOptions, dataBindingBuilder, extension, variantFactory, toolingRegistry, recorder);
        this.delegates = ImmutableMap.of((Object)VariantTypeImpl.FEATURE, (Object)featureTaskManager, (Object)VariantTypeImpl.BASE_FEATURE, (Object)featureTaskManager, (Object)VariantTypeImpl.LIBRARY, (Object)new LibraryTaskManager(globalScope, project2, projectOptions, dataBindingBuilder, extension, variantFactory, toolingRegistry, recorder));
    }

    @Override
    public void createTasksForVariantScope(VariantScope variantScope, List<VariantScope> variantScopesForLint) {
        this.delegates.get(variantScope.getType()).createTasksForVariantScope(variantScope, variantScopesForLint);
    }

    @Override
    protected Set<QualifiedContent.ScopeType> getJavaResMergingScopes(VariantScope variantScope, QualifiedContent.ContentType contentType) {
        VariantType variantType = variantScope.getType();
        if (variantType.isTestComponent()) {
            variantType = variantScope.getTestedVariantData().getType();
        }
        return this.delegates.get(variantType).getJavaResMergingScopes(variantScope, contentType);
    }

    @Override
    protected void postJavacCreation(VariantScope scope) {
        ConfigurableFileCollection files = scope.getGlobalScope().getProject().files(new Object[]{scope.getArtifacts().getFinalProduct(InternalArtifactType.JAVAC), scope.getVariantData().getAllPreJavacGeneratedBytecode(), scope.getVariantData().getAllPostJavacGeneratedBytecode()});
        scope.getArtifacts().appendToAllClasses((FileCollection)files);
    }
}

