/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dependency.DexingArtifactConfiguration;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.sdklib.AndroidVersion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.attributes.Attribute;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u001e\n\u0000\u001a\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0010\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0004\"\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0004\u00a8\u0006\u0011"}, d2={"ATTR_ENABLE_DESUGARING", "Lorg/gradle/api/attributes/Attribute;", "", "getATTR_ENABLE_DESUGARING", "()Lorg/gradle/api/attributes/Attribute;", "ATTR_IS_DEBUGGABLE", "getATTR_IS_DEBUGGABLE", "ATTR_MIN_SDK", "getATTR_MIN_SDK", "getDexingArtifactConfiguration", "Lcom/android/build/gradle/internal/dependency/DexingArtifactConfiguration;", "scope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "getDexingArtifactConfigurations", "", "scopes", "", "gradle"})
public final class DexingTransformKt {
    @NotNull
    private static final Attribute<String> ATTR_MIN_SDK;
    @NotNull
    private static final Attribute<String> ATTR_IS_DEBUGGABLE;
    @NotNull
    private static final Attribute<String> ATTR_ENABLE_DESUGARING;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<DexingArtifactConfiguration> getDexingArtifactConfigurations(@NotNull Collection<? extends VariantScope> scopes) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(scopes, (String)"scopes");
        Iterable $this$map$iv = scopes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VariantScope variantScope = (VariantScope)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            DexingArtifactConfiguration dexingArtifactConfiguration = DexingTransformKt.getDexingArtifactConfiguration((VariantScope)it);
            collection.add(dexingArtifactConfiguration);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public static final DexingArtifactConfiguration getDexingArtifactConfiguration(@NotNull VariantScope scope) {
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        GradleVariantConfiguration gradleVariantConfiguration = scope.getVariantConfiguration();
        Intrinsics.checkExpressionValueIsNotNull((Object)gradleVariantConfiguration, (String)"scope.variantConfiguration");
        AndroidVersion androidVersion = gradleVariantConfiguration.getMinSdkVersionWithTargetDeviceApi();
        Intrinsics.checkExpressionValueIsNotNull((Object)androidVersion, (String)"scope.variantConfigurati\u2026ersionWithTargetDeviceApi");
        int minSdk = androidVersion.getFeatureLevel();
        GradleVariantConfiguration gradleVariantConfiguration2 = scope.getVariantConfiguration();
        Intrinsics.checkExpressionValueIsNotNull((Object)gradleVariantConfiguration2, (String)"scope.variantConfiguration");
        CoreBuildType coreBuildType = (CoreBuildType)gradleVariantConfiguration2.getBuildType();
        Intrinsics.checkExpressionValueIsNotNull((Object)coreBuildType, (String)"scope.variantConfiguration.buildType");
        boolean debuggable = coreBuildType.isDebuggable();
        boolean enableDesugaring = scope.getJava8LangSupportType() == VariantScope.Java8LangSupport.D8;
        return new DexingArtifactConfiguration(minSdk, debuggable, enableDesugaring);
    }

    @NotNull
    public static final Attribute<String> getATTR_MIN_SDK() {
        return ATTR_MIN_SDK;
    }

    @NotNull
    public static final Attribute<String> getATTR_IS_DEBUGGABLE() {
        return ATTR_IS_DEBUGGABLE;
    }

    @NotNull
    public static final Attribute<String> getATTR_ENABLE_DESUGARING() {
        return ATTR_ENABLE_DESUGARING;
    }

    static {
        Attribute attribute = Attribute.of((String)"dexing-min-sdk", String.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)attribute, (String)"Attribute.of(\"dexing-min-sdk\", String::class.java)");
        ATTR_MIN_SDK = attribute;
        Attribute attribute2 = Attribute.of((String)"dexing-is-debuggable", String.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)attribute2, (String)"Attribute.of(\"dexing-is-\u2026ble\", String::class.java)");
        ATTR_IS_DEBUGGABLE = attribute2;
        Attribute attribute3 = Attribute.of((String)"dexing-enable-desugaring", String.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)attribute3, (String)"Attribute.of(\"dexing-ena\u2026ing\", String::class.java)");
        ATTR_ENABLE_DESUGARING = attribute3;
    }
}

