/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.ide.common.symbols.SymbolIo;
import com.android.ide.common.xml.AndroidManifestParser;
import com.google.common.collect.ImmutableList;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import javax.inject.Inject;
import javax.xml.parsers.ParserConfigurationException;
import org.gradle.api.artifacts.transform.ArtifactTransform;
import org.xml.sax.SAXException;

public class LibrarySymbolTableTransform
extends ArtifactTransform {
    @Inject
    public LibrarySymbolTableTransform() {
    }

    public List<File> transform(File explodedAar) {
        try {
            Path result = LibrarySymbolTableTransform.transform(explodedAar.toPath(), this.getOutputDirectory().toPath());
            return result != null ? ImmutableList.of((Object)result.toFile()) : ImmutableList.of();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static Path transform(Path explodedAar, Path outputDirectory) throws IOException {
        Path manifest = explodedAar.resolve("AndroidManifest.xml");
        if (!Files.exists(manifest, new LinkOption[0])) {
            return null;
        }
        String packageName = LibrarySymbolTableTransform.getPackageName(manifest);
        Path rTxt = explodedAar.resolve("R.txt");
        Files.createDirectories(outputDirectory, new FileAttribute[0]);
        Path outputFile = outputDirectory.resolve(packageName + "-r.txt");
        SymbolIo.writeSymbolListWithPackageName((Path)rTxt, (String)packageName, (Path)outputFile);
        return outputFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getPackageName(Path manifest) throws IOException {
        try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(manifest, new OpenOption[0]));){
            String string = AndroidManifestParser.parse((InputStream)is).getPackage();
            return string;
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException("Failed to get package name from manifest " + manifest.toAbsolutePath(), e);
        }
    }
}

