/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.plugins;

import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.ide.common.repository.GradleVersion;
import java.io.File;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lcom/android/build/gradle/internal/plugins/VersionCheckPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "project", "Companion", "gradle"})
public final class VersionCheckPlugin
implements Plugin<Project> {
    @JvmField
    public static final GradleVersion GRADLE_MIN_VERSION;
    public static final Companion Companion;

    public void apply(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        ProjectOptions projectOptions = new ProjectOptions(project2);
        Logger logger = project2.getLogger();
        Gradle gradle = project2.getGradle();
        Intrinsics.checkExpressionValueIsNotNull((Object)gradle, (String)"project.gradle");
        String currentVersion = gradle.getGradleVersion();
        if (GRADLE_MIN_VERSION.compareTo(currentVersion) > 0) {
            File file = new File("gradle" + File.separator + "wrapper" + File.separator + "gradle-wrapper.properties");
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Minimum supported Gradle version is " + GRADLE_MIN_VERSION + ". Current version is " + currentVersion + ". " + "If using the gradle wrapper, try editing the distributionUrl in " + file.getAbsolutePath() + ' ' + "to gradle-" + GRADLE_MIN_VERSION + "-all.zip";
            Object[] objectArray = new Object[]{};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            String errorMessage = string2;
            if (projectOptions.get(BooleanOption.VERSION_CHECK_OVERRIDE_PROPERTY)) {
                logger.warn(errorMessage);
                logger.warn("As " + BooleanOption.VERSION_CHECK_OVERRIDE_PROPERTY.getPropertyName() + " is set, continuing anyway.");
            } else {
                throw (Throwable)new RuntimeException(errorMessage);
            }
        }
    }

    static {
        Companion = new Companion(null);
        GRADLE_MIN_VERSION = GradleVersion.parse((String)"5.5");
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/build/gradle/internal/plugins/VersionCheckPlugin$Companion;", "", "()V", "GRADLE_MIN_VERSION", "Lcom/android/ide/common/repository/GradleVersion;", "kotlin.jvm.PlatformType", "gradle"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

