/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.coverage.JacocoConfigurations;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.tasks.JacocoTaskDelegate;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.options.BooleanOption;
import com.android.builder.dexing.DexerTool;
import com.android.ide.common.workers.WorkerExecutorFacade;
import java.io.IOException;
import java.io.UncheckedIOException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;

@CacheableTask
public abstract class JacocoTask
extends AndroidVariantTask {
    private FileCollection jacocoAntTaskConfiguration;
    private FileCollection inputClasses;
    private JacocoTaskDelegate delegate;
    private WorkerExecutorFacade.IsolationMode isolationMode;

    @InputFiles
    public FileCollection getJacocoAntTaskConfiguration() {
        return this.jacocoAntTaskConfiguration;
    }

    @InputFiles
    public FileCollection getInputClasses() {
        return this.inputClasses;
    }

    @Input
    public WorkerExecutorFacade.IsolationMode getIsolationMode() {
        return this.isolationMode;
    }

    @OutputDirectory
    public abstract DirectoryProperty getOutput();

    @OutputDirectory
    public abstract DirectoryProperty getOutputJars();

    public static String getJacocoVersion(VariantScope scope) {
        if (scope.getDexer() == DexerTool.DX) {
            return "0.7.4.201502262128";
        }
        return scope.getGlobalScope().getExtension().getJacoco().getVersion();
    }

    @TaskAction
    public void run(IncrementalTaskInputs inputs) {
        this.recordTaskAction((Function0<Unit>)((Function0)() -> {
            try (WorkerExecutorFacade workers = this.getWorkerFacadeWithWorkers();){
                this.delegate.run(workers, inputs);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return null;
        }));
    }

    public static class CreationAction
    extends VariantTaskCreationAction<JacocoTask> {
        public CreationAction(VariantScope scope) {
            super(scope);
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("jacoco");
        }

        @Override
        public Class<JacocoTask> getType() {
            return JacocoTask.class;
        }

        @Override
        public void handleProvider(TaskProvider<? extends JacocoTask> taskProvider) {
            super.handleProvider(taskProvider);
            this.getVariantScope().getArtifacts().producesDir(InternalArtifactType.JACOCO_INSTRUMENTED_CLASSES, BuildArtifactsHolder.OperationType.INITIAL, taskProvider, JacocoTask::getOutput, "out");
            this.getVariantScope().getArtifacts().producesDir(InternalArtifactType.JACOCO_INSTRUMENTED_JARS, BuildArtifactsHolder.OperationType.INITIAL, taskProvider, JacocoTask::getOutputJars, "out");
        }

        @Override
        public void configure(JacocoTask task) {
            super.configure(task);
            VariantScope scope = this.getVariantScope();
            task.inputClasses = scope.getArtifacts().getAllClasses();
            task.jacocoAntTaskConfiguration = (FileCollection)JacocoConfigurations.getJacocoAntTaskConfiguration(scope.getGlobalScope().getProject(), JacocoTask.getJacocoVersion(scope));
            task.isolationMode = scope.getGlobalScope().getProjectOptions().get(BooleanOption.FORCE_JACOCO_OUT_OF_PROCESS) ? WorkerExecutorFacade.IsolationMode.PROCESS : WorkerExecutorFacade.IsolationMode.CLASSLOADER;
            task.delegate = new JacocoTaskDelegate(task.jacocoAntTaskConfiguration, (Provider<Directory>)task.getOutput(), (Provider<Directory>)task.getOutputJars(), task.inputClasses, task.isolationMode);
        }
    }
}

