/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.VariantOutput;
import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.BuildElements;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.PackageForUnitTest$CreationAction$handleProvider$1;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.utils.FileUtils;
import com.android.utils.PathUtils;
import com.google.common.base.Joiner;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u0013H\u0000\u00a2\u0006\u0002\b\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0014R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lcom/android/build/gradle/internal/tasks/PackageForUnitTest;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "apkForUnitTest", "Lorg/gradle/api/file/RegularFileProperty;", "getApkForUnitTest", "()Lorg/gradle/api/file/RegularFileProperty;", "mergedAssets", "Lorg/gradle/api/provider/ListProperty;", "Lorg/gradle/api/file/Directory;", "getMergedAssets", "()Lorg/gradle/api/provider/ListProperty;", "resApk", "Lorg/gradle/api/file/DirectoryProperty;", "getResApk", "()Lorg/gradle/api/file/DirectoryProperty;", "apkFrom", "Ljava/io/File;", "compiledResourcesZip", "Lorg/gradle/api/provider/Provider;", "apkFrom$gradle", "doTaskAction", "", "CreationAction", "gradle"})
public abstract class PackageForUnitTest
extends NonIncrementalTask {
    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract DirectoryProperty getResApk();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract ListProperty<Directory> getMergedAssets();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getApkForUnitTest();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doTaskAction() throws IOException {
        Object object = this.getApkForUnitTest().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"apkForUnitTest.get()");
        File apkForUnitTest = ((RegularFile)object).getAsFile();
        FileUtils.copyFile((File)this.apkFrom$gradle((Provider<Directory>)((Provider)this.getResApk())), (File)apkForUnitTest);
        URI uri = URI.create("jar:" + apkForUnitTest.toURI());
        Closeable closeable = FileSystems.newFileSystem(uri, MapsKt.emptyMap());
        boolean bl = false;
        Throwable throwable = null;
        try {
            FileSystem apkFs = (FileSystem)closeable;
            boolean bl2 = false;
            Path apkAssetsPath = apkFs.getPath("/assets", new String[0]);
            Iterator iterator = ((List)this.getMergedAssets().get()).iterator();
            while (iterator.hasNext()) {
                Directory mergedAsset;
                Directory directory = mergedAsset = (Directory)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)directory, (String)"mergedAsset");
                Path mergedAssetsPath = directory.getAsFile().toPath();
                Files.walkFileTree(mergedAssetsPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(mergedAssetsPath, apkAssetsPath){
                    final /* synthetic */ Path $mergedAssetsPath;
                    final /* synthetic */ Path $apkAssetsPath;

                    @NotNull
                    public FileVisitResult visitFile(@NotNull Path path, @NotNull BasicFileAttributes basicFileAttributes) throws IOException {
                        Path destPath;
                        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
                        Intrinsics.checkParameterIsNotNull((Object)basicFileAttributes, (String)"basicFileAttributes");
                        String relativePath = PathUtils.toSystemIndependentPath((Path)this.$mergedAssetsPath.relativize(path));
                        Path path2 = destPath = this.$apkAssetsPath.resolve(relativePath);
                        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"destPath");
                        Files.createDirectories(path2.getParent(), new FileAttribute[0]);
                        Files.copy(path, destPath, new CopyOption[0]);
                        return FileVisitResult.CONTINUE;
                    }
                    {
                        this.$mergedAssetsPath = $captured_local_variable$0;
                        this.$apkAssetsPath = $captured_local_variable$1;
                    }
                });
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public final File apkFrom$gradle(@NotNull Provider<Directory> compiledResourcesZip) {
        Intrinsics.checkParameterIsNotNull(compiledResourcesZip, (String)"compiledResourcesZip");
        BuildElements builtElements = ExistingBuildElements.Companion.from((ArtifactType)InternalArtifactType.PROCESSED_RES, compiledResourcesZip);
        if (builtElements.size() == 1) {
            File file = ((BuildOutput)CollectionsKt.first((Iterable)builtElements)).getOutputFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"builtElements.first().outputFile");
            return file;
        }
        Iterable $this$forEach$iv = builtElements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BuildOutput buildOutput = (BuildOutput)element$iv;
            boolean bl = false;
            if (buildOutput.getFilters().isEmpty()) {
                File file = buildOutput.getOutputFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"buildOutput.outputFile");
                return file;
            }
            if (buildOutput.getFilters().size() != 1 || buildOutput.getFilter(VariantOutput.FilterType.ABI.name()) == null) continue;
            File file = buildOutput.getOutputFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"buildOutput.outputFile");
            return file;
        }
        if (builtElements.isEmpty()) {
            throw (Throwable)new RuntimeException("No resources build output, please file a bug.");
        }
        StringBuilder sb = new StringBuilder("Found following build outputs : \n");
        Iterable $this$forEach$iv2 = builtElements;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            BuildOutput it = (BuildOutput)element$iv;
            boolean bl = false;
            sb.append("BuildOutput: " + Joiner.on((char)',').join((Iterable)it.getFilters()) + '\n');
        }
        sb.append("Cannot find a build output with all resources, please file a bug.");
        throw (Throwable)new RuntimeException(sb.toString());
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0018\u0010\u0011\u001a\u00020\u000f2\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/tasks/PackageForUnitTest$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/PackageForUnitTest;", "scope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "(Lcom/android/build/gradle/internal/scope/VariantScope;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle"})
    public static final class CreationAction
    extends VariantTaskCreationAction<PackageForUnitTest> {
        @NotNull
        private final String name;
        @NotNull
        private final Class<PackageForUnitTest> type;

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public Class<PackageForUnitTest> getType() {
            return this.type;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<? extends PackageForUnitTest> taskProvider) {
            Intrinsics.checkParameterIsNotNull(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            this.getVariantScope().getArtifacts().producesFile(InternalArtifactType.APK_FOR_LOCAL_TEST, BuildArtifactsHolder.OperationType.INITIAL, taskProvider, (Function1)PackageForUnitTest$CreationAction$handleProvider$1.INSTANCE, "apk-for-local-test.ap_");
        }

        @Override
        public void configure(@NotNull PackageForUnitTest task) {
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super.configure((Task)task);
            BuildArtifactsHolder buildArtifactsHolder = this.getVariantScope().getArtifacts();
            Intrinsics.checkExpressionValueIsNotNull((Object)buildArtifactsHolder, (String)"variantScope.artifacts");
            BuildArtifactsHolder artifacts2 = buildArtifactsHolder;
            artifacts2.setTaskInputToFinalProduct(InternalArtifactType.PROCESSED_RES, (Property)task.getResApk());
            artifacts2.setTaskInputToFinalProducts(InternalArtifactType.MERGED_ASSETS, task.getMergedAssets());
        }

        public CreationAction(@NotNull VariantScope scope) {
            Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
            super(scope);
            String string = this.getVariantScope().getTaskName("package", "ForUnitTest");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variantScope.getTaskName(\"package\", \"ForUnitTest\")");
            this.name = string;
            this.type = PackageForUnitTest.class;
        }
    }
}

