/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.factory.TaskCreationAction;
import com.android.utils.FileUtils;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;

public abstract class PrepareLintJar
extends DefaultTask {
    public static final String NAME = "prepareLintJar";
    private FileCollection lintChecks;

    @Classpath
    public FileCollection getLintChecks() {
        return this.lintChecks;
    }

    @OutputFile
    public abstract RegularFileProperty getOutputLintJar();

    @TaskAction
    public void prepare() throws IOException {
        Set files = this.lintChecks.getFiles();
        if (files.size() > 1) {
            throw new RuntimeException("Found more than one jar in the 'lintChecks' configuration. Only one file is supported. If using a separate Gradle project, make sure compilation dependencies are using compileOnly");
        }
        if (!files.isEmpty()) {
            File outputDir = ((RegularFile)this.getOutputLintJar().get()).getAsFile();
            FileUtils.deleteRecursivelyIfExists((File)outputDir);
            FileUtils.mkdirs((File)outputDir.getParentFile());
            Files.copy((File)((File)Iterables.getOnlyElement((Iterable)files)), (File)outputDir);
        }
    }

    public static class CreationAction
    extends TaskCreationAction<PrepareLintJar> {
        private final GlobalScope scope;

        public CreationAction(GlobalScope scope) {
            this.scope = scope;
        }

        @Override
        public String getName() {
            return PrepareLintJar.NAME;
        }

        @Override
        public Class<PrepareLintJar> getType() {
            return PrepareLintJar.class;
        }

        @Override
        public void handleProvider(TaskProvider<? extends PrepareLintJar> taskProvider) {
            super.handleProvider(taskProvider);
            this.scope.getArtifacts().producesFile(InternalArtifactType.LINT_JAR, BuildArtifactsHolder.OperationType.INITIAL, taskProvider, PrepareLintJar::getOutputLintJar, "lint.jar");
        }

        @Override
        public void configure(PrepareLintJar task) {
            task.lintChecks = this.scope.getLocalCustomLintChecks();
        }
    }
}

