/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.utils;

import com.android.build.gradle.internal.utils.DesugarLibUtils;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.FileCollection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u000e\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"DESUGAR_LIB_CONFIG_NAME", "", "getArtifactCollection", "Lorg/gradle/api/file/FileCollection;", "configuration", "Lorg/gradle/api/artifacts/Configuration;", "getDesugarLibJarFromMaven", "project", "Lorg/gradle/api/Project;", "gradle"})
@JvmName(name="DesugarLibUtils")
public final class DesugarLibUtils {
    private static final String DESUGAR_LIB_CONFIG_NAME = "_internal_desugar_jdk_libs";

    @NotNull
    public static final FileCollection getDesugarLibJarFromMaven(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Configuration existingConfig = (Configuration)project2.getConfigurations().findByName(DESUGAR_LIB_CONFIG_NAME);
        if (existingConfig != null) {
            return DesugarLibUtils.getArtifactCollection(existingConfig);
        }
        Configuration config2 = (Configuration)project2.getConfigurations().create(DESUGAR_LIB_CONFIG_NAME, (Action)getDesugarLibJarFromMaven.config.1.INSTANCE);
        DependencyHandler dependencyHandler = project2.getDependencies();
        Configuration configuration2 = config2;
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration2, (String)"config");
        dependencyHandler.add(configuration2.getName(), (Object)MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"group", (Object)"com.android.tools"), TuplesKt.to((Object)"name", (Object)"desugar_jdk_libs"), TuplesKt.to((Object)"version", (Object)"1.0.0")}));
        return DesugarLibUtils.getArtifactCollection(config2);
    }

    private static final FileCollection getArtifactCollection(Configuration configuration2) {
        ArtifactView artifactView = configuration2.getIncoming().artifactView((Action)getArtifactCollection.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)artifactView, (String)"configuration.incoming.a\u2026        )\n        }\n    }");
        ArtifactCollection artifactCollection = artifactView.getArtifacts();
        Intrinsics.checkExpressionValueIsNotNull((Object)artifactCollection, (String)"configuration.incoming.a\u2026        }\n    }.artifacts");
        FileCollection fileCollection2 = artifactCollection.getArtifactFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection2, (String)"configuration.incoming.a\u2026}.artifacts.artifactFiles");
        return fileCollection2;
    }
}

