/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.res.namespaced;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.internal.res.LinkApplicationAndroidResourcesTask;
import com.android.build.gradle.internal.res.namespaced.AutoNamespaceDependenciesTask;
import com.android.build.gradle.internal.res.namespaced.CompileRClassTaskCreationAction;
import com.android.build.gradle.internal.res.namespaced.CompileSourceSetResources;
import com.android.build.gradle.internal.res.namespaced.CreateNonNamespacedLibraryManifestTask;
import com.android.build.gradle.internal.res.namespaced.GenerateNamespacedLibraryRFilesTask;
import com.android.build.gradle.internal.res.namespaced.LinkLibraryAndroidResourcesTask;
import com.android.build.gradle.internal.res.namespaced.ProcessAndroidAppResourcesTask;
import com.android.build.gradle.internal.res.namespaced.StaticLibraryManifestTask;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.factory.TaskFactory;
import com.android.build.gradle.internal.tasks.factory.TaskFactoryUtils;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.options.BooleanOption;
import com.android.utils.StringHelper;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0002J(\u0010\u000b\u001a\u00020\n2\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\n2\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rH\u0002J&\u0010\u0014\u001a\u00020\n2\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/internal/res/namespaced/NamespacedResourcesTaskManager;", "", "globalScope", "Lcom/android/build/gradle/internal/scope/GlobalScope;", "taskFactory", "Lcom/android/build/gradle/internal/tasks/factory/TaskFactory;", "variantScope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "(Lcom/android/build/gradle/internal/scope/GlobalScope;Lcom/android/build/gradle/internal/tasks/factory/TaskFactory;Lcom/android/build/gradle/internal/scope/VariantScope;)V", "createCompileResourcesTask", "", "createNamespacedAppProcessTask", "packageOutputType", "Lcom/android/build/api/artifact/ArtifactType;", "Lorg/gradle/api/file/Directory;", "baseName", "", "useAaptToGenerateLegacyMultidexMainDexProguardRules", "", "createNamespacedLibraryTestProcessResourcesTask", "createNamespacedResourceTasks", "gradle"})
public final class NamespacedResourcesTaskManager {
    private final GlobalScope globalScope;
    private final TaskFactory taskFactory;
    private final VariantScope variantScope;

    public final void createNamespacedResourceTasks(@Nullable ArtifactType<Directory> packageOutputType, @NotNull String baseName, boolean useAaptToGenerateLegacyMultidexMainDexProguardRules) {
        Intrinsics.checkParameterIsNotNull((Object)baseName, (String)"baseName");
        if (this.globalScope.getProjectOptions().get(BooleanOption.CONVERT_NON_NAMESPACED_DEPENDENCIES)) {
            TaskProvider task = this.taskFactory.register(new AutoNamespaceDependenciesTask.CreationAction(this.variantScope));
            TaskFactoryUtils.dependsOn(this.variantScope.getTaskContainer().getSourceGenTask(), new TaskProvider[]{task});
        }
        this.createCompileResourcesTask();
        this.taskFactory.register(new CreateNonNamespacedLibraryManifestTask.CreationAction(this.variantScope));
        this.taskFactory.register(new StaticLibraryManifestTask.CreationAction(this.variantScope));
        this.taskFactory.register(new LinkLibraryAndroidResourcesTask.CreationAction(this.variantScope));
        this.taskFactory.register(new GenerateNamespacedLibraryRFilesTask.CreationAction(this.variantScope));
        if (this.variantScope.getType().isTestComponent()) {
            BaseVariantData baseVariantData = this.variantScope.getTestedVariantData();
            if (baseVariantData == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)baseVariantData, (String)"variantScope.testedVariantData!!");
            if (baseVariantData.getType().isAar()) {
                this.createNamespacedLibraryTestProcessResourcesTask(packageOutputType);
            } else {
                this.createNamespacedAppProcessTask(packageOutputType, baseName, false);
            }
        } else if (this.variantScope.getType().isApk()) {
            this.createNamespacedAppProcessTask(packageOutputType, baseName, useAaptToGenerateLegacyMultidexMainDexProguardRules);
        }
        this.taskFactory.register(new CompileRClassTaskCreationAction(this.variantScope));
    }

    private final void createNamespacedAppProcessTask(ArtifactType<Directory> packageOutputType, String baseName, boolean useAaptToGenerateLegacyMultidexMainDexProguardRules) {
        this.taskFactory.register(new LinkApplicationAndroidResourcesTask.NamespacedCreationAction(this.variantScope, useAaptToGenerateLegacyMultidexMainDexProguardRules, baseName));
        if (packageOutputType != null) {
            this.variantScope.getArtifacts().republish(InternalArtifactType.PROCESSED_RES.INSTANCE, packageOutputType);
        }
    }

    private final void createNamespacedLibraryTestProcessResourcesTask(ArtifactType<Directory> packageOutputType) {
        this.taskFactory.register(new ProcessAndroidAppResourcesTask.CreationAction(this.variantScope));
        if (packageOutputType != null) {
            this.variantScope.getArtifacts().republish(InternalArtifactType.PROCESSED_RES.INSTANCE, packageOutputType);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void createCompileResourcesTask() {
        BaseVariantData baseVariantData = this.variantScope.getVariantData();
        Intrinsics.checkExpressionValueIsNotNull((Object)baseVariantData, (String)"variantScope.variantData");
        LinkedHashMap<String, FileCollection> linkedHashMap = baseVariantData.getAndroidResources();
        Intrinsics.checkExpressionValueIsNotNull(linkedHashMap, (String)"variantScope.variantData.androidResources");
        Object object = linkedHashMap;
        boolean bl = false;
        Iterator iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            void sourceSetName;
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            boolean bl2 = false;
            object = (String)entry2.getKey();
            entry2 = entry;
            bl2 = false;
            FileCollection artifacts2 = (FileCollection)entry2.getValue();
            StringBuilder stringBuilder = new StringBuilder();
            void v3 = sourceSetName;
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"sourceSetName");
            StringBuilder stringBuilder2 = stringBuilder.append(StringHelper.appendCapitalized((String)"compile", (String)v3));
            String string = this.variantScope.getFullVariantName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variantScope.fullVariantName");
            String name = stringBuilder2.append(StringHelper.appendCapitalized((String)"ResourcesFor", (String)string)).toString();
            FileCollection fileCollection2 = artifacts2;
            Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection2, (String)"artifacts");
            this.taskFactory.register(new CompileSourceSetResources.CreationAction(name, fileCollection2, this.variantScope));
        }
    }

    public NamespacedResourcesTaskManager(@NotNull GlobalScope globalScope, @NotNull TaskFactory taskFactory, @NotNull VariantScope variantScope) {
        Intrinsics.checkParameterIsNotNull((Object)globalScope, (String)"globalScope");
        Intrinsics.checkParameterIsNotNull((Object)taskFactory, (String)"taskFactory");
        Intrinsics.checkParameterIsNotNull((Object)variantScope, (String)"variantScope");
        this.globalScope = globalScope;
        this.taskFactory = taskFactory;
        this.variantScope = variantScope;
    }
}

