/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.utils;

import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.internal.CompileOptions;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.utils.DesugarLibUtils;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0002\u001a\u000e\u0010\n\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r\u001a\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002\u001a\u000e\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"DESUGAR_LIB_CONFIG_NAME", "", "DESUGAR_LIB_DEX", "createDesugarLibConfiguration", "Lorg/gradle/api/artifacts/Configuration;", "project", "Lorg/gradle/api/Project;", "getArtifactCollection", "Lorg/gradle/api/file/FileCollection;", "configuration", "getDesugarLibConfig", "getDesugarLibDexFromTransform", "variantScope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "config", "getDesugarLibJarFromMaven", "gradle"})
@JvmName(name="DesugarLibUtils")
public final class DesugarLibUtils {
    private static final String DESUGAR_LIB_CONFIG_NAME = "_internal_desugar_jdk_libs";
    @NotNull
    public static final String DESUGAR_LIB_DEX = "_internal-desugar-jdk-libs-dex";

    @NotNull
    public static final FileCollection getDesugarLibJarFromMaven(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Configuration existingConfig = (Configuration)project2.getConfigurations().findByName(DESUGAR_LIB_CONFIG_NAME);
        if (existingConfig != null) {
            return DesugarLibUtils.getArtifactCollection(existingConfig);
        }
        Configuration config2 = DesugarLibUtils.createDesugarLibConfiguration(project2);
        return DesugarLibUtils.getArtifactCollection(config2);
    }

    @NotNull
    public static final FileCollection getDesugarLibDexFromTransform(@NotNull VariantScope variantScope) {
        boolean langDesugarEnabled;
        Intrinsics.checkParameterIsNotNull((Object)variantScope, (String)"variantScope");
        GlobalScope globalScope = variantScope.getGlobalScope();
        Intrinsics.checkExpressionValueIsNotNull((Object)globalScope, (String)"variantScope.globalScope");
        BaseExtension baseExtension = globalScope.getExtension();
        Intrinsics.checkExpressionValueIsNotNull((Object)baseExtension, (String)"variantScope.globalScope.extension");
        CompileOptions compileOptions = baseExtension.getCompileOptions();
        Intrinsics.checkExpressionValueIsNotNull((Object)compileOptions, (String)"variantScope.globalScope.extension.compileOptions");
        Boolean apiDesugarEnabled = compileOptions.getJavaApiDesugaringEnabled();
        boolean bl = langDesugarEnabled = variantScope.getJava8LangSupportType() == VariantScope.Java8LangSupport.D8 || variantScope.getJava8LangSupportType() == VariantScope.Java8LangSupport.R8;
        if (apiDesugarEnabled == null || Intrinsics.areEqual((Object)apiDesugarEnabled, (Object)false) || !langDesugarEnabled) {
            GlobalScope globalScope2 = variantScope.getGlobalScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)globalScope2, (String)"variantScope.globalScope");
            ConfigurableFileCollection configurableFileCollection = globalScope2.getProject().files(new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)configurableFileCollection, (String)"variantScope.globalScope.project.files()");
            return (FileCollection)configurableFileCollection;
        }
        GlobalScope globalScope3 = variantScope.getGlobalScope();
        Intrinsics.checkExpressionValueIsNotNull((Object)globalScope3, (String)"variantScope.globalScope");
        Project project2 = globalScope3.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"variantScope.globalScope.project");
        Project project3 = project2;
        Configuration existingConfig = (Configuration)project3.getConfigurations().findByName(DESUGAR_LIB_CONFIG_NAME);
        if (existingConfig != null) {
            return DesugarLibUtils.getDesugarLibDexFromTransform(existingConfig);
        }
        return DesugarLibUtils.getDesugarLibDexFromTransform(DesugarLibUtils.createDesugarLibConfiguration(project3));
    }

    @NotNull
    public static final String getDesugarLibConfig(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        return "default";
    }

    private static final Configuration createDesugarLibConfiguration(Project project2) {
        Configuration config2 = (Configuration)project2.getConfigurations().create(DESUGAR_LIB_CONFIG_NAME, (Action)createDesugarLibConfiguration.config.1.INSTANCE);
        DependencyHandler dependencyHandler = project2.getDependencies();
        Configuration configuration2 = config2;
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration2, (String)"config");
        dependencyHandler.add(configuration2.getName(), (Object)MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"group", (Object)"com.android.tools"), TuplesKt.to((Object)"name", (Object)"desugar_jdk_libs"), TuplesKt.to((Object)"version", (Object)"1.0.0")}));
        return config2;
    }

    private static final FileCollection getDesugarLibDexFromTransform(Configuration config2) {
        ArtifactView artifactView = config2.getIncoming().artifactView((Action)getDesugarLibDexFromTransform.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)artifactView, (String)"config.incoming.artifact\u2026        )\n        }\n    }");
        ArtifactCollection artifactCollection = artifactView.getArtifacts();
        Intrinsics.checkExpressionValueIsNotNull((Object)artifactCollection, (String)"config.incoming.artifact\u2026        }\n    }.artifacts");
        FileCollection fileCollection2 = artifactCollection.getArtifactFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection2, (String)"config.incoming.artifact\u2026}.artifacts.artifactFiles");
        return fileCollection2;
    }

    private static final FileCollection getArtifactCollection(Configuration configuration2) {
        ArtifactView artifactView = configuration2.getIncoming().artifactView((Action)getArtifactCollection.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)artifactView, (String)"configuration.incoming.a\u2026        )\n        }\n    }");
        ArtifactCollection artifactCollection = artifactView.getArtifacts();
        Intrinsics.checkExpressionValueIsNotNull((Object)artifactCollection, (String)"configuration.incoming.a\u2026        }\n    }.artifacts");
        FileCollection fileCollection2 = artifactCollection.getArtifactFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection2, (String)"configuration.incoming.a\u2026}.artifacts.artifactFiles");
        return fileCollection2;
    }
}

