/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.Version;
import com.android.build.FilterData;
import com.android.build.VariantOutput;
import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.internal.BuildTypeData;
import com.android.build.gradle.internal.CompileOptions;
import com.android.build.gradle.internal.ExtraModelInfo;
import com.android.build.gradle.internal.ProductFlavorData;
import com.android.build.gradle.internal.VariantManager;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.LintOptions;
import com.android.build.gradle.internal.ide.AaptOptionsImpl;
import com.android.build.gradle.internal.ide.AndroidArtifactImpl;
import com.android.build.gradle.internal.ide.AndroidGradlePluginProjectFlagsImpl;
import com.android.build.gradle.internal.ide.BuildOutputsSupplier;
import com.android.build.gradle.internal.ide.BuildTypeContainerImpl;
import com.android.build.gradle.internal.ide.DefaultAndroidProject;
import com.android.build.gradle.internal.ide.DefaultInstantAppProjectBuildOutput;
import com.android.build.gradle.internal.ide.DefaultInstantAppVariantBuildOutput;
import com.android.build.gradle.internal.ide.EarlySyncBuildOutput;
import com.android.build.gradle.internal.ide.InstantRunImpl;
import com.android.build.gradle.internal.ide.ModelBuilder;
import com.android.build.gradle.internal.ide.ProductFlavorContainerImpl;
import com.android.build.gradle.internal.ide.ProductFlavorImpl;
import com.android.build.gradle.internal.ide.VariantImpl;
import com.android.build.gradle.internal.ide.ViewBindingOptionsImpl;
import com.android.build.gradle.internal.ide.dependencies.BuildMappingUtils;
import com.android.build.gradle.internal.scope.ApkData;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.InstantAppOutputScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.SyncOptions;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.ArtifactMetaData;
import com.android.builder.model.Dependencies;
import com.android.builder.model.InstantAppProjectBuildOutput;
import com.android.builder.model.InstantAppVariantBuildOutput;
import com.android.builder.model.ModelBuilderParameter;
import com.android.builder.model.NativeToolchain;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.SigningConfig;
import com.android.builder.model.SyncIssue;
import com.android.builder.model.Variant;
import com.android.builder.model.level2.DependencyGraphs;
import com.android.utils.Pair;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.tooling.provider.model.ParameterizedToolingModelBuilder;

public class InstantAppModelBuilder
implements ParameterizedToolingModelBuilder<ModelBuilderParameter> {
    private int modelLevel = 0;
    private final BaseExtension extension;
    private final ExtraModelInfo extraModelInfo;
    private final VariantManager variantManager;
    private boolean modelWithFullDependency = false;

    public InstantAppModelBuilder(VariantManager variantManager, BaseExtension extension, ExtraModelInfo extraModelInfo) {
        this.extension = extension;
        this.extraModelInfo = extraModelInfo;
        this.variantManager = variantManager;
    }

    public boolean canBuild(String modelName) {
        return modelName.equals(AndroidProject.class.getName()) || modelName.equals(InstantAppProjectBuildOutput.class.getName()) || modelName.equals(Variant.class.getName());
    }

    public Object buildAll(String modelName, Project project2) {
        if (modelName.equals(AndroidProject.class.getName())) {
            return this.buildAndroidProject(project2, true);
        }
        if (modelName.equals(Variant.class.getName())) {
            throw new RuntimeException("Please use parameterized tooling API to obtain Variant model.");
        }
        return this.buildNonParameterizedModels(modelName);
    }

    public Object buildAll(String modelName, ModelBuilderParameter parameter, Project project2) {
        if (modelName.equals(AndroidProject.class.getName())) {
            return this.buildAndroidProject(project2, parameter.getShouldBuildVariant());
        }
        if (modelName.equals(Variant.class.getName())) {
            return this.buildVariant(parameter.getVariantName());
        }
        return this.buildNonParameterizedModels(modelName);
    }

    private Object buildNonParameterizedModels(String modelName) {
        if (modelName.equals(InstantAppProjectBuildOutput.class.getName())) {
            return this.buildMinimalisticModel();
        }
        throw new RuntimeException("Cannot build model " + modelName);
    }

    public Class<ModelBuilderParameter> getParameterType() {
        return ModelBuilderParameter.class;
    }

    private Object buildAndroidProject(Project project2, boolean shouldBuildVariant) {
        ProjectOptions projectOptions = new ProjectOptions(project2);
        Integer modelLevelInt = SyncOptions.buildModelOnlyVersion(projectOptions);
        if (modelLevelInt != null) {
            this.modelLevel = modelLevelInt;
        }
        if (this.modelLevel < 3) {
            throw new RuntimeException("This Gradle plugin requires a newer IDE able to request IDE model level 3. For Android Studio this means version 3.0+");
        }
        this.modelWithFullDependency = projectOptions.get(BooleanOption.IDE_BUILD_MODEL_FEATURE_FULL_DEPENDENCIES);
        ProductFlavorContainer defaultConfig = ProductFlavorContainerImpl.createProductFlavorContainer(this.variantManager.getDefaultConfig(), this.extraModelInfo.getExtraFlavorSourceProviders(this.variantManager.getDefaultConfig().getProductFlavor().getName()));
        ArrayList flavorDimensionList = this.extension.getFlavorDimensionList() != null ? this.extension.getFlavorDimensionList() : Lists.newArrayList();
        ArrayList buildTypes = Lists.newArrayList();
        ArrayList productFlavors = Lists.newArrayList();
        ArrayList variants = Lists.newArrayList();
        ArrayList variantNames = Lists.newArrayList();
        for (BuildTypeData buildTypeData : this.variantManager.getBuildTypes().values()) {
            buildTypes.add(BuildTypeContainerImpl.create(buildTypeData, this.extraModelInfo.getExtraBuildTypeSourceProviders(buildTypeData.getBuildType().getName())));
        }
        for (ProductFlavorData productFlavorData : this.variantManager.getProductFlavors().values()) {
            productFlavors.add(ProductFlavorContainerImpl.createProductFlavorContainer(productFlavorData, this.extraModelInfo.getExtraFlavorSourceProviders(productFlavorData.getProductFlavor().getName())));
        }
        String defaultVariant = this.variantManager.getDefaultVariant(this.extraModelInfo.getSyncIssueHandler());
        for (VariantScope variantScope : this.variantManager.getVariantScopes()) {
            if (variantScope.getVariantData().getType().isTestComponent()) continue;
            variantNames.add(variantScope.getFullVariantName());
            if (!shouldBuildVariant) continue;
            variants.add(this.createVariant(variantScope.getVariantData()));
        }
        return new DefaultAndroidProject(project2.getName(), null, defaultConfig, flavorDimensionList, buildTypes, productFlavors, variants, variantNames, defaultVariant, "android-28", (Collection<String>)Collections.emptyList(), (Collection<File>)Collections.emptyList(), (Collection<SigningConfig>)Collections.emptyList(), AaptOptionsImpl.createDummy(), (Collection<ArtifactMetaData>)Collections.emptyList(), (Collection<SyncIssue>)this.extraModelInfo.getSyncIssueHandler().getSyncIssues(), new CompileOptions(), new LintOptions(), project2.getBuildDir(), "", (Collection<NativeToolchain>)Collections.emptyList(), "", 4, Version.BUILDER_MODEL_API_VERSION, false, (Collection<String>)ImmutableList.of(), ViewBindingOptionsImpl.createDummy(), new AndroidGradlePluginProjectFlagsImpl(Collections.emptyMap()));
    }

    private Object buildMinimalisticModel() {
        ImmutableList.Builder variantsOutput = ImmutableList.builder();
        for (VariantScope variantScope : this.variantManager.getVariantScopes()) {
            InstantAppOutputScope instantAppOutputScope = null;
            try {
                instantAppOutputScope = InstantAppOutputScope.load(variantScope.getApkLocation());
            }
            catch (IOException e) {
                Logger.getAnonymousLogger().log(Level.SEVERE, "Error while loading output.json", e);
            }
            if (instantAppOutputScope == null) continue;
            variantsOutput.add((Object)new DefaultInstantAppVariantBuildOutput(variantScope.getFullVariantName(), instantAppOutputScope.getApplicationId(), new BuildOutput(InternalArtifactType.INSTANTAPP_BUNDLE.INSTANCE, ApkData.of(VariantOutput.OutputType.MAIN, (Collection<FilterData>)ImmutableList.of(), 0), instantAppOutputScope.getInstantAppBundle()), (Collection<EarlySyncBuildOutput>)new BuildOutputsSupplier((List<ArtifactType>)ImmutableList.of((Object)((Object)InternalArtifactType.APK.INSTANCE), (Object)((Object)InternalArtifactType.ABI_PACKAGED_SPLIT.INSTANCE), (Object)((Object)InternalArtifactType.DENSITY_OR_LANGUAGE_PACKAGED_SPLIT.INSTANCE)), instantAppOutputScope.getApkDirectories()).get()));
        }
        return new DefaultInstantAppProjectBuildOutput((ImmutableList<InstantAppVariantBuildOutput>)variantsOutput.build());
    }

    private VariantImpl buildVariant(String variantName) {
        if (variantName == null) {
            throw new IllegalArgumentException("Variant name cannot be null.");
        }
        for (VariantScope variantScope : this.variantManager.getVariantScopes()) {
            if (variantScope.getVariantData().getType().isTestComponent() || !variantScope.getFullVariantName().equals(variantName)) continue;
            return this.createVariant(variantScope.getVariantData());
        }
        throw new IllegalArgumentException(String.format("Variant with name '%s' doesn't exist.", variantName));
    }

    private VariantImpl createVariant(BaseVariantData variantData) {
        VariantScope variantScope = variantData.getScope();
        ImmutableMap<String, String> buildMapping = BuildMappingUtils.computeBuildMapping(variantScope.getGlobalScope().getProject().getGradle());
        GradleVariantConfiguration variantConfiguration = variantData.getVariantConfiguration();
        Pair<Dependencies, DependencyGraphs> dependencies = ModelBuilder.getDependencies(variantScope, buildMapping, this.extraModelInfo, this.modelLevel, this.modelWithFullDependency);
        File outputLocation = variantScope.getApkLocation();
        String baseName = variantScope.getGlobalScope().getProjectBaseName() + "-" + variantConfiguration.getBaseName();
        AndroidArtifactImpl mainArtifact = new AndroidArtifactImpl("_main_", baseName, variantScope.getTaskContainer().getAssembleTask().getName(), false, null, "unused", variantScope.getTaskName("dummy"), variantScope.getTaskName("dummy"), Collections.emptyList(), Collections.emptyList(), new File(""), Collections.emptySet(), new File(""), (Dependencies)dependencies.getFirst(), (DependencyGraphs)dependencies.getSecond(), Collections.emptyList(), null, null, null, variantConfiguration.getMergedBuildConfigFields(), variantConfiguration.getMergedResValues(), new InstantRunImpl(variantScope.getGlobalScope().getProject().file((Object)"removed_build_info"), 7), () -> ImmutableList.of((Object)new EarlySyncBuildOutput(InternalArtifactType.INSTANTAPP_BUNDLE.INSTANCE, VariantOutput.OutputType.MAIN, (Collection<? extends FilterData>)ImmutableList.of(), -1, new File(outputLocation, baseName + ".zip"))), new BuildOutputsSupplier((List<ArtifactType>)ImmutableList.of(), (List<File>)ImmutableList.of()), null, null, null, null);
        return new VariantImpl(variantConfiguration.getFullName(), variantConfiguration.getBaseName(), ((CoreBuildType)variantConfiguration.getBuildType()).getName(), variantData.getVariantConfiguration().getProductFlavors().stream().map(ProductFlavor::getName).collect(Collectors.toList()), new ProductFlavorImpl(variantConfiguration.getMergedFlavor()), mainArtifact, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false);
    }
}

