/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.cxx.stripping.SymbolStripExecutableFinder;
import com.android.build.gradle.internal.tasks.StripDebugSymbolsTask;
import com.android.build.gradle.internal.tasks.UnstrippedLibs;
import com.android.ide.common.process.LoggedProcessOutputHandler;
import com.android.ide.common.process.ProcessExecutor;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.process.ProcessResult;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import java.io.File;
import java.io.Serializable;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lcom/android/build/gradle/internal/tasks/StripDebugSymbolsRunnable;", "Ljava/lang/Runnable;", "params", "Lcom/android/build/gradle/internal/tasks/StripDebugSymbolsRunnable$Params;", "(Lcom/android/build/gradle/internal/tasks/StripDebugSymbolsRunnable$Params;)V", "getParams", "()Lcom/android/build/gradle/internal/tasks/StripDebugSymbolsRunnable$Params;", "run", "", "Params", "gradle"})
final class StripDebugSymbolsRunnable
implements Runnable {
    @NotNull
    private final Params params;

    @Override
    public void run() {
        ProcessResult result;
        LoggerWrapper logger = new LoggerWrapper(Logging.getLogger(StripDebugSymbolsTask.class));
        FileUtils.mkdirs((File)this.params.getOutput().getParentFile());
        File exe2 = this.params.getStripToolFinder().stripToolExecutableFile(this.params.getInput(), this.params.getAbi(), (Function1<? super String, ? extends File>)new Function1(this, logger){
            final /* synthetic */ StripDebugSymbolsRunnable this$0;
            final /* synthetic */ LoggerWrapper $logger;

            @Nullable
            public final Void invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                String string = this.this$0.getParams().getInput().getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"params.input.name");
                UnstrippedLibs.INSTANCE.add(string);
                this.$logger.verbose(it + " Packaging it as is.", new Object[0]);
                return null;
            }
            {
                this.this$0 = stripDebugSymbolsRunnable;
                this.$logger = loggerWrapper;
                super(1);
            }
        });
        if (exe2 == null || this.params.getJustCopyInput()) {
            FileUtils.copyFile((File)this.params.getInput(), (File)this.params.getOutput());
            return;
        }
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        builder.setExecutable(exe2);
        builder.addArgs("--strip-unneeded");
        builder.addArgs("-o");
        builder.addArgs(this.params.getOutput().toString());
        builder.addArgs(this.params.getInput().toString());
        ProcessResult processResult = result = this.params.getProcessExecutor().execute(builder.createProcess(), (ProcessOutputHandler)new LoggedProcessOutputHandler((ILogger)logger));
        Intrinsics.checkExpressionValueIsNotNull((Object)processResult, (String)"result");
        if (processResult.getExitValue() != 0) {
            String string = this.params.getInput().getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"params.input.name");
            UnstrippedLibs.INSTANCE.add(string);
            logger.verbose("Unable to strip library " + this.params.getInput().getAbsolutePath() + " due to error " + result.getExitValue() + " returned from " + exe2 + ", packaging it as is.", new Object[0]);
            FileUtils.copyFile((File)this.params.getInput(), (File)this.params.getOutput());
        }
    }

    @NotNull
    public final Params getParams() {
        return this.params;
    }

    @Inject
    public StripDebugSymbolsRunnable(@NotNull Params params) {
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        this.params = params;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001d\u001a\u00020\nH\u00c6\u0003J\t\u0010\u001e\u001a\u00020\fH\u00c6\u0003JG\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010 \u001a\u00020\b2\b\u0010!\u001a\u0004\u0018\u00010\"H\u00d6\u0003J\t\u0010#\u001a\u00020$H\u00d6\u0001J\t\u0010%\u001a\u00020&H\u00d6\u0001R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006'"}, d2={"Lcom/android/build/gradle/internal/tasks/StripDebugSymbolsRunnable$Params;", "Ljava/io/Serializable;", "input", "Ljava/io/File;", "output", "abi", "Lcom/android/build/gradle/internal/core/Abi;", "justCopyInput", "", "stripToolFinder", "Lcom/android/build/gradle/internal/cxx/stripping/SymbolStripExecutableFinder;", "processExecutor", "Lcom/android/ide/common/process/ProcessExecutor;", "(Ljava/io/File;Ljava/io/File;Lcom/android/build/gradle/internal/core/Abi;ZLcom/android/build/gradle/internal/cxx/stripping/SymbolStripExecutableFinder;Lcom/android/ide/common/process/ProcessExecutor;)V", "getAbi", "()Lcom/android/build/gradle/internal/core/Abi;", "getInput", "()Ljava/io/File;", "getJustCopyInput", "()Z", "getOutput", "getProcessExecutor", "()Lcom/android/ide/common/process/ProcessExecutor;", "getStripToolFinder", "()Lcom/android/build/gradle/internal/cxx/stripping/SymbolStripExecutableFinder;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "", "hashCode", "", "toString", "", "gradle"})
    public static final class Params
    implements Serializable {
        @NotNull
        private final File input;
        @NotNull
        private final File output;
        @Nullable
        private final Abi abi;
        private final boolean justCopyInput;
        @NotNull
        private final SymbolStripExecutableFinder stripToolFinder;
        @NotNull
        private final ProcessExecutor processExecutor;

        @NotNull
        public final File getInput() {
            return this.input;
        }

        @NotNull
        public final File getOutput() {
            return this.output;
        }

        @Nullable
        public final Abi getAbi() {
            return this.abi;
        }

        public final boolean getJustCopyInput() {
            return this.justCopyInput;
        }

        @NotNull
        public final SymbolStripExecutableFinder getStripToolFinder() {
            return this.stripToolFinder;
        }

        @NotNull
        public final ProcessExecutor getProcessExecutor() {
            return this.processExecutor;
        }

        public Params(@NotNull File input, @NotNull File output2, @Nullable Abi abi, boolean justCopyInput, @NotNull SymbolStripExecutableFinder stripToolFinder2, @NotNull ProcessExecutor processExecutor) {
            Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
            Intrinsics.checkParameterIsNotNull((Object)output2, (String)"output");
            Intrinsics.checkParameterIsNotNull((Object)stripToolFinder2, (String)"stripToolFinder");
            Intrinsics.checkParameterIsNotNull((Object)processExecutor, (String)"processExecutor");
            this.input = input;
            this.output = output2;
            this.abi = abi;
            this.justCopyInput = justCopyInput;
            this.stripToolFinder = stripToolFinder2;
            this.processExecutor = processExecutor;
        }

        @NotNull
        public final File component1() {
            return this.input;
        }

        @NotNull
        public final File component2() {
            return this.output;
        }

        @Nullable
        public final Abi component3() {
            return this.abi;
        }

        public final boolean component4() {
            return this.justCopyInput;
        }

        @NotNull
        public final SymbolStripExecutableFinder component5() {
            return this.stripToolFinder;
        }

        @NotNull
        public final ProcessExecutor component6() {
            return this.processExecutor;
        }

        @NotNull
        public final Params copy(@NotNull File input, @NotNull File output2, @Nullable Abi abi, boolean justCopyInput, @NotNull SymbolStripExecutableFinder stripToolFinder2, @NotNull ProcessExecutor processExecutor) {
            Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
            Intrinsics.checkParameterIsNotNull((Object)output2, (String)"output");
            Intrinsics.checkParameterIsNotNull((Object)stripToolFinder2, (String)"stripToolFinder");
            Intrinsics.checkParameterIsNotNull((Object)processExecutor, (String)"processExecutor");
            return new Params(input, output2, abi, justCopyInput, stripToolFinder2, processExecutor);
        }

        public static /* synthetic */ Params copy$default(Params params, File file, File file2, Abi abi, boolean bl, SymbolStripExecutableFinder symbolStripExecutableFinder, ProcessExecutor processExecutor, int n, Object object) {
            if ((n & 1) != 0) {
                file = params.input;
            }
            if ((n & 2) != 0) {
                file2 = params.output;
            }
            if ((n & 4) != 0) {
                abi = params.abi;
            }
            if ((n & 8) != 0) {
                bl = params.justCopyInput;
            }
            if ((n & 0x10) != 0) {
                symbolStripExecutableFinder = params.stripToolFinder;
            }
            if ((n & 0x20) != 0) {
                processExecutor = params.processExecutor;
            }
            return params.copy(file, file2, abi, bl, symbolStripExecutableFinder, processExecutor);
        }

        @NotNull
        public String toString() {
            return "Params(input=" + this.input + ", output=" + this.output + ", abi=" + (Object)((Object)this.abi) + ", justCopyInput=" + this.justCopyInput + ", stripToolFinder=" + this.stripToolFinder + ", processExecutor=" + this.processExecutor + ")";
        }

        public int hashCode() {
            File file = this.input;
            File file2 = this.output;
            Abi abi = this.abi;
            int n = (((file != null ? ((Object)file).hashCode() : 0) * 31 + (file2 != null ? ((Object)file2).hashCode() : 0)) * 31 + (abi != null ? ((Object)((Object)abi)).hashCode() : 0)) * 31;
            int n2 = this.justCopyInput ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            SymbolStripExecutableFinder symbolStripExecutableFinder = this.stripToolFinder;
            ProcessExecutor processExecutor = this.processExecutor;
            return ((n + n2) * 31 + (symbolStripExecutableFinder != null ? symbolStripExecutableFinder.hashCode() : 0)) * 31 + (processExecutor != null ? processExecutor.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Params)) break block3;
                    Params params = (Params)object;
                    if (!Intrinsics.areEqual((Object)this.input, (Object)params.input) || !Intrinsics.areEqual((Object)this.output, (Object)params.output) || !Intrinsics.areEqual((Object)((Object)this.abi), (Object)((Object)params.abi)) || this.justCopyInput != params.justCopyInput || !Intrinsics.areEqual((Object)this.stripToolFinder, (Object)params.stripToolFinder) || !Intrinsics.areEqual((Object)this.processExecutor, (Object)params.processExecutor)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

