/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.AndroidDependenciesRenderer;
import com.android.build.gradle.internal.scope.VariantScope;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0007J\u0014\u0010\n\u001a\u00020\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/build/gradle/internal/tasks/DependencyReportTask;", "Lorg/gradle/api/DefaultTask;", "()V", "renderer", "Lcom/android/build/gradle/internal/AndroidDependenciesRenderer;", "variants", "Ljava/util/HashSet;", "Lcom/android/build/gradle/internal/scope/VariantScope;", "generate", "", "setVariants", "variantScopes", "", "gradle"})
public class DependencyReportTask
extends DefaultTask {
    private final AndroidDependenciesRenderer renderer = new AndroidDependenciesRenderer();
    private final HashSet<VariantScope> variants = new HashSet();

    @TaskAction
    public final void generate() throws IOException {
        this.renderer.setOutput(((StyledTextOutputFactory)this.getServices().get(StyledTextOutputFactory.class)).create(((Object)((Object)this)).getClass()));
        Iterable iterable = this.variants;
        boolean bl = false;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                VariantScope it = (VariantScope)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)it.getFullVariantName());
                it = (VariantScope)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string = it.getFullVariantName();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        };
        List sortedVariants = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
        for (VariantScope variant2 : sortedVariants) {
            this.renderer.startVariant(variant2);
            this.renderer.render(variant2);
        }
    }

    public final void setVariants(@NotNull Collection<? extends VariantScope> variantScopes) {
        Intrinsics.checkParameterIsNotNull(variantScopes, (String)"variantScopes");
        this.variants.addAll(variantScopes);
    }
}

