/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.gradle.internal.BuildTypeData;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.VariantModel;
import com.android.build.gradle.internal.api.BaseVariantImpl;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.errors.SyncIssueHandler;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantFactory;
import com.android.build.gradle.internal.variant.FeatureVariantFactory;
import com.android.build.gradle.internal.variant.LibraryVariantFactory;
import com.android.builder.core.VariantType;
import com.android.builder.core.VariantTypeImpl;
import com.android.builder.errors.EvalIssueReporter;
import com.android.builder.profile.Recorder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import org.gradle.api.NamedDomainObjectContainer;

public class MultiTypeVariantFactory
extends BaseVariantFactory {
    private final Map<VariantType, BaseVariantFactory> delegates;

    public MultiTypeVariantFactory(GlobalScope globalScope) {
        super(globalScope);
        this.delegates = ImmutableMap.of((Object)VariantTypeImpl.BASE_FEATURE, (Object)new FeatureVariantFactory(globalScope, (VariantType)VariantTypeImpl.BASE_FEATURE), (Object)VariantTypeImpl.FEATURE, (Object)new FeatureVariantFactory(globalScope, (VariantType)VariantTypeImpl.FEATURE), (Object)VariantTypeImpl.LIBRARY, (Object)new LibraryVariantFactory(globalScope));
    }

    @Override
    public BaseVariantData createVariantData(GradleVariantConfiguration variantConfiguration, TaskManager taskManager, Recorder recorder) {
        return this.delegates.get(variantConfiguration.getType()).createVariantData(variantConfiguration, taskManager, recorder);
    }

    @Override
    public Class<? extends BaseVariantImpl> getVariantImplementationClass(BaseVariantData variantData) {
        return this.delegates.get(variantData.getType()).getVariantImplementationClass(variantData);
    }

    @Override
    public Collection<VariantType> getVariantConfigurationTypes() {
        if (this.globalScope.getExtension().getBaseFeature().booleanValue()) {
            return ImmutableList.of((Object)VariantTypeImpl.BASE_FEATURE, (Object)VariantTypeImpl.LIBRARY);
        }
        return ImmutableList.of((Object)VariantTypeImpl.FEATURE, (Object)VariantTypeImpl.LIBRARY);
    }

    @Override
    public boolean hasTestScope() {
        return true;
    }

    @Override
    public void validateModel(VariantModel model2) {
        for (BaseVariantFactory variantFactory : this.delegates.values()) {
            variantFactory.validateModel(model2);
        }
        if (this.getVariantConfigurationTypes().stream().noneMatch(VariantType::isFeatureSplit)) {
            return;
        }
        SyncIssueHandler issueReporter = this.globalScope.getErrorHandler();
        for (BuildTypeData buildType : model2.getBuildTypes().values()) {
            if (!buildType.getBuildType().isMinifyEnabled()) continue;
            issueReporter.reportError(EvalIssueReporter.Type.GENERIC, "Feature modules cannot set minifyEnabled to true. minifyEnabled is set to true in build type '" + buildType.getBuildType().getName() + "'.\nTo enable minification for a feature module, set minifyEnabled to true in the base module.");
        }
    }

    @Override
    public void createDefaultComponents(NamedDomainObjectContainer<BuildType> buildTypes, NamedDomainObjectContainer<ProductFlavor> productFlavors, NamedDomainObjectContainer<SigningConfig> signingConfigs) {
        signingConfigs.create("debug");
        buildTypes.create("debug");
        buildTypes.create("release");
    }
}

