/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ndk;

import com.android.build.gradle.internal.SdkLocator;
import com.android.build.gradle.internal.cxx.configure.NdkLocatorKt;
import com.android.build.gradle.internal.cxx.configure.NdkLocatorRecord;
import com.android.build.gradle.internal.ndk.DefaultNdkInfo;
import com.android.build.gradle.internal.ndk.NdkHandlerKt;
import com.android.build.gradle.internal.ndk.NdkInfo;
import com.android.build.gradle.internal.ndk.NdkInstallStatus;
import com.android.build.gradle.internal.ndk.NdkPlatform;
import com.android.build.gradle.internal.ndk.NdkR14Info;
import com.android.build.gradle.internal.ndk.NdkR19Info;
import com.android.builder.errors.EvalIssueReporter;
import com.android.builder.sdk.InstallFailedException;
import com.android.builder.sdk.LicenceNotAcceptedException;
import com.android.builder.sdk.SdkLibData;
import com.android.builder.sdk.SdkLoader;
import com.android.repository.Revision;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 '2\u00020\u0001:\u0002'(B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0016\u001a\u00020\u0007H\u0002J\n\u0010\u0017\u001a\u0004\u0018\u00010\nH\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\rH\u0002J\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\b\u0010$\u001a\u00020\u001fH\u0002J\u000e\u0010%\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020\nR\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006)"}, d2={"Lcom/android/build/gradle/internal/ndk/NdkHandler;", "", "evalIssueReporter", "Lcom/android/builder/errors/EvalIssueReporter;", "enableSideBySideNdk", "", "ndkVersionFromDsl", "", "compileSdkVersion", "projectDir", "Ljava/io/File;", "(Lcom/android/builder/errors/EvalIssueReporter;ZLjava/lang/String;Ljava/lang/String;Ljava/io/File;)V", "ndkInstallStatus", "Lcom/android/build/gradle/internal/ndk/NdkInstallStatus;", "ndkPlatform", "getNdkPlatform", "()Lcom/android/build/gradle/internal/ndk/NdkInstallStatus;", "sideBySideLocatorRecord", "Lcom/android/build/gradle/internal/cxx/configure/NdkLocatorRecord;", "userExplicityRequestedNdkVersion", "getUserExplicityRequestedNdkVersion", "()Z", "downloadNdkVersion", "findNdk", "getNdkInfo", "Lcom/android/build/gradle/internal/ndk/NdkInfo;", "ndkDirectory", "revision", "Lcom/android/repository/Revision;", "getNdkStatus", "installFromSdk", "", "sdkLoader", "Lcom/android/builder/sdk/SdkLoader;", "sdkLibData", "Lcom/android/builder/sdk/SdkLibData;", "invalidateNdk", "writeNdkLocatorRecord", "file", "Companion", "FindRevisionResult", "gradle"})
public final class NdkHandler {
    private NdkInstallStatus ndkInstallStatus;
    private NdkLocatorRecord sideBySideLocatorRecord;
    private final boolean userExplicityRequestedNdkVersion;
    private final EvalIssueReporter evalIssueReporter;
    private final boolean enableSideBySideNdk;
    private final String ndkVersionFromDsl;
    private final String compileSdkVersion;
    private final File projectDir;
    public static final Companion Companion = new Companion(null);

    public final boolean getUserExplicityRequestedNdkVersion() {
        return this.userExplicityRequestedNdkVersion;
    }

    private final File findNdk() {
        File file;
        if (this.enableSideBySideNdk) {
            NdkLocatorRecord record;
            this.sideBySideLocatorRecord = record = NdkLocatorKt.findNdkPath(this.evalIssueReporter, this.ndkVersionFromDsl, this.projectDir);
            file = record.getNdkFolder();
        } else {
            file = NdkHandler.Companion.findNdkDirectory(this.projectDir, this.evalIssueReporter);
        }
        return file;
    }

    private final NdkInfo getNdkInfo(File ndkDirectory, Revision revision) {
        return revision.getMajor() >= 19 ? (NdkInfo)new NdkR19Info(ndkDirectory) : (revision.getMajor() >= 14 ? (NdkInfo)new NdkR14Info(ndkDirectory) : (NdkInfo)new DefaultNdkInfo(ndkDirectory));
    }

    private final NdkInstallStatus getNdkStatus() {
        File ndkDirectory = this.findNdk();
        if (ndkDirectory == null || !ndkDirectory.exists()) {
            return NdkInstallStatus.NotInstalled.INSTANCE;
        }
        FindRevisionResult found = Companion.findRevision(ndkDirectory);
        if (!(found instanceof FindRevisionResult.Found)) {
            if (found instanceof FindRevisionResult.Error) {
                return new NdkInstallStatus.Invalid(((FindRevisionResult.Error)found).getMessage());
            }
            throw new NoWhenBranchMatchedException();
        }
        Revision revision = ((FindRevisionResult.Found)found).getRevision();
        NdkInfo ndkInfo = this.getNdkInfo(ndkDirectory, revision);
        String error2 = ndkInfo.validate();
        if (error2 != null) {
            return new NdkInstallStatus.Invalid(error2);
        }
        return new NdkInstallStatus.Valid(new NdkPlatform(ndkDirectory, ndkInfo, revision, this.compileSdkVersion));
    }

    @NotNull
    public final NdkInstallStatus getNdkPlatform() {
        if (this.ndkInstallStatus == null) {
            this.ndkInstallStatus = this.getNdkStatus();
        }
        NdkInstallStatus ndkInstallStatus = this.ndkInstallStatus;
        if (ndkInstallStatus == null) {
            Intrinsics.throwNpe();
        }
        return ndkInstallStatus;
    }

    private final void invalidateNdk() {
        this.ndkInstallStatus = null;
    }

    public final void installFromSdk(@NotNull SdkLoader sdkLoader, @NotNull SdkLibData sdkLibData) {
        Intrinsics.checkParameterIsNotNull((Object)sdkLoader, (String)"sdkLoader");
        Intrinsics.checkParameterIsNotNull((Object)sdkLibData, (String)"sdkLibData");
        try {
            if (this.enableSideBySideNdk) {
                sdkLoader.installSdkTool(sdkLibData, "ndk;" + this.downloadNdkVersion());
            } else {
                sdkLoader.installSdkTool(sdkLibData, "ndk-bundle");
            }
        }
        catch (LicenceNotAcceptedException e) {
            throw (Throwable)new RuntimeException(e);
        }
        catch (InstallFailedException e) {
            throw (Throwable)new RuntimeException(e);
        }
        this.invalidateNdk();
    }

    private final String downloadNdkVersion() {
        Revision parsed;
        String string = this.ndkVersionFromDsl;
        if (string == null) {
            string = "20.0.5594570";
        }
        String fullVersion = string;
        Revision revision = parsed = Revision.parseRevision((String)fullVersion);
        Intrinsics.checkExpressionValueIsNotNull((Object)revision, (String)"parsed");
        Revision threePart = new Revision(revision.getMajor(), parsed.getMinor(), parsed.getMicro());
        String string2 = threePart.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"threePart.toString()");
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeNdkLocatorRecord(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (this.sideBySideLocatorRecord != null) {
            file.getParentFile().mkdirs();
            Closeable closeable = new FileWriter(file);
            boolean bl = false;
            Throwable throwable = null;
            try {
                FileWriter writer = (FileWriter)closeable;
                boolean bl2 = false;
                NdkHandlerKt.getGSON().toJson((Object)this.sideBySideLocatorRecord, (Appendable)writer);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    public NdkHandler(@NotNull EvalIssueReporter evalIssueReporter, boolean enableSideBySideNdk, @Nullable String ndkVersionFromDsl, @NotNull String compileSdkVersion, @NotNull File projectDir) {
        Intrinsics.checkParameterIsNotNull((Object)evalIssueReporter, (String)"evalIssueReporter");
        Intrinsics.checkParameterIsNotNull((Object)compileSdkVersion, (String)"compileSdkVersion");
        Intrinsics.checkParameterIsNotNull((Object)projectDir, (String)"projectDir");
        this.evalIssueReporter = evalIssueReporter;
        this.enableSideBySideNdk = enableSideBySideNdk;
        this.ndkVersionFromDsl = ndkVersionFromDsl;
        this.compileSdkVersion = compileSdkVersion;
        this.projectDir = projectDir;
        this.userExplicityRequestedNdkVersion = this.ndkVersionFromDsl != null;
    }

    @VisibleForTesting
    @JvmStatic
    @NotNull
    public static final FindRevisionResult findRevision(@NotNull File ndkDirectory) {
        return Companion.findRevision(ndkDirectory);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0005\u0006B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u0082\u0001\u0002\u0007\b\u00a8\u0006\t"}, d2={"Lcom/android/build/gradle/internal/ndk/NdkHandler$FindRevisionResult;", "", "()V", "getOrThrow", "Lcom/android/repository/Revision;", "Error", "Found", "Lcom/android/build/gradle/internal/ndk/NdkHandler$FindRevisionResult$Found;", "Lcom/android/build/gradle/internal/ndk/NdkHandler$FindRevisionResult$Error;", "gradle"})
    public static abstract class FindRevisionResult {
        @NotNull
        public final Revision getOrThrow() {
            FindRevisionResult findRevisionResult = this;
            if (findRevisionResult instanceof Found) {
                return ((Found)this).getRevision();
            }
            if (findRevisionResult instanceof Error) {
                throw (Throwable)new RuntimeException(((Error)this).getMessage());
            }
            throw new NoWhenBranchMatchedException();
        }

        private FindRevisionResult() {
        }

        public /* synthetic */ FindRevisionResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/android/build/gradle/internal/ndk/NdkHandler$FindRevisionResult$Found;", "Lcom/android/build/gradle/internal/ndk/NdkHandler$FindRevisionResult;", "revision", "Lcom/android/repository/Revision;", "(Lcom/android/repository/Revision;)V", "getRevision", "()Lcom/android/repository/Revision;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "gradle"})
        public static final class Found
        extends FindRevisionResult {
            @NotNull
            private final Revision revision;

            @NotNull
            public final Revision getRevision() {
                return this.revision;
            }

            public Found(@NotNull Revision revision) {
                Intrinsics.checkParameterIsNotNull((Object)revision, (String)"revision");
                super(null);
                this.revision = revision;
            }

            @NotNull
            public final Revision component1() {
                return this.revision;
            }

            @NotNull
            public final Found copy(@NotNull Revision revision) {
                Intrinsics.checkParameterIsNotNull((Object)revision, (String)"revision");
                return new Found(revision);
            }

            public static /* synthetic */ Found copy$default(Found found, Revision revision, int n, Object object) {
                if ((n & 1) != 0) {
                    revision = found.revision;
                }
                return found.copy(revision);
            }

            @NotNull
            public String toString() {
                return "Found(revision=" + this.revision + ")";
            }

            public int hashCode() {
                Revision revision = this.revision;
                return revision != null ? revision.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Found)) break block3;
                        Found found = (Found)object;
                        if (!Intrinsics.areEqual((Object)this.revision, (Object)found.revision)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/internal/ndk/NdkHandler$FindRevisionResult$Error;", "Lcom/android/build/gradle/internal/ndk/NdkHandler$FindRevisionResult;", "message", "", "(Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "gradle"})
        public static final class Error
        extends FindRevisionResult {
            @NotNull
            private final String message;

            @NotNull
            public final String getMessage() {
                return this.message;
            }

            public Error(@NotNull String message) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                super(null);
                this.message = message;
            }

            @NotNull
            public final String component1() {
                return this.message;
            }

            @NotNull
            public final Error copy(@NotNull String message) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                return new Error(message);
            }

            public static /* synthetic */ Error copy$default(Error error2, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = error2.message;
                }
                return error2.copy(string);
            }

            @NotNull
            public String toString() {
                return "Error(message=" + this.message + ")";
            }

            public int hashCode() {
                String string = this.message;
                return string != null ? string.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Error)) break block3;
                        Error error2 = (Error)object;
                        if (!Intrinsics.areEqual((Object)this.message, (Object)error2.message)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0007J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002\u00a8\u0006\u000f"}, d2={"Lcom/android/build/gradle/internal/ndk/NdkHandler$Companion;", "", "()V", "findNdkDirectory", "Ljava/io/File;", "projectDir", "evalIssueReporter", "Lcom/android/builder/errors/EvalIssueReporter;", "properties", "Ljava/util/Properties;", "findRevision", "Lcom/android/build/gradle/internal/ndk/NdkHandler$FindRevisionResult;", "ndkDirectory", "readProperties", "file", "gradle"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Properties readProperties(File file) {
            Properties properties = new Properties();
            try {
                Closeable closeable = new FileInputStream(file);
                boolean bl = false;
                Throwable throwable = null;
                try {
                    FileInputStream fis = (FileInputStream)closeable;
                    boolean bl2 = false;
                    Closeable closeable2 = new InputStreamReader((InputStream)fis, Charsets.UTF_8);
                    boolean bl3 = false;
                    Throwable throwable2 = null;
                    try {
                        InputStreamReader reader = (InputStreamReader)closeable2;
                        boolean bl4 = false;
                        properties.load(reader);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException e) {
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = "Unable to read %1$s.";
                Object[] objectArray = new Object[]{file};
                boolean bl = false;
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
                String string3 = string2;
                Throwable throwable = e;
                String string4 = string3;
                throw (Throwable)new RuntimeException(string4, throwable);
            }
            return properties;
        }

        @VisibleForTesting
        @JvmStatic
        @NotNull
        public final FindRevisionResult findRevision(@NotNull File ndkDirectory) {
            FindRevisionResult findRevisionResult;
            Intrinsics.checkParameterIsNotNull((Object)ndkDirectory, (String)"ndkDirectory");
            File sourceProperties = new File(ndkDirectory, "source.properties");
            if (!sourceProperties.exists()) {
                File releaseTxt = FilesKt.resolve((File)ndkDirectory, (String)"RELEASE.TXT");
                return releaseTxt.exists() ? (FindRevisionResult)new FindRevisionResult.Error("NDK at " + ndkDirectory + " is not supported (pre-r11)") : (FindRevisionResult)new FindRevisionResult.Error(sourceProperties + " does not exist");
            }
            Properties properties = this.readProperties(sourceProperties);
            String version = properties.getProperty("Pkg.Revision");
            if (version != null) {
                Revision revision = Revision.parseRevision((String)version);
                Intrinsics.checkExpressionValueIsNotNull((Object)revision, (String)"Revision.parseRevision(version)");
                findRevisionResult = new FindRevisionResult.Found(revision);
            } else {
                findRevisionResult = new FindRevisionResult.Error("Could not parse Pkg.Revision from " + sourceProperties);
            }
            return findRevisionResult;
        }

        private final File findNdkDirectory(File projectDir, EvalIssueReporter evalIssueReporter) {
            File localProperties = new File(projectDir, "local.properties");
            Properties properties = new Properties();
            if (localProperties.isFile()) {
                properties = this.readProperties(localProperties);
            }
            return this.findNdkDirectory(properties, projectDir, evalIssueReporter);
        }

        private final File findNdkDirectory(Properties properties, File projectDir, EvalIssueReporter evalIssueReporter) {
            String ndkDirProp = properties.getProperty("ndk.dir");
            if (ndkDirProp != null) {
                return new File(ndkDirProp);
            }
            String ndkEnvVar = System.getenv("ANDROID_NDK_HOME");
            if (ndkEnvVar != null) {
                return new File(ndkEnvVar);
            }
            File sdkFolder2 = SdkLocator.getSdkDirectory(projectDir, evalIssueReporter);
            File ndkBundle = new File(sdkFolder2, "ndk-bundle");
            if (ndkBundle.isDirectory()) {
                return ndkBundle;
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

