/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.tasks.DexArchiveBuilderTaskDelegate;
import com.android.build.gradle.internal.tasks.DexArchiveBuilderTaskDelegateKt;
import com.android.build.gradle.internal.tasks.DexArchiveBuilderTaskDelegateKt$sam$i$java_util_function_BiPredicate$0;
import com.android.builder.dexing.ClassFileInput;
import com.android.builder.dexing.ClassFileInputs;
import com.android.builder.dexing.DexArchiveBuilder;
import com.android.builder.dexing.DexArchiveBuilderException;
import com.android.ide.common.blame.MessageReceiver;
import com.google.common.base.Preconditions;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0002\u001a(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"loggerWrapper", "Lcom/android/build/gradle/internal/LoggerWrapper;", "getBucketForFile", "", "isDirectory", "", "path", "", "numberOfBuckets", "launchProcessing", "", "dexConversionParameters", "Lcom/android/build/gradle/internal/tasks/DexArchiveBuilderTaskDelegate$DexConversionParameters;", "outStream", "Ljava/io/OutputStream;", "errStream", "receiver", "Lcom/android/ide/common/blame/MessageReceiver;", "gradle"})
public final class DexArchiveBuilderTaskDelegateKt {
    private static final LoggerWrapper loggerWrapper;

    private static final int getBucketForFile(boolean isDirectory, String path, int numberOfBuckets) {
        Path path2 = Paths.get(path, new String[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"Paths.get(path)");
        Preconditions.checkArgument((!path2.isAbsolute() ? 1 : 0) != 0, (String)("Path should be relative: " + path), (Object[])new Object[0]);
        if (!isDirectory) {
            int n = path.hashCode();
            boolean bl = false;
            return Math.abs(n) % numberOfBuckets;
        }
        Path path3 = Paths.get(path, new String[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)path3, (String)"Paths.get(path)");
        Path path4 = path3.getParent();
        if (path4 == null) {
            return 0;
        }
        Path packagePath = path4;
        int n = ((Object)packagePath).toString().hashCode();
        boolean bl = false;
        return Math.abs(n) % numberOfBuckets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final void launchProcessing(DexArchiveBuilderTaskDelegate.DexConversionParameters dexConversionParameters, OutputStream outStream, OutputStream errStream, MessageReceiver receiver) {
        Path it;
        void $this$mapTo$iv$iv;
        DexArchiveBuilder dexArchiveBuilder = dexConversionParameters.getDexArchiveBuilder(outStream, errStream, dexConversionParameters.getDexPerClass$gradle(), receiver);
        Iterable $this$map$iv = dexConversionParameters.getInputs$gradle();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Path path = ((File)((Object)it)).toPath();
            collection.add(path);
        }
        List inputPaths = (List)destination$iv$iv;
        boolean hasIncrementalInfo = dexConversionParameters.isDirectory$gradle() && dexConversionParameters.isIncremental$gradle();
        Function2<Path, String, Boolean> $fun$toProcess$1 = new Function2<Path, String, Boolean>(dexConversionParameters, hasIncrementalInfo){
            final /* synthetic */ DexArchiveBuilderTaskDelegate.DexConversionParameters $dexConversionParameters;
            final /* synthetic */ boolean $hasIncrementalInfo;

            public final boolean invoke(@NotNull Path rootPath, @NotNull String path) {
                Path relativePath;
                Path inputPath;
                Intrinsics.checkParameterIsNotNull((Object)rootPath, (String)"rootPath");
                Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
                Path path2 = inputPath = Paths.get(path, new String[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"inputPath");
                Path path3 = relativePath = path2.isAbsolute() ? rootPath.relativize(inputPath) : inputPath;
                if (!this.$dexConversionParameters.belongsToThisBucket(((Object)relativePath).toString())) {
                    return false;
                }
                if (!this.$hasIncrementalInfo) {
                    return true;
                }
                File resolved = rootPath.resolve(path).toFile();
                return this.$dexConversionParameters.getAdditionalPaths$gradle().contains(resolved) || this.$dexConversionParameters.getChangedFiles$gradle().contains(resolved);
            }
            {
                this.$dexConversionParameters = dexConversionParameters;
                this.$hasIncrementalInfo = bl;
                super(2);
            }
        };
        Function2 bucketFilter2 = (Function2)new Function2<Path, String, Boolean>($fun$toProcess$1){
            final /* synthetic */ launchProcessing.1 $toProcess$1;

            public final boolean invoke(@NotNull Path rootPath, @NotNull String path) {
                Intrinsics.checkParameterIsNotNull((Object)rootPath, (String)"rootPath");
                Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
                return this.$toProcess$1.invoke(rootPath, path);
            }
            {
                this.$toProcess$1 = var1_1;
                super(2);
            }
        };
        Object $this$forEach$iv = inputPaths;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv.iterator();
        while (object.hasNext()) {
            Object element$iv = object.next();
            it = (Path)element$iv;
            boolean bl = false;
            loggerWrapper.verbose("Dexing '" + it + "' to '" + dexConversionParameters.getOutput$gradle() + "'", new Object[0]);
        }
        try {
            $this$forEach$iv = (Closeable)Closer.create();
            boolean bl = false;
            object = null;
            try {
                Closer closer = (Closer)$this$forEach$iv;
                boolean bl2 = false;
                Stream classFileEntries = Stream.empty();
                AutoCloseable autoCloseable = classFileEntries;
                boolean bl3 = false;
                Throwable throwable = null;
                try {
                    Stream it2 = (Stream)autoCloseable;
                    boolean bl4 = false;
                    for (Path inputPath : inputPaths) {
                        ClassFileInput classFileInput = ClassFileInputs.fromPath((Path)inputPath);
                        boolean bl5 = false;
                        boolean bl6 = false;
                        ClassFileInput it3 = classFileInput;
                        boolean bl7 = false;
                        closer.register((Closeable)it3);
                        ClassFileInput classFileInput2 = classFileInput;
                        Object object2 = bucketFilter2;
                        if (object2 != null) {
                            classFileInput = object2;
                            object2 = new DexArchiveBuilderTaskDelegateKt$sam$i$java_util_function_BiPredicate$0((Function2)classFileInput);
                        }
                        classFileEntries = Stream.concat(classFileEntries, classFileInput2.entries((BiPredicate)object2));
                    }
                    dexArchiveBuilder.convert(classFileEntries, Paths.get(new URI(dexConversionParameters.getOutput$gradle())));
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)$this$forEach$iv, (Throwable)object);
            }
        }
        catch (DexArchiveBuilderException ex) {
            if (dexConversionParameters.isDirectory$gradle()) {
                throw (Throwable)new DexArchiveBuilderException("Failed to process for directories input", (Throwable)ex);
            }
            throw (Throwable)new DexArchiveBuilderException("Failed to process " + (Path)CollectionsKt.first((List)inputPaths), (Throwable)ex);
        }
    }

    static {
        LoggerWrapper loggerWrapper = LoggerWrapper.getLogger(DexArchiveBuilderTaskDelegate.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)loggerWrapper, (String)"LoggerWrapper.getLogger(\u2026TaskDelegate::class.java)");
        DexArchiveBuilderTaskDelegateKt.loggerWrapper = loggerWrapper;
    }

    public static final /* synthetic */ int access$getBucketForFile(boolean isDirectory, String path, int numberOfBuckets) {
        return DexArchiveBuilderTaskDelegateKt.getBucketForFile(isDirectory, path, numberOfBuckets);
    }

    public static final /* synthetic */ void access$launchProcessing(DexArchiveBuilderTaskDelegate.DexConversionParameters dexConversionParameters, OutputStream outStream, OutputStream errStream, MessageReceiver receiver) {
        DexArchiveBuilderTaskDelegateKt.launchProcessing(dexConversionParameters, outStream, errStream, receiver);
    }

    public static final /* synthetic */ LoggerWrapper access$getLoggerWrapper$p() {
        return loggerWrapper;
    }
}

