/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.PerModuleReportDependenciesTask;
import com.android.build.gradle.internal.tasks.PerModuleReportDependenciesTask$CreationAction$handleProvider$1;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.tools.build.libraries.metadata.AppDependencies;
import com.android.tools.build.libraries.metadata.Library;
import com.android.tools.build.libraries.metadata.LibraryDependencies;
import com.android.tools.build.libraries.metadata.MavenLibrary;
import com.android.tools.build.libraries.metadata.ModuleDependencies;
import com.google.protobuf.ByteString;
import java.io.File;
import java.io.FileOutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ComponentSelectionCause;
import org.gradle.api.artifacts.result.ComponentSelectionDescriptor;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001%B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J@\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00160\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001fH\u0002J\b\u0010 \u001a\u00020!H\u0014J\u0010\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020$H\u0002R\u0013\u0010\u0005\u001a\u00020\u00068G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R \u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00118G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006&"}, d2={"Lcom/android/build/gradle/internal/tasks/PerModuleReportDependenciesTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "(Lorg/gradle/api/model/ObjectFactory;)V", "dependenciesList", "Lorg/gradle/api/file/RegularFileProperty;", "getDependenciesList", "()Lorg/gradle/api/file/RegularFileProperty;", "moduleName", "Lorg/gradle/api/provider/Property;", "", "getModuleName", "()Lorg/gradle/api/provider/Property;", "runtimeClasspath", "Lorg/gradle/api/artifacts/Configuration;", "<set-?>", "Lorg/gradle/api/file/FileCollection;", "runtimeClasspathArtifacts", "getRuntimeClasspathArtifacts", "()Lorg/gradle/api/file/FileCollection;", "convertDependencyToMavenLibrary", "Ljava/lang/Integer;", "moduleVersion", "Lorg/gradle/api/artifacts/ModuleVersionIdentifier;", "digest", "Lcom/google/protobuf/ByteString;", "librariesToIndexMap", "Ljava/util/Dictionary;", "Lcom/android/tools/build/libraries/metadata/Library;", "libraries", "Ljava/util/LinkedList;", "doTaskAction", "", "getFileDigest", "file", "Ljava/io/File;", "CreationAction", "gradle"})
public abstract class PerModuleReportDependenciesTask
extends NonIncrementalTask {
    private Configuration runtimeClasspath;
    @NotNull
    private FileCollection runtimeClasspathArtifacts;
    @NotNull
    private final RegularFileProperty dependenciesList;

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public final FileCollection getRuntimeClasspathArtifacts() {
        FileCollection fileCollection2 = this.runtimeClasspathArtifacts;
        if (fileCollection2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"runtimeClasspathArtifacts");
        }
        return fileCollection2;
    }

    @OutputFile
    @NotNull
    public final RegularFileProperty getDependenciesList() {
        return this.dependenciesList;
    }

    @Input
    @NotNull
    public abstract Property<String> getModuleName();

    private final Integer convertDependencyToMavenLibrary(ModuleVersionIdentifier moduleVersion, ByteString digest, Dictionary<Library, Integer> librariesToIndexMap, LinkedList<Library> libraries) {
        if (moduleVersion != null) {
            Library lib;
            Integer index;
            Library.Builder libBuilder = Library.newBuilder().setMavenLibrary(MavenLibrary.newBuilder().setGroupId(moduleVersion.getGroup()).setArtifactId(moduleVersion.getName()).setVersion(moduleVersion.getVersion()).build());
            if (digest != null) {
                libBuilder.setDigests(Library.Digests.newBuilder().setSha256(digest));
            }
            if ((index = librariesToIndexMap.get(lib = libBuilder.build())) == null) {
                index = new Integer(libraries.size());
                libraries.add(lib);
                librariesToIndexMap.put(lib, index);
            }
            return index;
        }
        return null;
    }

    private final ByteString getFileDigest(File file) {
        ByteString byteString = ByteString.copyFrom((byte[])MessageDigest.getInstance("SHA-256").digest(FilesKt.readBytes((File)file)));
        Intrinsics.checkExpressionValueIsNotNull((Object)byteString, (String)"ByteString.copyFrom(Mess\u2026digest(file.readBytes()))");
        return byteString;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doTaskAction() {
        void $this$filterTo$iv$iv;
        Object index;
        Dictionary librariesToIndexMap = new Hashtable();
        LinkedList<Library> libraries = new LinkedList<Library>();
        LinkedList<LibraryDependencies> libraryDependencies = new LinkedList<LibraryDependencies>();
        Set directDependenciesIndices = new HashSet();
        Configuration configuration2 = this.runtimeClasspath;
        if (configuration2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"runtimeClasspath");
        }
        ArtifactView artifactView = configuration2.getIncoming().artifactView((Action)doTaskAction.artifacts.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)artifactView, (String)"runtimeClasspath.incomin\u2026entIdentifier }\n        }");
        ArtifactCollection artifacts2 = artifactView.getArtifacts();
        HashMap<ComponentIdentifier, ByteString> componentDigestMap = new HashMap<ComponentIdentifier, ByteString>();
        Iterator iterator = artifacts2.iterator();
        while (iterator.hasNext()) {
            ResolvedArtifactResult artifact;
            ResolvedArtifactResult resolvedArtifactResult = artifact = (ResolvedArtifactResult)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedArtifactResult, (String)"artifact");
            ComponentArtifactIdentifier componentArtifactIdentifier = resolvedArtifactResult.getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)componentArtifactIdentifier, (String)"artifact.id");
            ComponentIdentifier componentIdentifier = componentArtifactIdentifier.getComponentIdentifier();
            File file = artifact.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"artifact.file");
            componentDigestMap.put(componentIdentifier, this.getFileDigest(file));
        }
        Configuration configuration3 = this.runtimeClasspath;
        if (configuration3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"runtimeClasspath");
        }
        ResolvableDependencies resolvableDependencies = configuration3.getIncoming();
        Intrinsics.checkExpressionValueIsNotNull((Object)resolvableDependencies, (String)"runtimeClasspath.incoming");
        ResolutionResult resolutionResult = resolvableDependencies.getResolutionResult();
        Intrinsics.checkExpressionValueIsNotNull((Object)resolutionResult, (String)"runtimeClasspath.incoming.resolutionResult");
        for (DependencyResult dependency : resolutionResult.getAllDependencies()) {
            LibraryDependencies it;
            Object element$iv$iv;
            Iterable $this$filterTo$iv$iv2;
            ResolvedComponentResult resolvedComponent;
            if (!(dependency instanceof ResolvedDependencyResult) || !(((ResolvedDependencyResult)dependency).getRequested() instanceof ModuleComponentSelector)) continue;
            ResolvedComponentResult resolvedComponentResult = resolvedComponent = ((ResolvedDependencyResult)dependency).getSelected();
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedComponentResult, (String)"resolvedComponent");
            index = this.convertDependencyToMavenLibrary(resolvedComponentResult.getModuleVersion(), (ByteString)componentDigestMap.get(resolvedComponent.getId()), librariesToIndexMap, libraries);
            if (index == null) continue;
            Iterable $this$filter$iv = libraryDependencies;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                element$iv$iv = iterator2.next();
                it = (LibraryDependencies)element$iv$iv;
                boolean bl = false;
                if (!(it.getLibraryIndex() == ((Integer)index).intValue())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            if (((List)destination$iv$iv).isEmpty()) {
                LibraryDependencies.Builder libraryDependency = LibraryDependencies.newBuilder().setLibraryIndex((Integer)index);
                for (DependencyResult libDep : resolvedComponent.getDependencies()) {
                    if (!(libDep instanceof ResolvedDependencyResult) || !(((ResolvedDependencyResult)libDep).getRequested() instanceof ModuleComponentSelector)) continue;
                    ResolvedComponentResult resolvedComponentResult2 = ((ResolvedDependencyResult)libDep).getSelected();
                    Intrinsics.checkExpressionValueIsNotNull((Object)resolvedComponentResult2, (String)"libDep.selected");
                    ModuleVersionIdentifier moduleVersionIdentifier = resolvedComponentResult2.getModuleVersion();
                    ResolvedComponentResult resolvedComponentResult3 = ((ResolvedDependencyResult)libDep).getSelected();
                    Intrinsics.checkExpressionValueIsNotNull((Object)resolvedComponentResult3, (String)"libDep.selected");
                    Integer depIndex = this.convertDependencyToMavenLibrary(moduleVersionIdentifier, (ByteString)componentDigestMap.get(resolvedComponentResult3.getId()), librariesToIndexMap, libraries);
                    if (depIndex == null) continue;
                    libraryDependency.addLibraryDepIndex(depIndex);
                }
                libraryDependencies.add(libraryDependency.build());
            }
            ResolvedComponentResult resolvedComponentResult4 = ((ResolvedDependencyResult)dependency).getFrom();
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedComponentResult4, (String)"dependency.from");
            ComponentSelectionReason componentSelectionReason = resolvedComponentResult4.getSelectionReason();
            Intrinsics.checkExpressionValueIsNotNull((Object)componentSelectionReason, (String)"dependency.from.selectionReason");
            List list = componentSelectionReason.getDescriptions();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"dependency.from.selectionReason.descriptions");
            $this$filter$iv = list;
            $i$f$filter = false;
            $this$filterTo$iv$iv2 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            iterator2 = $this$filterTo$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                element$iv$iv = iterator2.next();
                it = (ComponentSelectionDescriptor)element$iv$iv;
                boolean bl = false;
                LibraryDependencies libraryDependencies2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)libraryDependencies2, (String)"it");
                if (!(libraryDependencies2.getCause() == ComponentSelectionCause.ROOT)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            if (!(!$this$filter$iv.isEmpty())) continue;
            directDependenciesIndices.add(((Integer)index).intValue());
        }
        Set set = componentDigestMap.keySet();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"componentDigestMap.keys");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        index = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ComponentIdentifier it = (ComponentIdentifier)element$iv$iv;
            boolean bl = false;
            if (!(!(it instanceof ProjectComponentIdentifier) && !(it instanceof ModuleComponentIdentifier))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List fileComponentIds = (List)destination$iv$iv;
        for (ComponentIdentifier fileComponentId : fileComponentIds) {
            Library library2 = Library.newBuilder().setDigests(Library.Digests.newBuilder().setSha256((ByteString)componentDigestMap.get(fileComponentId))).build();
            int index2 = libraries.size();
            libraries.add(library2);
            LibraryDependencies.Builder libraryDependency = LibraryDependencies.newBuilder().setLibraryIndex(index2);
            libraryDependencies.add(libraryDependency.build());
            directDependenciesIndices.add(index2);
        }
        ModuleDependencies.Builder moduleDependency = ModuleDependencies.newBuilder().setModuleName((String)this.getModuleName().get());
        Iterator iterator3 = directDependenciesIndices.iterator();
        while (iterator3.hasNext()) {
            int index3 = ((Number)iterator3.next()).intValue();
            moduleDependency.addDependencyIndex(index3);
        }
        AppDependencies appDependencies = AppDependencies.newBuilder().addAllLibrary((Iterable<? extends Library>)libraries).addAllLibraryDependencies((Iterable<? extends LibraryDependencies>)libraryDependencies).addModuleDependencies(moduleDependency.build()).build();
        Object object = this.dependenciesList.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"dependenciesList.get()");
        appDependencies.writeTo(new FileOutputStream(((RegularFile)object).getAsFile()));
    }

    @Inject
    public PerModuleReportDependenciesTask(@NotNull ObjectFactory objectFactory) {
        Intrinsics.checkParameterIsNotNull((Object)objectFactory, (String)"objectFactory");
        RegularFileProperty regularFileProperty = objectFactory.fileProperty();
        Intrinsics.checkExpressionValueIsNotNull((Object)regularFileProperty, (String)"objectFactory.fileProperty()");
        this.dependenciesList = regularFileProperty;
    }

    public static final /* synthetic */ Configuration access$getRuntimeClasspath$p(PerModuleReportDependenciesTask $this) {
        Configuration configuration2 = $this.runtimeClasspath;
        if (configuration2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"runtimeClasspath");
        }
        return configuration2;
    }

    public static final /* synthetic */ FileCollection access$getRuntimeClasspathArtifacts$p(PerModuleReportDependenciesTask $this) {
        FileCollection fileCollection2 = $this.runtimeClasspathArtifacts;
        if (fileCollection2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"runtimeClasspathArtifacts");
        }
        return fileCollection2;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0018\u0010\u0011\u001a\u00020\u000f2\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/tasks/PerModuleReportDependenciesTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/PerModuleReportDependenciesTask;", "variantScope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "(Lcom/android/build/gradle/internal/scope/VariantScope;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle"})
    public static final class CreationAction
    extends VariantTaskCreationAction<PerModuleReportDependenciesTask> {
        @NotNull
        private final String name;
        @NotNull
        private final Class<PerModuleReportDependenciesTask> type;

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public Class<PerModuleReportDependenciesTask> getType() {
            return this.type;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<? extends PerModuleReportDependenciesTask> taskProvider) {
            Intrinsics.checkParameterIsNotNull(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            this.getVariantScope().getArtifacts().producesFile((ArtifactType)InternalArtifactType.METADATA_LIBRARY_DEPENDENCIES_REPORT.INSTANCE, taskProvider, (Function1)PerModuleReportDependenciesTask$CreationAction$handleProvider$1.INSTANCE, "dependencies.pb");
        }

        @Override
        public void configure(@NotNull PerModuleReportDependenciesTask task) {
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super.configure((Task)task);
            VariantDependencies variantDependencies = this.getVariantScope().getVariantDependencies();
            Intrinsics.checkExpressionValueIsNotNull((Object)variantDependencies, (String)"variantScope.variantDependencies");
            Configuration configuration2 = variantDependencies.getRuntimeClasspath();
            Intrinsics.checkExpressionValueIsNotNull((Object)configuration2, (String)"variantScope.variantDependencies.runtimeClasspath");
            task.runtimeClasspath = configuration2;
            ArtifactCollection artifactCollection = this.getVariantScope().getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.EXTERNAL, AndroidArtifacts.ArtifactType.JAR);
            Intrinsics.checkExpressionValueIsNotNull((Object)artifactCollection, (String)"variantScope.getArtifact\u2026actType.JAR\n            )");
            FileCollection fileCollection2 = artifactCollection.getArtifactFiles();
            Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection2, (String)"variantScope.getArtifact\u2026          ).artifactFiles");
            task.runtimeClasspathArtifacts = fileCollection2;
            if (this.getVariantScope().getType().isBaseModule()) {
                task.getModuleName().set((Object)"base");
            } else {
                task.getModuleName().set(this.getVariantScope().getFeatureName());
            }
            task.getModuleName().disallowChanges();
        }

        public CreationAction(@NotNull VariantScope variantScope) {
            Intrinsics.checkParameterIsNotNull((Object)variantScope, (String)"variantScope");
            super(variantScope);
            String string = variantScope.getTaskName("collect", "Dependencies");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variantScope.getTaskName\u2026collect\", \"Dependencies\")");
            this.name = string;
            this.type = PerModuleReportDependenciesTask.class;
        }
    }
}

